/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.jetbrains.annotations.Nullable;

@Singleton
public class JFedVersionInfo {
    private static final String VERSION_PROPERTIES_FILE = "/version.properties";
    private static final String PROP_VERSION = "version";
    private static final String PROP_GIT_COMMIT = "build.git_commit";
    private static final String PROP_GIT_BRANCH = "build.git_branch";
    private static final String PROP_BUILD_CI = "build.ci_build";
    private final String version;
    private final String ciBuild;
    private final String gitCommit;
    private final String gitBranch;
    @Nonnull
    private final String fullVersionString;
    @Nonnull
    private final Environment environment;

    public JFedVersionInfo() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getResourceAsStream(VERSION_PROPERTIES_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException("Something went wrong fetching the jFed version: " + e.getMessage(), e);
        }
        this.version = prop.getProperty(PROP_VERSION, "Unknown");
        this.ciBuild = prop.getProperty(PROP_BUILD_CI);
        this.gitCommit = prop.getProperty(PROP_GIT_COMMIT);
        this.gitBranch = prop.getProperty(PROP_GIT_BRANCH);
        Object fullVersionStr = this.version;
        if (this.ciBuild != null && !this.ciBuild.isEmpty()) {
            fullVersionStr = (String)fullVersionStr + "  - build #" + this.ciBuild;
        }
        if (this.gitCommit != null && !this.gitCommit.isEmpty()) {
            fullVersionStr = (String)fullVersionStr + "  - git commit #" + this.gitCommit;
        }
        fullVersionStr = (String)fullVersionStr + " on " + this.gitBranch;
        this.fullVersionString = ((String)fullVersionStr).toString();
        this.environment = JFedVersionInfo.deriveEnvironment(this.version);
    }

    @Nonnull
    private static Environment deriveEnvironment(@Nullable String version) {
        if (version == null) {
            return Environment.UNKNOWN;
        }
        if (version.startsWith("${")) {
            return Environment.DEVELOP;
        }
        if (version.toLowerCase().contains("snapshot")) {
            return Environment.SNAPSHOT;
        }
        if (version.replaceAll("-rc[0-9]*$", "").matches("[0-9.]+")) {
            return Environment.PRODUCTION;
        }
        return Environment.UNKNOWN;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCIBuild() {
        return this.ciBuild;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getFullVersionString() {
        return this.fullVersionString;
    }

    public static String getEnvironmentString() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " - Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
    }

    public String toString() {
        return "JFedVersionInfo{version='" + this.version + "', ciBuild='" + this.ciBuild + "', gitCommit='" + this.gitCommit + "', gitBranch='" + this.gitBranch + "', fullVersionString='" + this.fullVersionString + "', environment=" + this.environment + "}";
    }

    public static enum Environment {
        UNKNOWN,
        DEVELOP,
        SNAPSHOT,
        PRODUCTION;

    }
}

