/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import ch.ethz.ssh2.crypto.cipher.AES;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import ch.ethz.ssh2.crypto.cipher.DES;
import ch.ethz.ssh2.crypto.cipher.DESede;
import ch.ethz.ssh2.crypto.digest.MD5;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtil {
    private static final Logger LOG;
    private static final byte DER_ANS_SEQUENCE = 48;
    private static final byte DER_ANS_INTEGER = 2;
    protected static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    protected static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    protected static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    protected static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    protected static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    protected static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    protected static final String BEGIN_OPENSSH_PRIVATE_KEY = "-----BEGIN OPENSSH PRIVATE KEY----";
    protected static final String END_OPENSSH_PRIVATE_KEY = "-----END OPENSSH PRIVATE KEY----";
    protected static final String SSH_RSA = "ssh-rsa";
    protected static final String SSH_DSS = "ssh-dss";
    protected static final String SSH_DSA = "ssh-dsa";
    protected static final String SSH_ECDSA = "ssh-ecdsa";
    protected static final String SSH_ECDSA_SK = "ssh-ecdsa-sk";
    protected static final String SSH_ED25519_SK = "ssh-ed25519-sk";
    protected static final String SSH_ED25519 = "ssh-ed25519";

    private KeyUtil() {
    }

    public static boolean hasUnlimitedStrengthCryptography() {
        try {
            return Cipher.getMaxAllowedKeyLength("RC5") >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nonnull
    public static byte[] keyStoreToPKCS12Bytes(@Nonnull KeyStore keystore, @Nullable String keyStorePass, @Nullable String pkcs12Pass) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore kspkcs12 = KeyStore.getInstance("pkcs12");
        char[] inphrase = keyStorePass == null ? null : keyStorePass.toCharArray();
        char[] outphrase = pkcs12Pass == null ? null : pkcs12Pass.toCharArray();
        kspkcs12.load(null, inphrase);
        Enumeration<String> eAliases = keystore.aliases();
        int n = 0;
        while (eAliases.hasMoreElements()) {
            String strAlias = eAliases.nextElement();
            System.out.println("Alias " + n++ + ": " + strAlias);
            if (!keystore.isKeyEntry(strAlias)) continue;
            System.out.println("Adding key for alias " + strAlias);
            Key key = keystore.getKey(strAlias, inphrase);
            Certificate[] chain = keystore.getCertificateChain(strAlias);
            kspkcs12.setKeyEntry(strAlias, key, outphrase, chain);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        kspkcs12.store(out, outphrase);
        return out.toByteArray();
    }

    @Nonnull
    public static KeyStore pkcs12BytesToKeyStore(@Nonnull byte[] pkcs12bytes, @Nullable String keyStorePass, @Nullable String pkcs12Pass) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore kspkcs12 = KeyStore.getInstance("pkcs12");
        KeyStore ksjks = KeyStore.getInstance("jks");
        char[] inphrase = pkcs12Pass == null ? null : pkcs12Pass.toCharArray();
        char[] outphrase = keyStorePass == null ? null : keyStorePass.toCharArray();
        kspkcs12.load(new ByteArrayInputStream(pkcs12bytes), inphrase);
        ksjks.load(null, outphrase);
        Enumeration<String> eAliases = kspkcs12.aliases();
        int n = 0;
        while (eAliases.hasMoreElements()) {
            String strAlias = eAliases.nextElement();
            System.out.println("Alias " + n++ + ": " + strAlias);
            if (!kspkcs12.isKeyEntry(strAlias)) continue;
            System.out.println("Adding key for alias " + strAlias);
            Key key = kspkcs12.getKey(strAlias, inphrase);
            Certificate[] chain = kspkcs12.getCertificateChain(strAlias);
            ksjks.setKeyEntry(strAlias, key, outphrase, chain);
        }
        return ksjks;
    }

    @Nullable
    public static X509Certificate pemToX509Certificate(@Nonnull String pem) {
        String start;
        String pemCert = pem.trim().replaceAll("\r\n", "\n");
        int startPos = pemCert.indexOf(start = BEGIN_CERTIFICATE);
        if (startPos != -1) {
            int endPos = (pemCert = pemCert.substring(startPos + start.length())).indexOf(END_CERTIFICATE);
            if (endPos < 0) {
                return null;
            }
            pemCert = pemCert.substring(0, endPos);
        }
        byte[] decodedContent = Base64.decodeBase64((byte[])StringUtils.getBytesUtf8((String)pemCert));
        ByteArrayInputStream inStream = new ByteArrayInputStream(decodedContent);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return certificate;
        }
        catch (CertificateException e) {
            LOG.warn("Note: failed to parse certificate: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static List<X509Certificate> pemToX509CertificateChain(@Nonnull String origPem) {
        int endPos;
        String pemCert;
        int startPos;
        String pem = origPem.replaceAll("\r\n", "\n");
        ArrayList<X509Certificate> res = new ArrayList<X509Certificate>();
        String start = BEGIN_CERTIFICATE;
        String end = END_CERTIFICATE;
        while (!pem.isEmpty() && (startPos = (pemCert = pem.trim()).indexOf(start)) != -1 && (endPos = (pemCert = pemCert.substring(startPos + start.length())).indexOf(end)) >= 0) {
            pem = pemCert.substring(endPos + end.length());
            pemCert = pemCert.substring(0, endPos);
            byte[] decodedContent = Base64.decodeBase64((byte[])StringUtils.getBytesUtf8((String)pemCert));
            ByteArrayInputStream inStream = new ByteArrayInputStream(decodedContent);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                res.add(certificate);
            }
            catch (CertificateException e) {
                LOG.warn("Note: failed to parse certificate (in cert chain). Will ignore this certificate.", (Throwable)e);
            }
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    @Nonnull
    public static String x509certificateChainToPem(@Nonnull Collection<X509Certificate> certs) {
        Object pem = "";
        for (X509Certificate c : certs) {
            pem = (String)pem + KeyUtil.x509certificateToPem(c);
        }
        return pem;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String x509certificateToPem(@Nullable X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            String s = Base64.encodeBase64String((byte[])cert.getEncoded());
            String begin = "-----BEGIN CERTIFICATE-----\n";
            String end = "-----END CERTIFICATE-----\n";
            s = TextUtil.wrap((String)(s + "\n"), (int)64);
            return begin + s + end;
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String x509certificateToCredentialXmlGid(@Nullable X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            String s = Base64.encodeBase64String((byte[])cert.getEncoded());
            s = TextUtil.wrap((String)(s + "\n"), (int)64);
            return s;
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static String getCompatibleSigAlgName(@Nonnull String keyAlgName) {
        if ("DSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA1WithDSA";
        }
        if ("RSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA256WithRSA";
        }
        if ("EC".equalsIgnoreCase(keyAlgName)) {
            return "SHA256withECDSA";
        }
        throw new RuntimeException("Cannot Derive Signature Algorithm");
    }

    public static boolean matchingKeys(@Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey) {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new RuntimeException("Unsupported key format (" + privateKey.getAlgorithm() + ") for matchingKeys (" + privateKey.getClass().getName() + ")");
        }
        try {
            Cipher pkCipher = Cipher.getInstance(privateKey.getAlgorithm());
            pkCipher.init(1, publicKey);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream os = new CipherOutputStream(baos, pkCipher);
            byte[] testBytes = new byte[]{0, 1, 2, 3, 4, 127, -126, -100, 100};
            os.write(testBytes);
            os.close();
            byte[] enc = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(enc);
            pkCipher.init(2, privateKey);
            CipherInputStream is = new CipherInputStream(bais, pkCipher);
            byte[] testReadBytes = new byte[testBytes.length];
            int bytesRead = is.read(testReadBytes);
            assert (bytesRead == testReadBytes.length);
            is.close();
            for (int i = 0; i < testBytes.length; ++i) {
                if (testBytes[i] == testReadBytes[i]) continue;
                Object orig = "";
                Object read = "";
                for (int j = 0; j < testBytes.length; ++j) {
                    orig = (String)orig + testBytes[j] + " ";
                    read = (String)read + testReadBytes[j] + " ";
                }
                Object encString = "";
                for (byte anEnc : enc) {
                    encString = (String)encString + anEnc + " ";
                }
                LOG.debug("Difference wile checking if private and public key match: byte " + i + " differs.\norig=" + (String)orig + "\nenc=" + (String)encString + "\ndec=" + (String)read);
                return false;
            }
        }
        catch (Exception e) {
            LOG.debug("Error checking if private and public key match (probably because keys don't match)", (Throwable)e);
            return false;
        }
        return true;
    }

    @Deprecated
    @Nullable
    public static X509Certificate makeSelfSigned(@Nonnull KeyPair keyPair, @Nonnull String dn, int validityDays) {
        Calendar expiry = Calendar.getInstance();
        expiry.add(6, validityDays);
        try {
            PrivateKey privKey = keyPair.getPrivate();
            PublicKey pubKey = keyPair.getPublic();
            assert (privKey != null);
            assert (pubKey != null);
            String sigAlgName = KeyUtil.getCompatibleSigAlgName(privKey.getAlgorithm());
            X500Name owner = new X500Name("CN=" + dn);
            BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
            Date firstDate = new Date(System.currentTimeMillis() - 86400000L);
            Date lastDate = new Date(System.currentTimeMillis() + (long)validityDays * 24L * 60L * 60L * 1000L);
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(owner, serial, firstDate, lastDate, owner, SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
            return KeyUtil.signCertificate(certBuilder, privKey);
        }
        catch (CertificateException | OperatorCreationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey caPrivateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(caPrivateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    public static boolean isPemPrivateKeyEncrypted(@Nonnull String pem) {
        if (pem.contains("Proc-Type")) {
            return true;
        }
        if (pem.contains("DEK-Info")) {
            return true;
        }
        if (pem.contains("BEGIN OPENSSH PRIVATE KEY")) {
            try {
                OpenSSHPemParser k = new OpenSSHPemParser(pem);
                return k.encryptedPrivateKey;
            }
            catch (PEMDecodingException e) {
                return false;
            }
        }
        return false;
    }

    @Nullable
    public static PrivateKey pemToPrivateKey(@Nonnull String pem, @Nullable char[] password) throws PEMDecodingException {
        assert (!KeyUtil.isPemPrivateKeyEncrypted(pem)) : "This method does not support encrypted keys";
        assert (password == null || password.length == 0) : "This method does not support encrypted keys, but you supplied a password";
        String pemKey = pem.trim().replaceAll("\r\n", "\n");
        String start = BEGIN_PRIVATE_KEY;
        String end = END_PRIVATE_KEY;
        int startPos = pemKey.indexOf(start);
        if (startPos != -1) {
            int endPos = (pemKey = pemKey.substring(startPos + start.length())).indexOf(end);
            if (endPos < 0) {
                throw new PEMDecodingException("Did not find end: '" + end + "' in: " + pem);
            }
            pemKey = pemKey.substring(0, endPos).trim();
            String fullPemKey = start + "\n" + pemKey + "\n" + end;
            try {
                byte[] pkcs8KeyBytes = Base64.decodeBase64((String)pemKey.replaceAll("\n", ""));
                PKCS8EncodedKeySpec pkcs8Spec = new PKCS8EncodedKeySpec(pkcs8KeyBytes);
                KeyFactory keyFact = KeyFactory.getInstance("RSA");
                return keyFact.generatePrivate(pkcs8Spec);
            }
            catch (Exception e) {
                throw new PEMDecodingException("Error reading PEM private key: " + e.getMessage(), e);
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static RSAPublicKey rsaPrivateKeyToRsaPublicKey(@Nullable java.security.interfaces.RSAPrivateKey privateKey) {
        if (privateKey == null) {
            return null;
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            return KeyUtil.rsaPrivateCrtKeyToPublicKey((RSAPrivateCrtKey)privateKey);
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)privateKey;
            try {
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(rsaKey.getModulus(), rsaKey.getPublicExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKey pubkey = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
                return pubkey;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOG.warn("Failed to create public key from bc private key", (Throwable)e);
                return null;
            }
        }
        if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            java.security.interfaces.RSAPrivateKey rsaKey = privateKey;
            try {
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(rsaKey.getModulus(), BigInteger.valueOf(65537L));
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKey pubkey = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
                return pubkey;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOG.warn("Failed to create public key from rsa private key", (Throwable)e);
                return null;
            }
        }
        LOG.error("Cannot reconstruct public key from private key. privateKey class=" + privateKey.getClass().getName());
        return null;
    }

    @Nullable
    public static RSAPublicKey rsaPrivateCrtKeyToPublicKey(@Nonnull RSAPrivateCrtKey rsaPrivateKey) {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey myPublicKey = keyFactory.generatePublic(publicKeySpec);
            return (RSAPublicKey)myPublicKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.warn("Failed to create public key from rsa private crt key", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private static BigInteger readDerLength(@Nonnull LinkedList<Byte> bytes) {
        byte first = bytes.removeFirst();
        boolean shortform = (first & 0x80) == 0;
        int len = first & 0x7F;
        if (shortform) {
            assert (len > 0);
            BigInteger r = BigInteger.valueOf(len);
            assert (r.signum() >= 0);
            return r;
        }
        int resBytesLen = len;
        int resBytesStart = 0;
        if (bytes.getFirst() < 0) {
            ++resBytesLen;
            resBytesStart = 1;
        }
        byte[] res = new byte[resBytesLen];
        res[0] = 0;
        for (int i = resBytesStart; i < resBytesLen; ++i) {
            res[i] = bytes.removeFirst();
        }
        BigInteger r = new BigInteger(res);
        assert (r.signum() > 0);
        return r;
    }

    @Nonnull
    private static BigInteger readDerInt(@Nonnull LinkedList<Byte> bytes) throws PEMDecodingException {
        byte first = bytes.removeFirst();
        if (first != 2) {
            throw new PEMDecodingException("Expected INTEGER in PEM bytes, but got " + first);
        }
        BigInteger len = KeyUtil.readDerLength(bytes);
        int l = len.intValue();
        assert (l <= bytes.size());
        byte[] intBytes = new byte[l];
        for (int i = 0; i < l; ++i) {
            intBytes[i] = bytes.removeFirst();
        }
        return new BigInteger(intBytes);
    }

    @Nonnull
    private static List<BigInteger> readDerBigIntSequence(@Nonnull LinkedList<Byte> bytes) throws PEMDecodingException {
        ArrayList<BigInteger> res = new ArrayList<BigInteger>();
        byte first = bytes.removeFirst();
        if (first != 48) {
            throw new PEMDecodingException("Expected SEQUENCE in PEM bytes, but got " + first);
        }
        BigInteger octetLen = KeyUtil.readDerLength(bytes);
        int l = octetLen.intValue();
        int targetLen = bytes.size() - l;
        while (bytes.size() > targetLen) {
            byte nextStart = bytes.getFirst();
            if (nextStart != 2) {
                return res;
            }
            BigInteger nextInt = KeyUtil.readDerInt(bytes);
            res.add(nextInt);
        }
        if (bytes.size() > targetLen) {
            throw new PEMDecodingException("Expected reading to end at targetLen=" + targetLen + " but read more: bytes.size=" + bytes.size());
        }
        while (bytes.size() < targetLen) {
            bytes.removeFirst();
        }
        return res;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static KeyPair openSSHPrivateKeyPemToRsaKeyPair(@Nullable String pem, final @Nullable char[] password) throws PEMDecodingException {
        if (pem == null) {
            return null;
        }
        if ((pem = KeyUtil.extractFirstPemBlock(pem, "OPENSSH PRIVATE KEY")) == null) {
            return null;
        }
        try {
            PasswordFinder passwordFinder = new PasswordFinder(){

                public char[] reqPassword(Resource<?> resource) {
                    return password;
                }

                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            };
            OpenSSHKeyV1KeyFile kf = new OpenSSHKeyV1KeyFile();
            kf.init(pem, null, (PasswordFinder)(password != null ? passwordFinder : null));
            PrivateKey key = kf.getPrivate();
            PublicKey pubkey = kf.getPublic();
            if (key instanceof java.security.interfaces.RSAPrivateKey && pubkey instanceof RSAPublicKey) {
                return new KeyPair(pubkey, key);
            }
            return null;
        }
        catch (IOException e) {
            throw new PEMDecodingException("Error decoding PEM", e);
        }
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static KeyPair openSSHPrivateKeyPemToKeyPair(@Nullable String pem, final @Nullable char[] password) throws PEMDecodingException {
        if (pem == null) {
            return null;
        }
        if ((pem = KeyUtil.extractFirstPemBlock(pem, "OPENSSH PRIVATE KEY")) == null) {
            return null;
        }
        try {
            PasswordFinder passwordFinder = new PasswordFinder(){

                public char[] reqPassword(Resource<?> resource) {
                    return password;
                }

                public boolean shouldRetry(Resource<?> resource) {
                    return false;
                }
            };
            OpenSSHKeyV1KeyFile kf = new OpenSSHKeyV1KeyFile();
            kf.init(pem, null, (PasswordFinder)(password != null ? passwordFinder : null));
            PrivateKey key = kf.getPrivate();
            PublicKey pubkey = kf.getPublic();
            return new KeyPair(pubkey, key);
        }
        catch (IOException e) {
            throw new PEMDecodingException("Error decoding PEM", e);
        }
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static KeyPair pemToRsaKeyPair(@Nullable String pem, @Nullable char[] password) throws PEMDecodingException {
        int startPos;
        if (pem == null) {
            return null;
        }
        String pemKey = pem.trim().replaceAll("\r\n", "\n");
        if (LOG.isDebugEnabled()) {
            try {
                String pwMd5String;
                String dataMd5String;
                if (!pemKey.isEmpty()) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] dataMd5 = md.digest(pemKey.getBytes("UTF-8"));
                    dataMd5String = Base64.encodeBase64String((byte[])dataMd5);
                } else {
                    dataMd5String = "empty";
                }
                String string = pwMd5String = password == null ? "null" : "empty";
                if (password != null && password.length > 0) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] pwMd5 = md.digest(new String(password).getBytes("UTF-8"));
                    pwMd5String = Base64.encodeBase64String((byte[])pwMd5);
                }
                LOG.debug("pemToRsaKeyPair() MD5's:  pem=" + dataMd5String + "  pass=" + pwMd5String);
            }
            catch (Exception e) {
                LOG.debug("Error generating debug output", (Throwable)e);
            }
        }
        if ((startPos = pemKey.indexOf(BEGIN_RSA_PRIVATE_KEY)) != -1) {
            int endPos = (pemKey = pemKey.substring(startPos + BEGIN_RSA_PRIVATE_KEY.length())).indexOf(END_RSA_PRIVATE_KEY);
            if (endPos < 0) {
                throw new PEMDecodingException("Did not find end: '-----END RSA PRIVATE KEY-----' in: " + pem);
            }
            pemKey = pemKey.substring(0, endPos).trim();
            String extraDebugOutput = "";
            try {
                byte[] data;
                String passString = null;
                if (password != null) {
                    passString = new String(password);
                }
                String pemEncodedData = pemKey;
                if (pemKey.trim().startsWith("Proc-Type: 4,ENCRYPTED")) {
                    int dekInfoIndex = pemKey.indexOf("DEK-Info: ");
                    if (dekInfoIndex < 0) {
                        throw new PEMDecodingException("Found Proc-Type: 4,ENCRYPTED in RSA PRIVATE KEY, but no DEK-Info");
                    }
                    int dekInfoEndIndex = pemKey.indexOf("\n", dekInfoIndex);
                    int emptyLineIndex = pemKey.indexOf("\n\n");
                    LOG.debug("emptyLineIndex=" + emptyLineIndex);
                    extraDebugOutput = pemKey.substring(0, 70);
                    if (emptyLineIndex < 0) {
                        throw new PEMDecodingException("Did not find empty line in encoded PEM block");
                    }
                    extraDebugOutput = pemKey.substring(0, emptyLineIndex);
                    assert (dekInfoEndIndex != -1);
                    String dekInfoLine = pemKey.substring(dekInfoIndex, dekInfoEndIndex);
                    LOG.debug("pemToRsaKeyPair() read dekInfoLine=\"" + dekInfoLine + "\"");
                    assert (dekInfoLine.startsWith("DEK-Info: "));
                    String dekInfoContent = dekInfoLine.substring("DEK-Info: ".length());
                    Object[] dekInfoContentParts = dekInfoContent.split(",");
                    LOG.debug("pemToRsaKeyPair() dekInfoContent=\"" + dekInfoContent + "\" dekInfoContentParts=" + Arrays.toString(dekInfoContentParts));
                    if (dekInfoContentParts.length != 2) {
                        throw new PEMDecodingException("Did not find 2 parts of info in DEK-Info: \"" + dekInfoContent + "\"");
                    }
                    Object algo = dekInfoContentParts[0];
                    byte[] salt = KeyUtil.hexToByteArray((String)dekInfoContentParts[1]);
                    LOG.debug("pemToRsaKeyPair() read dekInfoLine algo=\"" + (String)algo + "\" salt=\"" + (String)dekInfoContentParts[1] + "\"");
                    pemEncodedData = pemKey.substring(emptyLineIndex + 1);
                    data = Base64.decodeBase64((String)pemEncodedData.replaceAll("\n", ""));
                    if (passString != null) {
                        byte[] passBytes = passString.getBytes("US-ASCII");
                        data = KeyUtil.decryptPEM((String)algo, salt, data, passBytes);
                    }
                } else {
                    data = Base64.decodeBase64((String)pemEncodedData.replaceAll("\n", ""));
                }
                if (LOG.isDebugEnabled()) {
                    try {
                        String dataMd5String;
                        if (data.length > 0) {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            byte[] dataMd5 = md.digest(data);
                            dataMd5String = Base64.encodeBase64String((byte[])dataMd5);
                        } else {
                            dataMd5String = "empty";
                        }
                        LOG.debug("pemToRsaKeyPair() MD5's:  decr pem=" + dataMd5String);
                    }
                    catch (Exception e) {
                        LOG.debug("Error generating debug output", (Throwable)e);
                    }
                }
                LinkedList<Byte> dataList = new LinkedList<Byte>();
                for (byte aData : data) {
                    dataList.add(aData);
                }
                List<BigInteger> ints = KeyUtil.readDerBigIntSequence(dataList);
                if (ints.size() < 9) {
                    throw new RuntimeException("Not enough Integers in DER sequence: " + ints.size());
                }
                BigInteger version = ints.get(0);
                BigInteger modulus = ints.get(1);
                BigInteger publicExponent = ints.get(2);
                BigInteger privateExponent = ints.get(3);
                BigInteger primeP = ints.get(4);
                BigInteger primeQ = ints.get(5);
                BigInteger primeExponentP = ints.get(6);
                BigInteger primeExponentQ = ints.get(7);
                BigInteger crtCoefficient = ints.get(8);
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPrivateCrtKey key = (RSAPrivateCrtKey)keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
                RSAPublicKey pubkey = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
                return new KeyPair(pubkey, key);
            }
            catch (Exception e) {
                if (!extraDebugOutput.isEmpty()) {
                    LOG.debug("Error reading PEM private key (len=" + pemKey.length() + "). encrypted private key head =\n" + extraDebugOutput + " same as json=\n" + XmlRpcPrintUtil.xmlRpcObjectToString(extraDebugOutput), (Throwable)e);
                } else {
                    LOG.debug("Error reading PEM private key (len=" + pemKey.length() + ")", (Throwable)e);
                }
                throw new PEMDecodingException("Error reading PEM private key: " + e.getMessage(), e);
            }
        }
        LOG.debug("No -----BEGIN RSA PRIVATE KEY----- found in given pemkey (len=" + pemKey.length() + ")");
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static String extractFirstPemBlock(@Nullable String pem, @Nonnull String blockName) throws PEMDecodingException {
        if (pem == null) {
            return null;
        }
        String pemKey = pem.trim().replaceAll("\r\n", "\n");
        String start = "-----BEGIN " + blockName + "-----";
        String end = "-----END " + blockName + "-----";
        int startPos = pemKey.indexOf(start);
        if (startPos < 0) {
            return null;
        }
        int endPos = pemKey.indexOf(end, startPos);
        if (endPos < 0) {
            throw new PEMDecodingException("Did not find end: '" + end + "' in: " + pem);
        }
        pemKey = pemKey.substring(startPos + start.length(), endPos).trim();
        return start + "\n" + pemKey + "\n" + end;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static byte[] extractPemBlockBytes(@Nullable String pem, @Nonnull String blockName) throws PEMDecodingException {
        if (pem == null) {
            return null;
        }
        pem = pem.trim().replaceAll("\r\n", "\n");
        String start = "-----BEGIN " + blockName + "-----";
        String end = "-----END " + blockName + "-----";
        int startPos = pem.indexOf(start);
        int endPos = pem.indexOf(end, startPos);
        if (startPos < 0) {
            throw new PEMDecodingException("Did not find start: '" + start + "' in: " + pem);
        }
        if (endPos < 0) {
            throw new PEMDecodingException("Did not find end: '" + end + "' in: " + pem);
        }
        pem = pem.substring(startPos + start.length(), endPos).trim();
        return Base64.decodeBase64((String)pem.replaceAll("\n", ""));
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static java.security.interfaces.RSAPrivateKey openSSHPrivateKeyPemToRsaPrivateKey(@Nullable String pem, @Nullable char[] password) throws PEMDecodingException {
        if ((pem = KeyUtil.extractFirstPemBlock(pem, "OPENSSH PRIVATE KEY")) == null) {
            return null;
        }
        KeyPair res = KeyUtil.openSSHPrivateKeyPemToRsaKeyPair(pem, password);
        if (res == null) {
            return null;
        }
        assert (res.getPrivate() != null);
        return (java.security.interfaces.RSAPrivateKey)res.getPrivate();
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PrivateKey openSSHPrivateKeyPemToPrivateKey(@Nullable String pem, @Nullable char[] password) throws PEMDecodingException {
        if ((pem = KeyUtil.extractFirstPemBlock(pem, "OPENSSH PRIVATE KEY")) == null) {
            return null;
        }
        KeyPair res = KeyUtil.openSSHPrivateKeyPemToKeyPair(pem, password);
        if (res == null) {
            return null;
        }
        assert (res.getPrivate() != null);
        return res.getPrivate();
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static java.security.interfaces.RSAPrivateKey pemToRsaPrivateKey(@Nullable String pem, @Nullable char[] password) throws PEMDecodingException {
        if (pem == null) {
            return null;
        }
        java.security.interfaces.RSAPrivateKey pk0 = KeyUtil.openSSHPrivateKeyPemToRsaPrivateKey(pem, password);
        if (pk0 != null) {
            return pk0;
        }
        KeyPair res = KeyUtil.pemToRsaKeyPair(pem, password);
        if (res == null) {
            return null;
        }
        assert (res.getPrivate() != null);
        return (java.security.interfaces.RSAPrivateKey)res.getPrivate();
    }

    @Nullable
    public static PrivateKey pemToAnyPrivateKey(@Nonnull String pem, char[] password) throws PEMDecodingException {
        PrivateKey pk9 = KeyUtil.openSSHPrivateKeyPemToPrivateKey(pem, password);
        if (pk9 != null) {
            return pk9;
        }
        java.security.interfaces.RSAPrivateKey pk0 = KeyUtil.openSSHPrivateKeyPemToRsaPrivateKey(pem, password);
        if (pk0 != null) {
            return pk0;
        }
        java.security.interfaces.RSAPrivateKey pk1 = KeyUtil.pemToRsaPrivateKey(pem, password);
        if (pk1 != null) {
            return pk1;
        }
        PrivateKey pk2 = KeyUtil.pemToPrivateKey(pem, password);
        if (pk2 != null) {
            return pk2;
        }
        return null;
    }

    @Nonnull
    public static List<Certificate> parseAllPEMCertificates(@Nonnull String pemCerts) {
        int endIndex;
        ArrayList<Certificate> res = new ArrayList<Certificate>();
        int startIndex = pemCerts.indexOf(BEGIN_CERTIFICATE);
        while (startIndex != -1 && (endIndex = pemCerts.indexOf(END_CERTIFICATE, startIndex + 1)) != -1) {
            String certString = pemCerts.substring(startIndex + BEGIN_CERTIFICATE.length(), endIndex).trim().replaceAll("\r\n", "\n");
            X509Certificate cert = KeyUtil.pemToX509Certificate(certString);
            if (cert != null) {
                res.add(cert);
            }
            startIndex = pemCerts.indexOf(BEGIN_CERTIFICATE, endIndex + END_CERTIFICATE.length());
        }
        return res;
    }

    @Nonnull
    public static List<Byte> derLength(int len) {
        boolean ignoreLeadingZero;
        assert (len >= 0);
        ArrayList<Byte> res = new ArrayList<Byte>();
        if (len >= 0 && len <= 127) {
            res.add((byte)len);
            return res;
        }
        BigInteger helper = BigInteger.valueOf(len);
        byte[] helperBytes = helper.toByteArray();
        assert (helper.toByteArray()[0] >= 0);
        int octets_needed = helperBytes.length;
        boolean bl = ignoreLeadingZero = helperBytes[0] == 0;
        if (ignoreLeadingZero) {
            --octets_needed;
        }
        assert (octets_needed < 128 && octets_needed >= 0);
        byte first = (byte)(0x80 | octets_needed);
        res.add(first);
        for (byte b : helperBytes) {
            if (ignoreLeadingZero) {
                ignoreLeadingZero = false;
                continue;
            }
            res.add(b);
        }
        return res;
    }

    @Nonnull
    private static List<Byte> derBigInt(BigInteger bigint) {
        ArrayList<Byte> res = new ArrayList<Byte>();
        if (bigint.signum() == 0) {
            res.add((byte)0);
            return res;
        }
        byte[] bytes = bigint.toByteArray();
        assert (bytes.length > 0);
        boolean skipFirstZeroes = true;
        for (byte b : bytes) {
            if (b != 0 && skipFirstZeroes && b < 0 && bigint.signum() > 0) {
                res.add((byte)0);
            }
            if (b == 0 && skipFirstZeroes) continue;
            skipFirstZeroes = false;
            res.add(b);
        }
        return res;
    }

    @Nonnull
    public static List<Byte> derSequenceBigInt(@Nonnull List<BigInteger> bigints) {
        ArrayList<Byte> integers = new ArrayList<Byte>();
        for (BigInteger bigint : bigints) {
            integers.add((byte)2);
            List<Byte> e = KeyUtil.derBigInt(bigint);
            integers.addAll(KeyUtil.derLength(e.size()));
            integers.addAll(e);
        }
        ArrayList<Byte> der = new ArrayList<Byte>();
        der.add((byte)48);
        der.addAll(KeyUtil.derLength(integers.size()));
        der.addAll(integers);
        return der;
    }

    @Nonnull
    public static byte[] getPrivateKeyPKCS1(@Nonnull RSAPrivateCrtKey crtKey) {
        ArrayList<BigInteger> bigints = new ArrayList<BigInteger>();
        bigints.add(BigInteger.valueOf(0L));
        bigints.add(crtKey.getModulus());
        bigints.add(crtKey.getPublicExponent());
        bigints.add(crtKey.getPrivateExponent());
        bigints.add(crtKey.getPrimeP());
        bigints.add(crtKey.getPrimeQ());
        bigints.add(crtKey.getPrimeExponentP());
        bigints.add(crtKey.getPrimeExponentQ());
        bigints.add(crtKey.getCrtCoefficient());
        List<Byte> der = KeyUtil.derSequenceBigInt(bigints);
        byte[] derBytes = new byte[der.size()];
        int i = 0;
        for (byte b : der) {
            derBytes[i++] = b;
        }
        return derBytes;
    }

    @Nonnull
    public static byte[] getPublicKeyPKCS1(@Nonnull RSAPublicKey sshPublicKey) {
        ArrayList<BigInteger> bigints = new ArrayList<BigInteger>();
        bigints.add(sshPublicKey.getModulus());
        bigints.add(sshPublicKey.getPublicExponent());
        List<Byte> der = KeyUtil.derSequenceBigInt(bigints);
        byte[] derBytes = new byte[der.size()];
        int i = 0;
        for (byte b : der) {
            derBytes[i++] = b;
        }
        return derBytes;
    }

    @Nonnull
    public static char[] getPrivateKeyCharsPKCS1Base64(@Nonnull RSAPrivateCrtKey sshPrivateKey) {
        return KeyUtil.getPrivateKeyCharsPKCS1Base64(sshPrivateKey, null);
    }

    @Nonnull
    public static char[] getPrivateKeyCharsPKCS1Base64(@Nonnull RSAPrivateCrtKey sshPrivateKey, @Nullable char[] password) {
        String s;
        byte[] pkcs1Key = KeyUtil.getPrivateKeyPKCS1(sshPrivateKey);
        if (password == null) {
            s = Base64.encodeBase64String((byte[])pkcs1Key);
        } else {
            try {
                s = KeyUtil.encryptPEM(pkcs1Key, new String(password).getBytes("UTF-8"));
            }
            catch (PEMDecodingException | UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return s.toCharArray();
    }

    @Nonnull
    public static char[] getPublicKeyCharsPKCS1Base64(@Nonnull RSAPublicKey sshPublicKey) {
        String s = Base64.encodeBase64String((byte[])KeyUtil.getPublicKeyPKCS1(sshPublicKey));
        return s.toCharArray();
    }

    @Nonnull
    public static byte[] getPrivateKeyCharsPKCS8(@Nonnull PrivateKey privateKey) {
        if (!Objects.equals(privateKey.getFormat(), "PKCS#8")) {
            throw new RuntimeException(privateKey.getClass().getName() + " does not support PKCS#8");
        }
        assert (Objects.equals(privateKey.getFormat(), "PKCS#8"));
        return privateKey.getEncoded();
    }

    @Nonnull
    public static char[] getPrivateKeyCharsPKCS8Base64(@Nonnull PrivateKey privateKey) {
        return KeyUtil.getPrivateKeyCharsPKCS8Base64(privateKey, null);
    }

    @Nonnull
    public static char[] getPrivateKeyCharsPKCS8Base64(@Nonnull PrivateKey privateKey, @Nullable char[] password) {
        String s;
        byte[] pkcs8bytes = KeyUtil.getPrivateKeyCharsPKCS8(privateKey);
        if (password == null) {
            s = Base64.encodeBase64String((byte[])pkcs8bytes);
        } else {
            try {
                s = KeyUtil.encryptPEM(pkcs8bytes, new String(password).getBytes("UTF-8"));
            }
            catch (PEMDecodingException | UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return s.toCharArray();
    }

    @Nonnull
    public static char[] privateKeyToPem(@Nonnull PrivateKey privateKey) {
        return KeyUtil.privateKeyToPem(privateKey, null);
    }

    @Nonnull
    public static char[] privateKeyToPem(@Nonnull PrivateKey privateKey, @Nullable char[] password) {
        String pem = TextUtil.wrap((String)new String(KeyUtil.getPrivateKeyCharsPKCS8Base64(privateKey, password)), (int)64);
        String res = "-----BEGIN PRIVATE KEY-----\n" + pem + "\n-----END PRIVATE KEY-----\n";
        return res.toCharArray();
    }

    @Nonnull
    public static char[] privateKeyToAnyPem(@Nonnull PrivateKey privateKey) {
        return KeyUtil.privateKeyToAnyPem(privateKey, null);
    }

    @Nonnull
    public static char[] privateKeyToAnyPem(@Nonnull PrivateKey privateKey, @Nullable char[] password) {
        if (privateKey instanceof RSAPrivateCrtKey) {
            return KeyUtil.rsaPrivateKeyToPem((RSAPrivateCrtKey)privateKey, password);
        }
        if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            return KeyUtil.privateKeyToPem(privateKey, password);
        }
        if (privateKey instanceof ECPrivateKey || privateKey instanceof EdDSAPrivateKey || privateKey instanceof EdECPrivateKey) {
            throw new IllegalArgumentException("PrivateKey of type " + privateKey.getAlgorithm() + " (" + privateKey.getClass().getName() + ") is not yet supported. This requires OPENSSH PRIVATE KEY which contains public key.");
        }
        throw new IllegalArgumentException("PrivateKey of type " + privateKey.getAlgorithm() + " (" + privateKey.getClass().getName() + ") is not yet supported");
    }

    @Nonnull
    public static char[] rsaPrivateKeyToPem(@Nonnull java.security.interfaces.RSAPrivateKey rsaPrivateKey) {
        return KeyUtil.rsaPrivateKeyToPem(rsaPrivateKey, null);
    }

    @Nonnull
    public static char[] rsaPrivateKeyToPem(@Nonnull java.security.interfaces.RSAPrivateKey rsaPrivateKey, @Nullable char[] password) {
        if (!(rsaPrivateKey instanceof RSAPrivateCrtKey)) {
            throw new RuntimeException("rsaPrivateKey is not of class RSAPrivateCrtKey but of class=" + rsaPrivateKey.getClass().getName() + " -> does not contain enough data to transform it to the PKCS1 format needed for PEM \"RSA PRIVATE KEY\"");
        }
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)rsaPrivateKey;
        String tmp = new String(KeyUtil.getPrivateKeyCharsPKCS1Base64(rsaPrivateCrtKey, password));
        String pem = TextUtil.wrap((String)tmp, (int)64);
        String res = "-----BEGIN RSA PRIVATE KEY-----\n" + pem + "\n-----END RSA PRIVATE KEY-----\n";
        return res.toCharArray();
    }

    @Deprecated
    public static boolean hasAnyPrivateKey(@Nonnull String keyCertContent) {
        return KeyUtil.hasPrivateKey(keyCertContent) || KeyUtil.hasRsaPrivateKey(keyCertContent) || KeyUtil.hasOpenSshPrivateKey(keyCertContent);
    }

    @Deprecated
    public static boolean hasPrivateKey(@Nonnull String pemContent) {
        return pemContent.contains(BEGIN_PRIVATE_KEY);
    }

    @Deprecated
    public static boolean hasRsaPrivateKey(@Nonnull String pemContent) {
        return pemContent.contains(BEGIN_RSA_PRIVATE_KEY);
    }

    @Deprecated
    public static boolean hasOpenSshPrivateKey(@Nonnull String pemContent) {
        return pemContent.contains(BEGIN_OPENSSH_PRIVATE_KEY);
    }

    public static boolean hasX509Certificate(@Nonnull String pemContent) {
        return pemContent.contains(BEGIN_CERTIFICATE);
    }

    public static boolean isOpenSshFormatRsaPublicKey(@Nonnull File file) throws IOException {
        return KeyUtil.isOpenSshFormatRsaPublicKey(IOUtils.fileToString((File)file));
    }

    public static boolean isOpenSshFormatRsaPublicKey(@Nullable String content) {
        return content != null && content.startsWith("ssh-rsa ");
    }

    public static boolean isOpenSshFormatPublicKey(@Nonnull File file) throws IOException {
        return KeyUtil.isOpenSshFormatPublicKey(IOUtils.fileToString((File)file));
    }

    public static boolean isOpenSshFormatPublicKey(@Nullable String content) {
        return content != null && content.startsWith("ssh-") || content.startsWith("ecdsa-");
    }

    @Deprecated
    public static boolean hasEncryptedPrivateKey(@Nonnull String pemContent) {
        if (KeyUtil.hasEncryptedRsaPrivateKey(pemContent)) {
            return true;
        }
        return KeyUtil.hasEncryptedOpenSshPrivateKey(pemContent);
    }

    @Deprecated
    public static boolean hasEncryptedOpenSshPrivateKey(@Nonnull String pemContent) {
        if (!pemContent.contains(BEGIN_OPENSSH_PRIVATE_KEY)) {
            return false;
        }
        try {
            OpenSSHPemParser k = new OpenSSHPemParser(pemContent);
            return k.encryptedPrivateKey;
        }
        catch (PEMDecodingException e) {
            LOG.warn("hasEncryptedOpenSshPrivateKey is considering invalid PEM as unencrypted");
            return false;
        }
    }

    @Deprecated
    public static boolean hasEncryptedRsaPrivateKey(@Nonnull String pemContent) {
        return pemContent.contains(BEGIN_RSA_PRIVATE_KEY) && (pemContent.contains("Proc-Type:") || pemContent.contains("DEK-Info: ") || pemContent.contains("ENCRYPTED"));
    }

    @Nullable
    @Deprecated
    @Contract(value="null -> null; !null -> !null")
    public static String publicKeyToOpenSshAuthorizedKeysFormat(@Nullable PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey(publicKey);
        return publicKeyConvertor.getOpensshFormString();
    }

    @Nullable
    @Deprecated
    @Contract(value="null -> null; !null -> !null")
    public static String publicKeyToOpenSshAuthorizedKeysFormatData(@Nullable PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey(publicKey);
        return publicKeyConvertor.getOpensshFormEncodedKey();
    }

    @Deprecated
    @Nonnull
    public static String rsaPublicKeyToOpenSshAuthorizedKeysFormatData(@Nonnull RSAPublicKey rsaPublicKey) {
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey(rsaPublicKey);
        return publicKeyConvertor.getOpensshFormEncodedKey();
    }

    @Nonnull
    @Deprecated
    public static String rsaPublicKeyToOpenSshAuthorizedKeysFormat(@Nonnull RSAPublicKey rsaPublicKey) {
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey(rsaPublicKey);
        return publicKeyConvertor.getOpensshFormString();
    }

    public static void reverse(byte[] arr) {
        int l = arr.length;
        for (int i = 0; i < l / 2; ++i) {
            byte t = arr[i];
            arr[i] = arr[l - i - 1];
            arr[l - i - 1] = t;
        }
    }

    @Deprecated
    @Nonnull
    public static PublicKey openSshAuthorizedKeysFormatPublicKey(@Nonnull String openSshFormatPubKey) {
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromOpensshFormat(openSshFormatPubKey);
        return publicKeyConvertor.getPublicKey();
    }

    @Nonnull
    @Deprecated
    public static RSAPublicKey openSshAuthorizedKeysFormatRsaPublicKey(@Nonnull String openSshFormatPubKey) {
        PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromOpensshFormat(openSshFormatPubKey);
        return (RSAPublicKey)publicKeyConvertor.getPublicKey();
    }

    @Nonnull
    @Deprecated
    private static byte[] generateKeyFromPasswordSaltWithMD5(@Nonnull byte[] password, @Nonnull byte[] salt, int keyLen) throws PEMDecodingException {
        if (salt.length < 8) {
            throw new PEMDecodingException("Salt needs to be at least 8 bytes for key generation. It is only " + salt.length + " bytes");
        }
        MD5 md5 = new MD5();
        byte[] key = new byte[keyLen];
        byte[] tmp = new byte[md5.getDigestLength()];
        while (true) {
            md5.update(password, 0, password.length);
            md5.update(salt, 0, 8);
            int copy = keyLen < tmp.length ? keyLen : tmp.length;
            md5.digest(tmp, 0);
            System.arraycopy(tmp, 0, key, key.length - keyLen, copy);
            if ((keyLen -= copy) == 0) {
                return key;
            }
            md5.update(tmp, 0, tmp.length);
        }
    }

    @Nonnull
    @Deprecated
    private static String encryptPEM(@Nonnull byte[] data, @Nonnull byte[] pw) throws PEMDecodingException {
        byte[] salt = new byte[8];
        Random rand = new Random();
        rand.nextBytes(salt);
        Object saltString = "";
        for (byte aSalt : salt) {
            saltString = (String)saltString + String.format("%02X", aSalt);
        }
        byte[] crypted = KeyUtil.encryptPEMhelper(data, salt, pw);
        return "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC," + (String)saltString + "\n\n" + Base64.encodeBase64String((byte[])crypted);
    }

    @Nonnull
    @Deprecated
    private static byte[] encryptPEMhelper(@Nonnull byte[] data, @Nonnull byte[] salt, @Nonnull byte[] pw) throws PEMDecodingException {
        DESede des3 = new DESede();
        des3.init(true, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
        CBCMode bc = new CBCMode((BlockCipher)des3, salt, true);
        byte[] paddedData = KeyUtil.addPadding(data, bc.getBlockSize());
        byte[] res = new byte[paddedData.length];
        for (int i = 0; i < paddedData.length / bc.getBlockSize(); ++i) {
            bc.transformBlock(paddedData, i * bc.getBlockSize(), res, i * bc.getBlockSize());
        }
        return res;
    }

    @Nonnull
    @Deprecated
    private static byte[] decryptPEM(@Nonnull String algo, @Nonnull byte[] salt, @Nonnull byte[] data, @Nonnull byte[] pw) throws PEMDecodingException {
        assert (algo != null);
        assert (pw != null);
        assert (data != null);
        assert (salt != null);
        if (LOG.isDebugEnabled()) {
            try {
                String pwMd5String;
                String dataMd5String;
                if (data.length > 0) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] dataMd5 = md.digest(data);
                    dataMd5String = Base64.encodeBase64String((byte[])dataMd5);
                } else {
                    dataMd5String = "empty";
                }
                if (pw.length > 0) {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    byte[] pwMd5 = md.digest(pw);
                    pwMd5String = Base64.encodeBase64String((byte[])pwMd5);
                } else {
                    pwMd5String = "empty";
                }
                LOG.debug("decryptPEM() algo=" + algo + " salt=" + Base64.encodeBase64String((byte[])salt) + " dataMd5=" + dataMd5String + " pwMd5=" + pwMd5String);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.debug("decryptPEM() Error creating debug message", (Throwable)e);
            }
        }
        CBCMode bc = switch (algo) {
            case "DES-EDE3-CBC" -> {
                DESede des3 = new DESede();
                des3.init(false, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
                yield new CBCMode((BlockCipher)des3, salt, false);
            }
            case "DES-CBC" -> {
                DES des = new DES();
                des.init(false, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 8));
                yield new CBCMode((BlockCipher)des, salt, false);
            }
            case "AES-128-CBC" -> {
                AES aes = new AES();
                aes.init(false, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 16));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            case "AES-192-CBC" -> {
                AES aes = new AES();
                aes.init(false, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 24));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            case "AES-256-CBC" -> {
                AES aes = new AES();
                aes.init(false, KeyUtil.generateKeyFromPasswordSaltWithMD5(pw, salt, 32));
                yield new CBCMode((BlockCipher)aes, salt, false);
            }
            default -> {
                LOG.error("decryptPEM() Cannot decrypt PEM structure, unknown cipher " + algo);
                throw new PEMDecodingException("Cannot decrypt PEM structure, unknown cipher " + algo);
            }
        };
        if (data.length % bc.getBlockSize() != 0) {
            LOG.error("Invalid PEM structure, size of encrypted block is not a multiple of " + bc.getBlockSize());
            throw new PEMDecodingException("Invalid PEM structure, size of encrypted block is not a multiple of " + bc.getBlockSize());
        }
        byte[] dz = new byte[data.length];
        for (int i = 0; i < data.length / bc.getBlockSize(); ++i) {
            bc.transformBlock(data, i * bc.getBlockSize(), dz, i * bc.getBlockSize());
        }
        dz = KeyUtil.removePadding(dz, bc.getBlockSize());
        return dz;
    }

    @Nonnull
    @Deprecated
    private static byte[] addPadding(@Nonnull byte[] buff, int blockSize) {
        assert (blockSize == 8);
        int origLen = buff.length;
        int extraBytes = 8 - buff.length % blockSize;
        int resLen = origLen + extraBytes;
        byte[] res = new byte[resLen];
        System.arraycopy(buff, 0, res, 0, origLen);
        for (int i = origLen; i < resLen; ++i) {
            res[i] = (byte)extraBytes;
        }
        return res;
    }

    @Nonnull
    @Deprecated
    private static byte[] removePadding(@Nonnull byte[] buff, int blockSize) throws PEMDecodingException {
        int rfc_1423_padding = buff[buff.length - 1] & 0xFF;
        if (rfc_1423_padding < 1 || rfc_1423_padding > blockSize) {
            throw new PEMDecodingException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        for (int i = 2; i <= rfc_1423_padding; ++i) {
            if (buff[buff.length - i] == rfc_1423_padding) continue;
            throw new PEMDecodingException("Decrypted PEM has wrong padding, did you specify the correct password?");
        }
        byte[] tmp = new byte[buff.length - rfc_1423_padding];
        System.arraycopy(buff, 0, tmp, 0, buff.length - rfc_1423_padding);
        return tmp;
    }

    @Deprecated
    public static int hexToInt(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Need hex char");
    }

    @Nonnull
    @Deprecated
    public static byte[] hexToByteArray(@Nonnull String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Uneven string length in hex encoding \"" + hex + "\" len=" + hex.length());
        }
        byte[] decoded = new byte[hex.length() / 2];
        for (int i = 0; i < decoded.length; ++i) {
            int hi = KeyUtil.hexToInt(hex.charAt(i * 2));
            int lo = KeyUtil.hexToInt(hex.charAt(i * 2 + 1));
            decoded[i] = (byte)(hi * 16 + lo);
        }
        return decoded;
    }

    @Nonnull
    public static List<GeniUrn> findUrnsInCertAltNames(@Nonnull X509Certificate cert, @Nonnull AltNamesSource altNamesSource, boolean onlyUsers) {
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        Collection<List<?>> altNames = null;
        try {
            switch (altNamesSource) {
                case SUBJECT_ALT_NAMES: {
                    altNames = cert.getSubjectAlternativeNames();
                    break;
                }
                case ISSUES_ALT_NAMES: {
                    altNames = cert.getIssuerAlternativeNames();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported AltNamesSource: " + altNamesSource);
                }
            }
        }
        catch (CertificateParsingException e) {
            LOG.error("Error processing certificate alternate names: " + e.getMessage());
        }
        LOG.trace("certificate has alt names: " + (altNames != null && altNames.isEmpty()) + "\n");
        if (altNames != null) {
            Object invalidUrnErrors = "";
            boolean hasvalidUrn = false;
            for (List<?> altName : altNames) {
                Integer nameType = (Integer)altName.get(0);
                LOG.trace("certificate has altname of type " + nameType + "\n");
                if (nameType != 6) continue;
                String urn = (String)altName.get(1);
                GeniUrn geniUrn = GeniUrn.parse((String)urn);
                if (geniUrn == null) {
                    invalidUrnErrors = (String)invalidUrnErrors + "Warning: certificate alternative name URI is not a valid urn: \"" + urn + "\"  (will be ignored)";
                    continue;
                }
                if (onlyUsers && !Objects.equals(geniUrn.getEncodedResourceType(), "user")) {
                    invalidUrnErrors = (String)invalidUrnErrors + "Warning: certificate alternative name URI is not a user urn: \"" + urn + "\"  (will be ignored)";
                    continue;
                }
                hasvalidUrn = true;
                res.add(geniUrn);
                LOG.trace("processed altName of URN type. userUrn=" + geniUrn + "\n");
            }
            if (!hasvalidUrn && !((String)invalidUrnErrors).isEmpty()) {
                LOG.warn((String)invalidUrnErrors);
            }
        }
        return res;
    }

    @Nonnull
    public static List<String> findDnsInCertAltSubjectNames(@Nonnull X509Certificate cert) {
        ArrayList<String> res = new ArrayList<String>();
        Collection<List<?>> altNames = null;
        try {
            altNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            LOG.error("Error processing certificate alternate names: " + e.getMessage());
        }
        LOG.trace("certificate has subject alt names: " + (altNames != null && altNames.isEmpty()) + "\n");
        if (altNames != null) {
            for (List<?> altName : altNames) {
                Integer nameType = (Integer)altName.get(0);
                LOG.trace("certificate has altname of type " + nameType + "\n");
                if (nameType != 2) continue;
                String dns = (String)altName.get(1);
                if (dns == null) {
                    LOG.warn("Warning: certificate dnsName is null (will be ignored)");
                    continue;
                }
                res.add(dns);
                LOG.trace("processed altName of URN type. dnsName=" + dns + "\n");
            }
        }
        return res;
    }

    @Nonnull
    public static byte[] keyToSshAgent(@Nonnull RSAPrivateCrtKey privateKey, @Nonnull String comment) {
        Buffer b = new Buffer();
        b.put(SSH_RSA);
        b.put(privateKey.getModulus());
        b.put(privateKey.getPublicExponent());
        b.put(privateKey.getPrivateExponent());
        b.put(privateKey.getCrtCoefficient());
        b.put(privateKey.getPrimeP());
        b.put(privateKey.getPrimeQ());
        b.put(comment);
        return b.toByteArray();
    }

    @Nonnull
    public static byte[] keyToSshAgent(@Nonnull DSAPrivateKey privateKey, @Nonnull DSAPublicKey publicKey, @Nonnull String comment) {
        assert (Objects.equals(privateKey.getParams().getP(), publicKey.getParams().getP()));
        assert (Objects.equals(privateKey.getParams().getQ(), publicKey.getParams().getQ()));
        assert (Objects.equals(privateKey.getParams().getG(), publicKey.getParams().getG()));
        Buffer b = new Buffer();
        b.put(SSH_DSS);
        b.put(privateKey.getParams().getP());
        b.put(privateKey.getParams().getQ());
        b.put(privateKey.getParams().getG());
        b.put(publicKey.getY());
        b.put(privateKey.getX());
        b.put(comment);
        return b.toByteArray();
    }

    @Nullable
    public static PublicKey blobToPublicKey(byte[] input) {
        String keyType;
        ByteBuffer bb = ByteBuffer.wrap(input).order(ByteOrder.BIG_ENDIAN);
        int kts = bb.getInt();
        byte[] kt = new byte[kts];
        bb.get(kt);
        switch (keyType = StringUtils.newStringUtf8((byte[])kt)) {
            case "ssh-rsa": {
                int pubExpSize = bb.getInt();
                byte[] pubExp = new byte[pubExpSize];
                bb.get(pubExp);
                int modulusSize = bb.getInt();
                byte[] modulus = new byte[modulusSize];
                bb.get(modulus);
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    return keyFactory.generatePublic(new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(pubExp)));
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn("Could not load RSA Algorithm", (Throwable)e);
                    return null;
                }
                catch (InvalidKeySpecException e) {
                    LOG.warn("Failed to create RSA public key from SSH Agent info", (Throwable)e);
                    return null;
                }
            }
            case "ssh-dss": {
                int ps = bb.getInt();
                byte[] p = new byte[ps];
                bb.get(p);
                int qs = bb.getInt();
                byte[] q = new byte[qs];
                bb.get(q);
                int gs = bb.getInt();
                byte[] g = new byte[gs];
                bb.get(g);
                int ys = bb.getInt();
                byte[] y = new byte[ys];
                bb.get(y);
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                    return keyFactory.generatePublic(new DSAPublicKeySpec(new BigInteger(y), new BigInteger(p), new BigInteger(q), new BigInteger(g)));
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn("Failed to load DSA Algorithm", (Throwable)e);
                    return null;
                }
                catch (InvalidKeySpecException e) {
                    LOG.warn("Failed to create DSA public key from SSH Agent Info", (Throwable)e);
                    return null;
                }
            }
        }
        LOG.warn("Unknown key type: {}", (Object)keyType);
        return null;
    }

    @Nonnull
    public static String keyStoreToString(@Nonnull KeyStore trustStore) {
        try {
            StringBuilder res = new StringBuilder();
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] certs = trustStore.getCertificateChain(alias);
                if (certs == null && trustStore.getCertificate(alias) != null) {
                    certs = new Certificate[]{trustStore.getCertificate(alias)};
                }
                res.append("").append(alias).append(":");
                if (certs != null) {
                    for (Certificate cert : certs) {
                        if (cert instanceof X509Certificate) {
                            X509Certificate x509cert = (X509Certificate)cert;
                            res.append("\n   ").append(x509cert.getSubjectDN()).append("  NotAfter=").append(x509cert.getNotAfter());
                            continue;
                        }
                        res.append("\n   [non-x509cert]");
                    }
                } else {
                    res.append("\n   [certs=null]");
                }
                res.append("\n");
            }
            return res.toString();
        }
        catch (KeyStoreException e) {
            return "KeyStoreException while iterating keystore: " + e.getMessage();
        }
    }

    @Nonnull
    @Deprecated
    public static byte[] stripPemHeaderAndDecode(@Nonnull String pemContent) throws PEMDecodingException {
        String pem = pemContent.replaceAll("\r\n", "\n").trim();
        Pattern start = Pattern.compile("-----BEGIN ([A-Z ]+)-----\n");
        String endPrefix = "\n-----END ";
        String endSuffix = "-----";
        String pemObject = "";
        Matcher m = start.matcher(pem = pem.trim());
        if (!m.find()) {
            throw new PEMDecodingException("No PEM BEGIN found");
        }
        String neededEnd = endPrefix + m.group(1) + endSuffix;
        int startPos = m.end();
        int endPos = pem.indexOf(neededEnd);
        if (endPos < startPos) {
            throw new PEMDecodingException("No matching PEM END found for " + m.group(1));
        }
        pemObject = pem.substring(startPos, endPos);
        pemObject = pemObject.replaceAll("\n", "");
        return Base64.decodeBase64((String)pemObject);
    }

    @Deprecated
    public static boolean isPrivateKeyPemIncludingPubKey(@Nonnull String pemContent) {
        if (KeyUtil.hasRsaPrivateKey(pemContent)) {
            return !KeyUtil.hasEncryptedRsaPrivateKey(pemContent);
        }
        return KeyUtil.hasOpenSshPrivateKey(pemContent);
    }

    @Nullable
    @Deprecated
    public static PublicKey getPublicKeyFromPrivKeyPEM(@Nonnull String pemContent) throws PEMDecodingException {
        if (KeyUtil.hasRsaPrivateKey(pemContent)) {
            java.security.interfaces.RSAPrivateKey privKey = KeyUtil.pemToRsaPrivateKey(pemContent, null);
            return KeyUtil.rsaPrivateKeyToRsaPublicKey(privKey);
        }
        if (KeyUtil.hasOpenSshPrivateKey(pemContent)) {
            OpenSSHPemParser k = new OpenSSHPemParser(pemContent);
            return KeyUtil.openSshAuthorizedKeysFormatPublicKey(k.pubKeys.get(0));
        }
        return null;
    }

    @Nonnull
    @Deprecated
    public static KeyPair pemToAnyKeyPair(@Nonnull String pem, @Nullable char[] password) throws PEMDecodingException {
        KeyPair res;
        String pemBlock;
        if (KeyUtil.hasOpenSshPrivateKey(pem) && (pemBlock = KeyUtil.extractFirstPemBlock(pem, "OPENSSH PRIVATE KEY")) != null) {
            if (password != null || !KeyUtil.hasEncryptedOpenSshPrivateKey(pem)) {
                KeyPair res2 = KeyUtil.openSSHPrivateKeyPemToKeyPair(pemBlock, password);
                if (res2 != null) {
                    return res2;
                }
            } else {
                OpenSSHPemParser k = new OpenSSHPemParser(pemBlock);
                assert (k.pubKeys.size() >= 1);
                PublicKey pubKey = KeyUtil.openSshAuthorizedKeysFormatPublicKey(k.pubKeys.get(0));
                return new KeyPair(pubKey, null);
            }
        }
        if (KeyUtil.hasRsaPrivateKey(pem) && (password != null || !KeyUtil.hasEncryptedRsaPrivateKey(pem)) && (res = KeyUtil.pemToRsaKeyPair(pem, password)) != null) {
            return res;
        }
        if (KeyUtil.hasPrivateKey(pem)) {
            PrivateKey privKey = KeyUtil.pemToPrivateKey(pem, password);
            RSAPublicKey publicKey = null;
            if (privKey instanceof java.security.interfaces.RSAPrivateKey) {
                publicKey = KeyUtil.rsaPrivateKeyToRsaPublicKey((java.security.interfaces.RSAPrivateKey)privKey);
            }
            return new KeyPair(publicKey, privKey);
        }
        return new KeyPair(null, null);
    }

    @Deprecated
    public static boolean isSameOpenSshFormatPubKey(@Nonnull String pubKey1, @Nonnull String pubKey2) {
        String[] pubKey1Parts = pubKey1.trim().split(" ");
        String[] pubKey2Parts = pubKey2.trim().split(" ");
        if (pubKey1Parts.length < 2 || pubKey2Parts.length < 2) {
            return false;
        }
        return Objects.equals(pubKey1Parts[1], pubKey2Parts[1]);
    }

    @Deprecated
    public static boolean isSamePubKey(@Nonnull PublicKey pubKey1, @Nonnull PublicKey pubKey2) {
        byte[] pubKey1Bytes = pubKey1.getEncoded();
        byte[] pubKey2Bytes = pubKey2.getEncoded();
        return Arrays.equals(pubKey1Bytes, pubKey2Bytes);
    }

    static {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOG = LoggerFactory.getLogger(KeyUtil.class);
    }

    private static class OpenSSHPemParser {
        @Nonnull
        public final String cipherName;
        @Nonnull
        public final String kdfName;
        @Nonnull
        public final String kdfOptions;
        public final int keyCount;
        @Nonnull
        public final List<String> pubKeys;
        public final boolean encryptedPrivateKey;

        public OpenSSHPemParser(@Nonnull String pemContent) throws PEMDecodingException {
            byte[] pemBytes = KeyUtil.extractPemBlockBytes(pemContent, "OPENSSH PRIVATE KEY");
            ByteBuffer bb = ByteBuffer.wrap(pemBytes);
            byte[] AUTH_MAGIC = "openssh-key-v1\u0000".getBytes();
            for (int i = 0; i < AUTH_MAGIC.length; ++i) {
                if (bb.get() == AUTH_MAGIC[i]) continue;
                throw new PEMDecodingException("OPENSSH PRIVATE KEY invalid (AUTH_MAGIC is bad)");
            }
            this.cipherName = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser cipherName=\"" + this.cipherName + "\"");
            this.encryptedPrivateKey = !this.cipherName.equals("none");
            this.kdfName = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser kdfName=\"" + this.kdfName + "\"");
            this.kdfOptions = OpenSSHPemParser.readString(bb);
            System.out.println("OpenSSHPemParser kdfOptions=\"" + this.kdfOptions + "\"");
            this.keyCount = bb.getInt();
            System.out.println("OpenSSHPemParser keyCount=\"" + this.keyCount + "\"");
            ArrayList<CallSite> pubKeys = new ArrayList<CallSite>(this.keyCount);
            for (int i = 0; i < this.keyCount; ++i) {
                byte[] pubKeyBytes = OpenSSHPemParser.readByteString(bb);
                String keyType = OpenSSHPemParser.readString(ByteBuffer.wrap(pubKeyBytes));
                String pubKeyB64 = keyType + " " + Base64.encodeBase64String((byte[])pubKeyBytes);
                pubKeys.add((CallSite)((Object)pubKeyB64));
                System.out.println("OpenSSHPemParser pubKey[" + i + "]=\"" + new String(pubKeyBytes) + "\"");
                System.out.println("OpenSSHPemParser pubKey[" + i + "]=\"" + pubKeyB64 + "\"");
            }
            this.pubKeys = Collections.unmodifiableList(pubKeys);
        }

        @Nonnull
        private static String readString(@Nonnull ByteBuffer bb) {
            int strLen = bb.getInt();
            byte[] strBytes = new byte[strLen];
            bb.get(strBytes);
            return new String(strBytes, 0, strLen, Charset.defaultCharset());
        }

        @Nonnull
        private static byte[] readByteString(@Nonnull ByteBuffer bb) {
            int strLen = bb.getInt();
            byte[] strBytes = new byte[strLen];
            bb.get(strBytes);
            return strBytes;
        }
    }

    @Deprecated
    public static class PEMDecodingException
    extends Exception {
        public PEMDecodingException() {
        }

        public PEMDecodingException(String message) {
            super(message);
        }

        public PEMDecodingException(String message, Throwable cause) {
            super(message, cause);
        }

        public PEMDecodingException(Throwable cause) {
            super(cause);
        }
    }

    public static enum AltNamesSource {
        SUBJECT_ALT_NAMES,
        ISSUES_ALT_NAMES;

    }

    private static class Buffer {
        private final ByteBuffer bb = ByteBuffer.allocate(20480);
        private int size = 0;

        private Buffer() {
        }

        public void put(@Nonnull String str) {
            this.put(str.getBytes(StandardCharsets.UTF_8));
        }

        public void put(@Nonnull BigInteger bigInteger) {
            this.put(bigInteger.toByteArray());
        }

        public void put(@Nonnull byte[] bytes) {
            this.bb.putInt(bytes.length);
            this.size += 4;
            this.bb.put(bytes);
            this.size += bytes.length;
        }

        @Nonnull
        public byte[] toByteArray() {
            byte[] result = new byte[this.size];
            this.bb.rewind();
            this.bb.get(result);
            return result;
        }
    }
}

