/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;

public class DebuggingAuthorityList {
    private static Testbed debuggingTestbed = null;
    private static Server debuggingServer = null;

    private DebuggingAuthorityList() {
    }

    public static String getDebuggingAuthUrn() {
        return "urn:publicid:IDN+debug.jfed.iminds.be+authority+cm";
    }

    public static boolean isDebugging(Service service) {
        DebuggingAuthorityList.getDebuggingServer();
        assert (service.getServer() == debuggingServer == ((Integer)service.getServer().getId()).equals(debuggingServer.getId()));
        return service.getServer() == debuggingServer;
    }

    public static boolean isDebugging(Server server) {
        DebuggingAuthorityList.getDebuggingServer();
        assert (server == debuggingServer == ((Integer)server.getId()).equals(debuggingServer.getId()));
        return server == debuggingServer;
    }

    public static boolean isDebugging(Testbed testbed) {
        DebuggingAuthorityList.getDebuggingServer();
        assert (testbed == debuggingTestbed == ((String)testbed.getId()).equals(debuggingTestbed.getId()));
        return testbed == debuggingTestbed;
    }

    private static void addService(ServerBuilder serverBuilder, ApiInfo.ApiName api, int version, String url, String urn) {
        ServiceBuilder serviceBuilder = new ServiceBuilder();
        serviceBuilder.setApi(api.getId());
        serviceBuilder.setApiVersion("" + version);
        serviceBuilder.setUrl(url);
        serviceBuilder.setUrn(urn);
        serverBuilder.addServiceBuilder(serviceBuilder);
    }

    public static Server getDebuggingServer() {
        if (debuggingTestbed == null || debuggingServer == null) {
            String debugUrn = DebuggingAuthorityList.getDebuggingAuthUrn();
            TestbedBuilder testbedBuilder = new TestbedBuilder();
            ServerBuilder serverBuilder = new ServerBuilder();
            testbedBuilder.addServerBuilder(serverBuilder);
            testbedBuilder.setLongName("jFed Debug Authority");
            serverBuilder.setName("jFed Debug Authority");
            testbedBuilder.setDefaultComponentManagerUrn(debugUrn);
            serverBuilder.setDefaultComponentManagerUrn(debugUrn);
            serverBuilder.setServerType("debugging");
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_AM, 2, "https://debug.jfed.iminds.be/example/AM/2", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_AM, 3, "https://debug.jfed.iminds.be/example/AM/3", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_CH, 1, "https://debug.jfed.iminds.be/example/GENI_CH/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_CH_MA, 1, "https://debug.jfed.iminds.be/example/GENI_CH_MA/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_CH_SA, 1, "https://debug.jfed.iminds.be/example/GENI_CH_SA/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1, "https://debug.jfed.iminds.be/example/PL/SR/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.PROTOGENI_CH, 1, "https://debug.jfed.iminds.be/example/PG/CH/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.PROTOGENI_SA, 1, "https://debug.jfed.iminds.be/example/PG/SA/1", debugUrn);
            DebuggingAuthorityList.addService(serverBuilder, ApiInfo.ApiName.GENI_SCS, 1, "https://debug.jfed.iminds.be/example/SCS/1", debugUrn);
            debuggingTestbed = testbedBuilder.create();
            debuggingServer = (Server)debuggingTestbed.getServers().get(0);
        }
        assert (debuggingServer != null);
        assert (debuggingTestbed != null);
        return debuggingServer;
    }
}

