/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.module;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Singleton;

public class JFedWebApiClientModule
extends AbstractModule {
    public static final String DEFAULT_URL_STRING = "https://flsmonitor-api.fed4fire.eu/";
    public static final String NAMED__NO_CLIENT_AUTH_WEBAPI_URL = "noClientAuthWebApiUrl";
    public static final String NAMED__CLIENT_AUTH_WEBAPI_URL = "clientAuthWebApiUrl";
    public static final String NAMED__NO_CLIENT_AUTH_WEBAPI_CONFIG = "noClientAuthWebApiConfig";
    public static final String NAMED__CLIENT_AUTH_WEBAPI_CONFIG = "clientAuthWebApiConfig";
    public static final String NAMED__NO_CLIENT_AUTH_WEBAPI_CLIENT = "noClientAuthWebApiClient";
    public static final String NAMED__CLIENT_AUTH_WEBAPI_CLIENT = "clientAuthWebApiClient";

    protected void configure() {
    }

    @Provides
    @Named(value="noClientAuthWebApiUrl")
    @Singleton
    private URL provideNoClientAuthWebApiUrl(JFedPreferences jFedPreferences) {
        String userPreference = jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_JFED_WEBAPI_URL);
        if (userPreference == null || userPreference.trim().isEmpty() || userPreference.trim().equalsIgnoreCase("BUILTIN") || userPreference.trim().equalsIgnoreCase("DEFAULT")) {
            try {
                return new URL(DEFAULT_URL_STRING);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Bug: builtin URL is invalid: \"https://flsmonitor-api.fed4fire.eu/\"");
            }
        }
        try {
            return new URL(userPreference);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("jFed config option \"" + CorePreferenceKey.PREF_JFED_WEBAPI_URL.getKey() + "\" has an invalid value: \"" + userPreference + "\"", e);
        }
    }

    @Provides
    @Named(value="clientAuthWebApiUrl")
    @Singleton
    private URL provideClientAuthWebApiUrl(JFedPreferences jFedPreferences) {
        return this.provideNoClientAuthWebApiUrl(jFedPreferences);
    }

    @Provides
    @Named(value="clientAuthWebApiConfig")
    @Singleton
    private FedmonWebApiClientConfig provideClientAuthWebApiConfig(JFedTrustStore trustStore, @Named(value="clientAuthWebApiUrl") URL url, Logger logger, GeniUserProvider geniUserProvider) {
        assert (geniUserProvider.isUserLoggedIn());
        Properties fedmonWebApiClientConfigProperties = new Properties();
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_read_base", url.toExternalForm());
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_write_base", url.toExternalForm());
        FedmonWebApiClientPropertiesConfig fedmonWebApiClientConfig = new FedmonWebApiClientPropertiesConfig(fedmonWebApiClientConfigProperties, trustStore, geniUserProvider.getLoggedInGeniUser().getClientCertificateChain(), geniUserProvider.getLoggedInGeniUser().getPrivateKey(), logger);
        return fedmonWebApiClientConfig;
    }

    @Provides
    @Named(value="noClientAuthWebApiConfig")
    @Singleton
    private FedmonWebApiClientConfig provideNoClientAuthWebApiConfig(JFedTrustStore trustStore, @Named(value="noClientAuthWebApiUrl") URL url, Logger logger) {
        Properties fedmonWebApiClientConfigProperties = new Properties();
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_read_base", url.toExternalForm());
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_write_base", "http://localhost/");
        FedmonWebApiClientPropertiesConfig fedmonWebApiClientConfig = new FedmonWebApiClientPropertiesConfig(fedmonWebApiClientConfigProperties, trustStore, null, null, logger);
        return fedmonWebApiClientConfig;
    }

    @Provides
    @Singleton
    private FedmonWebApiClient provideNoAuthFedmonWebApiClient(@Named(value="noClientAuthWebApiConfig") FedmonWebApiClientConfig fedmonWebApiClientConfig) {
        FedmonWebApiCachedClient fedmonWebApiClient = new FedmonWebApiCachedClient(fedmonWebApiClientConfig);
        return fedmonWebApiClient;
    }
}

