/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithIdBuilder;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdObjectLinkSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdObjectLinkSerializer.class);

    private JsonLdObjectLinkSerializer() {
        throw new RuntimeException("no constructor");
    }

    protected static boolean writeSimpleType(Object value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        boolean handled = false;
        if (value instanceof JsonLdObject) {
            JsonLdObject fedmonBasicObj = (JsonLdObject)value;
            JsonSerializer defaultSerializer = serializerProvider.findValueSerializer(fedmonBasicObj.getClass());
            assert (defaultSerializer != null) : "defaultSerializer is null for " + fedmonBasicObj.getClass().getName();
            assert (!defaultSerializer.getClass().equals(ChildLinkSerializer.class));
            assert (!defaultSerializer.getClass().equals(ChildrenLinkListSerializer.class));
            assert (!defaultSerializer.getClass().equals(ParentLinkSerializer.class));
            assert (!defaultSerializer.getClass().equals(ParentsLinkListSerializer.class));
            defaultSerializer.serialize((Object)fedmonBasicObj, jsonGenerator, serializerProvider);
            handled = true;
        }
        if (!handled && value instanceof String) {
            jsonGenerator.writeString((String)value);
            handled = true;
        }
        if (!handled && value instanceof Long) {
            jsonGenerator.writeNumber(((Long)value).longValue());
            handled = true;
        }
        if (!handled && value instanceof Integer) {
            jsonGenerator.writeNumber(((Integer)value).intValue());
            handled = true;
        }
        if (!handled && value instanceof Double) {
            jsonGenerator.writeNumber(((Double)value).doubleValue());
            handled = true;
        }
        if (!handled && value instanceof Float) {
            jsonGenerator.writeNumber(((Float)value).floatValue());
            handled = true;
        }
        if (!handled && value instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)value);
            handled = true;
        }
        if (!handled && value instanceof Number) {
            jsonGenerator.writeNumber(value.toString());
            handled = true;
        }
        if (!handled && value instanceof Boolean) {
            jsonGenerator.writeBoolean(((Boolean)value).booleanValue());
            handled = true;
        }
        return handled;
    }

    protected static void serializeAsUriOrEmbedded(PrimaryIdObject toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean childDirection, boolean neverEmbed) throws IOException {
        assert (toSerialize != null);
        if (toSerialize.getUri() != null && (neverEmbed || !toSerialize.getSerializeAsEmbeddedObject())) {
            jsonGenerator.writeString(toSerialize.getUri().toASCIIString());
        } else {
            Object toSerializeFinal;
            JsonLdObjectWithIdBuilder builder = JsonLdObjectsMetaData.createBuilderCopy(toSerialize);
            if (neverEmbed || !toSerialize.getSerializeAsEmbeddedObject()) {
                LOG.warn("Requested not to serialize as embedded object, but no other choice since URI not known for object of type " + toSerialize.getClass().getName());
                toSerializeFinal = builder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
            } else {
                toSerializeFinal = childDirection ? builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT) : builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_LINK_CHILDREN_EMBED_PARENT);
            }
            assert (toSerializeFinal != null);
            assert (toSerializeFinal.getClass().equals(toSerialize.getClass()));
            JsonSerializer defaultSerializer = serializerProvider.findValueSerializer(toSerializeFinal.getClass());
            assert (defaultSerializer != null) : "defaultSerializer is null for " + toSerializeFinal.getClass().getName();
            assert (!defaultSerializer.getClass().equals(ChildLinkSerializer.class));
            assert (!defaultSerializer.getClass().equals(ChildrenLinkListSerializer.class));
            assert (!defaultSerializer.getClass().equals(ParentLinkSerializer.class));
            assert (!defaultSerializer.getClass().equals(ParentsLinkListSerializer.class));
            defaultSerializer.serialize(toSerializeFinal, jsonGenerator, serializerProvider);
        }
    }

    public static class NeverEmbedChildLinkMapSerializer
    extends JsonSerializer<Map<String, Object>> {
        public void serialize(Map<String, Object> toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, Object> entry : toSerialize.entrySet()) {
                if (entry.getValue() == null) continue;
                assert (entry.getKey() != null);
                LOG.debug("key=" + entry.getKey());
                jsonGenerator.writeFieldName(entry.getKey());
                boolean handled = this.serializeAny(entry.getValue(), jsonGenerator, serializerProvider);
                if (handled) continue;
                LOG.warn("Could not serialize field \"" + entry.getKey() + "\" of class " + entry.getValue().getClass().getName());
            }
            jsonGenerator.writeEndObject();
        }

        public boolean serializeAny(Object toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize instanceof PrimaryIdObject) {
                PrimaryIdObject fedmonFullObj = (PrimaryIdObject)toSerialize;
                if (fedmonFullObj.getUri() == null) {
                    JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(fedmonFullObj, jsonGenerator, serializerProvider, false, true);
                } else {
                    jsonGenerator.writeString(fedmonFullObj.getUri().toASCIIString());
                }
                return true;
            }
            boolean handled = JsonLdObjectLinkSerializer.writeSimpleType(toSerialize, jsonGenerator, serializerProvider);
            if (!handled && toSerialize instanceof List) {
                List l = (List)toSerialize;
                jsonGenerator.writeStartArray(l.size());
                for (Object o : l) {
                    boolean handledListItem = JsonLdObjectLinkSerializer.writeSimpleType(o, jsonGenerator, serializerProvider);
                    if (!handledListItem) {
                        this.serializeAny(o, jsonGenerator, serializerProvider);
                        handledListItem = true;
                    }
                    if (!handledListItem) {
                        LOG.error("Failed to handle Map.List item in list with item of type " + o.getClass().getName() + "  -> will ignore it!");
                    }
                    assert (handledListItem);
                }
                jsonGenerator.writeEndArray();
                handled = true;
            }
            if (!handled && toSerialize instanceof Map) {
                Map m = (Map)toSerialize;
                this.serialize(m, jsonGenerator, serializerProvider);
                handled = true;
            }
            if (!handled) {
                LOG.error("Failed to handle Map item of type " + toSerialize.getClass().getName() + "  -> will ignore it!");
                jsonGenerator.writeNull();
            }
            assert (handled) : "Failed to handle Map item of type " + toSerialize.getClass().getName() + "  -> will ignore it!";
            return handled;
        }
    }

    public static class NeverEmbedParentsLinkListSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<List<T>> {
        public void serialize(List<T> toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            jsonGenerator.writeStartArray(toSerialize.size());
            for (PrimaryIdObject fedmonFullObj : toSerialize) {
                JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(fedmonFullObj, jsonGenerator, serializerProvider, false, true);
            }
            jsonGenerator.writeEndArray();
        }
    }

    public static class NeverEmbedChildrenLinkListSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<List<T>> {
        public void serialize(List<T> toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            jsonGenerator.writeStartArray(toSerialize.size());
            for (PrimaryIdObject fedmonFullObj : toSerialize) {
                JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(fedmonFullObj, jsonGenerator, serializerProvider, true, true);
            }
            jsonGenerator.writeEndArray();
        }
    }

    public static class NeverEmbedParentLinkSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<T> {
        public void serialize(T toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(toSerialize, jsonGenerator, serializerProvider, false, true);
        }
    }

    public static class NeverEmbedChildLinkSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<T> {
        public void serialize(T toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(toSerialize, jsonGenerator, serializerProvider, true, true);
        }
    }

    public static class ParentLinkSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<T> {
        public void serialize(T toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(toSerialize, jsonGenerator, serializerProvider, false, false);
        }
    }

    public static class ParentsLinkListSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<List<T>> {
        public void serialize(List<T> toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            jsonGenerator.writeStartArray(toSerialize.size());
            for (PrimaryIdObject fedmonFullObj : toSerialize) {
                JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(fedmonFullObj, jsonGenerator, serializerProvider, false, false);
            }
            jsonGenerator.writeEndArray();
        }
    }

    public static class ChildLinkSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<T> {
        public void serialize(T toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(toSerialize, jsonGenerator, serializerProvider, true, false);
        }
    }

    public static class ChildrenLinkListSerializer<T extends PrimaryIdObject>
    extends JsonSerializer<List<T>> {
        public void serialize(List<T> toSerialize, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (toSerialize == null) {
                return;
            }
            jsonGenerator.writeStartArray(toSerialize.size());
            for (PrimaryIdObject fedmonFullObj : toSerialize) {
                JsonLdObjectLinkSerializer.serializeAsUriOrEmbedded(fedmonFullObj, jsonGenerator, serializerProvider, true, false);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

