/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.ContextMap;
import org.rendersnake.internal.StackedMap;
import org.rendersnake.tools.Inspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContext
implements ContextMap {
    public static final String REQUEST_PATH = "http.request.path";
    public static final String REQUEST_URIQ = "http.request.uri.query";
    public static final String REQUEST_PARAMETERS = "http.request.parameters";
    public static final String SESSION = "http.session";
    public static final String REQUEST_HEADERS = "http.request.headers";
    public static final String REQUEST_COOKIES = "http.request.cookies";
    public StackedMap attributes = new StackedMap();

    public ContextMap getContextMap(String key) {
        return (ContextMap)this.attributes.get(key);
    }

    @Override
    public PageContext withObject(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public Object getObject(String key, Object ... optional) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return value;
    }

    @Override
    public PageContext withString(String key, String value) {
        this.attributes.put(key, (Object)value);
        return this;
    }

    @Override
    public String getString(String key, String ... optional) {
        String value = (String)this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        return value;
    }

    @Override
    public PageContext withInteger(String key, Integer number) {
        this.attributes.put(key, (Object)number);
        return this;
    }

    @Override
    public Integer getInteger(String key, Integer ... optional) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Integer.parseInt((String)value);
        }
        return null;
    }

    @Override
    public PageContext withBoolean(String key, Boolean trueOrFalse) {
        this.attributes.put(key, (Object)trueOrFalse);
        return this;
    }

    @Override
    public Boolean getBoolean(String key, Boolean ... optional) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Boolean.parseBoolean((String)value);
        }
        return null;
    }

    @Override
    public PageContext withFloat(String key, Float aFloat) {
        this.attributes.put(key, (Object)aFloat);
        return this;
    }

    @Override
    public Float getFloat(String key, Float ... optional) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    @Override
    public PageContext withLong(String key, Long aLong) {
        this.attributes.put(key, (Object)aLong);
        return this;
    }

    @Override
    public Long getLong(String key, Long ... optional) {
        Object value = this.attributes.get(key);
        if (value == null) {
            return optional == null || optional.length == 0 ? null : optional[0];
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            return Long.parseLong((String)value);
        }
        return null;
    }

    protected void beginRender() {
        this.attributes.push();
    }

    protected void endRender() {
        this.attributes.pop();
    }

    public void renderForInpectorOn(Inspector inspector, HtmlCanvas html) throws IOException {
        html.write("{d=" + this.attributes.getDepth() + "}");
    }

    public void renderForErrorOn(HtmlCanvas html) throws IOException {
        html.h3().write(this.getClass().getName())._h3();
        html.table(HtmlAttributesFactory.border("1px").cellpadding("4px"));
        for (String key : this.attributes.keySet()) {
            Object value = this.attributes.get(key);
            html.tr().td().write(key)._td().td().write(value.toString())._td()._tr();
        }
        html._table();
    }

    public String toString() {
        return this.attributes.toString();
    }

    @Override
    public Object clear(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String each : this.attributes.keySet()) {
            map.put(each, this.attributes.get(each));
        }
        return map;
    }
}

