/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpTransaction;
import io.sentry.ProfilingTraceData;
import io.sentry.ScopeCallback;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanId;
import io.sentry.TraceContext;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.UserFeedback;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NoOpHub
implements IHub {
    private static final NoOpHub instance = new NoOpHub();
    @NotNull
    private final SentryOptions emptyOptions = SentryOptions.empty();

    private NoOpHub() {
    }

    public static NoOpHub getInstance() {
        return instance;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @NotNull ScopeCallback callback) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return SentryId.EMPTY_ID;
    }

    @Override
    public void captureUserFeedback(@NotNull UserFeedback userFeedback) {
    }

    @Override
    public void startSession() {
    }

    @Override
    public void endSession() {
    }

    @Override
    public void close() {
    }

    @Override
    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Hint hint) {
    }

    @Override
    public void setLevel(@Nullable SentryLevel level) {
    }

    @Override
    public void setTransaction(@Nullable String transaction) {
    }

    @Override
    public void setUser(@Nullable User user) {
    }

    @Override
    public void setFingerprint(@NotNull List<String> fingerprint) {
    }

    @Override
    public void clearBreadcrumbs() {
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
    }

    @Override
    public void removeTag(@NotNull String key) {
    }

    @Override
    public void setExtra(@NotNull String key, @NotNull String value) {
    }

    @Override
    public void removeExtra(@NotNull String key) {
    }

    @Override
    @NotNull
    public SentryId getLastEventId() {
        return SentryId.EMPTY_ID;
    }

    @Override
    public void pushScope() {
    }

    @Override
    public void popScope() {
    }

    @Override
    public void withScope(@NotNull ScopeCallback callback) {
    }

    @Override
    public void configureScope(@NotNull ScopeCallback callback) {
    }

    @Override
    public void bindClient(@NotNull ISentryClient client) {
    }

    @Override
    public void flush(long timeoutMillis) {
    }

    @Override
    @NotNull
    public IHub clone() {
        return instance;
    }

    @Deprecated
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Hint hint, @Nullable ProfilingTraceData profilingTraceData) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Hint hint) {
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return NoOpTransaction.getInstance();
    }

    @Override
    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @Nullable CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return NoOpTransaction.getInstance();
    }

    @Override
    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        return NoOpTransaction.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader traceHeaders() {
        return new SentryTraceHeader(SentryId.EMPTY_ID, SpanId.EMPTY_ID, true);
    }

    @Override
    public void setSpanContext(@NotNull Throwable throwable, @NotNull ISpan spanContext, @NotNull String transactionName) {
    }

    @Override
    @Nullable
    public ISpan getSpan() {
        return null;
    }

    @Override
    @NotNull
    public SentryOptions getOptions() {
        return this.emptyOptions;
    }

    @Override
    @Nullable
    public Boolean isCrashedLastRun() {
        return null;
    }
}

