/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISentryExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class SentryExecutorService
implements ISentryExecutorService {
    @NotNull
    private final ScheduledExecutorService executorService;

    @TestOnly
    SentryExecutorService(@NotNull ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    SentryExecutorService() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    @Override
    @NotNull
    public Future<?> schedule(@NotNull Runnable runnable, long delayMillis) {
        return this.executorService.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long timeoutMillis) {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

