/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.DiagnosticLogger;
import io.sentry.DuplicateEventDetectionEventProcessor;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.ExternalOptions;
import io.sentry.Hint;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.IScopeObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.ISerializer;
import io.sentry.ITransactionProfiler;
import io.sentry.ITransportFactory;
import io.sentry.Instrumenter;
import io.sentry.Integration;
import io.sentry.JsonSerializer;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpEnvelopeReader;
import io.sentry.NoOpLogger;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpSerializer;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoOpTransportFactory;
import io.sentry.SamplingContext;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.clientreport.ClientReportRecorder;
import io.sentry.clientreport.IClientReportRecorder;
import io.sentry.clientreport.NoOpClientReportRecorder;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.protocol.SdkVersion;
import io.sentry.protocol.SentryTransaction;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.Platform;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    @NotNull
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    @NotNull
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    @Nullable
    private String dsn;
    @Nullable
    private String dsnHash;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private boolean debug;
    private boolean enableNdk = true;
    @NotNull
    private ILogger logger = NoOpLogger.getInstance();
    @NotNull
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    @NotNull
    private IEnvelopeReader envelopeReader = new EnvelopeReader(new JsonSerializer(this));
    @NotNull
    private ISerializer serializer = new JsonSerializer(this);
    private int maxDepth = 100;
    @Nullable
    private String sentryClientName;
    @Nullable
    private BeforeSendCallback beforeSend;
    @Nullable
    private BeforeSendTransactionCallback beforeSendTransaction;
    @Nullable
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    @Nullable
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private Proxy proxy;
    @Nullable
    private Double sampleRate;
    @Nullable
    private Double tracesSampleRate;
    @Nullable
    private TracesSamplerCallback tracesSampler;
    @NotNull
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    @NotNull
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    @Nullable
    private String dist;
    private boolean attachThreads;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private long sessionTrackingIntervalMillis = 30000L;
    @Nullable
    private String distinctId;
    @Nullable
    private String serverName;
    private boolean attachServerName = true;
    private boolean enableUncaughtExceptionHandler = true;
    private boolean printUncaughtStackTrace = false;
    @NotNull
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    @NotNull
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    @Nullable
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    @NotNull
    private final List<IScopeObserver> observers = new ArrayList<IScopeObserver>();
    private boolean enableScopeSync;
    private boolean enableExternalConfiguration;
    @NotNull
    private final @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    private boolean enableDeduplication = true;
    private int maxSpans = 1000;
    private boolean enableShutdownHook = true;
    @NotNull
    private RequestSize maxRequestBodySize = RequestSize.NONE;
    private boolean traceSampling = true;
    @Nullable
    private Double profilesSampleRate;
    @Nullable
    private ProfilesSamplerCallback profilesSampler;
    private long maxTraceFileSize = 0x500000L;
    @NotNull
    private ITransactionProfiler transactionProfiler = NoOpTransactionProfiler.getInstance();
    @Nullable
    private List<String> tracePropagationTargets = null;
    @NotNull
    private final List<String> defaultTracePropagationTargets = Collections.singletonList(".*");
    @Nullable
    private String proguardUuid;
    @Nullable
    private Long idleTimeout = 3000L;
    @NotNull
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private boolean sendClientReports = true;
    @NotNull
    IClientReportRecorder clientReportRecorder = new ClientReportRecorder(this);
    @NotNull
    private IModulesLoader modulesLoader = NoOpModulesLoader.getInstance();
    @NotNull
    private Instrumenter instrumenter = Instrumenter.SENTRY;

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    @NotNull
    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addIntegration(@NotNull Integration integration) {
        this.integrations.add(integration);
    }

    @NotNull
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @Nullable
    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = dsn;
        this.dsnHash = StringUtils.calculateStringHash(this.dsn, this.logger);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @NotNull
    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable ILogger logger) {
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, logger);
    }

    @NotNull
    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(@Nullable SentryLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel != null ? diagnosticLevel : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    @NotNull
    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(@Nullable ISerializer serializer) {
        this.serializer = serializer != null ? serializer : NoOpSerializer.getInstance();
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @NotNull
    public IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader;
    }

    public void setEnvelopeReader(@Nullable IEnvelopeReader envelopeReader) {
        this.envelopeReader = envelopeReader != null ? envelopeReader : NoOpEnvelopeReader.getInstance();
    }

    public boolean isEnableNdk() {
        return this.enableNdk;
    }

    public void setEnableNdk(boolean enableNdk) {
        this.enableNdk = enableNdk;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public long getShutdownTimeout() {
        return this.shutdownTimeoutMillis;
    }

    public long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setShutdownTimeout(long shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    public void setShutdownTimeoutMillis(long shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    @Nullable
    public String getSentryClientName() {
        return this.sentryClientName;
    }

    public void setSentryClientName(@Nullable String sentryClientName) {
        this.sentryClientName = sentryClientName;
    }

    @Nullable
    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public void setBeforeSend(@Nullable BeforeSendCallback beforeSend) {
        this.beforeSend = beforeSend;
    }

    @Nullable
    public BeforeSendTransactionCallback getBeforeSendTransaction() {
        return this.beforeSendTransaction;
    }

    public void setBeforeSendTransaction(@Nullable BeforeSendTransactionCallback beforeSendTransaction) {
        this.beforeSendTransaction = beforeSendTransaction;
    }

    @Nullable
    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    public void setBeforeBreadcrumb(@Nullable BeforeBreadcrumbCallback beforeBreadcrumb) {
        this.beforeBreadcrumb = beforeBreadcrumb;
    }

    @Nullable
    public String getCacheDirPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.dsnHash != null ? new File(this.cacheDirPath, this.dsnHash).getAbsolutePath() : this.cacheDirPath;
    }

    @Nullable
    public String getOutboxPath() {
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File(cacheDirPath, "outbox").getAbsolutePath();
    }

    public void setCacheDirPath(@Nullable String cacheDirPath) {
        this.cacheDirPath = cacheDirPath;
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        this.maxBreadcrumbs = maxBreadcrumbs;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public Double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        if (!SampleRateUtils.isValidSampleRate(sampleRate)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values > 0.0 and <= 1.0.");
        }
        this.sampleRate = sampleRate;
    }

    @Nullable
    public Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    public void setTracesSampleRate(@Nullable Double tracesSampleRate) {
        if (!SampleRateUtils.isValidTracesSampleRate(tracesSampleRate)) {
            throw new IllegalArgumentException("The value " + tracesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.tracesSampleRate = tracesSampleRate;
    }

    @Nullable
    public TracesSamplerCallback getTracesSampler() {
        return this.tracesSampler;
    }

    public void setTracesSampler(@Nullable TracesSamplerCallback tracesSampler) {
        this.tracesSampler = tracesSampler;
    }

    @NotNull
    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public void addInAppExclude(@NotNull String exclude) {
        this.inAppExcludes.add(exclude);
    }

    @NotNull
    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public void addInAppInclude(@NotNull String include) {
        this.inAppIncludes.add(include);
    }

    @NotNull
    public ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public void setTransportFactory(@Nullable ITransportFactory transportFactory) {
        this.transportFactory = transportFactory != null ? transportFactory : NoOpTransportFactory.getInstance();
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @NotNull
    public ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public void setTransportGate(@Nullable ITransportGate transportGate) {
        this.transportGate = transportGate != null ? transportGate : NoOpTransportGate.getInstance();
    }

    public boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    public void setAttachStacktrace(boolean attachStacktrace) {
        this.attachStacktrace = attachStacktrace;
    }

    public boolean isAttachThreads() {
        return this.attachThreads;
    }

    public void setAttachThreads(boolean attachThreads) {
        this.attachThreads = attachThreads;
    }

    public boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    public void setEnableAutoSessionTracking(boolean enableAutoSessionTracking) {
        this.enableAutoSessionTracking = enableAutoSessionTracking;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    public boolean isAttachServerName() {
        return this.attachServerName;
    }

    public void setAttachServerName(boolean attachServerName) {
        this.attachServerName = attachServerName;
    }

    public long getSessionTrackingIntervalMillis() {
        return this.sessionTrackingIntervalMillis;
    }

    public void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        this.sessionTrackingIntervalMillis = sessionTrackingIntervalMillis;
    }

    @ApiStatus.Internal
    @Nullable
    public String getDistinctId() {
        return this.distinctId;
    }

    @ApiStatus.Internal
    public void setDistinctId(@Nullable String distinctId) {
        this.distinctId = distinctId;
    }

    public long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public void setFlushTimeoutMillis(long flushTimeoutMillis) {
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public void setEnableUncaughtExceptionHandler(boolean enableUncaughtExceptionHandler) {
        this.enableUncaughtExceptionHandler = enableUncaughtExceptionHandler;
    }

    public boolean isPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public void setPrintUncaughtStackTrace(boolean printUncaughtStackTrace) {
        this.printUncaughtStackTrace = printUncaughtStackTrace;
    }

    @ApiStatus.Internal
    @NotNull
    public ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    @ApiStatus.Internal
    @TestOnly
    public void setExecutorService(@NotNull ISentryExecutorService executorService) {
        if (executorService != null) {
            this.executorService = executorService;
        }
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @NotNull
    public IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    public void setEnvelopeDiskCache(@Nullable IEnvelopeCache envelopeDiskCache) {
        this.envelopeDiskCache = envelopeDiskCache != null ? envelopeDiskCache : NoOpEnvelopeCache.getInstance();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize > 0) {
            this.maxQueueSize = maxQueueSize;
        }
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @ApiStatus.Internal
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public boolean isSendDefaultPii() {
        return this.sendDefaultPii;
    }

    public void setSendDefaultPii(boolean sendDefaultPii) {
        this.sendDefaultPii = sendDefaultPii;
    }

    public void addScopeObserver(@NotNull IScopeObserver observer) {
        this.observers.add(observer);
    }

    @NotNull
    List<IScopeObserver> getScopeObservers() {
        return this.observers;
    }

    public boolean isEnableScopeSync() {
        return this.enableScopeSync;
    }

    public void setEnableScopeSync(boolean enableScopeSync) {
        this.enableScopeSync = enableScopeSync;
    }

    public boolean isEnableExternalConfiguration() {
        return this.enableExternalConfiguration;
    }

    public void setEnableExternalConfiguration(boolean enableExternalConfiguration) {
        this.enableExternalConfiguration = enableExternalConfiguration;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        this.tags.put(key, value);
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(long maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
    }

    public boolean isEnableDeduplication() {
        return this.enableDeduplication;
    }

    public void setEnableDeduplication(boolean enableDeduplication) {
        this.enableDeduplication = enableDeduplication;
    }

    public boolean isTracingEnabled() {
        return this.getTracesSampleRate() != null || this.getTracesSampler() != null;
    }

    @NotNull
    public Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    public void addIgnoredExceptionForType(@NotNull Class<? extends Throwable> exceptionType) {
        this.ignoredExceptionsForType.add(exceptionType);
    }

    boolean containsIgnoredExceptionForType(@NotNull Throwable throwable) {
        return this.ignoredExceptionsForType.contains(throwable.getClass());
    }

    @ApiStatus.Experimental
    public int getMaxSpans() {
        return this.maxSpans;
    }

    @ApiStatus.Experimental
    public void setMaxSpans(int maxSpans) {
        this.maxSpans = maxSpans;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public void setEnableShutdownHook(boolean enableShutdownHook) {
        this.enableShutdownHook = enableShutdownHook;
    }

    public int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public void setMaxCacheItems(int maxCacheItems) {
        this.maxCacheItems = maxCacheItems;
    }

    @NotNull
    public RequestSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(@NotNull RequestSize maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    @ApiStatus.Experimental
    public boolean isTraceSampling() {
        return this.traceSampling;
    }

    @Deprecated
    public void setTraceSampling(boolean traceSampling) {
        this.traceSampling = traceSampling;
    }

    public long getMaxTraceFileSize() {
        return this.maxTraceFileSize;
    }

    public void setMaxTraceFileSize(long maxTraceFileSize) {
        this.maxTraceFileSize = maxTraceFileSize;
    }

    @NotNull
    public ITransactionProfiler getTransactionProfiler() {
        return this.transactionProfiler;
    }

    public void setTransactionProfiler(@Nullable ITransactionProfiler transactionProfiler) {
        this.transactionProfiler = transactionProfiler != null ? transactionProfiler : NoOpTransactionProfiler.getInstance();
    }

    public boolean isProfilingEnabled() {
        return this.getProfilesSampleRate() != null && this.getProfilesSampleRate() > 0.0 || this.getProfilesSampler() != null;
    }

    @Deprecated
    public void setProfilingEnabled(boolean profilingEnabled) {
        if (this.getProfilesSampleRate() == null) {
            this.setProfilesSampleRate(profilingEnabled ? Double.valueOf(1.0) : null);
        }
    }

    @Nullable
    public ProfilesSamplerCallback getProfilesSampler() {
        return this.profilesSampler;
    }

    public void setProfilesSampler(@Nullable ProfilesSamplerCallback profilesSampler) {
        this.profilesSampler = profilesSampler;
    }

    @Nullable
    public Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    public void setProfilesSampleRate(@Nullable Double profilesSampleRate) {
        if (!SampleRateUtils.isValidProfilesSampleRate(profilesSampleRate)) {
            throw new IllegalArgumentException("The value " + profilesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.profilesSampleRate = profilesSampleRate;
    }

    @Nullable
    public String getProfilingTracesDirPath() {
        String cacheDirPath = this.getCacheDirPath();
        if (cacheDirPath == null) {
            return null;
        }
        return new File(cacheDirPath, "profiling_traces").getAbsolutePath();
    }

    @Deprecated
    @NotNull
    public List<String> getTracingOrigins() {
        return this.getTracePropagationTargets();
    }

    @Deprecated
    public void addTracingOrigin(@NotNull String tracingOrigin) {
        if (this.tracePropagationTargets == null) {
            this.tracePropagationTargets = new CopyOnWriteArrayList<String>();
        }
        if (!tracingOrigin.isEmpty()) {
            this.tracePropagationTargets.add(tracingOrigin);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public void setTracingOrigins(@Nullable List<String> tracingOrigins) {
        this.setTracePropagationTargets(tracingOrigins);
    }

    @NotNull
    public List<String> getTracePropagationTargets() {
        if (this.tracePropagationTargets == null) {
            return this.defaultTracePropagationTargets;
        }
        return this.tracePropagationTargets;
    }

    @ApiStatus.Internal
    public void setTracePropagationTargets(@Nullable List<String> tracePropagationTargets) {
        if (tracePropagationTargets == null) {
            this.tracePropagationTargets = tracePropagationTargets;
        } else {
            @NotNull ArrayList<String> filteredTracePropagationTargets = new ArrayList<String>();
            for (String target : tracePropagationTargets) {
                if (target.isEmpty()) continue;
                filteredTracePropagationTargets.add(target);
            }
            this.tracePropagationTargets = filteredTracePropagationTargets;
        }
    }

    @Nullable
    public String getProguardUuid() {
        return this.proguardUuid;
    }

    public void setProguardUuid(@Nullable String proguardUuid) {
        this.proguardUuid = proguardUuid;
    }

    @NotNull
    public List<String> getContextTags() {
        return this.contextTags;
    }

    public void addContextTag(@NotNull String contextTag) {
        this.contextTags.add(contextTag);
    }

    @Nullable
    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(@Nullable Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isSendClientReports() {
        return this.sendClientReports;
    }

    public void setSendClientReports(boolean sendClientReports) {
        this.sendClientReports = sendClientReports;
        this.clientReportRecorder = sendClientReports ? new ClientReportRecorder(this) : new NoOpClientReportRecorder();
    }

    public void setInstrumenter(@NotNull Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    @NotNull
    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    @ApiStatus.Internal
    @NotNull
    public IClientReportRecorder getClientReportRecorder() {
        return this.clientReportRecorder;
    }

    @ApiStatus.Internal
    @NotNull
    public IModulesLoader getModulesLoader() {
        return this.modulesLoader;
    }

    @ApiStatus.Internal
    public void setModulesLoader(@Nullable IModulesLoader modulesLoader) {
        this.modulesLoader = modulesLoader != null ? modulesLoader : NoOpModulesLoader.getInstance();
    }

    @NotNull
    static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    private SentryOptions(boolean empty) {
        if (!empty) {
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add(new DuplicateEventDetectionEventProcessor(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            this.setSentryClientName("sentry.java/6.9.0");
            this.setSdkVersion(this.createSdkVersion());
        }
    }

    public void merge(@NotNull ExternalOptions options) {
        if (options.getDsn() != null) {
            this.setDsn(options.getDsn());
        }
        if (options.getEnvironment() != null) {
            this.setEnvironment(options.getEnvironment());
        }
        if (options.getRelease() != null) {
            this.setRelease(options.getRelease());
        }
        if (options.getDist() != null) {
            this.setDist(options.getDist());
        }
        if (options.getServerName() != null) {
            this.setServerName(options.getServerName());
        }
        if (options.getProxy() != null) {
            this.setProxy(options.getProxy());
        }
        if (options.getEnableUncaughtExceptionHandler() != null) {
            this.setEnableUncaughtExceptionHandler(options.getEnableUncaughtExceptionHandler());
        }
        if (options.getPrintUncaughtStackTrace() != null) {
            this.setPrintUncaughtStackTrace(options.getPrintUncaughtStackTrace());
        }
        if (options.getTracesSampleRate() != null) {
            this.setTracesSampleRate(options.getTracesSampleRate());
        }
        if (options.getProfilesSampleRate() != null) {
            this.setProfilesSampleRate(options.getProfilesSampleRate());
        }
        if (options.getDebug() != null) {
            this.setDebug(options.getDebug());
        }
        if (options.getEnableDeduplication() != null) {
            this.setEnableDeduplication(options.getEnableDeduplication());
        }
        if (options.getSendClientReports() != null) {
            this.setSendClientReports(options.getSendClientReports());
        }
        HashMap<String, String> tags = new HashMap<String, String>(options.getTags());
        for (Map.Entry entry : tags.entrySet()) {
            this.tags.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList<String> inAppIncludes = new ArrayList<String>(options.getInAppIncludes());
        for (String string : inAppIncludes) {
            this.addInAppInclude(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(options.getInAppExcludes());
        for (String inAppExclude : arrayList) {
            this.addInAppExclude(inAppExclude);
        }
        for (Class<? extends Throwable> exceptionType : new HashSet<Class<? extends Throwable>>(options.getIgnoredExceptionsForType())) {
            this.addIgnoredExceptionForType(exceptionType);
        }
        if (options.getTracePropagationTargets() != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>(options.getTracePropagationTargets());
            this.setTracePropagationTargets(arrayList2);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(options.getContextTags());
        for (String contextTag : arrayList3) {
            this.addContextTag(contextTag);
        }
        if (options.getProguardUuid() != null) {
            this.setProguardUuid(options.getProguardUuid());
        }
        if (options.getIdleTimeout() != null) {
            this.setIdleTimeout(options.getIdleTimeout());
        }
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        String version = "6.9.0";
        SdkVersion sdkVersion = new SdkVersion("sentry.java", "6.9.0");
        sdkVersion.setVersion("6.9.0");
        sdkVersion.addPackage("maven:io.sentry:sentry", "6.9.0");
        return sdkVersion;
    }

    public static interface BeforeSendCallback {
        @Nullable
        public SentryEvent execute(@NotNull SentryEvent var1, @NotNull Hint var2);
    }

    public static interface BeforeSendTransactionCallback {
        @Nullable
        public SentryTransaction execute(@NotNull SentryTransaction var1, @NotNull Hint var2);
    }

    public static interface BeforeBreadcrumbCallback {
        @Nullable
        public Breadcrumb execute(@NotNull Breadcrumb var1, @NotNull Hint var2);
    }

    public static final class Proxy {
        @Nullable
        private String host;
        @Nullable
        private String port;
        @Nullable
        private String user;
        @Nullable
        private String pass;

        public Proxy(@Nullable String host, @Nullable String port, @Nullable String user, @Nullable String pass) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.pass = pass;
        }

        public Proxy() {
            this(null, null, null, null);
        }

        public Proxy(@Nullable String host, @Nullable String port) {
            this(host, port, null, null);
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @Nullable
        public String getPort() {
            return this.port;
        }

        public void setPort(@Nullable String port) {
            this.port = port;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }

        public void setUser(@Nullable String user) {
            this.user = user;
        }

        @Nullable
        public String getPass() {
            return this.pass;
        }

        public void setPass(@Nullable String pass) {
            this.pass = pass;
        }
    }

    public static interface TracesSamplerCallback {
        @Nullable
        public Double sample(@NotNull SamplingContext var1);
    }

    public static enum RequestSize {
        NONE,
        SMALL,
        MEDIUM,
        ALWAYS;

    }

    public static interface ProfilesSamplerCallback {
        @Nullable
        public Double sample(@NotNull SamplingContext var1);
    }
}

