/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SamplingContext;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.util.Objects;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class TracesSampler {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SecureRandom random;

    public TracesSampler(@NotNull SentryOptions options) {
        this(Objects.requireNonNull(options, "options are required"), new SecureRandom());
    }

    @TestOnly
    TracesSampler(@NotNull SentryOptions options, @NotNull SecureRandom random) {
        this.options = options;
        this.random = random;
    }

    @NotNull
    TracesSamplingDecision sample(@NotNull SamplingContext samplingContext) {
        TracesSamplingDecision parentSamplingDecision;
        TracesSamplingDecision samplingContextSamplingDecision = samplingContext.getTransactionContext().getSamplingDecision();
        if (samplingContextSamplingDecision != null) {
            return samplingContextSamplingDecision;
        }
        Double profilesSampleRate = null;
        if (this.options.getProfilesSampler() != null) {
            try {
                profilesSampleRate = this.options.getProfilesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ProfilesSamplerCallback' callback.", t);
            }
        }
        if (profilesSampleRate == null) {
            profilesSampleRate = this.options.getProfilesSampleRate();
        }
        Boolean profilesSampled = profilesSampleRate != null && this.sample(profilesSampleRate);
        if (this.options.getTracesSampler() != null) {
            Double samplerResult = null;
            try {
                samplerResult = this.options.getTracesSampler().sample(samplingContext);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'TracesSamplerCallback' callback.", t);
            }
            if (samplerResult != null) {
                return new TracesSamplingDecision(this.sample(samplerResult), samplerResult, profilesSampled, profilesSampleRate);
            }
        }
        if ((parentSamplingDecision = samplingContext.getTransactionContext().getParentSamplingDecision()) != null) {
            return parentSamplingDecision;
        }
        Double tracesSampleRateFromOptions = this.options.getTracesSampleRate();
        if (tracesSampleRateFromOptions != null) {
            return new TracesSamplingDecision(this.sample(tracesSampleRateFromOptions), tracesSampleRateFromOptions, profilesSampled, profilesSampleRate);
        }
        return new TracesSamplingDecision(false, null, false, null);
    }

    private boolean sample(@NotNull Double aDouble) {
        return !(aDouble < this.random.nextDouble());
    }
}

