/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.profilemeasurements;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ProfileMeasurementValue
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private Map<String, Object> unknown;
    @NotNull
    private Long relativeStartNs;
    @NotNull
    private String value;

    public ProfileMeasurementValue() {
        this(0L, 0);
    }

    public ProfileMeasurementValue(@NotNull Long relativeStartNs, @NotNull Number value) {
        this.relativeStartNs = relativeStartNs;
        this.value = value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileMeasurementValue that = (ProfileMeasurementValue)o;
        return Objects.equals(this.unknown, that.unknown) && this.relativeStartNs.equals(that.relativeStartNs) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.unknown, this.relativeStartNs, this.value);
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("value").value(logger, this.value);
        writer.name("elapsed_since_start_ns").value(logger, this.relativeStartNs);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String VALUE = "value";
        public static final String START_NS = "elapsed_since_start_ns";
    }

    public static final class Deserializer
    implements JsonDeserializer<ProfileMeasurementValue> {
        @Override
        @NotNull
        public ProfileMeasurementValue deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            ProfileMeasurementValue data = new ProfileMeasurementValue();
            ConcurrentHashMap<String, Object> unknown = null;
            block8: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "value": {
                        String value = reader.nextStringOrNull();
                        if (value == null) continue block8;
                        data.value = value;
                        continue block8;
                    }
                    case "elapsed_since_start_ns": {
                        Long startNs = reader.nextLongOrNull();
                        if (startNs == null) continue block8;
                        data.relativeStartNs = startNs;
                        continue block8;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            data.setUnknown(unknown);
            reader.endObject();
            return data;
        }
    }
}

