/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Response
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "response";
    @Nullable
    private String cookies;
    @Nullable
    private Map<String, String> headers;
    @Nullable
    private Integer statusCode;
    @Nullable
    private Long bodySize;
    @Nullable
    private Map<String, Object> unknown;

    public Response() {
    }

    public Response(@NotNull Response response) {
        this.cookies = response.cookies;
        this.headers = CollectionUtils.newConcurrentHashMap(response.headers);
        this.unknown = CollectionUtils.newConcurrentHashMap(response.unknown);
        this.statusCode = response.statusCode;
        this.bodySize = response.bodySize;
    }

    @Nullable
    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(@Nullable String cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@Nullable Map<String, String> headers) {
        this.headers = CollectionUtils.newConcurrentHashMap(headers);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Nullable
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(@Nullable Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Nullable
    public Long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(@Nullable Long bodySize) {
        this.bodySize = bodySize;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.cookies != null) {
            writer.name("cookies").value(this.cookies);
        }
        if (this.headers != null) {
            writer.name("headers").value(logger, this.headers);
        }
        if (this.statusCode != null) {
            writer.name("status_code").value(logger, this.statusCode);
        }
        if (this.bodySize != null) {
            writer.name("body_size").value(logger, this.bodySize);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String COOKIES = "cookies";
        public static final String HEADERS = "headers";
        public static final String STATUS_CODE = "status_code";
        public static final String BODY_SIZE = "body_size";
    }

    public static final class Deserializer
    implements JsonDeserializer<Response> {
        @Override
        @NotNull
        public Response deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            Response response = new Response();
            ConcurrentHashMap<String, Object> unknown = null;
            block12: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "cookies": {
                        response.cookies = reader.nextStringOrNull();
                        continue block12;
                    }
                    case "headers": {
                        Map deserializedHeaders = (Map)reader.nextObjectOrNull();
                        if (deserializedHeaders == null) continue block12;
                        response.headers = CollectionUtils.newConcurrentHashMap(deserializedHeaders);
                        continue block12;
                    }
                    case "status_code": {
                        response.statusCode = reader.nextIntegerOrNull();
                        continue block12;
                    }
                    case "body_size": {
                        response.bodySize = reader.nextLongOrNull();
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            response.setUnknown(unknown);
            reader.endObject();
            return response;
        }
    }
}

