/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonObjectWriter;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.util.CollectionUtils;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class User
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String email;
    @Nullable
    private String id;
    @Nullable
    private String username;
    @Nullable
    private String segment;
    @Nullable
    private String ipAddress;
    private @Nullable Map<String, @NotNull String> data;
    private @Nullable Map<String, @NotNull Object> unknown;

    public User() {
    }

    public User(@NotNull User user) {
        this.email = user.email;
        this.username = user.username;
        this.id = user.id;
        this.ipAddress = user.ipAddress;
        this.segment = user.segment;
        this.data = CollectionUtils.newConcurrentHashMap(user.data);
        this.unknown = CollectionUtils.newConcurrentHashMap(user.unknown);
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    public String getSegment() {
        return this.segment;
    }

    public void setSegment(@Nullable String segment) {
        this.segment = segment;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(@Nullable String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Deprecated
    public @Nullable Map<String, @NotNull String> getOthers() {
        return this.getData();
    }

    @Deprecated
    public void setOthers(@Nullable Map<String, @NotNull String> other) {
        this.setData(other);
    }

    public @Nullable Map<String, @NotNull String> getData() {
        return this.data;
    }

    public void setData(@Nullable Map<String, @NotNull String> data) {
        this.data = CollectionUtils.newConcurrentHashMap(data);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull JsonObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.email != null) {
            writer.name("email").value(this.email);
        }
        if (this.id != null) {
            writer.name("id").value(this.id);
        }
        if (this.username != null) {
            writer.name("username").value(this.username);
        }
        if (this.segment != null) {
            writer.name("segment").value(this.segment);
        }
        if (this.ipAddress != null) {
            writer.name("ip_address").value(this.ipAddress);
        }
        if (this.data != null) {
            writer.name("data").value(logger, this.data);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String EMAIL = "email";
        public static final String ID = "id";
        public static final String USERNAME = "username";
        public static final String SEGMENT = "segment";
        public static final String IP_ADDRESS = "ip_address";
        public static final String OTHER = "other";
        public static final String DATA = "data";
    }

    public static final class Deserializer
    implements JsonDeserializer<User> {
        @Override
        @NotNull
        public User deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            User user = new User();
            ConcurrentHashMap<String, Object> unknown = null;
            block18: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "email": {
                        user.email = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "id": {
                        user.id = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "username": {
                        user.username = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "segment": {
                        user.segment = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "ip_address": {
                        user.ipAddress = reader.nextStringOrNull();
                        continue block18;
                    }
                    case "data": {
                        user.data = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block18;
                    }
                    case "other": {
                        if (user.data != null && !user.data.isEmpty()) continue block18;
                        user.data = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block18;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            user.setUnknown(unknown);
            reader.endObject();
            return user;
        }
    }
}

