/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalDirESpecBundle
implements ESpecBundle {
    @Nonnull
    private final File dir;
    @Nonnull
    private final List<File> files;
    @Nullable
    private final ExperimentSpecification eSpec;

    LocalDirESpecBundle(@Nonnull File dir) {
        this.dir = dir;
        File[] filesArr = dir.listFiles();
        if (filesArr == null) {
            throw new RuntimeException("\"" + dir.getPath() + "\" is not a directory containing files, or an IO exception occured.");
        }
        this.files = Arrays.asList(filesArr);
        if (ESpecBundle.containsESpecDescriptionFilename(this.getFileNames())) {
            ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
            try {
                this.eSpec = parser.parse(this.getExperimentSpecificationYml());
            }
            catch (ExperimentSpecificationParser.ExperimentSpecificationParseException e) {
                throw new IllegalArgumentException("Failed to parse ExperimentSpecification: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read ExperimentSpecification", e);
            }
        } else {
            this.eSpec = null;
        }
    }

    @Override
    @Nonnull
    public List<String> getFileNames() {
        return this.files.stream().map(File::getName).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public byte[] getFileContent(@Nonnull String fileName) throws IOException {
        return IOUtils.fileToByteArray((File)new File(this.dir, fileName));
    }

    @Override
    public boolean isDir(@Nonnull String fileName) throws IOException {
        String fullPath = LocalDirESpecBundle.assureEndWithSlash(this.dir.getAbsolutePath()) + fileName;
        File f = new File(fullPath);
        if (!f.exists()) {
            throw new FileNotFoundException("file \"" + fileName + "\" does not exist in bundle");
        }
        return f.isDirectory();
    }

    @Override
    public List<String> getDirFiles(@Nonnull String dirFileName) throws IOException {
        String fullPath = LocalDirESpecBundle.assureEndWithSlash(this.dir.getAbsolutePath()) + dirFileName;
        File f = new File(fullPath);
        if (!f.exists()) {
            throw new FileNotFoundException("file \"" + dirFileName + "\" does not exist in bundle");
        }
        String[] res = f.list();
        if (res == null) {
            throw new IllegalArgumentException("file \"" + dirFileName + "\" in bundle is not a directory");
        }
        return Arrays.asList(res).stream().map(rf -> LocalDirESpecBundle.assureEndWithSlash(dirFileName) + rf).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public ExperimentSpecification getExperimentSpecification() {
        if (this.eSpec == null) {
            throw new RuntimeException("\"" + this.dir.getPath() + "\" does not contain the required file \"experiment-specification.yaml\" (or \"experiment-specification.yml\")");
        }
        return this.eSpec;
    }

    @Nonnull
    private static String assureEndWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    public String toString() {
        return "LocalDirESpecBundle{dir=" + String.valueOf(this.dir) + "}";
    }
}

