/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.filefetcher;

import be.iminds.ilabt.jfed.espec.bundle.BundleFetcher;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.ESpecFileFetchException;
import be.iminds.ilabt.jfed.espec.filefetcher.FileFetcher;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.GitFileSource;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcher;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentSpecificationFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentSpecificationFileManager.class);
    @Nonnull
    private final ExperimentSpecification eSpec;
    @Nonnull
    private final ESpecBundle bundle;
    @Nonnull
    private final ESpecLogger eSpecLogger;
    @Nullable
    private final RSpecGeneratorFactory rSpecGeneratorFactory;
    @Nullable
    private final GitAuthPreferences gitAuthPreferences;
    private final Map<FileSource, byte[]> bytes = new ConcurrentHashMap<FileSource, byte[]>();
    private final Set<FileSource> dirs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ExecutorService executorService;
    private boolean started;
    private boolean errorOccured;
    private AtomicInteger slowFetchCountdown;
    private Map<FileSource, ESpecBundle> cachedGitDirBundles = new HashMap<FileSource, ESpecBundle>();

    public ExperimentSpecificationFileManager(@Nonnull ExperimentSpecification eSpec, @Nonnull ESpecBundle bundle, @Nonnull ESpecLogger eSpecLogger, @Nullable RSpecGeneratorFactory rSpecGeneratorFactory, @Nullable GitAuthPreferences gitAuthPreferences) {
        this.eSpec = eSpec;
        this.bundle = bundle;
        this.eSpecLogger = eSpecLogger;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
        this.gitAuthPreferences = gitAuthPreferences;
        this.executorService = Executors.newFixedThreadPool(3, ThreadFactoryUtil.getFactory((String)"ESpecFileManager"));
        this.errorOccured = false;
    }

    public void fetchAll() {
        this.eSpecLogger.firePreFileLoad();
        this.started = true;
        ArrayList fileSources = new ArrayList();
        this.eSpec.getUploads().stream().map(UploadSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
        this.eSpec.getExecutes().stream().map(UploadLikeSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
        if (this.eSpec.getAnsible() != null) {
            this.eSpec.getAnsible().getAnsibleHostSpec().getUploadLists().stream().map(UploadSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
            this.eSpec.getAnsible().getAnsibleHostSpec().getExecuteLists().stream().map(UploadLikeSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
            this.eSpec.getAnsible().getAnsibleGalaxySpecs().stream().map(UploadLikeSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
            this.eSpec.getAnsible().getAnsiblePlaybookSpecs().stream().map(UploadLikeSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
            this.eSpec.getAnsible().getAnsiblePlaybookSpecs().stream().map(AnsiblePlaybookSpec::getExtraVarsJsonFileSpec).filter(Objects::nonNull).map(UploadLikeSpec::getSource).filter(Objects::nonNull).forEach(s -> fileSources.add(s));
        }
        Map<Boolean, List<FileFetcher>> fileSourceListBySpeed = fileSources.stream().map(fileSource -> new FileFetcher((FileSource)fileSource, this.bundle, this.rSpecGeneratorFactory, this.gitAuthPreferences)).collect(Collectors.partitioningBy(FileFetcher::isFast));
        List<FileFetcher> fastFetchers = fileSourceListBySpeed.get(true);
        List<FileFetcher> slowFetchers = fileSourceListBySpeed.get(false);
        for (FileFetcher fff : fastFetchers) {
            if (fff.getFileSource().isGeneratedKeyPair() || fff.getFileSource().getType() == FileSource.SourceType.META) continue;
            try {
                if (fff.isDir()) {
                    this.dirs.add(fff.getFileSource());
                    continue;
                }
                byte[] b = fff.fetchBytes();
                assert (b != null);
                LOG.debug("ExperimentSpecificationFileManager fetched " + b.length + " bytes for " + fff.getFileSource().getBasename());
                this.bytes.put(fff.getFileSource(), b);
                this.eSpecLogger.firePostFileLoadSuccess(fff.getFileSource(), true, b.length);
            }
            catch (IOException e) {
                LOG.error("Failed to (fast) fetch file with source type " + String.valueOf((Object)fff.getFileSource().getType()), (Throwable)e);
                this.errorOccured = true;
                this.executorService.shutdown();
                this.eSpecLogger.firePostFileLoadFail(fff.getFileSource(), true, 0L, "Failed to (fast) fetch file with source type " + String.valueOf((Object)fff.getFileSource().getType()), e);
                this.eSpecLogger.firePostFileLoadAll(false);
                return;
            }
        }
        LOG.debug("ExperimentSpecificationFileManager fetched " + fastFetchers.size() + " fast files.");
        if (!slowFetchers.isEmpty()) {
            this.slowFetchCountdown = new AtomicInteger(slowFetchers.size());
            for (FileFetcher sff : slowFetchers) {
                if (sff.getFileSource().isGeneratedKeyPair()) continue;
                try {
                    if (sff.isDir()) {
                        this.dirs.add(sff.getFileSource());
                        continue;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error checking if filefetch is a dir. Will ignore for now, and assume it is not.", (Throwable)e);
                }
                this.queueFileFetch(sff);
            }
            LOG.debug("ExperimentSpecificationFileManager queued " + slowFetchers.size() + " slow files for fetching.");
        } else {
            LOG.debug("ExperimentSpecificationFileManager has no slow files to fetch.");
            this.eSpecLogger.firePostFileLoadAll(true);
        }
        for (FileSource dirSource : this.dirs) {
            this.executorService.submit(() -> {
                try {
                    Iterator<DirFileBytes> dirsFilesToFetch = this.getDirBytes(dirSource);
                    LOG.debug("ExperimentSpecificationFileManager is fetching dir " + dirSource.getBasename());
                    long totalDirFiles = 0L;
                    long totalByteCount = 0L;
                    while (dirsFilesToFetch.hasNext()) {
                        DirFileBytes dirFileBytes = dirsFilesToFetch.next();
                        ++totalDirFiles;
                        if (dirFileBytes.isDir()) continue;
                        totalByteCount += (long)dirFileBytes.getContent().length;
                    }
                    LOG.debug("ExperimentSpecificationFileManager fetched dir " + dirSource.getBasename() + " with " + totalDirFiles + " files of total size " + totalByteCount);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected failure when (slow) fetching dir with source type " + String.valueOf((Object)dirSource.getType()), t);
                    this.errorOccured = true;
                    this.eSpecLogger.firePostFileLoadFail(dirSource, true, 0L, "Unexpected failure when (slow) fetching dir with source type " + String.valueOf((Object)dirSource.getType()), t);
                    this.executorService.shutdownNow();
                    this.eSpecLogger.firePostFileLoadAll(false);
                }
            });
            LOG.debug("ExperimentSpecificationFileManager is fetching dir " + dirSource.getBasename() + " in the background");
        }
        this.executorService.shutdown();
        LOG.debug("dir file sources: " + this.dirs.stream().map(FileSource::toString).collect(Collectors.joining(",")));
    }

    private void queueFileFetch(final @Nonnull FileFetcher fileFetcher) {
        Runnable backGroundFetch = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        byte[] b = fileFetcher.fetchBytes();
                        ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadSuccess(fileFetcher.getFileSource(), false, b.length);
                        ExperimentSpecificationFileManager.this.bytes.put(fileFetcher.getFileSource(), b);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to (slow) fetch file with source type " + String.valueOf((Object)fileFetcher.getFileSource().getType()), (Throwable)e);
                        ExperimentSpecificationFileManager.this.errorOccured = true;
                        ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadFail(fileFetcher.getFileSource(), true, 0L, "Failed to (slow) fetch file with source type " + String.valueOf((Object)fileFetcher.getFileSource().getType()), e);
                        ExperimentSpecificationFileManager.this.executorService.shutdownNow();
                        ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadAll(false);
                    }
                    if (ExperimentSpecificationFileManager.this.slowFetchCountdown.decrementAndGet() == 0 && !ExperimentSpecificationFileManager.this.errorOccured) {
                        ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadAll(true);
                    }
                }
                catch (Throwable t) {
                    LOG.error("Unexpected failure when (slow) fetching file with source type " + String.valueOf((Object)fileFetcher.getFileSource().getType()), t);
                    ExperimentSpecificationFileManager.this.errorOccured = true;
                    ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadFail(fileFetcher.getFileSource(), true, 0L, "Unexpected failure when (slow) fetching file with source type " + String.valueOf((Object)fileFetcher.getFileSource().getType()), t);
                    ExperimentSpecificationFileManager.this.executorService.shutdownNow();
                    ExperimentSpecificationFileManager.this.eSpecLogger.firePostFileLoadAll(false);
                }
            }
        };
        this.executorService.execute(backGroundFetch);
    }

    public boolean isReady() {
        if (!this.started) {
            throw new IllegalStateException("Dangerous to call isReady before starting!");
        }
        return this.executorService.isTerminated();
    }

    public boolean getErrorOccured() {
        return this.errorOccured;
    }

    public void waitUntilReady() throws InterruptedException {
        if (!this.started) {
            throw new IllegalStateException("Dangerous to call waitUntilReady before starting!");
        }
        if (this.isReady()) {
            LOG.debug("ExperimentSpecificationFileManager did not have to wait for all files to be ready");
            return;
        }
        LOG.debug("ExperimentSpecificationFileManager waits for all files to be ready");
        boolean terminated = this.executorService.awaitTermination(30L, TimeUnit.MINUTES);
        if (!terminated) {
            throw new IllegalStateException("Failed to wait until all files are ready");
        }
        LOG.debug("ExperimentSpecificationFileManager stopped waiting for files to be ready ready");
    }

    @Nonnull
    public byte[] getBytes(@Nonnull FileSource fileSource) {
        if (!this.isReady()) {
            throw new IllegalStateException("ExperimentSpecificationFileManager requires you to wait until all files are ready, before using them.");
        }
        byte[] res = this.bytes.get(fileSource);
        if (res == null) {
            throw new IllegalStateException("Unexpectedly did not have content of " + fileSource.getBasename() + " (debug details: search fileSource=" + String.valueOf(fileSource) + ". Known fileSources=" + String.valueOf(this.bytes.keySet()) + ")");
        }
        return res;
    }

    public boolean isDir(@Nonnull FileSource fileSource) {
        boolean res = this.dirs.contains(fileSource);
        return res;
    }

    public Iterator<DirFileBytes> getDirBytes(@Nonnull FileSource fileSource) throws IOException {
        String startDirPath;
        ESpecBundle bundleWithDir;
        if (!this.isDir(fileSource)) {
            throw new IllegalStateException("Provided fileSource is not a directory");
        }
        if (fileSource.getType() == FileSource.SourceType.GITHUB || fileSource.getType() == FileSource.SourceType.GIT) {
            bundleWithDir = this.getCachedGitDir(fileSource);
            startDirPath = "/";
        } else {
            bundleWithDir = this.bundle;
            startDirPath = ExperimentSpecificationFileManager.assureEndWithSlash(fileSource.getValue());
        }
        if (fileSource.getType() != FileSource.SourceType.BUNDLED && fileSource.getType() != FileSource.SourceType.GIT && fileSource.getType() != FileSource.SourceType.GITHUB) {
            throw new UnsupportedOperationException("Fetching files in directory not supported for file source " + String.valueOf((Object)fileSource.getType()));
        }
        final DirFile dirItself = new DirFile(startDirPath, "");
        List<String> files = bundleWithDir.getDirFiles(startDirPath);
        final LinkedList toCheck = files.stream().map(filename -> new DirFile((String)filename)).collect(Collectors.toCollection(LinkedList::new));
        return new Iterator<DirFileBytes>(){
            LinkedList<DirFile> files = new LinkedList();
            LinkedList<DirFile> dirs = new LinkedList();
            {
                this.dirs.add(dirItself);
            }

            private void check() {
                while (this.files.isEmpty() && this.dirs.isEmpty() && !toCheck.isEmpty()) {
                    DirFile cur = (DirFile)toCheck.pop();
                    try {
                        if (bundleWithDir.isDir(cur.fullname)) {
                            toCheck.addAll(bundleWithDir.getDirFiles(cur.fullname).stream().map(filename -> new DirFile((String)filename)).collect(Collectors.toList()));
                            this.dirs.add(cur);
                        } else {
                            this.files.add(cur);
                        }
                    }
                    catch (IOException e) {
                        throw new ESpecFileFetchException("Error checking next dir file", e);
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    this.dump("check()");
                }
            }

            @Override
            public boolean hasNext() {
                if (LOG.isDebugEnabled()) {
                    this.dump("hasNext()");
                }
                if (this.files.isEmpty() && this.dirs.isEmpty() && !toCheck.isEmpty()) {
                    this.check();
                }
                return !toCheck.isEmpty() || !this.files.isEmpty() || !this.dirs.isEmpty();
            }

            @Override
            public DirFileBytes next() {
                if (LOG.isDebugEnabled()) {
                    this.dump("next()");
                }
                if (!this.dirs.isEmpty()) {
                    DirFile n = this.dirs.pop();
                    return new DirFileBytes(n.baseFilename, ExperimentSpecificationFileManager.removeParentDir(startDirPath, n.fullname));
                }
                DirFile n = this.files.pop();
                try {
                    return new DirFileBytes(n.baseFilename, ExperimentSpecificationFileManager.removeParentDir(startDirPath, n.fullname), bundleWithDir.getFileContent(n.fullname));
                }
                catch (IOException e) {
                    throw new ESpecFileFetchException("Error reading next dir file", e);
                }
            }

            private void dump(String prefix) {
                LOG.debug(" dirIt DUMP " + prefix + " files=" + String.valueOf(this.files.stream().map(d -> d.fullname).collect(Collectors.toList())) + " toCheck=" + String.valueOf(toCheck.stream().map(d -> d.fullname).collect(Collectors.toList())));
            }
        };
    }

    private ESpecBundle getCachedGitDir(@Nonnull FileSource fileSource) {
        assert (fileSource.getType() == FileSource.SourceType.GITHUB || fileSource.getType() == FileSource.SourceType.GIT);
        GitFileSource gitFileSource = (GitFileSource)fileSource;
        assert (!gitFileSource.isFile()) : "Expected GitFileSource to not be a file but got: " + String.valueOf(fileSource);
        assert (gitFileSource.isDir()) : "Expected GitFileSource to be a dir but got: " + String.valueOf(fileSource);
        return this.cachedGitDirBundles.computeIfAbsent(fileSource, this::fetchGitDir);
    }

    @Nonnull
    private ESpecBundle fetchGitDir(@Nonnull FileSource fileSource) {
        assert (fileSource.getType() == FileSource.SourceType.GITHUB || fileSource.getType() == FileSource.SourceType.GIT);
        GitFileSource gitFileSource = (GitFileSource)fileSource;
        assert (!gitFileSource.isFile());
        assert (gitFileSource.isDir());
        assert (gitFileSource.getFilename() == null);
        if (gitFileSource.isFile() || !gitFileSource.isDir() || gitFileSource.getFilename() != null) {
            throw new IllegalArgumentException("Cannot fetch dir on a file");
        }
        GitFetcher fetcher = new GitFetcher(this.gitAuthPreferences);
        GitFetcherCommandBuilder commandBuilder = new GitFetcherCommandBuilder().setGitUrl(gitFileSource.getGitUrl()).setBranch(gitFileSource.getBranch()).setRepoSubDir(gitFileSource.getRepoSubDir()).setUsername(gitFileSource.getUsername()).setPassword(gitFileSource.getPassword()).setPrivateKeyPemFile(gitFileSource.getPrivateKeyPem());
        GitFetcherCommand command = commandBuilder.build();
        File localDir = fetcher.fetch(command);
        if (!localDir.exists()) {
            throw new ESpecFileFetchException("Target dir (" + localDir.getPath() + ") does not exist in downloaded git repo");
        }
        if (!localDir.isDirectory()) {
            throw new ESpecFileFetchException("Target dir (" + localDir.getPath() + ") is not a dir in downloaded git repo");
        }
        try {
            return BundleFetcher.fetchDir(localDir, false);
        }
        catch (ESpecBundle.ESpecBundleInitException e) {
            throw new ESpecFileFetchException("Error passing cloned git repo to BundleFetcher.fetchFir", e);
        }
    }

    @Nonnull
    public ExperimentSpecification getExperimentSpecification() {
        return this.eSpec;
    }

    @Nonnull
    public ESpecBundle getBundle() {
        return this.bundle;
    }

    @Nonnull
    private static String removeParentDir(@Nonnull String parentPath, @Nonnull String path) {
        if (parentPath.isEmpty()) {
            return path;
        }
        assert (path.startsWith(parentPath)) : "\"" + path + "\" does not start with \"" + parentPath + "\"";
        return path.substring(parentPath.length());
    }

    @Nonnull
    private static String assureEndWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    @Nonnull
    private static String assureStartWithSlash(@Nonnull String p) {
        if (p.startsWith("/")) {
            return p;
        }
        return "/" + p;
    }

    private static class DirFile {
        @Nonnull
        String fullname;
        @Nonnull
        String baseFilename;

        public DirFile(@Nonnull String fullname) {
            this(fullname, IOUtils.getUnixBasename((String)fullname));
        }

        public DirFile(@Nonnull String fullname, @Nonnull String baseFilename) {
            this.fullname = fullname;
            this.baseFilename = baseFilename;
            if (fullname.isEmpty()) {
                throw new IllegalArgumentException("fullname is empty for baseFilename=" + baseFilename);
            }
        }
    }

    public static class DirFileBytes {
        @Nonnull
        private final String baseFilename;
        @Nonnull
        private final String fullRelativePath;
        private final boolean dir;
        @Nonnull
        private final byte[] content;

        private DirFileBytes(@Nonnull String baseFilename, @Nonnull String fullRelativePath, @Nonnull byte[] content) {
            this.baseFilename = baseFilename;
            this.fullRelativePath = fullRelativePath;
            this.content = content;
            this.dir = false;
        }

        private DirFileBytes(@Nonnull String baseFilename, @Nonnull String fullRelativePath) {
            this.baseFilename = baseFilename;
            this.fullRelativePath = fullRelativePath;
            this.dir = true;
            this.content = new byte[0];
        }

        public DirFileBytes(@Nonnull byte[] content) {
            this.baseFilename = "";
            this.fullRelativePath = "";
            this.content = content;
            this.dir = false;
        }

        @Nonnull
        public String getBaseFilename() {
            return this.baseFilename;
        }

        @Nonnull
        public String getFullRelativePath() {
            return this.fullRelativePath;
        }

        public boolean isDir() {
            return this.dir;
        }

        @Nonnull
        public byte[] getContent() {
            return this.content;
        }
    }
}

