/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExperimentInfoOutputSpec {
    @Nonnull
    private final ExperimentInfoOutputType type;
    @Nonnull
    private final ExperimentInfoOutputDestination destination;
    @Nullable
    private final String destinationDetail;

    public ExperimentInfoOutputSpec(@Nonnull ExperimentInfoOutputType type, @Nonnull ExperimentInfoOutputDestination destination, @Nullable String destinationDetail) {
        this.type = type;
        this.destination = destination;
        this.destinationDetail = destinationDetail;
        if (destination == ExperimentInfoOutputDestination.LOCAL_FILE && (destinationDetail == null || destinationDetail.trim().isEmpty())) {
            throw new IllegalArgumentException("destination==LOCAL_FILE required non empty destinationDetail");
        }
    }

    public boolean isRequiringAnsibleKey() {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1, 2, 3, 4 -> true;
            case 5, 6, 7, 8, 9, 10, 11 -> false;
        };
    }

    @Nonnull
    public ExperimentInfoOutputType getType() {
        return this.type;
    }

    @Nonnull
    public ExperimentInfoOutputDestination getDestination() {
        return this.destination;
    }

    @Nullable
    public String getDestinationDetail() {
        return this.destinationDetail;
    }

    public static enum ExperimentInfoOutputType {
        ANSIBLE_ZIP,
        ANSIBLE_FILES,
        ANSIBLE_INVENTORY,
        ANSIBLE_PRIVATE_KEY,
        ANSIBLE_PUBLIC_KEY,
        MANIFEST_RSPEC,
        REQUEST_RSPEC,
        SSH_HOST_LIST,
        SSH_LOGIN_LIST,
        SSH_INFO_CSV,
        SSH_INFO_JSON,
        CLIENT_ID_LIST;

    }

    public static enum ExperimentInfoOutputDestination {
        LOCAL_FILE,
        LOG_DEBUG,
        LOG_INFO;

    }
}

