/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.parser;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ESpecConstants {
    public static final String KEYPAIR = "keypair";
    public static final String KEYPAIR_PRIVATE = "keypair.private";
    public static final String KEYPAIR_PUBLIC = "keypair.public";
    public static final String RANDOM = "random";
    public static final String RANDOM_FORMAT_TEXT = "text";
    public static final String RANDOM_FORMAT_BASE64 = "base64";
    public static final String RANDOM_FORMAT_PASSWORD = "password";
    public static final String RANDOM_FORMAT_BINARY = "binary";
    public static final String GENERATED_RSPEC = "rspec";
    public static final String META_MANIFEST = "manifest.xml";
    public static final String META_EXPERIMENT_INFO_JSON = "experiment-info.json";
    public static final String META_CLIENT_ID = "client_id.txt";
    public static final Set<String> metaValues = new TreeSet<String>(Arrays.asList("manifest.xml", "experiment-info.json", "client_id.txt"));
    public static final String DIRSPEC_CONTENT_SCRIPT = DirContent.SCRIPT.name().toLowerCase();
    public static final String DIRSPEC_CONTENT_UPLOAD = DirContent.UPLOAD.name().toLowerCase();
    public static final String DIRSPEC_CONTENT_ANSIBLE = DirContent.ANSIBLE.name().toLowerCase();

    private ESpecConstants() {
        throw new RuntimeException("no objects");
    }

    public static boolean isKeyPair(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return KEYPAIR.equalsIgnoreCase(value.trim());
    }

    public static boolean isAnyKeyOrPair(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return value.trim().toLowerCase().startsWith(KEYPAIR);
    }

    public static boolean isPrivateKey(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return KEYPAIR_PRIVATE.equalsIgnoreCase(value.trim());
    }

    public static boolean isPublicKey(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return KEYPAIR_PUBLIC.equalsIgnoreCase(value.trim());
    }

    public static boolean isRandom(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return RANDOM.equalsIgnoreCase(value.trim());
    }

    public static boolean isRandomFormat(@Nullable String format, @Nonnull String expected) {
        if (format == null) {
            return false;
        }
        return expected.equalsIgnoreCase(format.trim());
    }

    public static boolean isGeneratedRSpec(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return GENERATED_RSPEC.equalsIgnoreCase(value.trim());
    }

    public static boolean isMetaValue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return metaValues.contains(value.trim());
    }

    public static boolean isDirsSpecContentUpload(@Nullable String dirSpecContent) {
        if (dirSpecContent == null) {
            return false;
        }
        String m = dirSpecContent.toLowerCase().trim();
        return m.equals(DIRSPEC_CONTENT_UPLOAD) || m.equals(DIRSPEC_CONTENT_UPLOAD + "s");
    }

    public static boolean isDirsSpecContentScript(@Nullable String dirSpecContent) {
        if (dirSpecContent == null) {
            return false;
        }
        String m = dirSpecContent.toLowerCase().trim();
        return m.equals(DIRSPEC_CONTENT_SCRIPT) || m.equals(DIRSPEC_CONTENT_SCRIPT + "s");
    }

    public static boolean isDirsSpecContentAnsible(@Nullable String dirSpecContent) {
        if (dirSpecContent == null) {
            return false;
        }
        String m = dirSpecContent.toLowerCase().trim();
        return m.equals(DIRSPEC_CONTENT_ANSIBLE);
    }

    public static enum DirContent {
        UPLOAD,
        SCRIPT,
        ANSIBLE;

    }
}

