/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.util;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChModPermissionsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ChModPermissionsUtil.class);

    private ChModPermissionsUtil() {
    }

    public static int toMask(@Nonnull String chModStylePermissions) {
        if (ChModPermissionsUtil.isOctalStyle(chModStylePermissions)) {
            if (chModStylePermissions.startsWith("0")) {
                return Integer.decode(chModStylePermissions);
            }
            return Integer.decode("0" + chModStylePermissions);
        }
        if (ChModPermissionsUtil.isSymbolicStyle(chModStylePermissions)) {
            Set<ChModPermissionsPart> parts = ChModPermissionsUtil.symbolicToParts(chModStylePermissions);
            int res = 0;
            for (ChModPermissionsPart p : parts) {
                res |= p.getMask();
            }
            return res;
        }
        throw new IllegalArgumentException("Unrecognized format: \"" + chModStylePermissions + "\"");
    }

    public static int toSymbolic(@Nonnull String chModStylePermissions) {
        throw new RuntimeException("Not yet implemented");
    }

    public static int toOctal(@Nonnull String chModStylePermissions) {
        throw new RuntimeException("Not yet implemented");
    }

    public static int toSymbolic(int mask) {
        throw new RuntimeException("Not yet implemented");
    }

    public static int toOctal(int mask) {
        throw new RuntimeException("Not yet implemented");
    }

    public static boolean isOctalStyle(@Nonnull String chModStylePermissions) {
        return Character.isDigit(chModStylePermissions.charAt(0));
    }

    public static boolean isSymbolicStyle(@Nonnull String chModStylePermissions) {
        if (chModStylePermissions.length() < 2) {
            return false;
        }
        char start = chModStylePermissions.charAt(0);
        char end = chModStylePermissions.charAt(chModStylePermissions.length() - 1);
        boolean correctStart = start == 'o' || start == 'u' || start == 'g' || start == 'a';
        boolean correctEnd = end == 'r' || end == 'x' || end == 'w';
        boolean correctMiddle = chModStylePermissions.indexOf(61) != -1;
        return correctStart && correctMiddle && correctEnd;
    }

    @Nonnull
    private static Set<ChModPermissionsPart> symbolicToParts(@Nonnull String symbolicPermissionParts) {
        symbolicPermissionParts = symbolicPermissionParts.trim().replaceAll(" ", "");
        HashSet<ChModPermissionsPart> res = new HashSet<ChModPermissionsPart>();
        for (String part : symbolicPermissionParts.split(",")) {
            String[] partParts = part.split("=");
            if (partParts.length != 2) {
                throw new IllegalArgumentException("Invalid format: \"" + symbolicPermissionParts + "\"");
            }
            EnumMap<Perm, Boolean> perms = new EnumMap<Perm, Boolean>(Perm.class);
            perms.put(Perm.R, false);
            perms.put(Perm.W, false);
            perms.put(Perm.X, false);
            if (partParts[1].contains("x")) {
                perms.put(Perm.X, true);
            }
            if (partParts[1].contains("r")) {
                perms.put(Perm.R, true);
            }
            if (partParts[1].contains("w")) {
                perms.put(Perm.W, true);
            }
            if (partParts[0].contains("a") || partParts[0].contains("u")) {
                res.add(new ChModPermissionsPart(User.U, perms));
            }
            if (partParts[0].contains("a") || partParts[0].contains("o")) {
                res.add(new ChModPermissionsPart(User.O, perms));
            }
            if (!partParts[0].contains("a") && !partParts[0].contains("g")) continue;
            res.add(new ChModPermissionsPart(User.G, perms));
        }
        return res;
    }

    private static class ChModPermissionsPart {
        @Nonnull
        private final User user;
        @Nonnull
        private final EnumMap<Perm, Boolean> perms;

        private ChModPermissionsPart(@Nonnull User user, @Nonnull EnumMap<Perm, Boolean> perms) {
            this.user = user;
            this.perms = perms;
        }

        public int getMask() {
            int res = 0;
            if (this.perms.getOrDefault((Object)Perm.R, false).booleanValue()) {
                res |= 4;
            }
            if (this.perms.getOrDefault((Object)Perm.W, false).booleanValue()) {
                res |= 2;
            }
            if (this.perms.getOrDefault((Object)Perm.X, false).booleanValue()) {
                res |= 1;
            }
            if (this.user == User.U) {
                res <<= 6;
            }
            if (this.user == User.G) {
                res <<= 3;
            }
            return res;
        }
    }

    private static enum Perm {
        R,
        X,
        W;

    }

    private static enum User {
        U,
        G,
        O;

    }
}

