/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.history.ApiCallHistory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.PlanetlabSfaRegistryInterface;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniAMExtensions;
import be.iminds.ilabt.jfed.lowlevel.api.ProtoGeniClearingHouse1;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.api_scripts.GetUsersInProject;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HandleUntrustedCallback;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceIdParser;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.BasicSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.choosers.ServerChooser;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.LogHistoryPanel;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.CommandParameterModel;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooserFactory;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.DelegatedCredentialCreatorPanelController;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.SavePemPanelController;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.SpeaksForAbacCredentialCreatorPanelController;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.SpeaksForSfaCredentialCreatorPanelController;
import be.iminds.ilabt.jfed.ui.javafx.util.ExpandableHelp;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.lib.JFedPasswordManager;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.ListBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.LoggerFactory;

public class ProbeController {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(ProbeController.class);
    public static final Comparator<MethodInfo> methodInfoComparator = (m1, m2) -> {
        int m2o;
        int m1o = m1.annotation.order();
        if (m1o != (m2o = m2.annotation.order())) {
            return m1o - m2o;
        }
        return m1.name.compareTo(m2.name);
    };
    private static Stage probeStage = null;
    private final ObservableList<CommandParameterController> argumentControllers = FXCollections.observableArrayList();
    private final ObservableList<CommandParameterModel> argumentModels = FXCollections.observableArrayList();
    @FXML
    private LogHistoryPanel logPanel;
    @FXML
    private TreeView<String> apiAndMethodTreeView;
    @FXML
    private Parent commandConfigurationBox;
    @FXML
    private VBox speaksForSfaCredentialCreatorBox;
    @FXML
    private VBox speaksForAbacCredentialCreatorBox;
    @FXML
    private VBox delegatedCredentialCreatorBox;
    @FXML
    private VBox savePemBox;
    @FXML
    private SpeaksForSfaCredentialCreatorPanelController speaksForSfaCredentialCreatorPanelController;
    @FXML
    private SpeaksForAbacCredentialCreatorPanelController speaksForAbacCredentialCreatorPanelController;
    @FXML
    private DelegatedCredentialCreatorPanelController delegatedCredentialCreatorPanelController;
    @FXML
    private SavePemPanelController savePemPanelControllerController;
    @FXML
    private Button callButton;
    @FXML
    private CheckBox disableClientAuthenticationCheckBox;
    @FXML
    private Parent serverUrlSettingsBox;
    @FXML
    private RadioButton useUserRadioButton;
    @FXML
    private RadioButton userAuthorityRadioButton;
    @FXML
    private RadioButton userCustomServerRadioButton;
    @FXML
    private CheckBox useSshProxyCheckBox;
    @FXML
    private Pane proxySettingsBox;
    @FXML
    private RadioButton useAuthProxyRadioButton;
    @FXML
    private RadioButton useCustomProxyRadioButton;
    @FXML
    private TextField proxyUsername;
    @FXML
    private TextField proxyHostname;
    @FXML
    private TextField proxyPort;
    @FXML
    private TextField proxyPrivateKey;
    @FXML
    private PasswordField proxyPrivateKeyPass;
    @FXML
    private Pane proxyPrivateKeyBox;
    @FXML
    private Label proxyFeedbackLabel;
    @FXML
    private HBox userAuthChoiceBox;
    @FXML
    private ServerChooser authChooserController;
    @FXML
    private Label loggedInUserLabel;
    @FXML
    private HBox fixedServerURLBox;
    @FXML
    private VBox editableServerURLBox;
    @FXML
    private StackPane advancedStackPane;
    @FXML
    private Button advancedConnectionButton;
    @FXML
    private Parent advancedConnectionPane;
    @FXML
    private CheckBox retryWhenBusyCheckBox;
    @FXML
    private Parent autoRetryBox;
    @FXML
    private TextField maxBusyCountField;
    @FXML
    private TextField busyPauseBeforeRetryMsField;
    @FXML
    private TextField maxTimeoutsField;
    @FXML
    private TextField timeoutPauseBeforeRetryMsField;
    @FXML
    private TextField maxPossibleTemporaryErrorsField;
    @FXML
    private TextField possibleTemporaryErrorPauseBeforeRetryMsField;
    @FXML
    private TextField serverUrlField;
    @FXML
    private Label serverUrlLabel;
    @FXML
    private TextField customServerUrlField;
    @FXML
    private CheckBox ignoreSelfSignedCheckBox;
    @FXML
    private Label ignoreSelfSignedCheckLabel;
    @FXML
    private VBox commandNameBox;
    @FXML
    private Label commandNameLabel;
    @FXML
    private ExpandableHelp commandHelp;
    @FXML
    private ScrollPane argumentScrollPane;
    @FXML
    private GridPane argumentGrid;
    @FXML
    private VBox includeHeader;
    @FXML
    private VBox nameHeader;
    @FXML
    private VBox valueHeader;
    private MethodInfo currentlySelectedTreeMethod = null;
    private Map<TreeItem<String>, MethodInfo> treeItemToMethodInfo;
    private Map<TreeItem<String>, NicknamedApiInfo> treeItemToNicknamedApiInfo;
    private TreeItem<String> credentialManipulationSfaSpeaksForTreeItem;
    private TreeItem<String> credentialManipulationAbacSpeaksForTreeItem;
    private TreeItem<String> savePemTreeItem;
    private TreeItem<String> credentialManipulationDelegationTreeItem;
    private String lastProxyError = "";
    private final JavaFXLogger logger;
    private final SfaConnectionPool connectionProvider;
    private final GeniUserProvider geniUserProvider;
    private final ApiCallHistory apiCallHistory;
    private final CommandArgumentChooserFactory commandArgumentChoosterFactory;
    private final TaskThread tt;
    private final JFedPreferences jFedPreferences;
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;
    private final AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory;
    private final JFedPasswordManager jFedPasswordManager;
    private final TestbedInfoSource testbedInfoSource;
    private static final String textErrorClass = "validation_error";
    private boolean passwordsLoaded = false;

    @Inject
    public ProbeController(JavaFXLogger logger, SfaConnectionPool connectionProvider, GeniUserProvider geniUserProvider, ApiCallHistory apiCallHistory, CommandArgumentChooserFactory commandArgumentChoosterFactory, TaskThread tt, JFedPreferences jFedPreferences, TestbedInfoSource testbedInfoSource, AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory, AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory, JFedPasswordManager jFedPasswordManager) {
        this.logger = logger;
        this.connectionProvider = connectionProvider;
        this.geniUserProvider = geniUserProvider;
        this.apiCallHistory = apiCallHistory;
        this.commandArgumentChoosterFactory = commandArgumentChoosterFactory;
        this.tt = tt;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.automaticUserAndSliceApiWrapperFactory = automaticUserAndSliceApiWrapperFactory;
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
        this.jFedPasswordManager = jFedPasswordManager;
    }

    private static List<MethodInfo> findAvailableMethods(NicknamedApiInfo apiInfo, Object api) {
        Class<?> targetClass = api.getClass();
        ArrayList<MethodInfo> res = new ArrayList<MethodInfo>();
        for (Method m : targetClass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(ApiMethod.class)) continue;
            ApiMethod am = m.getAnnotation(ApiMethod.class);
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (api instanceof AbstractApi && (parameterTypes.length == 0 || !JFedConnection.class.isAssignableFrom(parameterTypes[0]))) {
                throw new RuntimeException("Method " + String.valueOf(m) + " of an AbstractApi does not have JFedConnection as first parameter but it does have @ApiMethod");
            }
            res.add(new MethodInfo(apiInfo, m, am));
        }
        res.sort(methodInfoComparator);
        return res;
    }

    public void updateServerUrlChoiceOnApiChange(NicknamedApiInfo newSelectedNicknamedApiInfo) {
        if (this.geniUserProvider.isUserLoggedIn() && this.geniUserProvider.getLoggedInGeniUser() != null && this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer() != null) {
            boolean userAuthoritySpecific;
            this.loggedInUserLabel.setText("User " + this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
            boolean wasInvisible = !this.useUserRadioButton.isVisible();
            this.useUserRadioButton.setVisible(true);
            boolean bl = userAuthoritySpecific = newSelectedNicknamedApiInfo != null && (newSelectedNicknamedApiInfo.requiresUserAuth || newSelectedNicknamedApiInfo.requiresUserAuthConnection);
            if (wasInvisible && userAuthoritySpecific) {
                this.useUserRadioButton.setSelected(true);
            }
        } else {
            this.useUserRadioButton.setVisible(false);
            this.loggedInUserLabel.setText("No User logged in.");
        }
        this.updateFixedServerUrlField(newSelectedNicknamedApiInfo);
    }

    @FXML
    private void initialize() {
        assert (this.logPanel != null);
        assert (this.apiAndMethodTreeView != null);
        assert (this.useUserRadioButton != null);
        this.useUserRadioButton.managedProperty().bind((ObservableValue)this.useUserRadioButton.visibleProperty());
        this.userAuthChoiceBox.managedProperty().bind((ObservableValue)this.userAuthChoiceBox.visibleProperty());
        this.fixedServerURLBox.managedProperty().bind((ObservableValue)this.fixedServerURLBox.visibleProperty());
        this.editableServerURLBox.managedProperty().bind((ObservableValue)this.editableServerURLBox.visibleProperty());
        this.ignoreSelfSignedCheckLabel.managedProperty().bind((ObservableValue)this.ignoreSelfSignedCheckLabel.visibleProperty());
        this.loggedInUserLabel.managedProperty().bind((ObservableValue)this.loggedInUserLabel.visibleProperty());
        this.commandConfigurationBox.managedProperty().bind((ObservableValue)this.commandConfigurationBox.visibleProperty());
        this.serverUrlSettingsBox.managedProperty().bind((ObservableValue)this.serverUrlSettingsBox.visibleProperty());
        this.serverUrlField.managedProperty().bind((ObservableValue)this.serverUrlField.visibleProperty());
        this.serverUrlLabel.managedProperty().bind((ObservableValue)this.serverUrlLabel.visibleProperty());
        this.userCustomServerRadioButton.managedProperty().bind((ObservableValue)this.userCustomServerRadioButton.visibleProperty());
        this.speaksForSfaCredentialCreatorBox.managedProperty().bind((ObservableValue)this.speaksForSfaCredentialCreatorBox.visibleProperty());
        this.speaksForSfaCredentialCreatorBox.setVisible(false);
        this.speaksForAbacCredentialCreatorBox.managedProperty().bind((ObservableValue)this.speaksForAbacCredentialCreatorBox.visibleProperty());
        this.speaksForAbacCredentialCreatorBox.setVisible(false);
        this.delegatedCredentialCreatorBox.managedProperty().bind((ObservableValue)this.delegatedCredentialCreatorBox.visibleProperty());
        this.delegatedCredentialCreatorBox.setVisible(false);
        this.savePemBox.managedProperty().bind((ObservableValue)this.savePemBox.visibleProperty());
        this.savePemBox.setVisible(false);
        this.proxySettingsBox.managedProperty().bind((ObservableValue)this.proxySettingsBox.visibleProperty());
        this.proxyPrivateKeyBox.managedProperty().bind((ObservableValue)this.proxyPrivateKeyBox.visibleProperty());
        this.proxySettingsBox.visibleProperty().bind((ObservableValue)this.useSshProxyCheckBox.selectedProperty());
        this.proxyUsername.editableProperty().bind((ObservableValue)this.useCustomProxyRadioButton.selectedProperty());
        this.proxyHostname.editableProperty().bind((ObservableValue)this.useCustomProxyRadioButton.selectedProperty());
        this.proxyPort.editableProperty().bind((ObservableValue)this.useCustomProxyRadioButton.selectedProperty());
        this.proxyPrivateKeyBox.visibleProperty().bind((ObservableValue)this.useCustomProxyRadioButton.selectedProperty());
        this.userAuthChoiceBox.visibleProperty().bind((ObservableValue)this.userAuthorityRadioButton.selectedProperty().or((ObservableBooleanValue)this.useUserRadioButton.selectedProperty()));
        this.fixedServerURLBox.visibleProperty().bind((ObservableValue)this.userAuthorityRadioButton.selectedProperty().or((ObservableBooleanValue)this.useUserRadioButton.selectedProperty()));
        this.editableServerURLBox.visibleProperty().bind((ObservableValue)this.userCustomServerRadioButton.selectedProperty());
        this.loggedInUserLabel.visibleProperty().bind((ObservableValue)this.useUserRadioButton.selectedProperty());
        this.authChooserController.editableProperty().bind((ObservableValue)this.userAuthorityRadioButton.selectedProperty());
        this.ignoreSelfSignedCheckLabel.visibleProperty().bind((ObservableValue)this.ignoreSelfSignedCheckBox.selectedProperty());
        this.useUserRadioButton.visibleProperty().addListener((observableValue, oldIsVisible, newIsVisible) -> {
            if (!newIsVisible.booleanValue() && this.useUserRadioButton.isSelected()) {
                this.userAuthorityRadioButton.selectedProperty().set(true);
            }
        });
        this.includeHeader.setMinWidth(this.includeHeader.getMaxWidth());
        this.includeHeader.setPrefWidth(this.includeHeader.getMaxWidth());
        this.includeHeader.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.nameHeader.setMinWidth(this.nameHeader.getMaxWidth());
        this.nameHeader.setPrefWidth(this.nameHeader.getMaxWidth());
        this.nameHeader.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.valueHeader.setMinWidth(this.valueHeader.getMaxWidth());
        this.valueHeader.setPrefWidth(this.valueHeader.getMaxWidth());
        this.valueHeader.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.advancedConnectionPane.managedProperty().bind((ObservableValue)this.advancedConnectionPane.visibleProperty());
        this.advancedConnectionButton.managedProperty().bind((ObservableValue)this.advancedConnectionButton.visibleProperty());
        this.advancedConnectionPane.setVisible(false);
        this.advancedConnectionButton.setVisible(true);
        RetrySettings globalRetrySettings = this.jFedPreferences.getRetrySettings();
        this.maxBusyCountField.setText("" + globalRetrySettings.getBusyMaxRetries());
        this.busyPauseBeforeRetryMsField.setText("" + globalRetrySettings.getBusyMsBeforeRetry());
        this.maxTimeoutsField.setText("" + globalRetrySettings.getTimeoutMaxRetries());
        this.timeoutPauseBeforeRetryMsField.setText("" + globalRetrySettings.getTimeoutMsBeforeRetry());
        this.maxPossibleTemporaryErrorsField.setText("" + globalRetrySettings.getPossibleTemporaryErrorMaxRetries());
        this.possibleTemporaryErrorPauseBeforeRetryMsField.setText("" + globalRetrySettings.getPossibleTemporaryErrorMsBeforeRetry());
        ChangeListener busyfocusListener = (observableValue, aBoolean, aBoolean2) -> this.updateTimeouts();
        ChangeListener busyTextListener = (observableValue, a, b) -> this.updateTimeouts();
        this.maxBusyCountField.focusedProperty().addListener(busyfocusListener);
        this.busyPauseBeforeRetryMsField.focusedProperty().addListener(busyfocusListener);
        this.maxTimeoutsField.focusedProperty().addListener(busyfocusListener);
        this.timeoutPauseBeforeRetryMsField.focusedProperty().addListener(busyfocusListener);
        this.maxPossibleTemporaryErrorsField.focusedProperty().addListener(busyfocusListener);
        this.possibleTemporaryErrorPauseBeforeRetryMsField.focusedProperty().addListener(busyfocusListener);
        this.maxBusyCountField.textProperty().addListener(busyTextListener);
        this.busyPauseBeforeRetryMsField.textProperty().addListener(busyTextListener);
        this.maxTimeoutsField.textProperty().addListener(busyTextListener);
        this.timeoutPauseBeforeRetryMsField.textProperty().addListener(busyTextListener);
        this.maxPossibleTemporaryErrorsField.textProperty().addListener(busyTextListener);
        this.possibleTemporaryErrorPauseBeforeRetryMsField.textProperty().addListener(busyTextListener);
        this.autoRetryBox.managedProperty().bind((ObservableValue)this.autoRetryBox.visibleProperty());
        this.autoRetryBox.visibleProperty().bind((ObservableValue)this.retryWhenBusyCheckBox.selectedProperty());
        this.doAllInit();
    }

    public void showAdvancedConnection() {
        this.advancedConnectionPane.setVisible(true);
        this.advancedConnectionButton.setVisible(false);
    }

    public void hideAdvancedConnection() {
        this.advancedConnectionPane.setVisible(false);
        this.advancedConnectionButton.setVisible(true);
    }

    public void updateTimeouts() {
        this.maxBusyCountField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        this.busyPauseBeforeRetryMsField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        this.maxTimeoutsField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        this.timeoutPauseBeforeRetryMsField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        this.maxPossibleTemporaryErrorsField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        this.possibleTemporaryErrorPauseBeforeRetryMsField.getStyleClass().removeAll((Object[])new String[]{textErrorClass});
        if (!this.retryWhenBusyCheckBox.isSelected()) {
            this.jFedPreferences.setRetrySettings(RetrySettings.getNoRetrySettings());
        } else {
            int maxBusyCount = 0;
            long busyPauseBeforeRetryMs = 0L;
            int maxTimeouts = 0;
            long timeoutPauseBeforeRetryMs = 0L;
            int possibleTemporaryErrorMaxRetries = 0;
            long possibleTemporaryErrorMsBeforeRetry = 0L;
            try {
                maxBusyCount = Integer.parseInt(this.maxBusyCountField.getText());
            }
            catch (NumberFormatException e) {
                this.maxBusyCountField.getStyleClass().add((Object)textErrorClass);
            }
            try {
                busyPauseBeforeRetryMs = Long.parseLong(this.busyPauseBeforeRetryMsField.getText());
            }
            catch (NumberFormatException e) {
                this.busyPauseBeforeRetryMsField.getStyleClass().add((Object)textErrorClass);
            }
            try {
                maxTimeouts = Integer.parseInt(this.maxTimeoutsField.getText());
            }
            catch (NumberFormatException e) {
                this.maxTimeoutsField.getStyleClass().add((Object)textErrorClass);
            }
            try {
                timeoutPauseBeforeRetryMs = Long.parseLong(this.timeoutPauseBeforeRetryMsField.getText());
            }
            catch (NumberFormatException e) {
                this.timeoutPauseBeforeRetryMsField.getStyleClass().add((Object)textErrorClass);
            }
            try {
                possibleTemporaryErrorMaxRetries = Integer.parseInt(this.maxPossibleTemporaryErrorsField.getText());
            }
            catch (NumberFormatException e) {
                this.maxPossibleTemporaryErrorsField.getStyleClass().add((Object)textErrorClass);
            }
            try {
                possibleTemporaryErrorMsBeforeRetry = Long.parseLong(this.possibleTemporaryErrorPauseBeforeRetryMsField.getText());
            }
            catch (NumberFormatException e) {
                this.possibleTemporaryErrorPauseBeforeRetryMsField.getStyleClass().add((Object)textErrorClass);
            }
            this.jFedPreferences.setRetrySettings(new RetrySettings(maxTimeouts, timeoutPauseBeforeRetryMs, maxBusyCount, busyPauseBeforeRetryMs, possibleTemporaryErrorMaxRetries, possibleTemporaryErrorMsBeforeRetry));
        }
    }

    private void initTreeViewHelper_addApis(List<NicknamedApiInfo> apis, TreeItem<String> rootItem) {
        for (NicknamedApiInfo api : apis) {
            String name = api.nickname;
            if (name == null && api.abstractApi != null) {
                name = api.abstractApi.getName();
            }
            TreeItem apiItem = new TreeItem((Object)name);
            rootItem.getChildren().add((Object)apiItem);
            this.treeItemToNicknamedApiInfo.put((TreeItem<String>)apiItem, api);
            Server dummyServer = this.geniUserProvider.isUserLoggedIn() ? this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer() : ((ServerBuilder)new ServerBuilder().setId((Object)-1)).setName("dummy").create();
            List<MethodInfo> methods = ProbeController.findAvailableMethods(api, api.getAnyApi(dummyServer));
            for (MethodInfo method : methods) {
                TreeItem methodItem = new TreeItem((Object)method.name);
                apiItem.getChildren().add((Object)methodItem);
                this.treeItemToMethodInfo.put((TreeItem<String>)methodItem, method);
            }
        }
    }

    public NicknamedApiInfo currentlySelectedTreeApi() {
        return this.currentlySelectedTreeMethod == null ? null : this.currentlySelectedTreeMethod.api;
    }

    public void initTreeView() {
        TreeItem rootItem = new TreeItem((Object)"APIs and Methods", null);
        rootItem.setExpanded(true);
        TreeItem amApisTreeItem = new TreeItem((Object)"Aggregate Manager APIs");
        rootItem.getChildren().add((Object)amApisTreeItem);
        TreeItem samaApisTreeItem = new TreeItem((Object)"User and Slice APIs");
        rootItem.getChildren().add((Object)samaApisTreeItem);
        TreeItem otherApisTreeItem = new TreeItem((Object)"Other APIs");
        rootItem.getChildren().add((Object)otherApisTreeItem);
        TreeItem wrapperApisTreeItem = new TreeItem((Object)"API Wrappers");
        rootItem.getChildren().add((Object)wrapperApisTreeItem);
        this.treeItemToMethodInfo = new HashMap<TreeItem<String>, MethodInfo>();
        this.treeItemToNicknamedApiInfo = new HashMap<TreeItem<String>, NicknamedApiInfo>();
        ArrayList<NicknamedApiInfo> apis = new ArrayList<NicknamedApiInfo>();
        apis.add(new NicknamedApiInfo("ProtoGeni SA", (AbstractApi)new ProtogeniSliceAuthority((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Planetlab SFA Registry", (AbstractApi)new PlanetlabSfaRegistryInterface((Logger)this.logger, this.jFedPreferences)));
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)samaApisTreeItem);
        apis = new ArrayList();
        apis.add(new NicknamedApiInfo("Aggregate Manager v2", (AbstractApi)new AggregateManager2((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Aggregate Manager v3", (AbstractApi)new AggregateManager3((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("ProtoGeni Extensions", (AbstractApi)new ProtoGeniAMExtensions((Logger)this.logger, this.jFedPreferences)));
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)amApisTreeItem);
        apis = new ArrayList();
        apis.add(new NicknamedApiInfo("ProtoGeni Cleaninghouse", (AbstractApi)new ProtoGeniClearingHouse1((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Stitching Computation Service", (AbstractApi)new StitchingComputationService((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("SLA Collector", (AbstractApi)new SlaCollector((Logger)this.logger, this.jFedPreferences)));
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)otherApisTreeItem);
        apis = new ArrayList();
        apis.add(new NicknamedApiInfo("Automatic User And Slice ApiWrapper", this.automaticUserAndSliceApiWrapperFactory.create(), null, false, false, false, false));
        apis.add(new NicknamedApiInfo("GetUsersInProject", null, null, false, false, false, false){

            @Override
            public Object getAnyApi(Server auth) {
                return new GetUsersInProject((Logger)ProbeController.this.logger, ProbeController.this.automaticUserAndSliceApiWrapperFactory, ProbeController.this.geniUserProvider);
            }
        });
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)wrapperApisTreeItem);
        TreeItem fedApisTreeItem = new TreeItem((Object)"Federation APIs");
        samaApisTreeItem.getChildren().add((Object)fedApisTreeItem);
        TreeItem fedApisV1TreeItem = new TreeItem((Object)"Version 1");
        fedApisTreeItem.getChildren().add((Object)fedApisV1TreeItem);
        TreeItem fedApisV2TreeItem = new TreeItem((Object)"Version 2");
        fedApisTreeItem.getChildren().add((Object)fedApisV2TreeItem);
        apis = new ArrayList();
        apis.add(new NicknamedApiInfo("Registry", (AbstractApi)new FederationRegistryApi1((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Member Authority", (AbstractApi)new FederationMemberAuthorityApi1((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Slice Authority", (AbstractApi)new FederationSliceAuthorityApi1((Logger)this.logger, this.jFedPreferences)));
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)fedApisV1TreeItem);
        apis = new ArrayList();
        apis.add(new NicknamedApiInfo("Registry", (AbstractApi)new FederationRegistryApi2((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Member Authority", (AbstractApi)new FederationMemberAuthorityApi2((Logger)this.logger, this.jFedPreferences)));
        apis.add(new NicknamedApiInfo("Slice Authority", (AbstractApi)new FederationSliceAuthorityApi2((Logger)this.logger, this.jFedPreferences)));
        this.initTreeViewHelper_addApis(apis, (TreeItem<String>)fedApisV2TreeItem);
        TreeItem credentialManipulationCategoryTreeItem = new TreeItem((Object)"Credential Manipulation");
        rootItem.getChildren().add((Object)credentialManipulationCategoryTreeItem);
        this.credentialManipulationSfaSpeaksForTreeItem = new TreeItem((Object)"Speaks For (SFA)");
        credentialManipulationCategoryTreeItem.getChildren().add(this.credentialManipulationSfaSpeaksForTreeItem);
        this.credentialManipulationAbacSpeaksForTreeItem = new TreeItem((Object)"Speaks For (ABAC)");
        credentialManipulationCategoryTreeItem.getChildren().add(this.credentialManipulationAbacSpeaksForTreeItem);
        this.credentialManipulationDelegationTreeItem = new TreeItem((Object)"Delegation");
        credentialManipulationCategoryTreeItem.getChildren().add(this.credentialManipulationDelegationTreeItem);
        this.savePemTreeItem = new TreeItem((Object)"Save User Login");
        credentialManipulationCategoryTreeItem.getChildren().add(this.savePemTreeItem);
        this.apiAndMethodTreeView.getSelectionModel().selectedItemProperty().addListener((observableValue, oldTreeItem, newTreeItem) -> {
            MethodInfo oldMethodInfo = this.treeItemToMethodInfo.get(oldTreeItem);
            MethodInfo newMethodInfo = this.treeItemToMethodInfo.get(newTreeItem);
            NicknamedApiInfo newNicknamedApiInfo = this.treeItemToNicknamedApiInfo.get(newTreeItem);
            if (newNicknamedApiInfo != null) {
                newTreeItem.setExpanded(!newTreeItem.isExpanded());
            }
            this.currentlySelectedTreeMethod = newMethodInfo;
            this.selectMethod(oldMethodInfo, newMethodInfo);
            this.updateServerUrlChoiceOnApiChange(this.currentlySelectedTreeApi());
            boolean hideCommand = newTreeItem == this.credentialManipulationSfaSpeaksForTreeItem || newTreeItem == this.credentialManipulationAbacSpeaksForTreeItem || newTreeItem == this.credentialManipulationDelegationTreeItem || newTreeItem == this.savePemTreeItem;
            this.commandConfigurationBox.setVisible(!hideCommand);
            this.speaksForSfaCredentialCreatorBox.setVisible(newTreeItem == this.credentialManipulationSfaSpeaksForTreeItem);
            this.speaksForAbacCredentialCreatorBox.setVisible(newTreeItem == this.credentialManipulationAbacSpeaksForTreeItem);
            this.delegatedCredentialCreatorBox.setVisible(newTreeItem == this.credentialManipulationDelegationTreeItem);
            this.savePemBox.setVisible(newTreeItem == this.savePemTreeItem);
        });
        this.apiAndMethodTreeView.setShowRoot(false);
        this.apiAndMethodTreeView.setRoot(rootItem);
    }

    public void updateFixedServerUrlField(NicknamedApiInfo newNicknamedApiInfo) {
        Object authUrl = "NONE";
        boolean error = true;
        if (newNicknamedApiInfo != null) {
            boolean userAuthoritySpecific;
            boolean bl = userAuthoritySpecific = newNicknamedApiInfo.requiresUserAuth || newNicknamedApiInfo.requiresUserAuthConnection;
            if (userAuthoritySpecific && this.useUserRadioButton.isSelected()) {
                if (!this.geniUserProvider.isUserLoggedIn()) {
                    authUrl = "No user logged in";
                    error = newNicknamedApiInfo.requiresConnection || newNicknamedApiInfo.requiresAuth;
                } else {
                    GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                    assert (geniUser != null);
                    Server userServer = geniUser.getUserAuthorityServer();
                    assert (userServer != null);
                    if (newNicknamedApiInfo.requiresConnection) {
                        ApiInfo.Api api = newNicknamedApiInfo.requiredServerType;
                        Service s = ApiInfo.findService((Server)userServer, (ApiInfo.Api)api);
                        if (s == null) {
                            authUrl = "User Authority " + userServer.getName() + " has no URL for " + String.valueOf(api);
                            error = true;
                        } else {
                            authUrl = s.getUrl();
                            error = false;
                        }
                    } else {
                        authUrl = null;
                        error = false;
                    }
                }
            } else {
                Server server = this.authChooserController.getSelectedServer();
                if (server != null) {
                    if (newNicknamedApiInfo.requiresConnection) {
                        ApiInfo.Api api = newNicknamedApiInfo.requiredServerType;
                        Service s = ApiInfo.findService((Server)server, (ApiInfo.Api)api);
                        if (s == null) {
                            authUrl = "Authority " + server.getName() + " has no URL for " + String.valueOf(api);
                            error = true;
                        } else {
                            authUrl = s.getUrl();
                            error = false;
                        }
                    } else {
                        authUrl = null;
                        error = false;
                    }
                } else {
                    error = newNicknamedApiInfo.requiresConnection || newNicknamedApiInfo.requiresAuth;
                }
            }
        }
        this.serverUrlField.getStyleClass().remove((Object)"textFieldError");
        if (error) {
            this.serverUrlField.getStyleClass().add((Object)"textFieldError");
        }
        if (newNicknamedApiInfo != null && newNicknamedApiInfo.requiresConnection) {
            this.serverUrlField.setVisible(true);
            this.serverUrlLabel.setVisible(true);
            this.serverUrlField.setText((String)authUrl);
        } else {
            this.serverUrlField.setVisible(false);
            this.serverUrlLabel.setVisible(false);
        }
        this.serverUrlSettingsBox.setVisible(newNicknamedApiInfo != null && (newNicknamedApiInfo.requiresConnection || newNicknamedApiInfo.requiresAuth));
    }

    private void doAllInit() {
        assert (this.logPanel != null);
        assert (this.authChooserController != null);
        assert (this.connectionProvider != null);
        this.initTreeView();
        this.authChooserController.selectedAuthorityProperty().addListener((observableValue, oldAuthorityInfo, newAuthorityInfo) -> this.updateFixedServerUrlField(this.currentlySelectedTreeApi()));
        this.useUserRadioButton.selectedProperty().addListener((observableValue, oldBool, newIsSelected) -> {
            if (newIsSelected.booleanValue()) {
                this.updateFixedServerUrlField(this.currentlySelectedTreeApi());
            }
            if (newIsSelected.booleanValue() && this.geniUserProvider.isUserLoggedIn() && this.geniUserProvider.getLoggedInGeniUser() != null && this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer() != null) {
                this.authChooserController.select(this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer());
            }
        });
        this.userAuthorityRadioButton.selectedProperty().addListener((observableValue, oldBool, newIsSelected) -> {
            if (newIsSelected.booleanValue()) {
                this.updateFixedServerUrlField(this.currentlySelectedTreeApi());
            }
        });
        ColumnConstraints colInfoInclude = new ColumnConstraints();
        ColumnConstraints colInfoName = new ColumnConstraints();
        ColumnConstraints colInfoValue = new ColumnConstraints();
        colInfoValue.setHgrow(Priority.ALWAYS);
        colInfoValue.setMaxWidth(Double.MAX_VALUE);
        colInfoInclude.setFillWidth(true);
        colInfoName.setFillWidth(true);
        colInfoValue.setFillWidth(true);
        this.argumentGrid.getColumnConstraints().add((Object)colInfoInclude);
        this.argumentGrid.getColumnConstraints().add((Object)colInfoName);
        this.argumentGrid.getColumnConstraints().add((Object)colInfoValue);
        RowConstraints headerRowinfo = new RowConstraints();
        headerRowinfo.setFillHeight(true);
        this.argumentGrid.getRowConstraints().add((Object)headerRowinfo);
        this.logPanel.setApiCallHistory(this.apiCallHistory);
    }

    private void selectMethod(MethodInfo oldMethod, MethodInfo newMethod) {
        if (oldMethod != null || newMethod != null) {
            for (CommandParameterController controller : this.argumentControllers) {
                controller.remove(this.argumentGrid);
            }
            this.argumentControllers.clear();
            this.argumentModels.clear();
            this.argumentGrid.getRowConstraints().clear();
        }
        if (this.commandHelp != null) {
            this.commandNameBox.getChildren().remove((Object)this.commandHelp);
        }
        if (newMethod != null) {
            assert (this.argumentModels.isEmpty());
            RowConstraints headerRowinfo = new RowConstraints();
            headerRowinfo.setFillHeight(true);
            this.argumentGrid.getRowConstraints().add((Object)headerRowinfo);
            int rowIndex = 1;
            this.argumentModels.setAll(this.createCommandParameterModels(newMethod));
            for (CommandParameterModel model : this.argumentModels) {
                RowConstraints rowinfo = new RowConstraints();
                rowinfo.setFillHeight(true);
                this.argumentGrid.getRowConstraints().add((Object)rowinfo);
                CommandParameterController controller = new CommandParameterController(this.commandArgumentChoosterFactory, model, this.argumentControllers);
                controller.add(this.argumentGrid, rowIndex++);
                this.argumentControllers.add((Object)controller);
            }
            this.commandHelp = new ExpandableHelp(newMethod.annotation.hint());
            this.commandNameBox.getChildren().add((Object)this.commandHelp);
            this.commandNameLabel.setText(newMethod.name);
            if (!this.commandNameLabel.getStyleClass().contains((Object)"boldText")) {
                this.commandNameLabel.getStyleClass().add((Object)"boldText");
            }
            this.userCustomServerRadioButton.setVisible(newMethod.api.requiresConnection);
        } else {
            this.commandNameLabel.setText("None selected");
            this.commandNameLabel.getStyleClass().remove((Object)"boldText");
        }
        this.updateFixedServerUrlField(this.currentlySelectedTreeApi());
    }

    public List<CommandParameterModel> createCommandParameterModels(MethodInfo methodInfo) {
        ArrayList<CommandParameterModel> parameterModels = new ArrayList<CommandParameterModel>();
        Method method = methodInfo.method;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] paramAnnotations = annotations[i];
            Class<?> paramClass = parameterTypes[i];
            for (Annotation paramAnnotation : paramAnnotations) {
                if (!Objects.equals(paramAnnotation.annotationType(), ApiMethodParameter.class)) continue;
                ApiMethodParameter amp = (ApiMethodParameter)paramAnnotation;
                CommandParameterModel commandParameterModel = new CommandParameterModel(amp.name(), paramClass, amp, methodInfo);
                parameterModels.add(commandParameterModel);
            }
        }
        return parameterModels;
    }

    @FXML
    private void updateProxy() {
        JFedConnection.ProxyInfo proxyInfo = this.getProxyInfo();
        if (proxyInfo == null) {
            if (this.useAuthProxyRadioButton.isSelected()) {
                this.proxyFeedbackLabel.setText("No Authority Proxy can be used. " + this.lastProxyError);
            } else {
                this.proxyFeedbackLabel.setText("Proxy not configured correctly. " + this.lastProxyError);
            }
        } else {
            this.proxyFeedbackLabel.setText("Proxy will be used.");
            if (this.useAuthProxyRadioButton.isSelected()) {
                JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)proxyInfo;
                this.proxyUsername.setText(sshProxyInfo.getUsername());
                this.proxyHostname.setText(sshProxyInfo.getHostname());
                this.proxyPort.setText("" + sshProxyInfo.getPort());
            }
        }
    }

    private JFedConnection.ProxyInfo getProxyInfo() {
        if (!this.useSshProxyCheckBox.isSelected()) {
            this.lastProxyError = "proxy disabled";
            return null;
        }
        if (this.useAuthProxyRadioButton.isSelected()) {
            if (this.geniUserProvider.isUserLoggedIn()) {
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                Server userAuth = geniUser.getUserAuthorityServer();
                if (!userAuth.getTestbed().getProxies().isEmpty()) {
                    Proxy pi = (Proxy)userAuth.getTestbed().getProxies().get(0);
                    LOG.debug("Using proxy: " + String.valueOf(pi));
                    assert (Objects.equals(pi.getType(), "jFed SSH Proxy") || Objects.equals(pi.getType(), "SSH")) : "Unexpected proxy type: " + String.valueOf(pi);
                    VlanRange range = new VlanRange(pi.getPortRange());
                    int port = range.getFirst();
                    LOG.info("SSH Proxy is activated, and there is an SSH Proxy for user authority " + userAuth.getName() + ": " + pi.getHostname() + ":" + port);
                    GeniUser geniUser1 = geniUser;
                    return new JFedConnection.SshProxyInfo(pi.getHostname(), port, pi.transformUsername(geniUser.getUserUrn().getEncodedResourceName()), (SshKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser1), pi.getHostKey());
                }
                this.lastProxyError = "user authority does not have SSH proxy";
                return null;
            }
            this.lastProxyError = "no user logged in";
            return null;
        }
        if (this.useCustomProxyRadioButton.isSelected()) {
            BasicSshKeyInfo keyInfo;
            int port;
            String username = this.proxyUsername.getText().trim();
            String hostname = this.proxyHostname.getText().trim();
            try {
                port = Integer.parseInt(this.proxyPort.getText().trim());
            }
            catch (NumberFormatException e) {
                this.lastProxyError = "invalid port specified";
                return null;
            }
            if (username.isEmpty() || hostname.isEmpty()) {
                this.lastProxyError = "username and/or hostname empty";
                return null;
            }
            this.lastProxyError = "problem with private key";
            String privateKeyFilename = this.proxyPrivateKey.getText().trim();
            if (privateKeyFilename.isEmpty()) {
                return null;
            }
            String fileContent = null;
            try {
                fileContent = IOUtils.fileToString((String)privateKeyFilename);
            }
            catch (IOException e) {
                return null;
            }
            if (fileContent.isEmpty()) {
                return null;
            }
            boolean needPass = KeyUtil.hasEncryptedPrivateKey((String)fileContent);
            PrivateKey privateKey = null;
            try {
                privateKey = KeyUtil.pemToAnyPrivateKey((String)fileContent, (char[])this.proxyPrivateKeyPass.getText().toCharArray());
            }
            catch (KeyUtil.PEMDecodingException e) {
                return null;
            }
            if (privateKey == null) {
                return null;
            }
            try {
                keyInfo = SshKeyInfoFactory.createBasicSshKeyInfoFromPrivateKeyOnly((PrivateKey)privateKey);
            }
            catch (InvalidSshKeyInfoException e) {
                LOG.warn("Could not create a valid SshKeyInfo from the provided private key");
                return null;
            }
            return new JFedConnection.SshProxyInfo(hostname, port, username, (SshKeyInfo)keyInfo, null);
        }
        this.lastProxyError = "unknown error: " + this.useAuthProxyRadioButton.isSelected() + " " + this.useCustomProxyRadioButton.isSelected();
        return null;
    }

    @FXML
    private void loadKeyFromFile() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            this.proxyPrivateKey.setText(file.getPath());
        }
        this.updateProxy();
    }

    @FXML
    private void call() {
        if (this.useSshProxyCheckBox.isSelected()) {
            JFedConnection.ProxyInfo proxyInfo = this.getProxyInfo();
            if (proxyInfo != null) {
                this.connectionProvider.setDefaultProxy(proxyInfo);
            } else {
                this.connectionProvider.setDefaultProxy(null);
            }
        } else {
            this.connectionProvider.setDefaultProxy(null);
        }
        boolean disableClientAuthentication = this.disableClientAuthenticationCheckBox.isSelected();
        MethodInfo calledMethod = this.currentlySelectedTreeMethod;
        if (calledMethod == null) {
            return;
        }
        NicknamedApiInfo calledApiInfo = calledMethod.api;
        assert (calledApiInfo != null);
        if (LOG.isDebugEnabled()) {
            StringBuilder info = new StringBuilder();
            info.append("Call method ").append(calledMethod.name).append(" with parameters:");
            for (CommandParameterModel param : this.argumentModels) {
                if (param.isRequired() || param.includedProperty().get()) {
                    info.append("  - ").append(param.getParameterName()).append(" -> \"").append(param.valueProperty().get()).append("\"");
                    continue;
                }
                info.append("  - Not included: ").append(param.getParameterName());
            }
            LOG.debug(info.toString());
        }
        try {
            JFedConnection con = null;
            Server auth = null;
            GeniUser geniUser = null;
            if (this.geniUserProvider.isUserLoggedIn()) {
                geniUser = this.geniUserProvider.getLoggedInGeniUser();
            }
            if (!this.passwordsLoaded && geniUser != null) {
                this.jFedPasswordManager.load(this.jFedPreferences, geniUser);
                this.passwordsLoaded = true;
            }
            if (this.useUserRadioButton.isSelected()) {
                if (calledApiInfo.requiresConnection) {
                    con = this.connectionProvider.getConnectionByUserAuthority(geniUser, calledApiInfo.requiredServerType, disableClientAuthentication);
                }
                if (calledApiInfo.requiresAuth) {
                    auth = geniUser.getUserAuthorityServer();
                }
            }
            if (this.userAuthorityRadioButton.isSelected()) {
                assert (con == null);
                if (calledApiInfo.requiresConnection) {
                    con = this.connectionProvider.getConnectionByAuthority(geniUser, this.authChooserController.getSelectedServer(), calledApiInfo.requiredServerType, disableClientAuthentication);
                }
                if (calledApiInfo.requiresAuth) {
                    auth = this.authChooserController.getSelectedServer();
                }
            }
            if (this.userCustomServerRadioButton.isSelected()) {
                HandleUntrustedCallback handleUntrustedCallback;
                assert (con == null);
                if (this.ignoreSelfSignedCheckBox.isSelected()) {
                    LOG.warn("SECURITY WARNING: making connection which accepts all certificates");
                    handleUntrustedCallback = new BasicConnectionBuilder.INSECURE_TRUSTALL_HandleUntrustedCallback();
                } else {
                    handleUntrustedCallback = sslCertificateJFedInfo -> {
                        if (sslCertificateJFedInfo.isTrusted()) {
                            return true;
                        }
                        Object problemDescription = "";
                        if (sslCertificateJFedInfo.isSelfSigned().booleanValue()) {
                            problemDescription = (String)problemDescription + "The server's certificate is self signed. Certificate info:\n";
                            for (X509Certificate cert : sslCertificateJFedInfo.getChain()) {
                                problemDescription = (String)problemDescription + cert.toString();
                                problemDescription = (String)problemDescription + "\n\n";
                            }
                        }
                        if (!sslCertificateJFedInfo.getSubjectMatchesHostname().booleanValue()) {
                            if (!Objects.equals(problemDescription, "")) {
                                problemDescription = (String)problemDescription + "\n\nADDITIONAL SECURITY PROBLEM:\n";
                            }
                            problemDescription = (String)problemDescription + "The certificate's subject hostname does not match the server URL:\n";
                            problemDescription = (String)problemDescription + "    Certificate Subject: " + sslCertificateJFedInfo.getSubject() + "\n";
                            problemDescription = (String)problemDescription + "    Server Hostname: " + sslCertificateJFedInfo.getHostname() + "\n";
                        }
                        ButtonType trustButtonType = new ButtonType("I know what I am doing, I checked the certificate manually, and I trust the server", ButtonBar.ButtonData.YES);
                        ButtonType noTrustButtonType = new ButtonType("I do not trust this", ButtonBar.ButtonData.NO);
                        Optional response = JFDialogs.create().owner((Node)this.callButton).message((String)problemDescription).allowCopyMessage().buttonTypes(new ButtonType[]{trustButtonType, noTrustButtonType}).showConfirm();
                        return response.isPresent() && response.get() == trustButtonType;
                    };
                }
                if (calledApiInfo.requiresConnection) {
                    con = this.connectionProvider.getConnectionByUrl(null, geniUser, new URL(this.customServerUrlField.getText()), handleUntrustedCallback, calledApiInfo.requiredServerType, disableClientAuthentication, null, this.ignoreSelfSignedCheckBox.isSelected() ? Collections.singletonList("*") : null);
                    assert (con != null) : "Custom server URL connection was not setup";
                }
                if (calledApiInfo.requiresAuth) {
                    if (calledApiInfo.requiredServerType == null) {
                        throw new RuntimeException("This is not supported using an URL");
                    }
                    throw new RuntimeException("This is not yet implemented");
                }
            }
            if (calledApiInfo.requiresConnection && con == null) {
                throw new RuntimeException("Authority to use for needed ServerType is unknown, or URL for needed ServerType is unknown: api=" + String.valueOf(calledApiInfo.requiredServerType));
            }
            if (calledApiInfo.requiresAuth && auth == null) {
                throw new RuntimeException("Authority to use is unknown");
            }
            this.execute(calledMethod, con, auth, geniUser);
        }
        catch (Exception e) {
            throw new RuntimeException("Call failed: " + e.getMessage(), e);
        }
    }

    public void execute(final MethodInfo methodInfo, JFedConnection connection, Server auth, GeniUser geniUser) throws JFedException {
        final Method method = methodInfo.method;
        NicknamedApiInfo nicknamedApiInfo = methodInfo.api;
        final Object targetObject = nicknamedApiInfo.getAnyApi(auth);
        int chooserIndex = 0;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        final Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] paramAnnotations = annotations[i];
            Class<?> paramClass = parameterTypes[i];
            if (JFedConnection.class.isAssignableFrom(paramClass)) {
                if (!nicknamedApiInfo.requiresConnection) {
                    throw new RuntimeException("This is configured as NOT requiring a connection, yet a JFedConnection class was found as parameter! -> BUG!");
                }
                parameters[i] = connection;
            } else if (Logger.class.isAssignableFrom(paramClass)) {
                parameters[i] = this.logger;
            } else if (Objects.equals(paramClass, GeniUser.class)) {
                assert (geniUser != null) : "parameter required user, but no user is provided";
                parameters[i] = geniUser;
            } else {
                for (Annotation paramAnnotation : paramAnnotations) {
                    if (!Objects.equals(paramAnnotation.annotationType(), ApiMethodParameter.class)) continue;
                    ApiMethodParameter amp = (ApiMethodParameter)paramAnnotation;
                    CommandParameterModel commandParameterModel = (CommandParameterModel)this.argumentModels.get(chooserIndex++);
                    ArrayList<AnyCredential> c = null;
                    if (commandParameterModel.isRequired() || commandParameterModel.includedProperty().get()) {
                        c = commandParameterModel.valueProperty().get();
                        assert (c != null) : "c==null when isRequired=" + commandParameterModel.isRequired() + " included=" + commandParameterModel.includedProperty().get() + " for " + commandParameterModel.getParameterName();
                        if (ResourceId.class.isInstance(c) && Objects.equals(paramClass, String.class)) {
                            c = ((ResourceId)c).getValue();
                        }
                        if (String.class.isInstance(c) && Objects.equals(paramClass, ResourceId.class)) {
                            c = ResourceIdParser.parse((String)((String)((Object)c)));
                        }
                        if (String.class.isInstance(c) && Objects.equals(paramClass, ResourceUrn.class)) {
                            c = new ResourceUrn((String)((Object)c));
                        }
                        if (String.class.isInstance(c) && Objects.equals(paramClass, Date.class)) {
                            try {
                                c = RFC3339Util.rfc3339StringToDate((String)((String)((Object)c)));
                            }
                            catch (ParseException e) {
                                throw new RuntimeException("Failed to convert user specified String to Date. Make sure the date is in RFC3339 format.", e);
                            }
                        }
                        if (String.class.isInstance(c) && Objects.equals(paramClass, GeniUrn.class)) {
                            try {
                                c = new GeniUrn((String)((Object)c));
                            }
                            catch (GeniUrn.GeniUrnParseException e) {
                                throw new RuntimeException("Failed to convert user specified String to GeniUrn. Is it a valid urn?", e);
                            }
                        }
                        if (amp.name().equals("credentialList") || amp.parameterType().equals((Object)ApiMethodParameterType.LIST_OF_CREDENTIAL)) {
                            assert (c != null);
                            assert (List.class.isInstance(c)) : "Argument with name \"credentialList\" has type " + c.getClass().getName() + " instead of List. Value: " + String.valueOf(c);
                            ArrayList<AnyCredential> credentials = new ArrayList<AnyCredential>();
                            List l = c;
                            for (Object o : l) {
                                if (AnyCredential.class.isInstance(o)) {
                                    AnyCredential cred = (AnyCredential)o;
                                    credentials.add(cred);
                                    continue;
                                }
                                throw new RuntimeException("In list of credentials, expected AnyCredential but got incompatible " + String.valueOf(o.getClass()) + ".");
                            }
                            c = credentials;
                        }
                    }
                    if (c != null && !paramClass.isInstance(c)) {
                        LOG.warn("WARNING: (for argument " + amp.name() + ") expected class " + String.valueOf(paramClass) + " but got incompatible " + String.valueOf(c.getClass()) + ". This will cause an error later on.");
                    }
                    if (c == null) {
                        LOG.debug("Using null for parameter nr " + i + " of " + paramClass.getName() + " with name " + amp.name());
                    }
                    parameters[i] = c;
                }
            }
            if (parameters[i] == null) {
                LOG.debug("Ignoring parameter nr " + i + " of " + paramClass.getName() + "  (probably because of no annotation)");
            }
            LOG.trace("DEBUG CommandPanel.execute parameters[" + i + "]=" + String.valueOf(parameters[i]));
        }
        Task call = new Task("Probe " + methodInfo.name + " Call"){

            public void doTask(@Nonnull TaskExecution singleTask) throws JFedException, InterruptedException {
                try {
                    Object abstractApi;
                    Logger myLogger = null;
                    Logger globalLogger = null;
                    if (targetObject instanceof AbstractApi) {
                        abstractApi = (AbstractApi)targetObject;
                        globalLogger = abstractApi.getLogger();
                        assert (globalLogger instanceof JavaFXLogger);
                        myLogger = globalLogger.getWrappingLogger((ResultListener)singleTask);
                        assert (myLogger instanceof JavaFXLogger);
                        abstractApi.setLogger(myLogger);
                    }
                    try {
                        abstractApi = method.invoke(targetObject, parameters);
                    }
                    catch (Exception e) {
                        LOG.error("Error invoking method {} with parameters {}", new Object[]{methodInfo.name, parameters, e});
                        throw e;
                    }
                    if (targetObject instanceof AbstractApi) {
                        assert (myLogger != null);
                        assert (globalLogger != null);
                        abstractApi = (AbstractApi)targetObject;
                        abstractApi.setLogger(globalLogger);
                        myLogger.removeResultListener((ResultListener)singleTask);
                    }
                    LOG.info("Calling probe task completed");
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        throw (InterruptedException)e;
                    }
                    LOG.error("Exception calling probe task", (Throwable)e);
                    e.printStackTrace();
                    if (e.getCause() != null && e.getCause() instanceof JFedException) {
                        throw (JFedException)e.getCause();
                    }
                    throw new JFedException("Exception invoking API call", (Throwable)e);
                }
            }
        };
        this.tt.addTask(call);
    }

    public static class MethodInfo {
        public final NicknamedApiInfo api;
        public final Method method;
        public final ApiMethod annotation;
        public final String name;

        public MethodInfo(NicknamedApiInfo api, Method method, ApiMethod annotation) {
            this.api = api;
            this.method = method;
            this.annotation = annotation;
            this.name = method.getName();
        }

        public MethodInfo(NicknamedApiInfo api, Method method) {
            this(api, method, method.getAnnotation(ApiMethod.class));
        }

        public String toString() {
            return this.name;
        }
    }

    public static class NicknamedApiInfo {
        public final String nickname;
        public final AbstractApi abstractApi;
        public final Object otherApi;
        public final ApiInfo.Api requiredServerType;
        public final boolean requiresConnection;
        public final boolean requiresUserAuthConnection;
        public final boolean requiresAuth;
        public final boolean requiresUserAuth;

        private NicknamedApiInfo(String nickname, Object api, ApiInfo.Api requiredServerType, boolean requiresConnection, boolean requiresUserAuthConnection, boolean requiresAuth, boolean requiresUserAuth) {
            this.nickname = nickname;
            if (api != null) {
                if (api instanceof AbstractApi) {
                    this.abstractApi = (AbstractApi)api;
                    this.otherApi = null;
                } else {
                    this.otherApi = api;
                    this.abstractApi = null;
                }
            } else {
                this.otherApi = null;
                this.abstractApi = null;
            }
            this.requiredServerType = requiredServerType;
            this.requiresConnection = requiresConnection;
            this.requiresUserAuthConnection = requiresUserAuthConnection;
            this.requiresAuth = requiresAuth;
            this.requiresUserAuth = requiresUserAuth;
            assert (requiresConnection == (requiredServerType != null));
            if (requiresUserAuthConnection) assert (requiresConnection);
            if (requiresUserAuth) assert (requiresAuth);
        }

        private NicknamedApiInfo(AbstractApi api) {
            this(api.getName(), api, NicknamedApiInfo.guessRequiresUserAuthConnection(api));
        }

        private NicknamedApiInfo(AbstractApi api, boolean requiresUserAuthConnection) {
            this(api.getName(), api, requiresUserAuthConnection);
        }

        private NicknamedApiInfo(String nickname, AbstractApi api) {
            this(nickname, api, NicknamedApiInfo.guessRequiresUserAuthConnection(api));
        }

        private NicknamedApiInfo(String nickname, AbstractApi api, boolean requiresUserAuthConnection) {
            this(nickname, api, api.getApi(), true, requiresUserAuthConnection, false, false);
        }

        private static boolean guessRequiresUserAuthConnection(AbstractApi api) {
            return api.getApi().getName().getAuthentication() == ConnectionConfig.Authentication.SSL_CLIENT_AUTH;
        }

        public Object getAnyApi(Server auth) {
            assert (this.abstractApi == null ^ this.otherApi == null);
            if (this.abstractApi != null) {
                return this.abstractApi;
            }
            return this.otherApi;
        }

        public AbstractApi getAbstractApi() {
            assert (this.abstractApi != null);
            assert (this.otherApi == null);
            return this.abstractApi;
        }
    }

    private static class CommandParameterController {
        private final CommandArgumentChooserFactory commandArgumentChooserFactory;
        public final CommandParameterModel model;
        public final CheckBox includedCheckBox;
        public final Label requiredLabel;
        public final Control includedColumnItem;
        public final VBox includedColumnItemBox;
        public final Label nameLabel;
        public final VBox nameLabelBox;
        public final VBox commandArgumentChooserBox;
        public final ExpandableHelp commandArgumentChooserHelper;
        public final CommandArgumentChooser commandArgumentChooser;
        private final ObservableList<CommandParameterController> otherControllers;
        private final ObservableList<CommandArgumentChooser> otherCommandArgumentChoosers;

        public CommandParameterController(CommandArgumentChooserFactory commandArgumentChooserFactory, CommandParameterModel model, ObservableList<CommandParameterController> otherControllers) {
            this.commandArgumentChooserFactory = commandArgumentChooserFactory;
            this.model = model;
            this.otherControllers = otherControllers;
            this.otherCommandArgumentChoosers = new OtherCommandArgumentsObservableList(otherControllers);
            this.includedCheckBox = new CheckBox();
            this.requiredLabel = new Label("required");
            if (model.isRequired()) {
                this.includedColumnItem = this.requiredLabel;
            } else {
                this.includedColumnItem = this.includedCheckBox;
                this.includedCheckBox.selectedProperty().bindBidirectional((Property)model.includedProperty());
            }
            this.includedColumnItemBox = new VBox();
            this.includedColumnItemBox.setPadding(new Insets(10.0));
            this.includedColumnItemBox.getChildren().add((Object)this.includedColumnItem);
            this.nameLabel = new Label(model.getParameterName());
            this.nameLabelBox = new VBox();
            this.nameLabelBox.setPadding(new Insets(10.0));
            this.nameLabelBox.getChildren().add((Object)this.nameLabel);
            this.commandArgumentChooser = commandArgumentChooserFactory.getCommandArgumentChooser(model.getParameterName(), model.getParameterClass(), model.getAnnotation(), model.getMethodInfo(), this.otherCommandArgumentChoosers);
            assert (this.commandArgumentChooser != null);
            assert (this.commandArgumentChooser.valueProperty() != null) : "commandArgumentChooser.valueProperty() is null for name=" + model.getParameterName() + " class=" + String.valueOf(model.getParameterClass()) + " chooserClass=" + ((Object)((Object)this.commandArgumentChooser)).getClass().getName();
            model.valueProperty().bind(this.commandArgumentChooser.valueProperty());
            this.commandArgumentChooser.disableProperty().bind((ObservableValue)model.includedProperty().not());
            this.commandArgumentChooserBox = new VBox();
            this.commandArgumentChooserBox.setPadding(new Insets(10.0));
            String helpText = model.getAnnotation().hint();
            this.commandArgumentChooserHelper = new ExpandableHelp(helpText);
            if (helpText != null && !helpText.isEmpty()) {
                this.commandArgumentChooserBox.getChildren().add((Object)this.commandArgumentChooserHelper);
            }
            this.commandArgumentChooserBox.getChildren().add((Object)this.commandArgumentChooser);
            this.commandArgumentChooserHelper.setMaxWidth(500.0);
            this.commandArgumentChooser.setMaxWidth(500.0);
        }

        public void add(GridPane gridPane, int row) {
            GridPane.setConstraints((Node)this.includedColumnItemBox, (int)0, (int)row);
            GridPane.setConstraints((Node)this.nameLabelBox, (int)1, (int)row);
            GridPane.setConstraints((Node)this.commandArgumentChooserBox, (int)2, (int)row);
            GridPane.setHalignment((Node)this.includedColumnItemBox, (HPos)HPos.CENTER);
            GridPane.setHalignment((Node)this.nameLabelBox, (HPos)HPos.RIGHT);
            GridPane.setHalignment((Node)this.commandArgumentChooserBox, (HPos)HPos.CENTER);
            GridPane.setHgrow((Node)this.includedColumnItemBox, (Priority)Priority.NEVER);
            GridPane.setHgrow((Node)this.nameLabelBox, (Priority)Priority.NEVER);
            GridPane.setHgrow((Node)this.commandArgumentChooserBox, (Priority)Priority.ALWAYS);
            this.includedColumnItem.getStyleClass().removeAll((Object[])new String[]{"argumentGridA", "argumentGridB"});
            this.includedColumnItemBox.getStyleClass().removeAll((Object[])new String[]{"argumentGridA", "argumentGridB"});
            this.nameLabel.getStyleClass().removeAll((Object[])new String[]{"argumentGridA", "argumentGridB"});
            this.nameLabelBox.getStyleClass().removeAll((Object[])new String[]{"argumentGridA", "argumentGridB"});
            this.commandArgumentChooserBox.getStyleClass().removeAll((Object[])new String[]{"argumentGridA", "argumentGridB"});
            if (row % 2 == 0) {
                this.includedColumnItem.getStyleClass().add((Object)"argumentGridA");
                this.includedColumnItemBox.getStyleClass().add((Object)"argumentGridA");
                this.nameLabel.getStyleClass().add((Object)"argumentGridA");
                this.nameLabelBox.getStyleClass().add((Object)"argumentGridA");
                this.commandArgumentChooserBox.getStyleClass().add((Object)"argumentGridA");
            } else {
                this.includedColumnItem.getStyleClass().add((Object)"argumentGridB");
                this.includedColumnItemBox.getStyleClass().add((Object)"argumentGridB");
                this.nameLabel.getStyleClass().add((Object)"argumentGridB");
                this.nameLabelBox.getStyleClass().add((Object)"argumentGridB");
                this.commandArgumentChooserBox.getStyleClass().add((Object)"argumentGridB");
            }
            gridPane.getChildren().add((Object)this.includedColumnItemBox);
            gridPane.getChildren().add((Object)this.nameLabelBox);
            gridPane.getChildren().add((Object)this.commandArgumentChooserBox);
            this.includedColumnItem.setMinWidth(this.includedColumnItem.getMaxWidth());
            this.nameLabel.setMinWidth(this.nameLabel.getMaxWidth());
            this.includedColumnItem.setPrefWidth(this.includedColumnItem.getMaxWidth());
            this.nameLabel.setPrefWidth(this.nameLabel.getMaxWidth());
            this.includedColumnItem.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.nameLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.commandArgumentChooserBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            gridPane.getStyleClass().add((Object)"argumentGrid");
        }

        public void remove(GridPane gridPane) {
            this.model.valueProperty().unbind();
            boolean removedItem = gridPane.getChildren().remove((Object)this.includedColumnItemBox);
            boolean removedItem2 = gridPane.getChildren().remove((Object)this.nameLabelBox);
            boolean removedItem3 = gridPane.getChildren().remove((Object)this.commandArgumentChooserBox);
            assert (removedItem);
            assert (removedItem2);
            assert (removedItem3);
        }

        public static class OtherCommandArgumentsObservableList
        extends ListBinding<CommandArgumentChooser> {
            private final ObservableList<CommandParameterController> otherControllers;

            public OtherCommandArgumentsObservableList(ObservableList<CommandParameterController> otherControllers) {
                this.otherControllers = otherControllers;
                otherControllers.addListener(change -> {});
            }

            private List<CommandArgumentChooser> buildList() {
                ArrayList<CommandArgumentChooser> res = new ArrayList<CommandArgumentChooser>();
                if (this.otherControllers == null) {
                    return res;
                }
                res.addAll(this.otherControllers.stream().filter(c -> c.commandArgumentChooser != null).map(c -> c.commandArgumentChooser).collect(Collectors.toList()));
                return res;
            }

            protected ObservableList<CommandArgumentChooser> computeValue() {
                return FXCollections.observableArrayList(this.buildList());
            }
        }
    }
}

