/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi2;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApiTypeDependantArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.Callback;

public class ChApi2MatchArgumentChooser
extends CommandArgumentChooser<Map<String, Object>>
implements ChApiTypeDependantArgumentChooser {
    private final ChangeListener<String> changeListener = (observableValue, oldString, newString) -> this.updateMap();
    @FXML
    private TableView<MyEntry> table;
    final ObservableList<MyEntry> argument = FXCollections.observableArrayList();
    private final ObjectProperty<Map<String, Object>> valueProperty = new SimpleObjectProperty();
    private AbstractFederationApi2 api;
    private String objectName;

    public ChApi2MatchArgumentChooser(AbstractFederationApi2 api, String objectName) {
        assert (objectName != null);
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("ChApi2MatchArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        this.api = api;
        this.objectName = objectName;
        try {
            fxmlLoader.load();
            assert (this.table != null);
            Map defaultArguments = api.getMinimumFieldsMap(objectName);
            if (defaultArguments != null) {
                defaultArguments.entrySet().stream().map(e -> new MyEntry((String)e.getKey(), (String)e.getValue())).forEach(arg_0 -> this.argument.add(arg_0));
            }
            this.table.setItems(this.argument);
            this.table.setEditable(true);
            Callback cellFactory = p -> new EditingCell();
            TableColumn keyCol = new TableColumn("Field");
            keyCol.setMinWidth(100.0);
            keyCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).key);
            keyCol.setCellFactory(cellFactory);
            keyCol.setEditable(true);
            TableColumn valueCol = new TableColumn("Required value");
            valueCol.setMinWidth(200.0);
            valueCol.setCellFactory(cellFactory);
            valueCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).value);
            valueCol.setEditable(true);
            this.table.getColumns().add((Object)keyCol);
            this.table.getColumns().add((Object)valueCol);
            this.argument.addListener(change -> {
                while (change.next()) {
                    change.getRemoved().forEach(MyEntry::removeListeners);
                    change.getAddedSubList().forEach(MyEntry::addListeners);
                }
                this.updateMap();
            });
            this.updateMap();
            this.argument.forEach(MyEntry::addListeners);
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setObjectType(String newObjectName) {
        if (newObjectName == null || this.objectName.equals(newObjectName)) {
            return;
        }
        this.objectName = newObjectName;
        this.argument.clear();
        Map defaultArguments = this.api.getMinimumFieldsMap(this.objectName);
        if (defaultArguments != null) {
            defaultArguments.entrySet().stream().map(e -> new MyEntry((String)e.getKey(), (String)e.getValue())).forEach(arg_0 -> this.argument.add(arg_0));
        }
        this.table.setItems(this.argument);
    }

    private void updateMap() {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (MyEntry e : this.argument) {
            String value = (String)e.value.get();
            if (value.contains(" OR ")) {
                String[] parts = value.split(" OR ");
                ArrayList oredValues = new ArrayList();
                Collections.addAll(oredValues, parts);
                newMap.put((String)e.key.get(), oredValues);
                continue;
            }
            newMap.put((String)e.key.get(), value);
        }
        this.valueProperty.set(newMap);
    }

    public void add() {
        this.argument.add((Object)new MyEntry("field name", "required value"));
    }

    public void remove() {
        MyEntry r = (MyEntry)this.table.getSelectionModel().getSelectedItem();
        if (r != null) {
            this.argument.remove((Object)r);
        }
    }

    class MyEntry {
        public final StringProperty key = new SimpleStringProperty();
        public final StringProperty value = new SimpleStringProperty();

        public MyEntry(String key, String value) {
            this.key.set((Object)key);
            this.value.set((Object)value);
        }

        public void addListeners() {
            this.key.addListener(ChApi2MatchArgumentChooser.this.changeListener);
            this.value.addListener(ChApi2MatchArgumentChooser.this.changeListener);
        }

        public void removeListeners() {
            this.key.removeListener(ChApi2MatchArgumentChooser.this.changeListener);
            this.value.removeListener(ChApi2MatchArgumentChooser.this.changeListener);
        }
    }

    private static class EditingCell
    extends TableCell<MyEntry, String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                Platform.runLater(() -> {
                    this.textField.requestFocus();
                    this.textField.selectAll();
                    this.textField.end();
                    Platform.runLater(() -> {
                        this.textField.requestFocus();
                        this.textField.end();
                    });
                });
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            if (this.textField == null) {
                this.textField = new TextField(this.getString());
                this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                this.textField.focusedProperty().addListener((arg0, oldIsFocused, newIsFocused) -> {
                    if (!newIsFocused.booleanValue()) {
                        System.out.println("OnFocusLost Committing edit: " + this.textField.getText());
                        this.commitEdit(this.textField.getText());
                    }
                });
                this.textField.setOnAction(actionEvent -> {
                    System.out.println("OnAction Committing edit: " + this.textField.getText());
                    this.commitEdit(this.textField.getText());
                });
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

