/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.Callback;

public class ChApiMemberArgumentChooser
extends CommandArgumentChooser<List<FederationSliceAuthorityApi2.UrnRoleTuple>> {
    private final ChangeListener<String> changeListener = (observableValue, s, s1) -> this.updateMembers();
    @FXML
    private TableView<MyMemberTuple> table;
    final ObservableList<MyMemberTuple> argument = FXCollections.observableArrayList();
    private final ObjectProperty<List<FederationSliceAuthorityApi2.UrnRoleTuple>> valueProperty = new SimpleObjectProperty();

    public ChApiMemberArgumentChooser(List<FederationSliceAuthorityApi2.UrnRoleTuple> defaultArguments) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ChApiMemberArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.table != null);
            if (defaultArguments != null) {
                defaultArguments.stream().map(e -> new MyMemberTuple(e.urn.toString(), e.role)).forEach(arg_0 -> this.argument.add(arg_0));
            }
            this.table.setItems(this.argument);
            this.table.setEditable(true);
            Callback cellFactory = p -> new EditingCell();
            TableColumn keyCol = new TableColumn("Member URN");
            keyCol.setMinWidth(100.0);
            keyCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyMemberTuple)myEntryStringCellDataFeatures.getValue()).urn);
            keyCol.setCellFactory(cellFactory);
            TableColumn valueCol = new TableColumn("Role");
            valueCol.setMinWidth(200.0);
            valueCol.setCellFactory(cellFactory);
            valueCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyMemberTuple)myEntryStringCellDataFeatures.getValue()).role);
            this.table.getColumns().add((Object)keyCol);
            this.table.getColumns().add((Object)valueCol);
            this.argument.addListener(change -> {
                while (change.next()) {
                    change.getRemoved().forEach(MyMemberTuple::removeListeners);
                    change.getAddedSubList().forEach(MyMemberTuple::addListeners);
                }
                this.updateMembers();
            });
            this.updateMembers();
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void updateMembers() {
        ArrayList<FederationSliceAuthorityApi2.UrnRoleTuple> newVal = new ArrayList<FederationSliceAuthorityApi2.UrnRoleTuple>();
        for (MyMemberTuple e : this.argument) {
            try {
                newVal.add(new FederationSliceAuthorityApi2.UrnRoleTuple("SLICE", new GeniUrn((String)e.urn.get()), (String)e.role.get()));
            }
            catch (GeniUrn.GeniUrnParseException e1) {
                System.err.println("Ignoring invalid urn: " + (String)e.urn.get());
            }
        }
        this.valueProperty.set(newVal);
    }

    public void add() {
        this.argument.add((Object)new MyMemberTuple("member_urn", "role"));
    }

    public void remove() {
        MyMemberTuple r = (MyMemberTuple)this.table.getSelectionModel().getSelectedItem();
        if (r != null) {
            this.argument.remove((Object)r);
        }
    }

    class MyMemberTuple {
        public final StringProperty urn = new SimpleStringProperty();
        public final StringProperty role = new SimpleStringProperty();

        public MyMemberTuple(String urn, String role) {
            this.urn.set((Object)urn);
            this.role.set((Object)role);
        }

        public void addListeners() {
            this.urn.addListener(ChApiMemberArgumentChooser.this.changeListener);
            this.role.addListener(ChApiMemberArgumentChooser.this.changeListener);
        }

        public void removeListeners() {
            this.urn.removeListener(ChApiMemberArgumentChooser.this.changeListener);
            this.role.removeListener(ChApiMemberArgumentChooser.this.changeListener);
        }
    }

    private static class EditingCell
    extends TableCell<MyMemberTuple, String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                Platform.runLater(() -> {
                    this.textField.requestFocus();
                    this.textField.selectAll();
                    this.textField.end();
                    Platform.runLater(() -> {
                        this.textField.requestFocus();
                        this.textField.end();
                    });
                });
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            if (this.textField == null) {
                this.textField = new TextField(this.getString());
                this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
                    if (!arg2.booleanValue()) {
                        this.commitEdit(this.textField.getText());
                    }
                });
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

