/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi1;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi2;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.ProbeController;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.BooleanArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApi1MatchArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApi2FieldsArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApi2FilterArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApi2MatchArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApiMemberArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ChApiTypeDependantArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CredentialArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.DateArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.ExtraOptionsArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.IntegerArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MapArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MapStringToStringArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MultiCredentialArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MultiLineStringArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MultiStringArgumentProvidedOptionsChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.MultiUrnArgumentProvidedOptionsChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.StringArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.StringArgumentProvidedOptionsChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.UnsupportedArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.UrnArgumentProvidedOptionsChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.UserSpecListArgumentChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;

public class CommandArgumentChooserFactory {
    private final TestbedInfoSource testbedInfoSource;
    private final GeniUserProvider geniUserProvider;
    private final ParameterHistoryModel parameterHistoryModel;
    private final SfaModel sfaModel;

    @Inject
    public CommandArgumentChooserFactory(TestbedInfoSource testbedInfoSource, GeniUserProvider geniUserProvider, ParameterHistoryModel parameterHistoryModel, SfaModel sfaModel) {
        this.testbedInfoSource = testbedInfoSource;
        this.geniUserProvider = geniUserProvider;
        this.parameterHistoryModel = parameterHistoryModel;
        this.sfaModel = sfaModel;
    }

    public <T> CommandArgumentChooser<T> getCommandArgumentChooser(String parameterName, Class<T> parameterClass, ApiMethodParameter annotation, ProbeController.MethodInfo methodInfo, ObservableList<CommandArgumentChooser> otherCommandArgumentChoosers) {
        Server userServer = null;
        if (this.geniUserProvider.isUserLoggedIn()) {
            userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        }
        ApiMethodParameterType paramType = ApiMethodParameterType.NOT_SPECIFIED;
        paramType = annotation.parameterType();
        if (paramType == ApiMethodParameterType.NOT_SPECIFIED) {
            paramType = CommandArgumentChooserFactory.deriveType(parameterName, parameterClass, annotation, methodInfo);
        }
        switch (paramType) {
            case STRING: {
                return new StringArgumentChooser(Objects.equals(annotation.guiDefault(), "") ? null : annotation.guiDefault());
            }
            case STRING_MULTILINE: {
                return new MultiLineStringArgumentChooser(Objects.equals(annotation.guiDefault(), "") ? null : annotation.guiDefault(), false);
            }
            case INTEGER: {
                Integer defaultValue = null;
                if (!Objects.equals(annotation.guiDefault(), "")) {
                    defaultValue = Integer.parseInt(annotation.guiDefault());
                }
                return new IntegerArgumentChooser(defaultValue);
            }
            case BOOLEAN: {
                Boolean defaultValue = null;
                if (!Objects.equals(annotation.guiDefault(), "")) {
                    defaultValue = false;
                    if (annotation.guiDefault().equalsIgnoreCase("true")) {
                        defaultValue = true;
                    }
                    if (annotation.guiDefault().equalsIgnoreCase("yes")) {
                        defaultValue = true;
                    }
                    if (annotation.guiDefault().equalsIgnoreCase("1")) {
                        defaultValue = true;
                    }
                }
                return new BooleanArgumentChooser(defaultValue);
            }
            case CREDENTIAL_STRING: {
                return new CredentialArgumentChooser(this.parameterHistoryModel, CommandArgumentChooser.CredentialSubject.ANY);
            }
            case USER_CREDENTIAL_STRING: {
                return new CredentialArgumentChooser(this.parameterHistoryModel, CommandArgumentChooser.CredentialSubject.USER);
            }
            case SLICE_CREDENTIAL_STRING: {
                return new CredentialArgumentChooser(this.parameterHistoryModel, CommandArgumentChooser.CredentialSubject.SLICE);
            }
            case URN: {
                return new UrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getAllUrnList(), null, userServer);
            }
            case SLIVER_URN: {
                return new UrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getSliverUrns(), "sliver", userServer);
            }
            case AM_URN: {
                return new UrnArgumentProvidedOptionsChooser((ObservableList<String>)FXCollections.observableArrayList((Collection)this.testbedInfoSource.getServers().stream().map(Server::getDefaultComponentManagerUrn).collect(Collectors.toList())), "authority", userServer);
            }
            case SLICE_URN: {
                return new UrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getSliceUrnsList(), "slice", userServer);
            }
            case USER_URN: {
                return new UrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getUserUrns(), "user", userServer);
            }
            case RSPEC_STRING: {
                String defaultRspec = "<rspec type=\"request\" generated=\"2013-01-16T14:20:39Z\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \" xmlns:client=\"http://www.protogeni.net/resources/rspec/ext/client/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.geni.net/resources/rspec/3\">\n  <node client_id=\"PC\" component_manager_id=\"urn:publicid:IDN+" + (this.geniUserProvider.isUserLoggedIn() ? this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getUrnTld() : "<AM>") + "+authority+cm\" exclusive=\"true\">\n    <sliver_type name=\"raw-pc\"/>\n  </node>\n</rspec>\n";
                return new MultiLineStringArgumentChooser((String)(Objects.equals(annotation.guiDefault(), "") ? defaultRspec : annotation.guiDefault()), true);
            }
            case LIST_OF_CREDENTIAL: {
                return new MultiCredentialArgumentChooser(this.parameterHistoryModel, CommandArgumentChooser.CredentialSubject.ANY);
            }
            case LIST_OF_URN_STRING: {
                return new MultiStringArgumentProvidedOptionsChooser((List<String>)this.parameterHistoryModel.getAllUrnList());
            }
            case LIST_OF_USERSPEC: {
                return new UserSpecListArgumentChooser(this.geniUserProvider, this.sfaModel);
            }
            case LIST_OF_STRING: {
                return new MultiStringArgumentProvidedOptionsChooser((List<String>)FXCollections.observableArrayList());
            }
            case LIST_OF_SLICE_URN_STRING: {
                return new MultiStringArgumentProvidedOptionsChooser((List<String>)this.parameterHistoryModel.getSliceUrnsList());
            }
            case LIST_OF_USER_URN_STRING: {
                return new MultiStringArgumentProvidedOptionsChooser((List<String>)this.parameterHistoryModel.getUserUrns());
            }
            case CH_API1_FILTER: {
                return new MultiStringArgumentProvidedOptionsChooser((List<String>)FXCollections.observableArrayList(CommandArgumentChooserFactory.getChApiFields1(methodInfo)));
            }
            case CH_API1_MATCH: {
                return new ChApi1MatchArgumentChooser(CommandArgumentChooserFactory.getChApiFieldsMap1(methodInfo));
            }
            case CH_API1_FIELDS: {
                return new MapStringToStringArgumentChooser(CommandArgumentChooserFactory.getChApiFieldsMap1(methodInfo), "Field", "Value");
            }
            case CH_API2_OBJECT_TYPE: {
                List<String> objectNames = CommandArgumentChooserFactory.getChApi2Objects(methodInfo);
                StringArgumentProvidedOptionsChooser res = new StringArgumentProvidedOptionsChooser((ObservableList<String>)FXCollections.observableArrayList(objectNames), CommandArgumentChooserFactory.getChApi2DefaultObject(methodInfo), false);
                res.valueProperty().addListener((observableValue, from, to) -> {
                    if (to != null) {
                        otherCommandArgumentChoosers.stream().filter(commandArgumentChooser -> ChApiTypeDependantArgumentChooser.class.isAssignableFrom(((Object)commandArgumentChooser).getClass())).forEach(commandArgumentChooser -> ((ChApiTypeDependantArgumentChooser)((Object)commandArgumentChooser)).setObjectType((String)to));
                    }
                });
                return res;
            }
            case CH_API2_FILTER: {
                return new ChApi2FilterArgumentChooser(CommandArgumentChooserFactory.getChApi2(methodInfo), CommandArgumentChooserFactory.getChApi2ConvenientOrDefaultObject(methodInfo));
            }
            case CH_API2_MATCH: {
                return new ChApi2MatchArgumentChooser(CommandArgumentChooserFactory.getChApi2(methodInfo), CommandArgumentChooserFactory.getChApi2ConvenientOrDefaultObject(methodInfo));
            }
            case CH_API2_FIELDS: {
                return new ChApi2FieldsArgumentChooser(CommandArgumentChooserFactory.getChApi2(methodInfo), CommandArgumentChooserFactory.getChApi2ConvenientOrDefaultObject(methodInfo));
            }
            case LIST_OF_URN: {
                return new MultiUrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getAllUrnList());
            }
            case LIST_OF_SLICE_URN: {
                return new MultiUrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getSliceUrnsList());
            }
            case LIST_OF_SLIVER_URN: {
                return new MultiUrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getSliverUrns());
            }
            case LIST_OF_USER_URN: {
                return new MultiUrnArgumentProvidedOptionsChooser((ObservableList<String>)this.parameterHistoryModel.getUserUrns());
            }
            case GENI_EXTRA_OPTIONS: {
                return new ExtraOptionsArgumentChooser(annotation.guiDefault());
            }
            case XML_RPC_STRUCT: {
                return new MapArgumentChooser(annotation.guiDefault(), true);
            }
            case CH_API_LIST_MEMBER_TUPLES: {
                return new ChApiMemberArgumentChooser(null);
            }
            case MAP_OF_STRING_TO_STRING: {
                return new MapStringToStringArgumentChooser(new HashMap<String, String>());
            }
            case MAP_OF_STRING_TO_OBJECT: {
                return new UnsupportedArgumentChooser(parameterClass);
            }
            case DATE: {
                return new DateArgumentChooser();
            }
            case STRING_DATE_RFC3339: {
                return new DateArgumentChooser();
            }
            case URL: {
                return new StringArgumentChooser(Objects.equals(annotation.guiDefault(), "") ? "http://example.com" : annotation.guiDefault());
            }
            case EMAIL: {
                return new StringArgumentChooser(Objects.equals(annotation.guiDefault(), "") ? "example@example.com" : annotation.guiDefault());
            }
        }
        return new UnsupportedArgumentChooser(parameterClass);
    }

    public static Map<String, String> getChApiFieldsMap1(ProbeController.MethodInfo methodInfo) {
        if (methodInfo.api.getAbstractApi() instanceof AbstractFederationApi1) {
            AbstractFederationApi1 gch = (AbstractFederationApi1)methodInfo.api.getAbstractApi();
            String objectName = gch.getMethodObject(methodInfo.method);
            if (objectName == null) {
                System.err.println("Tiny bug: method \"" + methodInfo.name + "\" not registered as object CRUD method.");
                return new HashMap<String, String>();
            }
            return gch.getMinimumFieldsMap(objectName);
        }
        return null;
    }

    public static ApiMethodParameterType deriveType(String parameterName, Class parameterClass, ApiMethodParameter annotation, ProbeController.MethodInfo methodInfo) {
        if (Objects.equals(annotation.name(), "credentialList")) {
            return ApiMethodParameterType.LIST_OF_CREDENTIAL;
        }
        if (annotation.name().equals("slice") || annotation.name().equals("sliceUrn")) {
            return ApiMethodParameterType.SLICE_URN;
        }
        if (Objects.equals(annotation.name(), "urns")) {
            return ApiMethodParameterType.LIST_OF_URN_STRING;
        }
        if (Objects.equals(annotation.name(), "userCredential")) {
            return ApiMethodParameterType.USER_CREDENTIAL_STRING;
        }
        if (Objects.equals(annotation.name(), "credential")) {
            return ApiMethodParameterType.CREDENTIAL_STRING;
        }
        if (Objects.equals(annotation.name(), "sliceCredential")) {
            return ApiMethodParameterType.SLICE_CREDENTIAL_STRING;
        }
        if (Objects.equals(annotation.name(), "clearingHouseCredential")) {
            return ApiMethodParameterType.CREDENTIAL_STRING;
        }
        if (annotation.name().equals("UserSpecList") || annotation.name().equals("users")) {
            return ApiMethodParameterType.LIST_OF_USERSPEC;
        }
        if (annotation.name().equals("user") || annotation.name().equals("userUrn")) {
            return ApiMethodParameterType.USER_URN;
        }
        if (Objects.equals(annotation.name(), "rspec")) {
            return ApiMethodParameterType.RSPEC_STRING;
        }
        if (Objects.equals(parameterClass, ResourceId.class)) {
            return ApiMethodParameterType.URN;
        }
        if (Objects.equals(parameterClass, ResourceUrn.class)) {
            return ApiMethodParameterType.URN;
        }
        if (Objects.equals(parameterClass, String.class)) {
            if (annotation.multiLineString()) {
                return ApiMethodParameterType.STRING_MULTILINE;
            }
            return ApiMethodParameterType.STRING;
        }
        if (Objects.equals(parameterClass, Boolean.class)) {
            return ApiMethodParameterType.BOOLEAN;
        }
        if (Objects.equals(parameterClass, Map.class) && (Objects.equals(annotation.name(), "options") || Objects.equals(annotation.name(), "extraOptions") || Objects.equals(annotation.name(), "extra_options"))) {
            return ApiMethodParameterType.GENI_EXTRA_OPTIONS;
        }
        if (Objects.equals(parameterClass, Map.class)) {
            return ApiMethodParameterType.XML_RPC_STRUCT;
        }
        if (Objects.equals(parameterClass, Integer.class)) {
            return ApiMethodParameterType.INTEGER;
        }
        if (Objects.equals(parameterClass, Date.class)) {
            return ApiMethodParameterType.DATE;
        }
        return ApiMethodParameterType.NOT_SPECIFIED;
    }

    public static List<String> getChApiFields1(ProbeController.MethodInfo methodInfo) {
        if (methodInfo.api.getAbstractApi() instanceof AbstractFederationApi1) {
            AbstractFederationApi1 gch = (AbstractFederationApi1)methodInfo.api.getAbstractApi();
            String objectName = gch.getMethodObject(methodInfo.method);
            if (objectName == null) {
                System.err.println("Tiny bug: method \"" + methodInfo.name + "\" not registered as object CRUD method.");
                return new ArrayList<String>();
            }
            return gch.getMinimumFieldNames(objectName);
        }
        return null;
    }

    public static String getChApi2DefaultObject(ProbeController.MethodInfo methodInfo) {
        if (methodInfo.api.getAbstractApi() instanceof AbstractFederationApi2) {
            AbstractFederationApi2 api = (AbstractFederationApi2)methodInfo.api.getAbstractApi();
            ArrayList objs = new ArrayList(api.getApiObjects());
            assert (objs != null);
            assert (!objs.contains(null)) : "api.getApiObjects() may not contain null: " + String.valueOf(objs);
            assert (objs.get(0) != null) : "api.getApiObjects() may not contain null: " + String.valueOf(objs);
            List reqs = api.getRequiredApiServices();
            objs.retainAll(reqs);
            if (objs.size() > 0) {
                assert (objs.get(0) != null) : "objs may not contain null: " + String.valueOf(objs);
                return (String)objs.get(0);
            }
            return (String)api.getApiObjects().get(0);
        }
        return null;
    }

    public static String getChApi2ConvenientOrDefaultObject(ProbeController.MethodInfo methodInfo) {
        if (!methodInfo.annotation.convenienceMethodFor().isEmpty() && !methodInfo.annotation.convenienceMethodObjectType().isEmpty()) {
            return methodInfo.annotation.convenienceMethodObjectType();
        }
        return CommandArgumentChooserFactory.getChApi2DefaultObject(methodInfo);
    }

    public static AbstractFederationApi2 getChApi2(ProbeController.MethodInfo methodInfo) {
        if (methodInfo.api.getAbstractApi() instanceof AbstractFederationApi2) {
            AbstractFederationApi2 api = (AbstractFederationApi2)methodInfo.api.getAbstractApi();
            return api;
        }
        return null;
    }

    public static List<String> getChApi2Objects(ProbeController.MethodInfo methodInfo) {
        if (methodInfo.api.getAbstractApi() instanceof AbstractFederationApi2) {
            AbstractFederationApi2 fedapi = (AbstractFederationApi2)methodInfo.api.getAbstractApi();
            return fedapi.getApiObjects();
        }
        return null;
    }
}

