/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.dialog.CredentialEditDialog;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.dialog.CredentialViewDialog;
import java.io.IOException;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class CredentialArgumentChooser
extends CommandArgumentChooser<AnyCredential> {
    @FXML
    private ComboBox<AnyCredential> comboBox;
    @Inject
    private final ParameterHistoryModel parameterHistoryModel;
    private final CommandArgumentChooser.CredentialSubject credentialSubject;

    public CredentialArgumentChooser(ParameterHistoryModel parameterHistoryModel, CommandArgumentChooser.CredentialSubject credentialSubject) {
        this.parameterHistoryModel = parameterHistoryModel;
        this.credentialSubject = credentialSubject;
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CredentialArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (parameterHistoryModel != null);
            assert (this.comboBox != null);
            this.comboBox.setConverter((StringConverter)new StringConverter<AnyCredential>(){

                public String toString(AnyCredential credential) {
                    if (credential != null) {
                        return credential.getName();
                    }
                    return null;
                }

                public AnyCredential fromString(String string) {
                    throw new RuntimeException("not supported and not supposed to be used");
                }
            });
            switch (credentialSubject) {
                case USER: {
                    this.comboBox.setItems(parameterHistoryModel.getUserCredentialsList());
                    break;
                }
                case SLICE: {
                    this.comboBox.setItems(parameterHistoryModel.getSliceCredentialsList());
                    break;
                }
                case ANY: {
                    this.comboBox.setItems(parameterHistoryModel.getAnyCredentialsList());
                }
            }
            if (!this.comboBox.getItems().isEmpty()) {
                this.comboBox.getSelectionModel().selectLast();
            }
            this.value = this.comboBox.getSelectionModel().selectedItemProperty();
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @FXML
    public void add() {
        ObservableList creds = null;
        switch (this.credentialSubject) {
            case USER: {
                creds = this.parameterHistoryModel.getUserCredentialsList();
                break;
            }
            case SLICE: {
                creds = this.parameterHistoryModel.getSliceCredentialsList();
                break;
            }
            case ANY: {
                creds = this.parameterHistoryModel.getUncategorizedCredentialsList();
            }
        }
        AnyCredential newCredentialInfo = CredentialEditDialog.showAddDialog();
        if (newCredentialInfo != null) {
            creds.add((Object)newCredentialInfo);
        }
    }

    @FXML
    public void view() {
        AnyCredential selected = (AnyCredential)this.comboBox.getSelectionModel().selectedItemProperty().get();
        if (selected != null) {
            CredentialViewDialog.showDialog(selected);
        }
    }
}

