/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;

public class DateArgumentChooser
extends CommandArgumentChooser<String>
implements Initializable {
    @FXML
    private TextField valueField;
    @FXML
    private Parent editDateBox;
    @FXML
    private TextField minuteField;
    @FXML
    private TextField hourField;
    @FXML
    private TextField dayField;
    @FXML
    private CheckBox editManuallyCheckBox;

    public DateArgumentChooser() {
        String defaultValue = RFC3339Util.dateToRFC3339String((Date)new Date(System.currentTimeMillis() + 0x6DDD00L), (boolean)true, (boolean)true, (boolean)true);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("DateArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            if (defaultValue != null) {
                this.valueField.setText(defaultValue);
            }
            this.editDateBox.managedProperty().bind((ObservableValue)this.editDateBox.visibleProperty());
            this.editDateBox.visibleProperty().bind((ObservableValue)this.editManuallyCheckBox.selectedProperty().not());
            this.valueField.editableProperty().bind((ObservableValue)this.editManuallyCheckBox.selectedProperty());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.changeDate();
    }

    public void changeDate() {
        try {
            int m = this.minuteField.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.minuteField.getText().trim());
            int h = this.hourField.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.hourField.getText().trim());
            int d = this.dayField.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.dayField.getText().trim());
            long date = System.currentTimeMillis();
            date += (long)m * 60000L;
            date += (long)h * 3600000L;
            String newValue = RFC3339Util.dateToRFC3339String((Date)new Date(date += (long)d * 86400000L), (boolean)true, (boolean)true, (boolean)true);
            this.valueField.setText(newValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.value = this.valueField.textProperty();
    }
}

