/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.Callback;

public class MapStringToStringArgumentChooser
extends CommandArgumentChooser<Map<String, String>> {
    private final ChangeListener<String> changeListener = (observableValue, s, s1) -> this.updateMap();
    @FXML
    protected TableView<MyEntry> table;
    final ObservableList<MyEntry> argument = FXCollections.observableArrayList();
    private final ObjectProperty<Map<String, String>> valueProperty = new SimpleObjectProperty();

    public MapStringToStringArgumentChooser(Map<String, String> defaultArguments) {
        this(defaultArguments, "Key", "Value");
    }

    public MapStringToStringArgumentChooser(Map<String, String> defaultArguments, String keyColHeader, String valueColHeader) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MapStringToStringArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.table != null);
            if (defaultArguments != null) {
                for (Map.Entry<String, String> e : defaultArguments.entrySet()) {
                    this.argument.add((Object)new MyEntry(e.getKey(), e.getValue()));
                }
            }
            this.table.setItems(this.argument);
            this.table.setEditable(true);
            Callback cellFactory = p -> new StringEditingCell();
            TableColumn keyCol = new TableColumn(keyColHeader);
            keyCol.setMinWidth(100.0);
            keyCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).key);
            keyCol.setCellFactory(cellFactory);
            TableColumn valueCol = new TableColumn(valueColHeader);
            valueCol.setMinWidth(200.0);
            valueCol.setCellFactory(cellFactory);
            valueCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).value);
            this.table.getColumns().add((Object)keyCol);
            this.table.getColumns().add((Object)valueCol);
            this.argument.addListener(change -> {
                while (change.next()) {
                    for (MyEntry r : change.getRemoved()) {
                        r.removeListeners();
                    }
                    for (MyEntry a : change.getAddedSubList()) {
                        a.addListeners();
                    }
                }
                this.updateMap();
            });
            this.updateMap();
            for (MyEntry e : this.argument) {
                e.addListeners();
            }
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void updateMap() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (MyEntry e : this.argument) {
            newMap.put((String)e.key.get(), (String)e.value.get());
        }
        this.valueProperty.set(newMap);
    }

    public void add() {
        this.argument.add((Object)new MyEntry("key", "value"));
    }

    public void remove() {
        MyEntry r = (MyEntry)this.table.getSelectionModel().getSelectedItem();
        if (r != null) {
            this.argument.remove((Object)r);
        }
    }

    class MyEntry {
        public final StringProperty key = new SimpleStringProperty();
        public final StringProperty value = new SimpleStringProperty();

        public MyEntry(String key, String value) {
            this.key.set((Object)key);
            this.value.set((Object)value);
        }

        public void addListeners() {
            this.key.addListener(MapStringToStringArgumentChooser.this.changeListener);
            this.value.addListener(MapStringToStringArgumentChooser.this.changeListener);
        }

        public void removeListeners() {
            this.key.removeListener(MapStringToStringArgumentChooser.this.changeListener);
            this.value.removeListener(MapStringToStringArgumentChooser.this.changeListener);
        }

        public String getKey() {
            return (String)this.key.get();
        }

        public StringProperty keyProperty() {
            return this.key;
        }

        public void setKey(String key) {
            this.key.set((Object)key);
        }

        public String getValue() {
            return (String)this.value.get();
        }

        public StringProperty valueProperty() {
            return this.value;
        }

        public void setValue(String value) {
            this.value.set((Object)value);
        }
    }

    static class StringEditingCell
    extends TableCell<MyEntry, String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                Platform.runLater(() -> {
                    this.textField.requestFocus();
                    this.textField.selectAll();
                    this.textField.end();
                    Platform.runLater(() -> {
                        this.textField.requestFocus();
                        this.textField.end();
                    });
                });
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            if (this.textField == null) {
                this.textField = new TextField(this.getString());
                this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
                    if (!arg2.booleanValue()) {
                        this.commitEdit(this.textField.getText());
                    }
                });
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

