/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.base_gui.util.StringConverterListCell;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.dialog.CredentialEditDialog;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.dialog.CredentialViewDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.util.StringConverter;

public class MultiCredentialArgumentChooser
extends CommandArgumentChooser<List<AnyCredential>> {
    @FXML
    private ListView<AnyCredential> listView;
    @FXML
    private Button addButton;
    @FXML
    private Button editButton;
    @FXML
    private Button viewButton;
    private final ObjectProperty<List<AnyCredential>> valueProperty = new SimpleObjectProperty();
    private final ParameterHistoryModel parameterHistoryModel;
    private final CommandArgumentChooser.CredentialSubject credentialSubject;

    public MultiCredentialArgumentChooser(ParameterHistoryModel parameterHistoryModel, CommandArgumentChooser.CredentialSubject credentialSubject) {
        this.parameterHistoryModel = parameterHistoryModel;
        this.credentialSubject = credentialSubject;
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MultiCredentialArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.listView != null);
            this.listView.setCellFactory(StringConverterListCell.getListViewCellFactory((StringConverter)new StringConverter<AnyCredential>(){

                public String toString(AnyCredential credential) {
                    return credential.getName();
                }

                public AnyCredential fromString(String string) {
                    throw new RuntimeException("not supported and not supposed to be used");
                }
            }));
            this.addButton.managedProperty().bind((ObservableValue)this.addButton.visibleProperty());
            this.editButton.managedProperty().bind((ObservableValue)this.editButton.visibleProperty());
            this.viewButton.managedProperty().bind((ObservableValue)this.viewButton.visibleProperty());
            this.listView.getSelectionModel().selectedItemProperty().addListener((observableValue, oldSelected, newSelected) -> {
                if (newSelected != null) {
                    this.editButton.setVisible(true);
                    this.viewButton.setVisible(true);
                } else {
                    this.editButton.setVisible(false);
                    this.viewButton.setVisible(false);
                }
            });
            this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            switch (credentialSubject) {
                case USER: {
                    this.listView.setItems(parameterHistoryModel.getUserCredentialsList());
                    break;
                }
                case SLICE: {
                    this.listView.setItems(parameterHistoryModel.getSliceCredentialsList());
                    break;
                }
                case ANY: {
                    this.listView.setItems(parameterHistoryModel.getAnyCredentialsList());
                }
            }
            if (!this.listView.getItems().isEmpty()) {
                this.listView.getSelectionModel().selectLast();
            }
            ObservableList selectedItems = this.listView.getSelectionModel().getSelectedItems();
            selectedItems.addListener(change -> this.valueProperty.set(new ArrayList(selectedItems)));
            this.valueProperty.set(new ArrayList(selectedItems));
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @FXML
    public void add() {
        ObservableList creds = null;
        switch (this.credentialSubject) {
            case USER: {
                creds = this.parameterHistoryModel.getUserCredentialsList();
                break;
            }
            case SLICE: {
                creds = this.parameterHistoryModel.getSliceCredentialsList();
                break;
            }
            case ANY: {
                creds = this.parameterHistoryModel.getUncategorizedCredentialsList();
            }
        }
        AnyCredential newCredentialInfo = CredentialEditDialog.showAddDialog();
        if (newCredentialInfo != null) {
            creds.add((Object)newCredentialInfo);
        }
    }

    @FXML
    public void edit() {
        AnyCredential selected = (AnyCredential)this.listView.getSelectionModel().selectedItemProperty().get();
        if (selected == null) {
            return;
        }
        AnyCredential editedCredentialInfo = CredentialEditDialog.showDialog(false, selected);
        if (editedCredentialInfo != null) {
            ObservableList creds = null;
            switch (this.credentialSubject) {
                case USER: {
                    creds = this.parameterHistoryModel.getUserCredentialsList();
                    break;
                }
                case SLICE: {
                    creds = this.parameterHistoryModel.getSliceCredentialsList();
                    break;
                }
                case ANY: {
                    creds = this.parameterHistoryModel.getUncategorizedCredentialsList();
                }
            }
            creds.remove((Object)selected);
            creds.add((Object)editedCredentialInfo);
        }
    }

    @FXML
    public void view() {
        AnyCredential selected = (AnyCredential)this.listView.getSelectionModel().selectedItemProperty().get();
        if (selected != null) {
            CredentialViewDialog.showDialog(selected);
        }
    }
}

