/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CredentialCreatorPanel {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialCreatorPanel.class);
    private final JavaFXLogger logger;
    private final AuthorityFinder authorityFinder;
    protected final GeniUserProvider geniUserProvider;
    protected final JFedConnectionProvider connectionProvider;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;
    private final TaskThread tt;
    private final JFedPreferences jFedPreferences;
    private final Map<GeniUrn, X509Certificate> resolvedUserCredentials = new HashMap<GeniUrn, X509Certificate>();

    protected CredentialCreatorPanel(JavaFXLogger logger, AuthorityFinder authorityFinder, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt, JFedPreferences jFedPreferences) {
        this.logger = logger;
        this.authorityFinder = authorityFinder;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
        this.tt = tt;
        this.jFedPreferences = jFedPreferences;
    }

    protected Task resolveUser(final GeniUrn otherUserUrn) {
        final Server otherUserAuth = this.authorityFinder.findByAnyUrn(otherUserUrn.getValue(), AuthorityFinder.Purpose.FIND_USERAUTH);
        Task resolveUserCall = new Task("Resolve User " + String.valueOf(otherUserUrn)){

            public void doTask(@Nonnull TaskExecution singleTask) throws JFedException, InterruptedException {
                LOG.debug("Resolving target to get certificate");
                SfaConnection con = (SfaConnection)CredentialCreatorPanel.this.connectionProvider.getConnectionByAuthority(CredentialCreatorPanel.this.geniUserProvider.getLoggedInGeniUser(), otherUserAuth, new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
                ProtogeniSliceAuthority sa = new ProtogeniSliceAuthority((be.iminds.ilabt.jfed.log.Logger)CredentialCreatorPanel.this.logger, CredentialCreatorPanel.this.jFedPreferences);
                List userCreds = CredentialCreatorPanel.this.sfaModel.getUserCredentials();
                assert (userCreds != null && !userCreds.isEmpty());
                ProtogeniSliceAuthority.SliceAuthorityReply reply = sa.resolveUser(con, AnyCredential.toSingleCredential((List)userCreds), (ResourceId)otherUserUrn);
                if (!reply.getGeniResponseCode().isSuccess()) {
                    return;
                }
                if (((ProtogeniSliceAuthority.UserInfo)reply.getValue()).getCertificate() == null) {
                    LOG.warn("Reply was succesful, but no certificate was returned");
                    return;
                }
                CredentialCreatorPanel.this.resolvedUserCredentials.put(otherUserUrn, ((ProtogeniSliceAuthority.UserInfo)reply.getValue()).getCertificate());
            }

            @Nonnull
            public List<Task> initDependsOn() {
                ArrayList<Task> res = new ArrayList<Task>();
                res.add((Task)CredentialCreatorPanel.this.hltf.getUserCredential());
                return res;
            }
        };
        return resolveUserCall;
    }

    protected Pair<GeniUrn, X509Certificate> getUserInfo(String urnString) throws GeniUrn.GeniUrnParseException, JFedException {
        X509Certificate cert;
        GeniUrn otherUserUrn = new GeniUrn(urnString);
        if (Objects.equals(this.geniUserProvider.getLoggedInGeniUser().getUserUrnString(), otherUserUrn.getValue())) {
            LOG.debug("getUserInfo() User is logged in user: all information already known for " + otherUserUrn.getValue());
            cert = (X509Certificate)this.geniUserProvider.getLoggedInGeniUser().getClientCertificateChain().get(0);
        } else {
            LOG.debug("getUserInfo() Getting needed information using ProtoGeni SA for urn: " + otherUserUrn.getValue());
            if (!this.resolvedUserCredentials.containsKey(otherUserUrn)) {
                LOG.trace("getUserInfo() Fetching user info");
                Task task = this.resolveUser(otherUserUrn);
                CountDownLatch latch = task.getCompletionCountDownLatch();
                this.tt.addTask(task);
                try {
                    assert (!Platform.isFxApplicationThread());
                    LOG.trace("getUserInfo() waiting for task completion");
                    latch.await();
                    LOG.trace("getUserInfo() task completion");
                }
                catch (InterruptedException e) {
                    LOG.warn("CountDownLatch InterruptedException", (Throwable)e);
                }
                cert = this.resolvedUserCredentials.get(otherUserUrn);
            } else {
                cert = this.resolvedUserCredentials.get(otherUserUrn);
            }
        }
        LOG.trace("getUserInfo() return");
        return new Pair((Object)otherUserUrn, (Object)cert);
    }

    protected String findUrnInCertificate(X509Certificate cert) {
        Collection<List<?>> altNames = null;
        try {
            altNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            LOG.error("Error processing certificate alternate names: " + e.getMessage());
            return null;
        }
        String userAuth = null;
        LOG.trace("certificate has alt names: " + (altNames != null && altNames.isEmpty()) + "\n");
        if (altNames != null) {
            Object invalidUrnErrors = "";
            boolean hasvalidUrn = false;
            for (List<?> altName : altNames) {
                Integer nameType = (Integer)altName.get(0);
                LOG.trace("certificate has altname of type " + nameType + "\n");
                if (nameType != 6) continue;
                String urn = (String)altName.get(1);
                GeniUrn geniUrn = GeniUrn.parse((String)urn);
                if (geniUrn == null || !Objects.equals(geniUrn.getEncodedResourceType(), "user")) {
                    invalidUrnErrors = (String)invalidUrnErrors + "Warning: certificate alternative name URI is not a valid user urn: \"" + urn + "\"  (will be ignored)";
                    continue;
                }
                hasvalidUrn = true;
                userAuth = geniUrn.getEncodedTopLevelAuthority();
                String userName = geniUrn.getEncodedResourceName();
                String userUrn = urn;
                LOG.trace("processed altName of URN type. userUrn=" + userUrn + "\n");
                return userUrn;
            }
            if (!hasvalidUrn && !((String)invalidUrnErrors).isEmpty()) {
                LOG.warn((String)invalidUrnErrors);
            }
        }
        LOG.warn("no urn found in certificate: " + String.valueOf(cert));
        this.setResult("ERROR: no urn found in certificate: " + String.valueOf(cert));
        return null;
    }

    protected abstract void setResult(String var1);

    protected X509Certificate certificateRetriever(String targetUrn) {
        LOG.trace("certificateRetriever() getting target info for urn " + targetUrn);
        Pair<GeniUrn, X509Certificate> targetInfo = null;
        try {
            targetInfo = this.getUserInfo(targetUrn);
            if (targetInfo == null || targetInfo.getValue() == null) {
                this.setResult("ERROR getting certificate for urn: " + targetUrn);
                return null;
            }
            return (X509Certificate)targetInfo.getValue();
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("ERROR urn is invalid: " + targetUrn, (Throwable)e);
            this.setResult("ERROR urn is invalid: " + targetUrn);
            return null;
        }
        catch (JFedException e) {
            LOG.error("Error in call retrieving info for urn: " + targetUrn, (Throwable)e);
            this.setResult("Error in call retrieving info for urn: " + targetUrn);
            return null;
        }
    }
}

