/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation;

import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CredentialArgumentChooser;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.CredentialCreatorPanel;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedCredentialCreatorPanelController
extends CredentialCreatorPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatedCredentialCreatorPanelController.class);
    @FXML
    private BorderPane root;
    @FXML
    private Label credentialLabel;
    @FXML
    private VBox credentialChooserBox;
    @FXML
    private CredentialArgumentChooser credentialChooser;
    @FXML
    private Label targetLabel;
    @FXML
    private TextField targetText;
    @FXML
    private Button generateButton;
    @FXML
    private Label resultLabel;
    @FXML
    private TextArea resultText;
    @FXML
    private Button saveResultButton;
    @FXML
    private Label privNameLabel;
    @FXML
    private TextField privNameText;
    @FXML
    private CheckBox canDelegateCheckBox;
    @FXML
    private Label expireLabel;
    @FXML
    private TextField expireText;
    @FXML
    private RadioButton targetViaUrn;
    @FXML
    private RadioButton targetViaCert;
    @FXML
    private VBox targetUrnBox;
    @FXML
    private VBox targetCertfileBox;
    @FXML
    private TextField targetCertFilename;
    @FXML
    private Button loadCertButton;
    private final ParameterHistoryModel parameterHistoryModel;
    private X509Certificate userCert;
    Thread generateDelegatedThread = null;

    @Inject
    DelegatedCredentialCreatorPanelController(JavaFXLogger logger, AuthorityFinder authorityFinder, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt, JFedPreferences jFedPreferences, ParameterHistoryModel parameterHistoryModel) {
        super(logger, authorityFinder, geniUserProvider, connectionProvider, sfaModel, hltf, tt, jFedPreferences);
        this.parameterHistoryModel = parameterHistoryModel;
    }

    @FXML
    private void initialize() {
        this.credentialLabel.managedProperty().bind((ObservableValue)this.credentialLabel.visibleProperty());
        this.credentialChooserBox.managedProperty().bind((ObservableValue)this.credentialChooserBox.visibleProperty());
        this.targetLabel.managedProperty().bind((ObservableValue)this.targetLabel.visibleProperty());
        this.targetText.managedProperty().bind((ObservableValue)this.targetText.visibleProperty());
        this.generateButton.managedProperty().bind((ObservableValue)this.generateButton.visibleProperty());
        this.resultLabel.managedProperty().bind((ObservableValue)this.resultLabel.visibleProperty());
        this.resultText.managedProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.saveResultButton.managedProperty().bind((ObservableValue)this.saveResultButton.visibleProperty());
        this.targetUrnBox.managedProperty().bind((ObservableValue)this.targetUrnBox.visibleProperty());
        this.targetCertfileBox.managedProperty().bind((ObservableValue)this.targetCertfileBox.visibleProperty());
        this.privNameLabel.managedProperty().bind((ObservableValue)this.privNameLabel.visibleProperty());
        this.privNameText.managedProperty().bind((ObservableValue)this.privNameText.visibleProperty());
        this.canDelegateCheckBox.managedProperty().bind((ObservableValue)this.canDelegateCheckBox.visibleProperty());
        this.expireLabel.managedProperty().bind((ObservableValue)this.expireLabel.visibleProperty());
        this.expireText.managedProperty().bind((ObservableValue)this.expireText.visibleProperty());
        this.credentialLabel.visibleProperty().bind((ObservableValue)this.credentialChooserBox.visibleProperty());
        this.targetLabel.managedProperty().bind((ObservableValue)this.targetText.visibleProperty());
        this.resultLabel.managedProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.saveResultButton.managedProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.privNameLabel.visibleProperty().bind((ObservableValue)this.privNameText.visibleProperty());
        this.expireLabel.visibleProperty().bind((ObservableValue)this.expireText.visibleProperty());
        this.targetUrnBox.visibleProperty().bind((ObservableValue)this.targetViaUrn.selectedProperty());
        this.targetCertfileBox.visibleProperty().bind((ObservableValue)this.targetViaCert.selectedProperty());
        this.credentialChooser = new CredentialArgumentChooser(this.parameterHistoryModel, CommandArgumentChooser.CredentialSubject.ANY);
        this.credentialChooserBox.getChildren().add((Object)this.credentialChooser);
    }

    @FXML
    private void loadCertFile() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            String filename = file.getPath();
            this.targetCertFilename.setText(filename);
            String fileContent = null;
            try {
                fileContent = IOUtils.fileToString((File)file);
                this.userCert = KeyUtil.pemToX509Certificate((String)fileContent);
            }
            catch (Exception e) {
                LOG.error("Error reading user certificate file \"" + filename + "\": " + e.getMessage(), (Throwable)e);
                this.targetCertFilename.setText("ERROR: " + e.getMessage());
                this.userCert = null;
            }
        }
    }

    @Override
    protected void setResult(String text) {
        Platform.runLater(() -> this.resultText.setText(text));
    }

    public void generate() {
        int expireInDaysHelper;
        if (this.targetViaCert.isSelected() && this.userCert == null) {
            LOG.info("button clicked: generateDelegate not called since no certificate loaded yet");
            return;
        }
        if (this.generateDelegatedThread != null) {
            LOG.debug("button clicked: generateDelegate still running, so not called");
            return;
        }
        LOG.debug("button clicked: generateDelegate called");
        this.generateButton.setDisable(true);
        AnyCredential delegatedCredential_any = (AnyCredential)this.credentialChooser.valueProperty().getValue();
        if (delegatedCredential_any == null || !(delegatedCredential_any instanceof SfaCredential)) {
            LOG.debug((String)("generateDelegate_Helper() no usable credential selected: " + String.valueOf(delegatedCredential_any) == null ? "null" : "class=" + delegatedCredential_any.getClass().getName() + " type=" + delegatedCredential_any.getType() + " version=" + delegatedCredential_any.getVersion()));
            return;
        }
        SfaCredential delegatedCredential = (SfaCredential)delegatedCredential_any;
        try {
            expireInDaysHelper = Integer.parseInt(this.expireText.getText());
        }
        catch (NumberFormatException e) {
            LOG.debug("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer", (Throwable)e);
            this.setResult("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer");
            return;
        }
        int expireInDays = expireInDaysHelper;
        String privilegeName = this.privNameText.getText();
        boolean canDelegate = this.canDelegateCheckBox.isSelected();
        this.generateDelegatedThread = new Thread(() -> {
            String targetUrn;
            if (this.targetViaUrn.isSelected()) {
                targetUrn = this.targetText.getText();
                this.userCert = this.certificateRetriever(targetUrn);
            } else {
                assert (this.userCert != null);
                targetUrn = this.findUrnInCertificate(this.userCert);
                assert (targetUrn != null);
            }
            this.generate_Helper(delegatedCredential, targetUrn, this.userCert, expireInDays, privilegeName, canDelegate);
            LOG.trace("generateDelegate_Helper() returned");
            this.generateDelegatedThread = null;
            Platform.runLater(() -> this.generateButton.setDisable(false));
        });
        this.generateDelegatedThread.start();
    }

    public void generate_Helper(SfaCredential delegatedCredential, String targetUrn, X509Certificate targetCert, int expireInDays, String privilegeName, boolean canDelegate) {
        assert (!Platform.isFxApplicationThread());
        assert (this.credentialChooser != null);
        assert (this.geniUserProvider.isUserLoggedIn());
        LOG.trace("generateDelegate_Helper() has target info");
        PrivateKey userPrivateKey = this.geniUserProvider.getLoggedInGeniUser().getPrivateKey();
        Date expireDate = new Date(System.currentTimeMillis() + (long)(expireInDays * 24 * 60 * 60 * 1000));
        try {
            LOG.trace("generateDelegate_Helper() creating credential");
            SfaCredential delegateCredential = delegatedCredential.delegate(targetUrn, targetCert, userPrivateKey, expireDate, privilegeName, canDelegate);
            LOG.trace("generateDelegate_Helper() showing result");
            this.setResult(delegateCredential.getCredentialXml());
            Platform.runLater(() -> this.parameterHistoryModel.addUserCredential((AnyCredential)delegateCredential));
        }
        catch (CredentialException e) {
            LOG.error("Exception creating speaks for credential", (Throwable)e);
            this.setResult("ERROR creating speaks for credential: " + e.getMessage());
        }
    }

    public void save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Credential File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Credential XML Files", new String[]{"*.xml"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file = fileChooser.showSaveDialog(this.root.getScene().getWindow());
        if (file != null) {
            try {
                IOUtils.stringToFile((File)file, (String)this.resultText.getText());
            }
            catch (Exception e) {
                LOG.error("Failed to save to file: " + file.getPath(), (Throwable)e);
            }
        }
    }
}

