/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation;

import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.credential_manipulation.CredentialCreatorPanel;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeaksForAbacCredentialCreatorPanelController
extends CredentialCreatorPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SpeaksForAbacCredentialCreatorPanelController.class);
    @FXML
    private BorderPane root;
    @FXML
    private Label spokenForUrnLabel;
    @FXML
    private TextField spokenForUrnText;
    @FXML
    private Label spokenForUrnNoteLabel;
    @FXML
    private TextArea speakerCertContent;
    @FXML
    private Button loadCertButton;
    @FXML
    private Button generateButton;
    @FXML
    private Label generateNoteLabel;
    @FXML
    private TextArea resultText;
    @FXML
    private Button saveResultButton;
    @FXML
    private TextField expireText;
    private final ParameterHistoryModel parameterHistoryModel;
    private X509Certificate spokenForCert;
    private PrivateKey spokenForPrivateKey;
    private X509Certificate speakerCert;

    @Inject
    SpeaksForAbacCredentialCreatorPanelController(JavaFXLogger logger, AuthorityFinder authorityFinder, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, SfaModel sfaModel, HighLevelTaskFactory hltf, TaskThread tt, JFedPreferences jFedPreferences, ParameterHistoryModel parameterHistoryModel) {
        super(logger, authorityFinder, geniUserProvider, connectionProvider, sfaModel, hltf, tt, jFedPreferences);
        this.parameterHistoryModel = parameterHistoryModel;
    }

    @FXML
    private void initialize() {
        this.spokenForUrnLabel.managedProperty().bind((ObservableValue)this.spokenForUrnLabel.visibleProperty());
        this.spokenForUrnText.managedProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.spokenForUrnNoteLabel.managedProperty().bind((ObservableValue)this.spokenForUrnNoteLabel.visibleProperty());
        this.generateButton.managedProperty().bind((ObservableValue)this.generateButton.visibleProperty());
        this.generateNoteLabel.managedProperty().bind((ObservableValue)this.generateNoteLabel.visibleProperty());
        this.resultText.managedProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.expireText.managedProperty().bind((ObservableValue)this.expireText.visibleProperty());
        this.spokenForUrnLabel.visibleProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.spokenForUrnNoteLabel.visibleProperty().bind((ObservableValue)this.spokenForUrnText.visibleProperty());
        this.generateNoteLabel.visibleProperty().bind((ObservableValue)this.generateButton.visibleProperty());
        this.saveResultButton.visibleProperty().bind((ObservableValue)this.resultText.visibleProperty());
        this.updateLoggedInUser();
    }

    @FXML
    private void loadCertFile() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            String filename = file.getPath();
            try {
                String fileContent = IOUtils.fileToString((File)file);
                Platform.runLater(() -> this.speakerCertContent.setText(fileContent));
            }
            catch (Exception e) {
                LOG.error("Error reading user certificate file \"" + filename + "\": " + e.getMessage(), (Throwable)e);
                Platform.runLater(() -> this.speakerCertContent.setText("ERROR loading file \"" + filename + "\": " + e.getMessage()));
            }
        }
    }

    private void updateLoggedInUser() {
        if (this.geniUserProvider.isUserLoggedIn()) {
            this.spokenForUrnText.setText(this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
            this.generateButton.setDisable(false);
            this.spokenForCert = !this.geniUserProvider.getLoggedInGeniUser().getClientCertificateChain().isEmpty() ? (X509Certificate)this.geniUserProvider.getLoggedInGeniUser().getClientCertificateChain().get(0) : null;
            this.spokenForPrivateKey = this.geniUserProvider.getLoggedInGeniUser().getPrivateKey();
        } else {
            this.spokenForUrnText.setText("no user logged in");
            this.generateButton.setDisable(true);
            this.spokenForCert = null;
            this.spokenForPrivateKey = null;
        }
    }

    @Override
    protected void setResult(String text) {
        Platform.runLater(() -> this.resultText.setText(text));
    }

    public void generate() {
        int expireInDaysHelper;
        this.speakerCert = KeyUtil.pemToX509Certificate((String)this.speakerCertContent.getText());
        if (this.speakerCert == null) {
            LOG.info("button clicked: generateDelegate not called since no PEM X509 certificate is provided");
            return;
        }
        LOG.debug("button clicked: generateSpeaksFor called");
        try {
            expireInDaysHelper = Integer.parseInt(this.expireText.getText());
        }
        catch (NumberFormatException e) {
            LOG.debug("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer", (Throwable)e);
            this.setResult("Error processing \"expire\": \"" + this.expireText.getText() + "\" is not a valid integer");
            return;
        }
        int expireInDays = expireInDaysHelper;
        try {
            Date expireDate = new Date(System.currentTimeMillis() + (long)(expireInDays * 24 * 60 * 60) * 1000L);
            LOG.trace("generateSpeaksFor_Helper() creating credential");
            AbacCredential speakForCredential = AbacCredential.createSpeaksFor((Date)expireDate, (X509Certificate)this.speakerCert, (X509Certificate)this.spokenForCert, (Key)this.spokenForPrivateKey);
            LOG.trace("generateSpeaksFor_Helper() showing result");
            this.setResult(speakForCredential.getCredentialXml());
            this.parameterHistoryModel.addUserCredential((AnyCredential)speakForCredential);
        }
        catch (AssertionError e) {
            LOG.error("AssertionError generating speaks for credential", (Throwable)((Object)e));
            this.setResult("AssertionError generating speaks for credential: " + ((Throwable)((Object)e)).getMessage());
        }
        catch (Exception e) {
            LOG.error("Exception generating speaks for credential", (Throwable)e);
            this.setResult("ERROR generating speaks for credential: " + e.getMessage());
        }
    }

    public void save() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Credential File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Credential XML Files", new String[]{"*.xml"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file = fileChooser.showSaveDialog(this.root.getScene().getWindow());
        if (file != null) {
            try {
                IOUtils.stringToFile((File)file, (String)this.resultText.getText());
            }
            catch (Exception e) {
                LOG.error("Failed to save to file: " + file.getPath(), (Throwable)e);
            }
        }
    }
}

