/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.dialog;

import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialEditDialog {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialEditDialog.class);

    public static AnyCredential showAddDialog() {
        return CredentialEditDialog.showDialog(true, null);
    }

    public static AnyCredential showDialog(boolean add, AnyCredential anyCredential) {
        assert (add || anyCredential != null);
        Stage dialog = new Stage();
        dialog.initStyle(StageStyle.UTILITY);
        dialog.initModality(Modality.APPLICATION_MODAL);
        SimpleObjectProperty resultProp = new SimpleObjectProperty(null);
        VBox box = new VBox();
        HBox box2 = new HBox();
        HBox.setHgrow((Node)box2, (Priority)Priority.ALWAYS);
        box2.setAlignment(Pos.CENTER);
        Button butOk = new Button("Use this Credential");
        Button butCancel = new Button(add ? "Do not add" : "Cancel Edit");
        Button butLoad = new Button("Load from file...");
        Label internalNameLabel = new Label("Internal Name:");
        TextField internalNameField = new TextField(anyCredential == null ? "User Imported Credential" : anyCredential.getName());
        Label credentialTypeLabel = new Label("Type:");
        TextField credentialTypeField = new TextField(anyCredential == null ? "auto" : anyCredential.getType());
        Label credentialVersionLabel = new Label("Version:");
        TextField credentialVersionField = new TextField(anyCredential == null ? "auto" : anyCredential.getVersion());
        Label valueLabel = new Label("Xml value:");
        TextArea valueArea = new TextArea(anyCredential == null ? "" : anyCredential.getCredentialXml());
        valueArea.setEditable(true);
        VBox.setVgrow((Node)valueArea, (Priority)Priority.ALWAYS);
        box2.getChildren().addAll((Object[])new Node[]{butOk, butCancel});
        box.getChildren().addAll((Object[])new Node[]{internalNameLabel, internalNameField, credentialTypeLabel, credentialTypeField, credentialVersionLabel, credentialVersionField, valueLabel, butLoad, valueArea, box2});
        Scene scene = new Scene((Parent)box);
        dialog.setScene(scene);
        dialog.sizeToScene();
        butOk.setOnAction(arg_0 -> CredentialEditDialog.lambda$showDialog$0(internalNameField, valueArea, credentialVersionField, credentialTypeField, (ObjectProperty)resultProp, dialog, arg_0));
        butCancel.setOnAction(arg_0 -> CredentialEditDialog.lambda$showDialog$1((ObjectProperty)resultProp, dialog, arg_0));
        butLoad.setOnAction(actionEvent -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open Credential File");
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Credential XML Files", new String[]{"*.xml"}));
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
            File file = fileChooser.showOpenDialog((Window)dialog);
            if (file != null) {
                try {
                    String content = IOUtils.fileToString((File)file);
                    Platform.runLater(() -> valueArea.setText(content));
                }
                catch (IOException e) {
                    LOG.error("Failed to open file: " + file.getPath(), (Throwable)e);
                }
            }
        });
        dialog.showAndWait();
        return (AnyCredential)resultProp.get();
    }

    private static /* synthetic */ void lambda$showDialog$1(ObjectProperty resultProp, Stage dialog, ActionEvent actionEvent) {
        resultProp.set(null);
        dialog.close();
    }

    private static /* synthetic */ void lambda$showDialog$0(TextField internalNameField, TextArea valueArea, TextField credentialVersionField, TextField credentialTypeField, ObjectProperty resultProp, Stage dialog, ActionEvent actionEvent) {
        String newName = internalNameField.getText();
        AnyCredential resGeniCredential = null;
        try {
            resGeniCredential = valueArea.getText() == null || valueArea.getText().isEmpty() || valueArea.getText().trim().equalsIgnoreCase("auto") || credentialVersionField.getText() == null || credentialVersionField.getText().isEmpty() || credentialVersionField.getText().trim().equalsIgnoreCase("auto") ? AnyCredential.createAutoDetect((String)newName, (String)valueArea.getText()) : AnyCredential.create((String)newName, (String)valueArea.getText(), (String)credentialTypeField.getText(), (String)credentialVersionField.getText());
            resultProp.set((Object)resGeniCredential);
        }
        catch (CredentialException e) {
            resultProp.set(null);
            LOG.error("Error creating credential: " + e.getMessage(), (Throwable)e);
        }
        dialog.close();
    }
}

