/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.tests.highlevel;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupConfig;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupContext;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupHelper;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupLogger;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfigImpl;
import be.iminds.ilabt.jfed.experimenter_gui.config.UserInfoProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigStitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapsFetcher;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcher;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import be.iminds.ilabt.jfed.git.SingleSshGitAuthPreferences;
import be.iminds.ilabt.jfed.highlevel.HighLevelModule;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.link_test.LinkTestListener;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.JsonTestConfigEditor;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.testing.shared.ProxyInfoGenerator;
import be.iminds.ilabt.jfed.testing.tests.highlevel.AbstractHLTest;
import be.iminds.ilabt.jfed.testing.tests.highlevel.ESpecLogToTestMethodResult;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.GuiLogicTestConfig;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import io.dropwizard.jackson.Jackson;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.slf4j.LoggerFactory;

public class GuiLogicTest
extends AbstractHLTest<GuiLogicTestConfig> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(GuiLogicTest.class);
    @Nonnull
    private final Server userAuthorityServer;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final RspecFactory rspecFactory;
    @Nonnull
    private final JFedCorePreferences configJFedPreferences;
    @Nonnull
    private final Injector configInjector;
    @Nonnull
    private final AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;
    @Nonnull
    private final List<ESpecAnsibleRunInfo> eSpecAnsibleRunInfos = new ArrayList<ESpecAnsibleRunInfo>();
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final ApiTestMetaData metadata = new ApiTestMetaData<GuiLogicTestConfig>(){

        @Nonnull
        public String getTestDescription() {
            return "A test using the jFed GUI Editor logic. This will reserve resources, test login, and delete them again.";
        }

        @Nonnull
        public Class<GuiLogicTestConfig> getConfigClass() {
            return GuiLogicTestConfig.class;
        }

        @Nonnull
        public GuiLogicTestConfig parseApiTestConfig(@Nonnull String apiTestConfigString) {
            try {
                return (GuiLogicTestConfig)MAPPER.readValue(apiTestConfigString, GuiLogicTestConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid Test config", e);
            }
        }

        @Nonnull
        public ApiTestConfigEditor<GuiLogicTestConfig> getApiTestConfigEditor() {
            return new JsonTestConfigEditor(GuiLogicTestConfig.class);
        }
    };
    NodeLoginTestStep nodeLoginTestStep;
    private List<ResourceInfo> resourceInfos;
    private JFedGuiConfig cachedGuiConfig = null;
    private AdvertisementRspecSource advertisementRspecSource;
    private Map<GuiLogicTestConfig.AnsibleTest, AnsibleInfo> ansibleInfos = new HashMap<GuiLogicTestConfig.AnsibleTest, AnsibleInfo>();

    @Inject
    public GuiLogicTest(@Nonnull Injector originalInjector, @Nonnull Logger logger, @Nonnull RspecFactory rspecFactory, @Nullable TargetAuthority testedAuthority, @Nonnull GeniUserProvider geniUserProvider, @Nonnull GuiLogicTestConfig testConfig, @Nonnull AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations) {
        super(logger, testedAuthority, geniUserProvider, testConfig);
        this.rspecFactory = rspecFactory;
        this.configJFedPreferences = this.setupPreferences(originalInjector);
        this.configInjector = this.createInjector(this.configJFedPreferences);
        this.testbedInfoSource = (TestbedInfoSource)this.configInjector.getInstance(TestbedInfoSource.class);
        this.authorityFinder = (AuthorityFinder)this.configInjector.getInstance(AuthorityFinder.class);
        this.sfaModel = (SfaModel)this.configInjector.getInstance(SfaModel.class);
        this.automatedTestExternalExecutableLocations = automatedTestExternalExecutableLocations;
        if (this.user == null) {
            throw new IllegalStateException("User is null");
        }
        Server uas = this.user.getUserAuthorityServer();
        if (uas == null) {
            throw new IllegalStateException("User has no Authority Server");
        }
        this.userAuthorityServer = uas;
    }

    private void setNotEnoughFreeResourcesDetected() {
        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("notEnoughFreeResourcesDetected").setValue((Object)true).setLarge(false));
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    public AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory getAutomaticUserAndSliceApiWrapperFactory() {
        return (AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory)this.configInjector.getInstance(AutomaticUserAndSliceApiWrapper.BasicAutomaticUserAndSliceApiWrapperFactory.class);
    }

    private JFedCorePreferences setupPreferences(Injector injector) {
        JFedCorePreferences newJFedPreferences;
        JFedPreferences basePrefs = (JFedPreferences)injector.getInstance(JFedPreferences.class);
        JFedCorePreferences jFedCorePreferences = newJFedPreferences = basePrefs instanceof JFedCorePreferences ? ((JFedCorePreferences)basePrefs).makeNoSaveCopy() : null;
        if (newJFedPreferences != null) {
            if (((GuiLogicTestConfig)this.getTestConfig()).getAmConnectionProxy().getMode().equals((Object)Proxy.ProxyMode.MANUAL)) {
                throw new RuntimeException("Option amConnectionProxy.mode == " + String.valueOf(Proxy.ProxyMode.MANUAL) + " is not supported");
            }
            if (((GuiLogicTestConfig)this.getTestConfig()).getNodeLoginTest().getProxy().getMode().equals((Object)Proxy.ProxyMode.MANUAL)) {
                throw new RuntimeException("Option nodeLoginTest.proxy.mode == " + String.valueOf(Proxy.ProxyMode.MANUAL) + " is not supported");
            }
            newJFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, ((GuiLogicTestConfig)this.getTestConfig()).getAmConnectionProxy().getMode().equals((Object)Proxy.ProxyMode.USER_AUTHORITY) ? "ALWAYS" : "NEVER");
            LOG.debug("Set usage of \"call\" proxy to: " + newJFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED));
            newJFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, ((GuiLogicTestConfig)this.getTestConfig()).getNodeLoginTest().getProxy().getMode().equals((Object)Proxy.ProxyMode.USER_AUTHORITY) ? "ALWAYS" : "NEVER");
            LOG.debug("Set usage of SSH proxy to: " + newJFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH));
        }
        return newJFedPreferences;
    }

    private Injector createInjector(JFedCorePreferences configPreferences) {
        ArrayList<Object> minimalModules = new ArrayList<Object>();
        minimalModules.add(new LowLevelModule());
        minimalModules.add(new HighLevelModule());
        minimalModules.add(new SfaOnlyExperimentModule());
        minimalModules.add(binder -> binder.bind(GeniUserProvider.class).toInstance((Object)this.geniUserProvider));
        minimalModules.add(binder -> binder.bind(JFedPreferences.class).toInstance((Object)configPreferences));
        minimalModules.add(binder -> binder.bind(JFedCorePreferences.class).toInstance((Object)configPreferences));
        AbstractModule loggerOverride = new AbstractModule(){

            protected void configure() {
                this.bind(Logger.class).toInstance((Object)GuiLogicTest.this.getLogger());
                if (!(GuiLogicTest.this.getLogger() instanceof JavaFXLogger)) {
                    throw new RuntimeException("Expected getLogger() to be a JavaFXLogger.");
                }
                this.bind(JavaFXLogger.class).toInstance((Object)((JavaFXLogger)GuiLogicTest.this.getLogger()));
            }
        };
        Injector resInjector = Guice.createInjector((Module[])new Module[]{Modules.override(minimalModules).with(new Module[]{loggerOverride})});
        this.assertNotNull(resInjector);
        LOG.debug("Created injector");
        Logger injectorLogger = (Logger)resInjector.getInstance(Logger.class);
        if (this.getLogger() != injectorLogger) {
            this.errorFatal("Invalid logger in injector");
        } else {
            LOG.debug("Logger OK");
        }
        JFedPreferences injectorPreferences = (JFedPreferences)resInjector.getInstance(JFedPreferences.class);
        if (configPreferences != injectorPreferences) {
            this.errorFatal("Invalid JFedPreferences in injector");
        } else {
            LOG.debug("JFedPreferences OK");
        }
        return resInjector;
    }

    public void setUp() throws Exception {
        this.assertNotNull(this.geniUserProvider, "No user specified for test");
        this.assertNotNull(this.user, "No user specified for test");
        this.assertNotNull(this.getTestedAuthority(), "No target server specified for test");
        this.assertNotNull(this.getTestConfig(), "no test config");
        this.assertTrue(((GuiLogicTestConfig)this.getTestConfig()).isValid(), "Test config is not valid");
        this.assertNotEmpty(((GuiLogicTestConfig)this.getTestConfig()).getResources(), "Configuration error: no Resource config");
        AtomicInteger index = new AtomicInteger(0);
        this.resourceInfos = ((GuiLogicTestConfig)this.getTestConfig()).getResources().stream().filter(Objects::nonNull).map(r -> new ResourceInfo(index.getAndIncrement(), (GuiLogicTestConfig.Resource)((Object)r))).collect(Collectors.toList());
        this.assertEquals(this.resourceInfos.size(), ((GuiLogicTestConfig)this.getTestConfig()).getResources().size(), "Configuration error: some of the Resources in the config where null");
        this.assertNotEmpty(this.resourceInfos, "bug");
        this.nodeLoginTestStep = new NodeLoginTestStep((ApiTest)this, ((GuiLogicTestConfig)this.getTestConfig()).generateNodeLoginTestStepConfig(this.geniUserProvider));
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            this.assertTrue(resourceInfo.config.getProvision().isEnabled(), "A disabled provision step is currently not supported.");
        }
        for (GuiLogicTestConfig.AnsibleTest ansibleTestConfig : ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests()) {
            this.setupAnsible(ansibleTestConfig);
        }
    }

    private JFedGuiConfig getGuiConfig() {
        if (this.cachedGuiConfig != null) {
            return this.cachedGuiConfig;
        }
        JFedPreferences jFedPreferences = (JFedPreferences)this.configInjector.getInstance(JFedPreferences.class);
        ConnectivityDetector connectivityDetector = (ConnectivityDetector)this.configInjector.getInstance(ConnectivityDetector.class);
        UserInfoProvider userInfoProvider = (UserInfoProvider)this.configInjector.getInstance(UserInfoProvider.class);
        userInfoProvider.addExtraFlags(new String[]{"dev-testbeds"});
        URL webApiUrl = (URL)this.configInjector.getInstance(Key.get(URL.class, (Annotation)Names.named((String)"noClientAuthWebApiUrl")));
        FedmonWebApiClient fedmonWebApiClient = (FedmonWebApiClient)this.configInjector.getInstance(FedmonWebApiClient.class);
        if (this.geniUserProvider == null) {
            throw new NullPointerException("geniUserProvider may not be null");
        }
        JFedExperimenterGuiConfigProvider jFedExperimenterGuiConfigProvider = new JFedExperimenterGuiConfigProvider(this.geniUserProvider, jFedPreferences, connectivityDetector, userInfoProvider, webApiUrl, this.logger, false);
        TestbedNodesMapsFetcher testbedNodesMapsFetcher = new TestbedNodesMapsFetcher(connectivityDetector);
        this.cachedGuiConfig = new JFedGuiConfigImpl(this.testbedInfoSource, this.authorityFinder, jFedExperimenterGuiConfigProvider, testbedNodesMapsFetcher, fedmonWebApiClient);
        return this.cachedGuiConfig;
    }

    private RSpecGeneratorFactory getRSpecGeneratorFactory() {
        return new RSpecGeneratorFactory(){

            @Nonnull
            public RSpecGenerator createRSpecGenerator() {
                return new GuiConfigRSpecGenerator(GuiLogicTest.this.getGuiConfig(), GuiLogicTest.this.authorityFinder, GuiLogicTest.this.testbedInfoSource);
            }

            @Nonnull
            public StitchingTestRSpecGenerator createStitchingTestRSpecGenerator() {
                return new GuiConfigStitchingTestRSpecGenerator(GuiLogicTest.this.getGuiConfig(), GuiLogicTest.this.authorityFinder, GuiLogicTest.this.testbedInfoSource);
            }
        };
    }

    @ApiTest.Test(groups={"init"})
    public void fetchAdvertisementRspec() throws JFedException {
        boolean needAdvertisementRspec = false;
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            RequestRSpec rspecConfig = resourceInfo.config.getRequestRSpec();
            if (rspecConfig == null || rspecConfig.getSource() != RequestRSpec.RequestRSpecSource.GENERATE_USING_ADVERTISEMENT) continue;
            needAdvertisementRspec = true;
            break;
        }
        if (!needAdvertisementRspec) {
            this.note("Advertisement RSpec not needed. Will do nothing here.");
            return;
        }
        AutomaticUserAndSliceApiWrapper userAndSliceApiWrapper = this.getAutomaticUserAndSliceApiWrapperFactory().create();
        this.assertNotNull(this.user, "internal error");
        GeniUrn userUrn = this.user.getUserUrn();
        List userCredentials = userAndSliceApiWrapper.getUserCredentials(this.logger, userUrn);
        AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory amWrapperFact = (AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory)this.configInjector.getInstance(AutomaticAggregateManagerWrapper.BasicAutomaticAggregateManagerWrapperFactory.class);
        AutomaticAggregateManagerWrapper amWrapper = amWrapperFact.create(this.testedAuthority.getServerToConnect());
        String advertismentRspec = amWrapper.listResources(userCredentials, true);
        if (advertismentRspec == null) {
            this.errorFatal("ListResources call did not return an advertisement RSpec");
            return;
        }
        this.advertisementRspecSource = new AdvertisementRspecSource(advertismentRspec, ModelRspecType.BASIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiTest.Test(hardDepends={"fetchAdvertisementRspec"}, groups={"init", "rspec"})
    public void getRspec() throws GeniUrn.GeniUrnParseException, ESpecBundle.ESpecBundleInitException, InterruptedException, IOException, ExperimentSpecificationParser.ExperimentSpecificationParseException {
        if (this.user == null) {
            this.fatalError("No test user");
        }
        ExperimentSetupLogger experimentSetupLogger = new ExperimentSetupLogger(){

            public void fatal(@Nullable String val, @Nullable Throwable t) {
                GuiLogicTest.this.errorFatal(val, t);
            }

            public void logExtraText(@Nonnull String name, @Nonnull Object value, boolean large) {
                GuiLogicTest.this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(name).setValue(value).setLarge(true).setHttpMediaTypeToText());
            }

            public void logExtraXml(@Nonnull String name, @Nonnull Object value, boolean large) {
                GuiLogicTest.this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(name).setValue(value).setLarge(true).setHttpMediaTypeToXml());
            }

            public void logExtraHtml(@Nonnull String name, @Nonnull Object value, boolean large) {
                GuiLogicTest.this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(name).setValue(value).setLarge(true).setHttpMediaTypeToHtml());
            }

            public void logExtraJson(@Nonnull String name, @Nonnull Object value, boolean large) {
                GuiLogicTest.this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(name).setValue(value).setLarge(true).setHttpMediaTypeToJson());
            }

            public void debug(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                GuiLogicTest.this.currentTestResult.addLogLine(LogOutput.LogLineType.DEBUG, val, e, formatAsCode);
            }

            public void info(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                GuiLogicTest.this.note(val, e, formatAsCode);
            }

            public void warn(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                GuiLogicTest.this.warn(val, e, formatAsCode);
            }

            public void error(@Nullable String val, @Nullable Throwable e, boolean formatAsCode) {
                GuiLogicTest.this.errorNonFatal(val, e, formatAsCode);
            }
        };
        ArrayList allRequestedNodeComponentIds = new ArrayList();
        int resourceIndex = 0;
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            resourceInfo.experimentSetupHelper = new ExperimentSetupHelper((String)(this.resourceInfos.size() < 2 ? "" : "" + resourceIndex), experimentSetupLogger, (ExperimentSetupConfig)resourceInfo.config, (ExperimentSetupContext)resourceInfo, this::getRSpecGeneratorFactory, this.rspecFactory, this.advertisementRspecSource, this.testbedInfoSource, this.authorityFinder, this.user, this.getAutomaticUserAndSliceApiWrapperFactory(), this.sfaModel, this.getLogger());
            try {
                resourceInfo.experimentSetupHelper.getRspec(this.getTestedAuthority().getServerForRspecComponentManager().getDefaultComponentManagerUrn());
                allRequestedNodeComponentIds.addAll(resourceInfo.experimentSetupHelper.getContext().allRequestedNodeComponentIds);
            }
            finally {
                if (!resourceInfo.experimentSetupHelper.isNotEnoughFreeResourcesDetected()) continue;
                this.setNotEnoughFreeResourcesDetected();
            }
        }
        try {
            if (!allRequestedNodeComponentIds.isEmpty()) {
                this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("rspec-request-fixed-nodes").setValue(allRequestedNodeComponentIds).setLarge(false));
            }
        }
        catch (Exception e) {
            this.note("Exception while totaling fixed nodes in request rspec", e);
        }
    }

    private void addManifestRspecFixedNodes(@Nullable ManifestRspecSource manifestRspecSource) {
        try {
            if (manifestRspecSource == null) {
                return;
            }
            List bni = manifestRspecSource.getBasicNodeInfo();
            if (bni == null) {
                return;
            }
            List fixedNodesList = bni.stream().filter(Objects::nonNull).map(BasicStringRspec.BasicNodeInfo::getComponentId).filter(Objects::nonNull).collect(Collectors.toList());
            if (fixedNodesList.isEmpty()) {
                return;
            }
            this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("rspec-manifest-fixed-nodes").setValue(fixedNodesList).setLarge(false));
        }
        catch (Exception e) {
            this.note("Exception while extracting fixed nodes from manifest rspec", e);
        }
    }

    @ApiTest.Test(hardDepends={"getRspec"}, groups={"init"})
    public void findProject() {
        this.assertNotNull(this.user);
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            resourceInfo.experimentSetupHelper.findProject();
        }
    }

    @ApiTest.Test(hardDepends={"getRspec", "findProject"}, groups={"init"})
    public void createExperiment() {
        this.assertNotNull(this.user);
        char sliceNamePrefix = 'g';
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            resourceInfo.sliceName = CommonAMTest.createSliceName((ApiTest)this, (Server)this.userAuthorityServer, (List)ApiInfo.getDefaultComponentManagerForEach((List)resourceInfo.serversInRspec), (String)("" + sliceNamePrefix), (int)resourceInfo.maxNodeNameLength, null);
            sliceNamePrefix = (char)(sliceNamePrefix + '\u0001');
            List<String> sshKeys = Collections.singletonList(this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKeyString());
            UserSpec userSpec = new UserSpec(this.user.getUserUrnString(), sshKeys);
            List<UserSpec> userSpecs = Collections.singletonList(userSpec);
            resourceInfo.experimentSetupHelper.createExperiment(resourceInfo.sliceName, userSpecs, true, false);
            resourceInfo.experiment.getLogEntries().addListener(change -> {
                while (change.next()) {
                    if (!change.wasAdded()) continue;
                    change.getAddedSubList().forEach(arg_0 -> ((ApiTestResult.ApiTestMethodResult)this.currentTestResult).addLogLine(arg_0));
                }
            });
            if (resourceInfo.config.getESpec() != null) {
                resourceInfo.eSpecLogHandler = new ESpecLogToTestMethodResult("Experiment Specification " + resourceInfo.index, "Logging of ESpec execution for resource " + resourceInfo.index, null);
                resourceInfo.eSpecLogHandler.setUniqueEspecId("" + resourceInfo.index);
                resourceInfo.experiment.addESpecLogListener((ESpecLogListener)resourceInfo.eSpecLogHandler);
            }
            if (!resourceInfo.config.getRunLinkTest()) continue;
            resourceInfo.linkTestResultToTest = new LinkTestResultToTest(resourceInfo);
            resourceInfo.experiment.addLinkTestListener((LinkTestListener)resourceInfo.linkTestResultToTest);
        }
    }

    @ApiTest.Test(hardDepends={"createExperiment"}, groups={"run"})
    public void runExperiment() {
        Logger injectorLogger = (Logger)this.configInjector.getInstance(Logger.class);
        if (this.getLogger() != injectorLogger) {
            this.errorFatal("Logger check: Invalid logger in experimentController injector");
        } else {
            this.note("Logger check: OK");
        }
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            resourceInfo.experimentSetupHelper.startExperiment(this.configInjector);
        }
        long maxTimeToWaitForReadyInMinutes = 0L;
        long extraWaitTimeInSeconds = 0L;
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (!resourceInfo.config.getWaitForReady().isEnabled()) {
                resourceInfo.waitForExperimentIsOver = true;
                continue;
            }
            if (resourceInfo.config.getWaitForReady().getMaxTimeMin() > maxTimeToWaitForReadyInMinutes) {
                maxTimeToWaitForReadyInMinutes = resourceInfo.config.getWaitForReady().getMaxTimeMin();
            }
            if (resourceInfo.config.getWaitForReady().getExtraWaitTimeSeconds() <= extraWaitTimeInSeconds) continue;
            extraWaitTimeInSeconds = resourceInfo.config.getWaitForReady().getExtraWaitTimeSeconds();
        }
        if (maxTimeToWaitForReadyInMinutes > 0L) {
            this.note("Start waiting (max " + maxTimeToWaitForReadyInMinutes + " minutes) for experiment(s) to become ready at " + new Date().toString());
        } else {
            this.note("Will not wait for experiment(s) to become ready.");
        }
        long now = System.currentTimeMillis();
        long deadline = now + maxTimeToWaitForReadyInMinutes * 60L * 1000L;
        boolean allDone = false;
        boolean sawFailure = false;
        while (now < deadline && !allDone && !sawFailure) {
            for (ResourceInfo resourceInfo : this.resourceInfos) {
                resourceInfo.experimentSetupHelper.mustWaitForExperiment();
                sawFailure |= resourceInfo.sawFailure;
            }
            allDone = this.resourceInfos.stream().allMatch(ResourceInfo::isWaitForExperimentOver);
            if (!allDone && !sawFailure) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            this.addEmbeddedResult((Collection<JobReport>)resourceInfo.experiment.getJobReports());
            if (resourceInfo.eSpecLogHandler == null) continue;
            ESpecLogToTestMethodResult eSpecLogHandler = resourceInfo.eSpecLogHandler;
            this.currentTestResult.addEmbedded(eSpecLogHandler.getLogAsTestMethodResult());
            eSpecLogHandler.getFedmonResultExtras().forEach(arg_0 -> ((ApiTestResult.ApiTestMethodResult)this.currentTestResult).addExtraResult(arg_0));
        }
        if (maxTimeToWaitForReadyInMinutes > 0L) {
            this.note("Stopped waiting for experiment(s) to become ready at " + new Date().toString());
        }
        if (extraWaitTimeInSeconds > 0L) {
            this.note("Waiting " + extraWaitTimeInSeconds + " extra seconds before continuing. (due to resource.waitForReady.extraWaitTimeSeconds option)");
            try {
                Thread.sleep(extraWaitTimeInSeconds * 1000L);
            }
            catch (InterruptedException e) {
                this.warn("Extra waiting time was interrupted. This should not happen.", e);
            }
        }
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (!resourceInfo.notEnoughResourcesDetected) continue;
            this.setNotEnoughFreeResourcesDetected();
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        if (this.resourceInfos.stream().anyMatch(ResourceInfo::isNotEnoughResourcesDetected)) {
            this.setNotEnoughFreeResourcesDetected();
            this.warn("Test cannot continue: Not enough free resources. ");
            this.note("This test method will be be in the \"WARNING\" state because of \"Not enough free resources\".");
            if (!sawFailure) {
                this.warn("(Additional warning: internal state not set to failure despite this.)");
                return;
            }
            return;
        }
        if (sawFailure) {
            if (this.resourceInfos.stream().anyMatch(ResourceInfo::isAtLeastOneFailingAnsibleRun)) {
                this.warn("Experiment failure is converted to warning because it was caused by the ESpec ansible step. Test will still fail later, in the ansible test step.");
                return;
            }
            this.errorFatal("One or more experiments have failed.");
        }
        if (!allDone) {
            this.errorFatal("One or more experiments did not become ready by the deadline.");
        }
    }

    public boolean isValidGeniRspec(@Nonnull String rspec) {
        return new BasicStringRspec(rspec).isValidRspec();
    }

    @ApiTest.Test(hardDepends={"runExperiment"}, groups={"login"})
    public void checkManifest() throws JFedException {
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (resourceInfo.notEnoughResourcesDetected) {
                this.setNotEnoughFreeResourcesDetected();
                this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
                return;
            }
            Slice slice = resourceInfo.experiment.getSliceOrNull();
            this.assertNotNull(slice, "experiment slice should not be null");
            resourceInfo.manifestRspecSource = slice.getManifestRspec();
            this.assertNotNull(resourceInfo.manifestRspecSource, "experiment slice manifestRspecSource should not be null");
            this.addManifestRspecFixedNodes(resourceInfo.manifestRspecSource);
            resourceInfo.manifestRspecString = resourceInfo.manifestRspecSource.getRspecXmlString();
            this.assertNotNull(resourceInfo.manifestRspecString, "experiment slice manifestRspecSource getRspecXmlString should not be null");
            this.assertNotNull(resourceInfo.requestRspec, "requestRspec should not be null");
            boolean validRequest = this.isValidGeniRspec(resourceInfo.requestRspec);
            resourceInfo.validManifest = this.isValidGeniRspec(resourceInfo.manifestRspecString);
            if (resourceInfo.requestRspec != null && validRequest && resourceInfo.validManifest) {
                this.setErrorsNotFatal();
                this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest((ApiTest)this, (String)resourceInfo.requestRspec, (String)resourceInfo.manifestRspecString));
                this.setErrorsFatal();
            }
            if (!resourceInfo.validManifest) continue;
            boolean foundNodeLogin = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(resourceInfo.manifestRspecString, null, null);
            if (foundNodeLogin) {
                this.note("Successfully found node login in manifest");
            } else {
                this.note("Did not find node login info in manifest");
            }
            if (resourceInfo.config.getSkipFinalManifestCheck()) continue;
            this.nodeLoginTestStep.checkManifestCorrectness(resourceInfo.manifestRspecString, this.testedAuthority);
        }
    }

    @ApiTest.Test(hardDepends={"checkManifest"}, groups={"login"})
    public void login() throws NoSuchAlgorithmException, IOException {
        if (!((GuiLogicTestConfig)this.getTestConfig()).getNodeLoginTest().isEnabled()) {
            this.skip("Test skipped because disabled in config");
            return;
        }
        this.assertNotNull(this.geniUserProvider, "No user specified for test");
        assert (this.nodeLoginTestStep != null);
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (resourceInfo.notEnoughResourcesDetected) {
                this.setNotEnoughFreeResourcesDetected();
                this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
                return;
            }
            if (resourceInfo.validManifest) continue;
            this.skip("Test skipped because at least one manifest is not a geni version 3 RSpec (so this test does not know how to extract node login info)");
            return;
        }
        String sliceName = this.resourceInfos.get((int)0).sliceName;
        this.nodeLoginTestStep.testNodeLogin(false, this.geniUserProvider, sliceName);
    }

    private JFedConnection.SshProxyInfo convertProxy(Proxy proxy, ResourceInfo resourceInfo) {
        this.assertNotNull(this.geniUserProvider, "No user specified for test");
        return ProxyInfoGenerator.generate((ApiTest)this, (Proxy)proxy, (GeniUserProvider)this.geniUserProvider, (String)resourceInfo.sliceName, (SSHKeyHelper)this.nodeLoginTestStep.getSshKeyHelper(), (String)this.nodeLoginTestStep.getSshUsername());
    }

    @ApiTest.Test(hardDepends={"checkManifest"}, groups={"login"})
    public void ansible() throws NoSuchAlgorithmException, IOException {
        boolean hasAnsibleTests;
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (!resourceInfo.notEnoughResourcesDetected) continue;
            this.setNotEnoughFreeResourcesDetected();
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        int ansibleOutputFileCount = 0;
        boolean bl = hasAnsibleTests = ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests() != null && !((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests().isEmpty() && ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests().stream().anyMatch(GuiLogicTestConfig.AnsibleTest::isEnabled);
        if (!hasAnsibleTests && this.eSpecAnsibleRunInfos.isEmpty()) {
            this.skip("Test skipped because disabled in config (and no espec ansible tests)");
            return;
        }
        if (!this.eSpecAnsibleRunInfos.isEmpty()) {
            this.note("There were " + this.eSpecAnsibleRunInfos.size() + " ansible scripts in the ESpec. Will check their status and log results.");
            for (ESpecAnsibleRunInfo info : this.eSpecAnsibleRunInfos) {
                SSHClient ssh;
                ResourceInfo resourceInfo = info.resourceInfo;
                if (resourceInfo.manifestRspecSource == null) {
                    this.errorNonFatal("Failed to get manifestRspecSource while looking for ansible node with client_id=\"" + info.getNodeClientId() + "\"");
                    continue;
                }
                ImmutableModelRspec modelRspec = resourceInfo.manifestRspecSource.getImmutableModelRspec();
                if (modelRspec == null) {
                    this.errorNonFatal("Failed to get manifest ModelRspec while looking for ansible node with client_id=\"" + info.getNodeClientId() + "\"");
                    continue;
                }
                RspecNode node = modelRspec.getNodeByClientId(info.getNodeClientId());
                if (node == null) {
                    this.errorNonFatal("Failed to find manifest RspecNode for ansible node with client_id=\"" + info.getNodeClientId() + "\"");
                    continue;
                }
                SetupSoftwareExperimentJob setupSoftwareExperimentJob = new SetupSoftwareExperimentJob(resourceInfo.experiment, (HighLevelTaskFactory)this.configInjector.getInstance(HighLevelTaskFactory.class), (TaskThread)this.configInjector.getInstance(TaskThread.class), (JobStateFactory)this.configInjector.getInstance(JobStateFactory.class), (AggregateManagerWrapperFactory)this.configInjector.getInstance(AggregateManagerWrapperFactory.class), (ExperimentPartControllerManager)this.configInjector.getInstance(ExperimentPartControllerManager.class), (ProxySocketFactoryProvider)this.configInjector.getInstance(ProxySocketFactoryProvider.class), (GeniUserProvider)this.configInjector.getInstance(GeniUserProvider.class), null, null);
                try {
                    ssh = setupSoftwareExperimentJob.setupNewSSHClient(node);
                }
                catch (JobWithSshConnectionManager.SshSetupException e) {
                    this.errorNonFatal("Failed to setup SSH connection to ansible node with client_id=\"" + info.getNodeClientId() + "\": " + e.getMessage(), e);
                    continue;
                }
                try {
                    SFTPClient sftpClient = ssh.newSFTPClient();
                    try {
                        String ansibleLogContent;
                        if (info.getFullLogPath() != null && (ansibleLogContent = this.downloadFileFromNode(sftpClient, info.getFullLogPath())) != null) {
                            this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"ansible", "output" + (String)(ansibleOutputFileCount++ == 0 ? "" : "" + ansibleOutputFileCount)}).setValue((Object)ansibleLogContent).setLarge(true).setHttpMediaTypeToText());
                            this.note("Appended ansible output to test log (" + ansibleLogContent.length() + " bytes)");
                        }
                        if (!info.isSuccess()) {
                            this.errorNonFatal("Ansible playbook \"" + info.getFullPath() + "\" on \"" + info.getNodeClientId() + "\" had failed.", info.getStatus().getThrowable());
                            continue;
                        }
                        this.note("Ansible playbook \"" + info.getFullPath() + "\" on \"" + info.getNodeClientId() + "\" ran successfully.");
                    }
                    finally {
                        if (sftpClient == null) continue;
                        sftpClient.close();
                    }
                }
                catch (Exception e) {
                    this.errorNonFatal("Exception while fetching log of ansible playbook \"" + info.getFullPath() + "\" on \"" + info.getNodeClientId() + "\"", e);
                }
            }
            LOG.debug("ESpec ansible log processing complete.");
        }
        int testRunCount = 0;
        int testSuccessCount = 0;
        int testWarningCount = 0;
        int testFailCount = 0;
        if (!hasAnsibleTests) {
            LOG.debug("No ansible test configured in test itself.");
            return;
        }
        block24: for (GuiLogicTestConfig.AnsibleTest curAnsibleTest : ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests()) {
            AnsibleInfo ansibleInfo = this.ansibleInfos.get(curAnsibleTest);
            this.assertTrue(ansibleInfo != null, "Internal error in test. (ansibleInfo==null)");
            LOG.debug("Starting ansible test " + ++testRunCount);
            JFedConnection.SshProxyInfo sshProxy = this.convertProxy(curAnsibleTest.getProxy(), this.resourceInfos.get(0));
            this.assertTrue(sshProxy == null, "ansible does not support an SSH proxy, but proxy configured: " + String.valueOf(sshProxy));
            try {
                this.writeAnsibleFiles(ansibleInfo, curAnsibleTest.getDebug());
                LOG.debug("   wrote ansible files to " + String.valueOf(ansibleInfo.ansibleDir));
            }
            catch (IOException e) {
                this.errorFatal("Failed to write ansible files", e);
            }
            Instant ansibleStartTime = Instant.now();
            String output = this.callAnsible(curAnsibleTest, ansibleInfo);
            LOG.debug("    got ansible output");
            Instant ansibleStopTime = Instant.now();
            Duration ansibleRunDuration = Duration.between(ansibleStartTime, ansibleStopTime);
            double durationS = (double)ansibleRunDuration.toMillis() / 1000.0;
            LOG.info("Ansible call took {} s.", (Object)durationS);
            this.note("Ansible call took " + durationS + " s.");
            if (output != null) {
                Object suffix = ansibleOutputFileCount++ == 0 ? "" : "" + ansibleOutputFileCount;
                this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"ansible", "output" + (String)suffix}).setValue((Object)output).setLarge(true).setHttpMediaTypeToText());
                this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"ansible", "secondsDuration" + (String)suffix}).setValue((Object)durationS).setLarge(false));
                List<GuiLogicTestConfig.ExtractSpec> extractSpecs = curAnsibleTest.getExtract();
                for (GuiLogicTestConfig.ExtractSpec extract : extractSpecs) {
                    String extractMethodAsText;
                    Pattern p;
                    assert (!extract.getDelim().trim().isEmpty());
                    assert (!extract.getStartDelimOrFallback().trim().isEmpty());
                    assert (!extract.getEndDelimOrFallback().trim().isEmpty());
                    if (extract.getRegex() != null && !extract.getRegex().trim().isEmpty()) {
                        p = Pattern.compile(extract.getRegex());
                        extractMethodAsText = "regex=\"" + extract.getRegex() + "\"";
                    } else {
                        p = Pattern.compile(Pattern.quote(extract.getStartDelimOrFallback()) + "(.+?)" + Pattern.quote(extract.getEndDelimOrFallback()));
                        extractMethodAsText = "startDelim=\"" + extract.getStartDelimOrFallback() + "\" endDelim=\"" + extract.getEndDelimOrFallback() + "\"";
                    }
                    Matcher m = p.matcher(output);
                    if (m.find()) {
                        String extractedString = m.group(1);
                        Object extractedObj = extractedString;
                        if (extract.getType() == GuiLogicTestConfig.ExtractDataType.JSON) {
                            try {
                                extractedObj = MAPPER.readValue(extractedString, Object.class);
                            }
                            catch (Exception e) {
                                LOG.error("Error parsing extracted JSON. Will try unescaping JSON.", (Throwable)e);
                                try {
                                    String unescaped = (String)MAPPER.readValue("\"" + extractedString + "\"", String.class);
                                    extractedObj = MAPPER.readValue(unescaped, Object.class);
                                }
                                catch (Exception e2) {
                                    LOG.error("Error parsing extracted unescaped JSON", (Throwable)e2);
                                    extractedObj = "ERROR parsing: " + extractedString;
                                }
                            }
                        }
                        ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder extraResultBuilder = new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"extract", extract.getName()}).setValue(extractedObj).setLarge(false);
                        switch (extract.getType()) {
                            case JSON: {
                                extraResultBuilder.setHttpMediaTypeToJson();
                                break;
                            }
                            default: {
                                extraResultBuilder.setHttpMediaTypeToText();
                            }
                        }
                        this.currentTestResult.addExtraResult(extraResultBuilder);
                        this.note("Found value to extract with name=\"" + extract.getName() + "\" " + extractMethodAsText + " (extracted string length=" + extractedString.length() + ")");
                        continue;
                    }
                    this.note("Did NOT find value to extract with name=\"" + extract.getName() + "\" " + extractMethodAsText);
                }
            }
            if (output == null || output.trim().isEmpty()) {
                this.fatalError("Ansible did not return any output.");
            }
            this.note("Ansible output:\n" + output + "\n", true);
            LogOutput.TestResultState res = GuiLogicTest.checkAnsibleOutput(output, this, null, null, null, curAnsibleTest.getSuccessRegex(), curAnsibleTest.getWarningRegex(), curAnsibleTest.getFailureRegex());
            switch (res) {
                case SUCCESS: {
                    ++testSuccessCount;
                    continue block24;
                }
                case WARN: {
                    ++testWarningCount;
                    continue block24;
                }
            }
            ++testFailCount;
        }
        if (testRunCount > 1) {
            this.note("Summary for " + testRunCount + " ansible tests: success=" + testSuccessCount + " warning=" + testWarningCount + " failure=" + testFailCount);
        }
        if (testRunCount != ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests().size()) {
            this.errorFatal("Error: not all ansible tests started: configured=" + ((GuiLogicTestConfig)this.getTestConfig()).getAnsibleTests().size() + " started=" + testRunCount);
        }
    }

    @Nullable
    private String downloadFileFromNode(SFTPClient sftpClient, String remoteFileFullPath) {
        String string;
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            LOG.debug("downloading \"{}\" ", (Object)remoteFileFullPath);
            sftpClient.getFileTransfer().download(remoteFileFullPath, (LocalDestFile)new InMemoryDestFile(){

                public long getLength() {
                    return 0L;
                }

                public OutputStream getOutputStream() throws IOException {
                    return out;
                }

                public OutputStream getOutputStream(boolean append) throws IOException {
                    return out;
                }
            });
            out.flush();
            string = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("Failed to download \"{}\" ", (Object)remoteFileFullPath);
                this.errorNonFatal("Failed to download \"" + remoteFileFullPath + "\"");
                return null;
            }
        }
        out.close();
        return string;
    }

    @ApiTest.Test(softDepends={"login", "ansible", "runExperiment"}, hardDepends={"getRspec", "createExperiment"}, groups={"cleanup", "login", "run"})
    public void deleteExperiment() {
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (resourceInfo.config.getCleanup().isEnabled()) {
                this.note("Will call experimentController.stop();");
                resourceInfo.experimentController.stop();
                continue;
            }
            this.note("Experiment Cleanup disabled");
            resourceInfo.deleted = true;
        }
        long maxTimeToWaitForDeleteInMinutes = 0L;
        for (ResourceInfo resourceInfo : this.resourceInfos) {
            if (resourceInfo.config.getCleanup().getMaxWaitTimeMinutes() <= maxTimeToWaitForDeleteInMinutes) continue;
            maxTimeToWaitForDeleteInMinutes = resourceInfo.config.getCleanup().getMaxWaitTimeMinutes();
        }
        this.note("Will wait until experiment is terminated");
        long now = System.currentTimeMillis();
        long deadline = now + maxTimeToWaitForDeleteInMinutes * 60L * 1000L;
        boolean allDeleted = false;
        while (now < deadline && !allDeleted) {
            for (ResourceInfo resourceInfo : this.resourceInfos) {
                if (resourceInfo.deleted) continue;
                this.note("Current ExperimentState=" + String.valueOf(resourceInfo.experiment.getExperimentState()));
                if (resourceInfo.experiment.getExperimentState() != ExperimentState.EMPTY && resourceInfo.experiment.getExperimentState() != ExperimentState.EXPIRED && resourceInfo.experiment.getExperimentState() != ExperimentState.FAILED) continue;
                this.note("Experiment was terminated");
                resourceInfo.deleted = true;
            }
            allDeleted = this.resourceInfos.stream().map(ResourceInfo::isDeleted).allMatch(b -> b == true);
            if (!allDeleted) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        if (!allDeleted) {
            this.errorFatal("Experiment(s) did not terminate within " + maxTimeToWaitForDeleteInMinutes + " minutes. Gave up waiting for it.");
        } else {
            this.note("All experiments deleted");
        }
    }

    public void setupAnsible(GuiLogicTestConfig.AnsibleTest config) {
        AnsibleInfo ansibleInfo = this.ansibleInfos.computeIfAbsent(config, x$0 -> new AnsibleInfo((GuiLogicTestConfig.AnsibleTest)x$0));
        if (config.isEnabled()) {
            ansibleInfo.ansiblePlaybookExeName = this.automatedTestExternalExecutableLocations.getExe("ansible-playbook").getAbsolutePath();
            if (config.getPlaybookContent() != null) {
                ansibleInfo.ansiblePlaybookContent = config.getPlaybookContent();
            } else {
                if (config.getPlaybookUrl() == null) {
                    throw new IllegalStateException("Both config.getPlaybookUrl() and config.getPlaybookContent() are null");
                }
                boolean isSpecialGit = config.getPlaybookUrl().trim().startsWith("git ");
                boolean isSpecialGithub = config.getPlaybookUrl().trim().startsWith("github ");
                if (isSpecialGit || isSpecialGithub) {
                    String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
                    this.fetchPlaybookFromGit(ansibleInfo, config.getPlaybookUrl().trim(), isSpecialGithub, config.getPlaybookFileNameInArchive(), userPem);
                } else {
                    boolean downloadArchive;
                    URL url;
                    try {
                        url = new URL(config.getPlaybookUrl());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Invalid URL specified for RSpec: \"" + config.getPlaybookUrl() + "\"", e);
                    }
                    boolean bl = downloadArchive = config.getPlaybookFileNameInArchive() != null;
                    if (!downloadArchive) {
                        this.fetchPlaybookYmlUrl(config, ansibleInfo, url);
                    } else {
                        this.fetchPlaybookArchiveUrl(config, ansibleInfo, url);
                    }
                }
            }
            if (!ansibleInfo.ansibleDir.exists() || !ansibleInfo.ansibleDir.isDirectory()) {
                File parentDir = ansibleInfo.ansibleDir.getParentFile();
                if (parentDir != null && !ansibleInfo.ansibleDir.exists() && parentDir.exists() && parentDir.isDirectory()) {
                    ansibleInfo.ansibleDir.mkdir();
                    if (!ansibleInfo.ansibleDir.exists() || !ansibleInfo.ansibleDir.isDirectory()) {
                        this.errorFatal("The ansible directory \"" + ansibleInfo.ansibleDir.getPath() + "\" does not exist and could be created.");
                    }
                } else {
                    this.errorFatal("The ansible directory \"" + ansibleInfo.ansibleDir.getPath() + "\" does not exist and will not be created because the parent dir doesn't exist either.");
                }
            }
            if (!(ansibleInfo.ansiblePlaybookLocalFile.exists() && ansibleInfo.ansiblePlaybookLocalFile.isFile() && ansibleInfo.ansiblePlaybookLocalFile.canRead())) {
                this.errorFatal("The ansible playbook file \"" + ansibleInfo.ansiblePlaybookLocalFile.getPath() + "\" does not exist (or is not readable)");
            }
            this.note("Preparation for ansible test succesfull");
        }
    }

    private void fetchPlaybookFromGit(AnsibleInfo ansibleInfo, String gitSourceSpec, boolean isGithub, String playbookFileName, String privateKeyPem) {
        GitFetcherCommandBuilder c = (GitFetcherCommandBuilder)GitFetcherCommandBuilder.fromString((String)gitSourceSpec).orElseThrow(() -> new IllegalArgumentException("gitSourceSpec='" + gitSourceSpec + "' is not a valid git source string"));
        c.setTargetDir(GitFetcherCommand.createTempDirectory());
        if (privateKeyPem != null) {
            c.setPrivateKeyPemFile(privateKeyPem);
        }
        String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
        ansibleInfo.ansibleDir = new GitFetcher((GitAuthPreferences)(userPem == null ? null : new SingleSshGitAuthPreferences(userPem))).fetch(c.build());
        ansibleInfo.ansiblePlaybookLocalFile = new File(ansibleInfo.ansibleDir, playbookFileName);
    }

    private void fetchPlaybookArchiveUrl(GuiLogicTestConfig.AnsibleTest config, AnsibleInfo ansibleInfo, URL url) {
        File archiveFile;
        try {
            archiveFile = IOUtils.urlToTmpFile((URL)url);
            File archiveDir = archiveFile.getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch Playbook archive at \"" + config.getPlaybookUrl() + "\"", e);
        }
        try {
            ansibleInfo.ansibleDir = Files.createTempDirectory("ansibleTest", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            this.errorFatal("Could not create temporary dir for ansible files.", e);
        }
        if (config.getPlaybookFileNameInArchive() == null) {
            throw new IllegalStateException("ansible playbook in archive filename should be specified in config");
        }
        ansibleInfo.ansiblePlaybookLocalFile = new File(ansibleInfo.ansibleDir, config.getPlaybookFileNameInArchive());
        boolean foundPlayBook = false;
        try {
            boolean isCompressedArchive;
            ArrayList<ArchiveEntry> archiveEntries = new ArrayList<ArchiveEntry>();
            CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
            ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory();
            try (FileInputStream inputStream = new FileInputStream(archiveFile);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                 CompressorInputStream cis = compressorStreamFactory.createCompressorInputStream((InputStream)bufferedInputStream);){
                isCompressedArchive = true;
            }
            catch (IOException | CompressorException e) {
                isCompressedArchive = false;
            }
            LOG.debug("Archive is " + (isCompressedArchive ? "a" : "NOT a") + " compressed archive");
            ArrayList<String> foundFilenames = new ArrayList<String>();
            try (FileInputStream inputStream = new FileInputStream(archiveFile);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                 ArchiveInputStream archiveInput = isCompressedArchive ? archiveStreamFactory.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)compressorStreamFactory.createCompressorInputStream((InputStream)bufferedInputStream))) : archiveStreamFactory.createArchiveInputStream((InputStream)bufferedInputStream);){
                ArchiveEntry archiveEntry = archiveInput.getNextEntry();
                while (archiveEntry != null) {
                    archiveEntries.add(archiveEntry);
                    foundFilenames.add(archiveEntry.getName());
                    if (archiveEntry.getName().equals(config.getPlaybookFileNameInArchive())) {
                        foundPlayBook = true;
                    }
                    File extractedFile = new File(ansibleInfo.ansibleDir, archiveEntry.getName());
                    if (archiveEntry.isDirectory()) {
                        boolean success = extractedFile.mkdirs();
                        if (!success) {
                            LOG.warn("Failed to create dir to extract to: '" + extractedFile.getAbsolutePath() + "'");
                        }
                    } else {
                        Files.copy((InputStream)archiveInput, extractedFile.toPath(), new CopyOption[0]);
                    }
                    archiveEntry = archiveInput.getNextEntry();
                }
                archiveInput.close();
            }
        }
        catch (IOException | ArchiveException | CompressorException e) {
            throw new RuntimeException("Failed to process Playbook archive at \"" + config.getPlaybookUrl() + "\"", e);
        }
        finally {
            archiveFile.delete();
        }
        if (!foundPlayBook) {
            throw new RuntimeException("Playbook \"" + config.getPlaybookFileNameInArchive() + "\" was not found in archive at \"" + config.getPlaybookUrl() + "\"");
        }
    }

    private void fetchPlaybookYmlUrl(GuiLogicTestConfig.AnsibleTest config, AnsibleInfo ansibleInfo, URL url) {
        try (InputStream is = url.openStream();){
            ansibleInfo.ansiblePlaybookContent = IOUtils.streamToString((InputStream)is, (String)"UTF-8");
            if (ansibleInfo.ansiblePlaybookContent.trim().isEmpty()) {
                this.warn("Empty Playbook read from URL \"" + ansibleInfo.ansiblePlaybookContent + "\"");
            }
            String head = TextUtil.abbreviate((String)ansibleInfo.ansiblePlaybookContent, (int)200);
            this.note("Downloaded Playbook from \"" + config.getPlaybookUrl() + "\". Playbook size: " + ansibleInfo.ansiblePlaybookContent.length() + " characters.\nHead: " + head, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch Playbook at \"" + config.getPlaybookUrl() + "\"", e);
        }
        try {
            ansibleInfo.ansibleDir = Files.createTempDirectory("ansibleTest", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            this.errorFatal("Could not create temporary dir for ansible files.", e);
        }
        ansibleInfo.ansiblePlaybookLocalFile = new File(ansibleInfo.ansibleDir, "playbook.yml");
        try {
            FileWriter fw = new FileWriter(ansibleInfo.ansiblePlaybookLocalFile);
            fw.write(ansibleInfo.ansiblePlaybookContent);
            fw.close();
        }
        catch (IOException e) {
            this.errorFatal("Error writing '" + ansibleInfo.ansiblePlaybookLocalFile.getPath() + "': " + e.getMessage(), e);
        }
    }

    static LogOutput.TestResultState checkAnsibleOutput(String output, ApiTest test, @Nullable String ansibleSuccessWord, @Nullable String ansibleWarningWord, @Nullable String ansibleFailureWord, @Nullable String ansibleSuccessRegex, @Nullable String ansibleWarningRegex, @Nullable String ansibleFailureRegex) {
        if (ansibleFailureWord != null && output.contains(ansibleFailureWord)) {
            test.errorNonFatal("Error: Ansible output contained \"" + ansibleFailureWord + "\"");
            return LogOutput.TestResultState.FAILED;
        }
        if (ansibleFailureRegex != null && Pattern.compile(ansibleFailureRegex).matcher(output).find()) {
            test.errorNonFatal("Error: Ansible output matched regex \"" + ansibleFailureRegex + "\"");
            return LogOutput.TestResultState.FAILED;
        }
        if (ansibleWarningWord != null && output.contains(ansibleWarningWord)) {
            test.warn("Warning: Ansible output contained \"" + ansibleWarningWord + "\"");
            return LogOutput.TestResultState.WARN;
        }
        if (ansibleWarningRegex != null && Pattern.compile(ansibleWarningRegex).matcher(output).find()) {
            test.warn("Warning: Ansible output matched regex \"" + ansibleWarningRegex + "\"");
            return LogOutput.TestResultState.WARN;
        }
        if (ansibleSuccessWord != null && output.contains(ansibleSuccessWord)) {
            test.note("Success: Ansible output contained \"" + ansibleSuccessWord + "\"");
            return LogOutput.TestResultState.SUCCESS;
        }
        if (ansibleSuccessRegex != null && Pattern.compile(ansibleSuccessRegex).matcher(output).find()) {
            test.note("Success: Ansible output matched regex \"" + ansibleSuccessRegex + "\"");
            return LogOutput.TestResultState.SUCCESS;
        }
        if (ansibleSuccessWord != null) {
            if (ansibleSuccessRegex != null) {
                test.errorNonFatal("Error: Ansible output did not contain \"" + ansibleSuccessWord + "\" or match regex \"" + ansibleSuccessRegex + "\"");
                return LogOutput.TestResultState.FAILED;
            }
            test.errorNonFatal("Error: Ansible output did not contain \"" + ansibleSuccessWord + "\"");
            return LogOutput.TestResultState.FAILED;
        }
        test.errorNonFatal("Error: Ansible output did not match regex \"" + ansibleSuccessRegex + "\"");
        return LogOutput.TestResultState.FAILED;
    }

    private void writeAnsibleFiles(AnsibleInfo ansibleInfo, boolean addDebug) throws IOException {
        RspecFactory rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC);
        ResourceInfo resourceInfo = this.resourceInfos.get(0);
        this.assertNotNull(resourceInfo.requestRspecSource, "No Request Rspec for resource 0");
        ModelRspec first = resourceInfo.requestRspecSource.getModelRspec(ModelRspecType.BASIC, new ProgressHandler[0]);
        if (first == null) {
            this.fatalError("Failed to parse request rspec 0");
        }
        ModelRspec mergedRequestRspec = rspecFactory.copyModelRspec(first, "request");
        for (int i = 1; i < this.resourceInfos.size(); ++i) {
            resourceInfo = this.resourceInfos.get(i);
            this.assertNotNull(resourceInfo.requestRspecSource, "No Request Rspec for resource " + i);
            ModelRspec cur = resourceInfo.requestRspecSource.getModelRspec(ModelRspecType.BASIC, new ProgressHandler[0]);
            if (cur == null) {
                this.fatalError("Failed to parse request rspec " + i);
            }
            for (RspecNode node : cur.getNodes()) {
                RspecNode mergedNode = rspecFactory.copyNode(mergedRequestRspec, node, RspecNode.InterfaceCopyMethod.NO_COPY);
                mergedRequestRspec.addNode(mergedNode);
                if (!addDebug) continue;
                this.note("Added node to merged request RSpec: " + node.getClientId());
            }
        }
        String mergedRequestRspecString = mergedRequestRspec.toGeni3Rspec();
        if (addDebug) {
            this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"ansible", "mergedRequestRspec"}).setValue((Object)mergedRequestRspecString).setLarge(true).setHttpMediaTypeToXml());
        }
        AnsibleFileWriter ansibleFileWriter = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(mergedRequestRspecString), (PrivateKey)this.nodeLoginTestStep.getSshKeyHelper().getSshPrivateKey(), (PublicKey)this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKey(), (GeniUser)this.getUser(), null, (String)this.nodeLoginTestStep.getSshUsername());
        for (ResourceInfo curResourceInfo : this.resourceInfos) {
            assert (curResourceInfo.manifestRspecString != null);
            if (curResourceInfo.manifestRspecString == null) continue;
            ansibleFileWriter.addAltBasicStringRspec(curResourceInfo.manifestRspecString);
        }
        ansibleFileWriter.writeFilesToDir(ansibleInfo.ansibleDir);
        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey(new String[]{"ansible", "hostsFile"}).setValue((Object)ansibleFileWriter.getAnsibleHostFileContent()).setLarge(true).setHttpMediaTypeToText());
    }

    private void runAnsibleWatchdog(AtomicBoolean ansibleIsRunning, Process p, StringBuffer output, BufferedReader input, Thread ansibleProcessThread) {
        LOG.info("Ansible watchdog: Ansible exceeded deadline. Starting stop-procedure.");
        output.append(System.lineSeparator()).append(System.lineSeparator()).append("********** TIMEOUT -> KILLING ANSIBLE PROCESS **********").append(System.lineSeparator()).append(System.lineSeparator());
        if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Class<?> cl = p.getClass();
                Field field = cl.getDeclaredField("pid");
                field.setAccessible(true);
                Object pidObject = field.get(p);
                Integer pid = (Integer)pidObject;
                LOG.debug("Found ansible process pid: " + pid);
                LOG.debug("Sending SIGINT to ansible process");
                Process killprocess = Runtime.getRuntime().exec("kill -INT " + pid);
                killprocess.waitFor();
                String killoutput = IOUtils.streamToString((InputStream)killprocess.getInputStream(), (String)"UTF-8") + IOUtils.streamToString((InputStream)killprocess.getErrorStream(), (String)"UTF-8");
                LOG.debug("  kill output: " + killoutput);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ansibleIsRunning.get()) {
                    LOG.info("Ansible watchdog detected that ansible stopped now.");
                    return;
                }
                LOG.debug("Sending SIGTERM to ansible process");
                killprocess = Runtime.getRuntime().exec("kill -TERM " + pid);
                killprocess.waitFor();
                killoutput = IOUtils.streamToString((InputStream)killprocess.getInputStream(), (String)"UTF-8") + IOUtils.streamToString((InputStream)killprocess.getErrorStream(), (String)"UTF-8");
                LOG.debug("  kill output: " + killoutput);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!ansibleIsRunning.get()) {
                    LOG.info("Ansible watchdog detected that ansible stopped now.");
                    return;
                }
                LOG.debug("Sending SIGKILL to ansible process");
                killprocess = Runtime.getRuntime().exec("kill -KILL " + pid);
                killprocess.waitFor();
                killoutput = IOUtils.streamToString((InputStream)killprocess.getInputStream(), (String)"UTF-8") + IOUtils.streamToString((InputStream)killprocess.getErrorStream(), (String)"UTF-8");
                LOG.debug("  kill output: " + killoutput);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception e) {
                LOG.error("Error trying to kill -KILL <PID>. Will ignore and try next method.", (Throwable)e);
            }
        }
        if (!ansibleIsRunning.get()) {
            LOG.debug("Ansible watchdog detected that ansible stopped now.");
            return;
        }
        LOG.debug("Ansible watchdog detected that ansible is still running. Doing another attempt to stop it (kill -KILL <PID>).");
        LOG.debug("Ansible watchdog will try destroy the process (p.destroy();).");
        p.destroy();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!ansibleIsRunning.get()) {
            LOG.info("Ansible watchdog detected that ansible stopped now.");
            return;
        }
        LOG.debug("Ansible watchdog detected that ansible is still running. Trying harder to stop it (p.destroyForcibly()).");
        p.destroyForcibly();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!ansibleIsRunning.get()) {
            LOG.info("Ansible watchdog detected that ansible stopped now.");
            return;
        }
        LOG.debug("Ansible watchdog detected that ansible is still running. final attempt to stop it (ansibleProcessThread.interrupt()).");
        ansibleProcessThread.interrupt();
        try {
            Thread.sleep(100L);
            Thread.yield();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (ansibleIsRunning.get()) {
            ansibleProcessThread.interrupt();
            try {
                Thread.sleep(100L);
                Thread.yield();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (ansibleIsRunning.get()) {
            ansibleProcessThread.interrupt();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!ansibleIsRunning.get()) {
            LOG.info("Ansible watchdog detected that ansible stopped now.");
            return;
        }
        LOG.debug("Ansible watchdog detected that ansible is still running. Doing a desperate attempt to stop it (input.close()). Be aware that this might block the watchdog thread itself...");
        try {
            input.close();
        }
        catch (IOException e) {
            LOG.debug("Ansible watchdog closed ansible process 'input' (= output), and that threw an error", (Throwable)e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!ansibleIsRunning.get()) {
            LOG.info("Ansible watchdog detected that ansible stopped now.");
            return;
        }
        LOG.error("Ansible watchdog detected that ansible is still running. Will give up trying to stop it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callAnsible(@Nonnull GuiLogicTestConfig.AnsibleTest ansibleTestConfig, @Nonnull AnsibleInfo ansibleInfo) {
        Object ansibleVersion;
        Object fileListing;
        ArrayList<String> command = new ArrayList<String>();
        command.add(ansibleInfo.ansiblePlaybookExeName);
        command.add(ansibleInfo.ansiblePlaybookLocalFile.getAbsolutePath());
        if (ansibleTestConfig.getDebug()) {
            command.add("-vvvv");
        }
        try {
            fileListing = Files.walk(ansibleInfo.ansibleDir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            LOG.error("Error listing files in ansible dir (will be safely ignored)", (Throwable)e);
            fileListing = "*** error listing files (" + e.getMessage() + ") ***";
        }
        try {
            String line;
            String[] versionCommand = new String[]{ansibleInfo.ansiblePlaybookExeName, "--version"};
            Process p = Runtime.getRuntime().exec(versionCommand);
            StringBuilder ansibleVersionSB = new StringBuilder();
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = stdoutReader.readLine()) != null) {
                ansibleVersionSB.append(line).append("\n");
            }
            stdoutReader.close();
            ansibleVersion = ansibleVersionSB.toString();
            p.getOutputStream().close();
            p.getErrorStream().close();
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            LOG.error("Error checking ansible version (will be safely ignored)", (Throwable)e);
            ansibleVersion = "*** error checking ansible version (" + e.getMessage() + ") ***";
        }
        this.note("Calling ansible in dir with files: " + (String)fileListing);
        this.note("Using ansible version: " + (String)ansibleVersion);
        this.note("Calling ansible with command: " + String.valueOf(command));
        ExecutorService executor = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(ansibleInfo.ansibleDir);
            pb = pb.redirectErrorStream(true);
            LOG.debug("Starting ansible process");
            Process p = pb.start();
            StringBuffer output = new StringBuffer();
            AtomicBoolean ansibleIsRunning = new AtomicBoolean(true);
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                if (ansibleTestConfig.getTimeoutInSec() > 0) {
                    Thread ansibleProcessThread = Thread.currentThread();
                    executor = Executors.newSingleThreadScheduledExecutor();
                    executor.schedule(() -> this.runAnsibleWatchdog(ansibleIsRunning, p, output, input, ansibleProcessThread), ansibleTestConfig.getTimeoutInSec(), TimeUnit.SECONDS);
                    LOG.debug("Scheduled ansible process watchdog in " + ansibleTestConfig.getTimeoutInSec() + " seconds.");
                } else {
                    executor = null;
                    LOG.debug("no ansible watchdog.");
                }
                try {
                    p.getOutputStream().close();
                }
                catch (IOException e) {
                    LOG.warn("Ansible I/O error trying to close java output stream (= ansible stdin)", (Throwable)e);
                }
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        output.append(line).append(System.lineSeparator());
                    }
                    input.close();
                }
                catch (IOException e) {
                    LOG.warn("Ansible I/O error. Possibly due to watchdog action?", (Throwable)e);
                    output.append(System.lineSeparator()).append(System.lineSeparator()).append("********** ansible I/O error **********").append(System.lineSeparator()).append(System.lineSeparator());
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.warn("Ansible p.waitFor(); InterruptedException. Watchdog must have activated.");
                    output.append(System.lineSeparator()).append(System.lineSeparator()).append("********** EXECUTION INTERRUPTED **********").append(System.lineSeparator()).append(System.lineSeparator());
                }
            }
            finally {
                ansibleIsRunning.set(false);
                LOG.info("Ansible call finished");
                if (executor != null) {
                    LOG.debug("Stopping any waiting ansible watchdog.");
                    executor.shutdownNow();
                }
            }
            return output.toString();
        }
        catch (Exception e) {
            this.fatalError("Error trying to call ansible with command: " + String.valueOf(command), e);
            return null;
        }
    }

    private class ResourceInfo
    extends ExperimentSetupContext {
        private final int index;
        @NotNull
        private final GuiLogicTestConfig.Resource config;
        private ExperimentSetupHelper experimentSetupHelper;
        private ESpecLogToTestMethodResult eSpecLogHandler;
        private LinkTestResultToTest linkTestResultToTest;
        public boolean atLeastOneFailingAnsibleRun = false;

        public ResourceInfo(@NotNull int index, GuiLogicTestConfig.Resource config) {
            this.index = index;
            this.config = config;
        }

        public boolean isWaitForExperimentOver() {
            return this.waitForExperimentIsOver;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isNotEnoughResourcesDetected() {
            return this.notEnoughResourcesDetected;
        }

        public boolean isAtLeastOneFailingAnsibleRun() {
            return this.atLeastOneFailingAnsibleRun;
        }
    }

    private class LinkTestResultToTest
    implements LinkTestListener {
        @Nonnull
        private final String index;
        @Nonnull
        private final ResourceInfo resourceInfo;

        private LinkTestResultToTest(ResourceInfo resourceInfo) {
            this.index = "" + resourceInfo.index;
            this.resourceInfo = resourceInfo;
        }

        public void onReport(@Nonnull TestLinksJob.LinkTestReport report) {
        }

        public void onAllReports(@Nonnull List<TestLinksJob.LinkTestReport> reports, @Nonnull TestLinksJob.LinkTestResult worstResult) {
            String reportsAsString = reports.stream().map(TestLinksJob.LinkTestReport::toStringNoSuccessDebug).collect(Collectors.joining(" \n   "));
            if (worstResult == TestLinksJob.LinkTestResult.SUCCESS) {
                GuiLogicTest.this.note("Link test successfull for resource " + this.index + ": \n   " + reportsAsString, true);
            } else {
                GuiLogicTest.this.errorNonFatal("Link test failed for resource " + this.index + ": \n   " + reportsAsString, true);
            }
        }
    }

    private static class ESpecAnsibleRunInfo {
        @Nonnull
        private ResourceInfo resourceInfo;
        @Nonnull
        private AnsiblePlaybookSpec ansiblePlaybookSpec;
        @Nonnull
        private String fullPath;
        @Nullable
        private String fullLogPath;
        @Nonnull
        private String nodeClientId;
        @Nonnull
        private ESpecLogListener.ESpecStepStatus status;

        public ESpecAnsibleRunInfo(@Nonnull ResourceInfo resourceInfo, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.resourceInfo = resourceInfo;
            this.ansiblePlaybookSpec = ansiblePlaybookSpec;
            this.fullPath = fullPath;
            this.fullLogPath = fullLogPath;
            this.nodeClientId = nodeClientId;
            this.status = status;
        }

        @Nonnull
        public AnsiblePlaybookSpec getAnsiblePlaybookSpec() {
            return this.ansiblePlaybookSpec;
        }

        @Nonnull
        public String getFullPath() {
            return this.fullPath;
        }

        @Nullable
        public String getFullLogPath() {
            return this.fullLogPath;
        }

        @Nonnull
        public String getNodeClientId() {
            return this.nodeClientId;
        }

        @Nonnull
        public ESpecLogListener.ESpecStepStatus getStatus() {
            return this.status;
        }

        public boolean isSuccess() {
            return this.status.isSuccess();
        }
    }

    private class AnsibleInfo {
        private final GuiLogicTestConfig.AnsibleTest ansibleTestConfig;
        private File ansibleDir;
        private File ansiblePlaybookLocalFile;
        private String ansiblePlaybookExeName;
        private String ansiblePlaybookContent;

        public AnsibleInfo(GuiLogicTestConfig.AnsibleTest ansibleTestConfig) {
            this.ansibleTestConfig = ansibleTestConfig;
        }
    }

    private class ESpecLogToTest
    implements ESpecLogListener {
        @Nonnull
        private final String index;
        @Nonnull
        private final ResourceInfo resourceInfo;

        private ESpecLogToTest(ResourceInfo resourceInfo) {
            this.index = "" + resourceInfo.index;
            this.resourceInfo = resourceInfo;
        }

        public void onPreFileLoad() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start loading files.");
        }

        public void onPostFileLoad(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to load file \"" + fileSource.getBasename() + "\"", status.getThrowable());
            } else if (!isFast) {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully loaded file \"" + fileSource.getBasename() + "\" (" + byteSize + " byte)");
            }
        }

        public void onPostFileLoadAll(boolean success) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to load all files.");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully finished loading files.");
            }
        }

        public void onPreRSpec() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start Provisioning RSpec.");
        }

        public void onRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRspec) {
            if (this.resourceInfo.requestRspec == null) {
                this.resourceInfo.requestRspec = requestRspec;
            }
        }

        public void onPostRSpec(@Nonnull RspecSpec rspec, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                GuiLogicTest.this.errorNonFatal("Failed setting up experiment resources", status.getThrowable());
            }
        }

        public void onPostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to Provision RSpec");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully Provisioned RSpec with nodes " + allNodeClientIds.stream().collect(Collectors.joining()));
            }
        }

        public void onPreDir() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start dir setup.");
        }

        public void onPreDirNode(@Nonnull String nodeClientId) {
        }

        public void onPreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        }

        public void onPostDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Failed to setup dir at \"" + fullPath + "\"", status.getThrowable());
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Successfully setup dir at \"" + fullPath + "\"");
            }
        }

        public void onPostDirNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostDirAll(boolean success) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to setup dirs");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully setup dirs");
            }
        }

        public void onPreUpload() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start upload(s).");
        }

        public void onPreUploadNode(@Nonnull String nodeClientId) {
        }

        public void onPreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull UploadProgressTracker uploadProgressTracker) {
        }

        public void onPostUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Failed to upload file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Successfully uploaded file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
            }
        }

        public void onPostUploadNode(@Nonnull String nodeClientId, boolean success) {
        }

        public void onPostUploadAll(boolean success) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to upload at least one file to one node");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully uploaded files");
            }
        }

        public void onPreExecute() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start execute(s).");
        }

        public void onPreExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        }

        public void onPostExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            if (status.isFailure()) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Failed to execute script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus, status.getThrowable());
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Successfully executed script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus);
            }
        }

        public void onPostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to execute script \"" + executeSpec.getDesc() + "\" on at least one node");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully executed script \"" + executeSpec.getDesc() + "\" on all nodes");
            }
        }

        public void onPostExecuteAll(boolean success) {
            if (!success) {
                GuiLogicTest.this.errorNonFatal("ExperimentSpecification " + this.index + ": Failed to execute at least one script on at least one node");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully executed all scripts");
            }
        }

        public void onPreAnsible() {
            GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Start ansible(s).");
        }

        public void onPreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        }

        public void onPostAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
            ESpecAnsibleRunInfo info = new ESpecAnsibleRunInfo(this.resourceInfo, ansiblePlaybookSpec, fullPath, fullLogPath, nodeClientId, status);
            GuiLogicTest.this.eSpecAnsibleRunInfos.add(info);
            if (status.isFailure()) {
                this.resourceInfo.atLeastOneFailingAnsibleRun = true;
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Failed to execute ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"", status.getThrowable());
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": (on \"" + nodeClientId + "\") Successfully executed ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"");
            }
        }

        public void onPostAnsibleAll(boolean success) {
            if (!success) {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Failed to ansible at least one script on at least one node");
            } else {
                GuiLogicTest.this.note("ExperimentSpecification " + this.index + ": Successfully ansibled all scripts");
            }
        }
    }
}

