/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsConstants;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class SerializableApiCallDetailsWriter {
    public static void writeApiCallDetails(SerializableApiCallDetails apiCallDetails, XMLEventWriter xtw, XMLEventFactory eventFactory) throws XMLStreamException {
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CALL, null, null));
        xtw.add(eventFactory.createAttribute(SerializableApiCallDetailsConstants.Q_CALL_ID, Integer.toString(apiCallDetails.getId())));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_AUTHORITY_NAME, null, null));
        xtw.add(eventFactory.createCharacters(apiCallDetails.getAuthorityName()));
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_AUTHORITY_NAME, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_AUTHORITY_URN, null, null));
        xtw.add(eventFactory.createCharacters(apiCallDetails.getAuthorityUrn()));
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_AUTHORITY_URN, null));
        if (apiCallDetails.getBaseServerUrl() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_BASE_SERVER_URL, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getBaseServerUrl()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_BASE_SERVER_URL, null));
        }
        if (apiCallDetails.getCallServerUrl() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CALL_SERVER_URL, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getCallServerUrl()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CALL_SERVER_URL, null));
        }
        if (apiCallDetails.getProxyInfo() != null) {
            JFedConnection.ProxyInfo proxyInfo = apiCallDetails.getProxyInfo();
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_PROXY_INFO, null, null));
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HOSTNAME, null, null));
            xtw.add(eventFactory.createCharacters(proxyInfo.getHostname()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HOSTNAME, null));
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_PORT, null, null));
            xtw.add(eventFactory.createCharacters(Integer.toString(proxyInfo.getPort())));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_PORT, null));
            if (proxyInfo instanceof JFedConnection.SshProxyInfo) {
                JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)proxyInfo;
                xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_USERNAME, null, null));
                xtw.add(eventFactory.createCharacters(sshProxyInfo.getUsername()));
                xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_USERNAME, null));
                xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HOST_KEY, null, null));
                xtw.add(eventFactory.createCharacters(sshProxyInfo.getHostKey()));
                xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HOST_KEY, null));
            }
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_PROXY_INFO, null));
        }
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_USER_URN, null, null));
        if (apiCallDetails.getConnectionSslAuthUserUrn() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionSslAuthUserUrn()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_USER_URN, null));
        if (apiCallDetails.getConnectionBasicHttpAuthUsername() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_HTTP_BASIC_AUTHENTICATION_USERNAME, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionBasicHttpAuthUsername()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_HTTP_BASIC_AUTHENTICATION_USERNAME, null));
        }
        if (apiCallDetails.getConnectionType() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_AUTH_METHOD, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionAuthenticationMethod()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_AUTH_METHOD, null));
        }
        if (apiCallDetails.getConnectionType() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_PROTOCOL, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionProtocol()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_PROTOCOL, null));
        }
        if (apiCallDetails.getConnectionType() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_TYPE, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionType()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_TYPE, null));
        }
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_ID, null, null));
        if (apiCallDetails.getConnectionId() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionId()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_ID, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_CONNECTION_USER_CERTS, null, null));
        if (apiCallDetails.getConnectionSslAuthUserCertificates() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getConnectionSslAuthUserCertificates()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CONNECTION_USER_CERTS, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_LINE, null, null));
        if (apiCallDetails.getHttpRequestStatusLine() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpRequestStatusLine()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_LINE, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_HEADERS, null, null));
        if (apiCallDetails.getHttpRequestHeaders() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpRequestHeaders()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_HEADERS, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST, null, null));
        if (apiCallDetails.getHttpRequest() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpRequest()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_REQUEST, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_STATUS_LINE, null, null));
        if (apiCallDetails.getHttpResponseStatusLine() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpResponseStatusLine()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_STATUS_LINE, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_RESPONSE_HEADERS, null, null));
        if (apiCallDetails.getHttpResponseStatusLine() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpResponseStatusLine()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_RESPONSE_HEADERS, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_HTTP_REPLY, null, null));
        if (apiCallDetails.getHttpResponse() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getHttpResponse()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_HTTP_REPLY, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_API_NAME, null, null));
        if (apiCallDetails.getApiName() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getApiName()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_API_NAME, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_JAVA_METHOD_NAME, null, null));
        if (apiCallDetails.getJavaMethodName() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getJavaMethodName()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_JAVA_METHOD_NAME, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_METHOD_NAME, null, null));
        if (apiCallDetails.getGeniMethodName() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getGeniMethodName()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_METHOD_NAME, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_XMLRPC_REQUEST, null, null));
        if (apiCallDetails.getXmlRpcRequestJsonString() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getXmlRpcRequestJsonString()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_XMLRPC_REQUEST, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_XMLRPC_REPLY, null, null));
        if (apiCallDetails.getXmlRpcResponseJsonString() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getXmlRpcResponseJsonString()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_XMLRPC_REPLY, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_VALUE, null, null));
        if (apiCallDetails.getXmlRpcGeniResponseValue() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getXmlRpcGeniResponseValue()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_VALUE, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_OUTPUT, null, null));
        if (apiCallDetails.getXmlRpcGeniResponseOutput() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getXmlRpcGeniResponseOutput()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_OUTPUT, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_CODE, null, null));
        if (apiCallDetails.getXmlRpcGeniResponseCode() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getXmlRpcGeniResponseCode()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_CODE, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE, null, null));
        if (apiCallDetails.getGeniResponseCode() != null) {
            xtw.add(eventFactory.createCharacters(Integer.toString(apiCallDetails.getGeniResponseCode())));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE_DESCRIPTION, null, null));
        if (apiCallDetails.getGeniResponseCodeDescription() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getGeniResponseCodeDescription()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE_DESCRIPTION, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_CODE_IS_SUCCESS, null, null));
        if (apiCallDetails.getGeniResponseCodeIsSuccess() != null) {
            xtw.add(eventFactory.createCharacters(Boolean.toString(apiCallDetails.getGeniResponseCodeIsSuccess())));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_CODE_IS_SUCCESS, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_OUTPUT, null, null));
        if (apiCallDetails.getGeniResponseOutput() != null) {
            xtw.add(eventFactory.createCharacters(apiCallDetails.getGeniResponseOutput()));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_OUTPUT, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_START_TIME, null, null));
        if (apiCallDetails.getStartTime() != null) {
            xtw.add(eventFactory.createCharacters(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(apiCallDetails.getStartTime().toInstant(), ZoneId.systemDefault()))));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_START_TIME, null));
        xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_END_TIME, null, null));
        if (apiCallDetails.getStopTime() != null) {
            xtw.add(eventFactory.createCharacters(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(apiCallDetails.getStopTime().toInstant(), ZoneId.systemDefault()))));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_END_TIME, null));
        if (apiCallDetails.getProtogeniSpewLogUrl() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_PROTOGENI_SPEW_LOG_URL, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getProtogeniSpewLogUrl()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_PROTOGENI_SPEW_LOG_URL, null));
        }
        if (apiCallDetails.getExceptionString() != null) {
            xtw.add(eventFactory.createStartElement(SerializableApiCallDetailsConstants.Q_EXCEPTION, null, null));
            xtw.add(eventFactory.createCharacters(apiCallDetails.getExceptionString()));
            xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_EXCEPTION, null));
        }
        xtw.add(eventFactory.createEndElement(SerializableApiCallDetailsConstants.Q_CALL, null));
    }
}

