/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicAnsibleService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicIPv4;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicLease;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicOpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.parser.EventListExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.SliverTypeShaping;
import be.iminds.ilabt.jfed.rspec_fx.StaxRspecFxParser;
import be.iminds.ilabt.jfed.rspec_fx.StaxRspecFxWriter;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXExecuteService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXInstallService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRspecFactory
implements RspecFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FXRspecFactory.class);
    private static final FXRspecFactory INSTANCE = new FXRspecFactory();
    private final StaxRspecFxParser fxParser = StaxRspecFxParser.getInstance();
    private final StaxRspecFxWriter fxWriter = StaxRspecFxWriter.getInstance();

    private FXRspecFactory() {
    }

    public static FXRspecFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public ModelRspecType getModelRspecType() {
        return ModelRspecType.FX;
    }

    @Nonnull
    public FXRspecNode createNode(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec == null || modelRspec instanceof FXModelRspec);
        return new FXRspecNode((FXModelRspec)modelRspec, null);
    }

    @Nonnull
    public FXRspecNode createNodeWithClientId(@Nonnull ModelRspec modelRspec, @Nullable String id) {
        assert (modelRspec == null || modelRspec instanceof FXModelRspec);
        return new FXRspecNode((FXModelRspec)modelRspec, id);
    }

    @Nonnull
    public FXRspecNode copyNode(@Nonnull ModelRspec newModelRspec, @Nonnull RspecNode rspecNode, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        assert (rspecNode instanceof FXRspecNode);
        assert (newModelRspec instanceof FXModelRspec);
        return new FXRspecNode((FXModelRspec)newModelRspec, rspecNode, interfaceCopyMethod);
    }

    @Nonnull
    public FXRspecNode copyNodeIncludingInterfaces(@Nonnull ModelRspec newModelRspec, @Nonnull RspecNode rspecNode) {
        assert (rspecNode instanceof FXRspecNode);
        assert (newModelRspec instanceof FXModelRspec);
        return new FXRspecNode((FXModelRspec)newModelRspec, rspecNode, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
    }

    @Nonnull
    public RspecNode convertToSpecialNode(@Nonnull RspecNode origNode) throws RspecParseException {
        boolean isDelayBridge;
        assert (origNode != null);
        assert (origNode instanceof FXRspecNode);
        EventListExtraXml delayShapingXml = null;
        if (origNode.getSliverTypes().size() == 1) {
            for (ExtraXml extraXml : ((SliverType)origNode.getSliverTypes().get(0)).getExtraXml()) {
                if (!Objects.equals(RspecXmlConstants.Q_SLIVER_TYPE_SHAPING, extraXml.getStartElementName())) continue;
                assert (delayShapingXml == null);
                assert (extraXml instanceof EventListExtraXml);
                delayShapingXml = (EventListExtraXml)extraXml;
            }
        }
        boolean bl = isDelayBridge = origNode.getSliverTypes().size() == 1 && Objects.equals(((SliverType)origNode.getSliverTypes().get(0)).getName(), "delay");
        if (isDelayBridge) {
            SliverType origSliverType = (SliverType)origNode.getSliverTypes().get(0);
            ArrayList sliverTypeExtraXml = new ArrayList(origSliverType.getExtraXml());
            sliverTypeExtraXml.remove(delayShapingXml);
            SliverType newSliverType = new SliverTypeBuilder(origSliverType.getName()).setDiskImages((Collection)origSliverType.getDiskImages()).setExtraXml(sliverTypeExtraXml).build();
            origNode.getSliverTypes().set(0, newSliverType);
            DelayRspecNode res = new DelayRspecNode((FXModelRspec)origNode.getRspec(), (FXRspecNode)origNode, RspecNode.InterfaceCopyMethod.STEAL_INTERFACE);
            if (delayShapingXml != null) {
                SliverTypeShaping sliverTypeShaping = this.fxParser.parseSliverTypeShaping(delayShapingXml.getLocation(), delayShapingXml.getAsEventReader());
                res.setPropertiesFromSliverTypeShaping(sliverTypeShaping);
            }
            return res;
        }
        return origNode;
    }

    @Nonnull
    public FXRspecLink createLink(@Nonnull ModelRspec rspec, @Nullable String addDefaultLinkType) {
        assert (rspec instanceof FXModelRspec);
        return new FXRspecLink((FXModelRspec)rspec, null, addDefaultLinkType);
    }

    @Nonnull
    public FXRspecLink createLinkWithClientId(@Nonnull ModelRspec rspec, @Nonnull String id, @Nullable String addDefaultLinkType) {
        assert (rspec instanceof FXModelRspec);
        return new FXRspecLink((FXModelRspec)rspec, id, addDefaultLinkType);
    }

    @Nonnull
    public FXRspecLink copyLink(@Nonnull ModelRspec newModelRspec, @Nonnull RspecLink rspecLink, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        assert (newModelRspec instanceof FXModelRspec);
        return new FXRspecLink((FXModelRspec)newModelRspec, rspecLink, interfaceCopyMethod);
    }

    @Nonnull
    public FXRspecInterface createInterface(@Nonnull RspecNode node, @Nullable String id) {
        assert (node instanceof FXRspecNode);
        return new FXRspecInterface((FXRspecNode)node, id);
    }

    @Nonnull
    public FXRspecInterface createInterface(@Nonnull RspecLink link, @Nullable String id) {
        assert (link instanceof FXRspecLink);
        return new FXRspecInterface((FXRspecLink)link, id);
    }

    @Nonnull
    public FXRspecInterface createInterface(@Nonnull RspecNode node, @Nonnull RspecLink link, @Nullable String id) {
        assert (node instanceof FXRspecNode);
        assert (link instanceof FXRspecLink);
        return new FXRspecInterface((FXRspecNode)node, (FXRspecLink)link, id);
    }

    @Nonnull
    public FXRspecInterface createInterface(@Nonnull RspecNode node, @Nonnull RspecLink link) {
        assert (node instanceof FXRspecNode);
        assert (link instanceof FXRspecLink);
        assert (node.getRspec() == link.getRspec());
        assert (node.getRspec() instanceof FXModelRspec);
        String newClientId = node.getRspec().nextIfaceName(node);
        return new FXRspecInterface((FXRspecNode)node, (FXRspecLink)link, newClientId);
    }

    @Nonnull
    public FXLinkSetting createLinkSetting(@Nonnull RspecInterface fromIface, @Nonnull RspecInterface toIface) {
        assert (fromIface instanceof FXRspecInterface);
        assert (toIface instanceof FXRspecInterface);
        return new FXLinkSetting((FXRspecInterface)fromIface, (FXRspecInterface)toIface);
    }

    @Nonnull
    public ExecuteService createExecuteService(@Nullable String shell, @Nullable String command) {
        return new FXExecuteService(shell, command);
    }

    @Nonnull
    public InstallService createInstallService(@Nullable String installPath, @Nullable String url) {
        return new FXInstallService(installPath, url);
    }

    @Nonnull
    public AnsibleService createAnsibleService() {
        return new BasicAnsibleService();
    }

    @Nonnull
    public FXModelRspec createModelRspec(@Nullable String rspecType) {
        return new FXModelRspec(rspecType);
    }

    @Nonnull
    public FXModelRspec copyModelRspec(@Nonnull ModelRspec orig, @Nullable String newType) {
        FXModelRspec res = this.createModelRspec(newType == null ? orig.getType() : newType);
        res.setParseData(orig.getSchemaLocation(), orig.getOrigDefaultNamespace(), orig.getNameSpaceInfo());
        for (RspecNode n : orig.getNodes()) {
            res.addNode(new FXRspecNode(res, n, RspecNode.InterfaceCopyMethod.NO_COPY));
        }
        res.setHardwareTypeInfo(orig.getHardwareTypeInfo());
        for (RspecNode n : orig.getNodes()) {
            FXRspecNode copiedNode = res.getNodeByUniqueId(n.getUniqueId());
            assert (copiedNode != null);
            if (copiedNode == null) continue;
            for (RspecInterface iface : n.getInterfaces()) {
                if (iface.isLinkBound()) continue;
                FXRspecInterface ifaceCopy = new FXRspecInterface(copiedNode, iface.getClientId());
                ifaceCopy.overwritePropertiesWith(iface, true);
            }
        }
        for (RspecLink l : orig.getLinks()) {
            FXRspecLink newLink = new FXRspecLink(res, l, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
            res.addLink(newLink);
            for (RspecInterface i : l.getInterfaces()) {
                FXRspecInterface newIface = newLink.getInterfaceByClientId(i.getClientId());
                assert (newIface != null);
                if (newIface == null) continue;
                if (i.isNodeBound()) {
                    FXRspecNode newNode = res.getNodeByUniqueId(i.getNode().getUniqueId());
                    assert (newNode != null);
                    newIface.bindNode(newNode);
                }
                newIface.overwritePropertiesWith(i, true);
            }
        }
        for (OpenflowDataPath odp : orig.getOpenflowDataPaths()) {
            BasicOpenflowDataPath newOdp = new BasicOpenflowDataPath(odp.getAsExtraXml(), odp.getComponentManagerId(), odp.getComponentId(), odp.getDpid());
            res.addOpenflowDataPath((OpenflowDataPath)newOdp);
        }
        for (RspecLink l : orig.getLeases()) {
            res.addLease((Lease)new BasicLease((Lease)l));
        }
        for (Channel channel : orig.getChannels()) {
            res.addChannel(new FXRspecChannel(channel));
        }
        for (AddressPool addressPool : orig.getAddressPools()) {
            res.addAddressPool(new FXAddressPool(addressPool));
        }
        res.setExtraXml(new ArrayList<ExtraXml>(orig.getExtraXml()));
        ArrayList<UserSpec> userSpecCopy = new ArrayList<UserSpec>();
        for (UserSpec u : orig.getSshKeys()) {
            userSpecCopy.add(new UserSpec(u));
        }
        res.setSshKeys(userSpecCopy);
        res.setExpires(orig.getExpiresString());
        res.getDiskImageLists().addAll(orig.getDiskImageLists());
        res.getFlavorLists().addAll(orig.getFlavorLists());
        res.setRoutableAddressesAvailable(orig.getRoutableAddressesAvailable());
        res.setRoutableAddressesConfigured(orig.getRoutableAddressesConfigured());
        orig.getExecuteAnsiblePlaybooks().forEach(res::addExecuteAnsiblePlaybook);
        return res;
    }

    public boolean processExtraLinkXml(@Nonnull RspecLink link, @Nonnull EventListExtraXml extraXml) throws RspecParseException {
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof FXRspecFactory;
    }

    public int hashCode() {
        return FXRspecFactory.class.hashCode();
    }

    public void mergeExtra(@Nonnull ModelRspec aMergedModel, @Nonnull ModelRspec aPartialRspec) {
        FXModelRspec mergedModel = (FXModelRspec)aMergedModel;
        FXModelRspec partialRspec = (FXModelRspec)aPartialRspec;
        partialRspec.getChannels().forEach(mergedModel::addChannel);
        partialRspec.getLeases().forEach(mergedModel::addLease);
    }

    @Nonnull
    public OpenflowDataPath createOpenflowDataPath(@Nonnull ModelRspec modelRspec, @Nonnull EventListExtraXml allXml, @Nullable String componentManagerId, @Nullable String componentId, @Nullable String dpidAttValue) {
        assert (modelRspec instanceof FXModelRspec);
        return new BasicOpenflowDataPath((ExtraXml)allXml, componentManagerId, componentId, dpidAttValue);
    }

    @Nonnull
    public Lease createLease(@Nonnull ModelRspec rspec, @Nullable String leaseId, @Nullable String clientId, @Nullable Date validFromDate, @Nullable Date validUntilDate, @Nullable String validFromString, @Nullable String validUntilString) {
        assert (rspec instanceof FXModelRspec);
        return new BasicLease(leaseId, clientId, validFromDate, validUntilDate, validFromString, validUntilString);
    }

    @Nonnull
    public Lease createLease(@Nonnull ModelRspec rspec, @Nullable String leaseId, @Nullable String clientId, @Nullable Date validFromDate, @Nullable Date validUntilDate) {
        assert (rspec instanceof FXModelRspec);
        return new BasicLease(leaseId, clientId, validFromDate, validUntilDate);
    }

    @Nonnull
    public Channel createChannel(@Nonnull ModelRspec modelRspec) {
        return new FXRspecChannel();
    }

    @Nonnull
    public AddressPool createAddressPool(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec instanceof FXModelRspec);
        return new FXAddressPool();
    }

    @Nonnull
    public AddressPool copyAddressPool(@Nonnull ModelRspec modelRspec, @Nonnull AddressPool addressPool) {
        assert (modelRspec instanceof FXModelRspec);
        return new FXAddressPool(addressPool);
    }

    @Nonnull
    public IPv4 createIPv4(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec instanceof FXModelRspec);
        return new BasicIPv4();
    }

    @Nonnull
    public IPv4 createIPv4(@Nonnull ModelRspec modelRspec, @Nullable String address, @Nullable String netmask) {
        assert (modelRspec instanceof FXModelRspec);
        return new BasicIPv4(address, netmask);
    }

    @Nonnull
    public ExecuteAnsiblePlaybook createExecuteAnsibleCookbook(@Nonnull ModelRspec rspec, @Nullable String source, @Nullable String outputFilename) {
        return new BasicExecuteAnsiblePlaybook(source, outputFilename);
    }

    @Nonnull
    public DistributeSshKeypair createDistributeSshKeypair(@Nonnull ModelRspec rspec, @Nullable String location, @Nullable GeniUrn userUrn) {
        return new BasicDistributeSshKeypair(location, userUrn);
    }

    @Nonnull
    public WebVncService createWebVncService(String providerId, String vncUrl, String username, String password) {
        return new WebVncService(providerId, vncUrl, username, password);
    }
}

