/*
 * Decompiled with CFR 0.152.
 */
package de.saring.leafletmap;

import de.saring.leafletmap.LatLong;
import de.saring.leafletmap.LeafletMapView;
import de.saring.leafletmap.MapConfig;
import de.saring.leafletmap.MapLayer;
import de.saring.leafletmap.Marker;
import de.saring.leafletmap.MarkerClusterGroup;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import netscape.javascript.JSObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 42\u00020\u0001:\u000245B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\bJ\u0014\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0007H\u0004J\u0010\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010)\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\bJ\u0016\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u001eJ\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u000e\u0010/\u001a\u00020 2\u0006\u0010,\u001a\u00020\u001eJ\u000e\u00100\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u00100\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0007J\u0016\u00101\u001a\u00020 2\u0006\u0010,\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u000bJ\u000e\u00103\u001a\u00020 2\u0006\u00102\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lde/saring/leafletmap/LeafletMapView;", "Ljavafx/scene/layout/StackPane;", "()V", "DEBUG", "", "clusterById", "", "", "Lde/saring/leafletmap/MarkerClusterGroup;", "clusterIds", "clusterMarkerNameSuffix", "", "clusterNameSuffix", "jsBridge", "Lde/saring/leafletmap/LeafletMapView$JSBridge;", "markerById", "Lde/saring/leafletmap/Marker;", "markerIds", "varNameSuffix", "webEngine", "Ljavafx/scene/web/WebEngine;", "webView", "Ljavafx/scene/web/WebView;", "addMarker", "marker", "addMarkerClusterGroup", "markerClusterGroup", "addTrack", "positions", "", "Lde/saring/leafletmap/LatLong;", "clearMarkersAndTracks", "", "displayMap", "Ljava/util/concurrent/CompletableFuture;", "Ljavafx/concurrent/Worker$State;", "mapConfig", "Lde/saring/leafletmap/MapConfig;", "execScript", "script", "executeMapSetupScripts", "fitBoundsOfMarkerClusterGroup", "moveMarker", "markerName", "position", "onMarkerClick", "id", "panTo", "removeMarker", "setView", "zoomLevel", "setZoom", "Companion", "JSBridge", "leafletmap"})
public final class LeafletMapView
extends StackPane {
    private final boolean DEBUG = false;
    private final WebView webView = new WebView();
    private final WebEngine webEngine;
    private int varNameSuffix;
    private int clusterNameSuffix;
    private int clusterMarkerNameSuffix;
    private JSBridge jsBridge;
    private final Map<String, Marker> markerById;
    private final Map<Marker, String> markerIds;
    private final Map<String, MarkerClusterGroup> clusterById;
    private final Map<MarkerClusterGroup, String> clusterIds;
    @NotNull
    private static final EventType<Event> JS_CLICK_EVENTTYPE;
    public static final Companion Companion;

    @NotNull
    public final CompletableFuture<Worker.State> displayMap(@NotNull MapConfig mapConfig) {
        Intrinsics.checkParameterIsNotNull((Object)mapConfig, (String)"mapConfig");
        CompletableFuture<Worker.State> finalMapLoadState = new CompletableFuture<Worker.State>();
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(this, mapConfig, finalMapLoadState){
            final /* synthetic */ LeafletMapView this$0;
            final /* synthetic */ MapConfig $mapConfig;
            final /* synthetic */ CompletableFuture $finalMapLoadState;

            public final void changed(ObservableValue<? extends Worker.State> $noName_0, Worker.State $noName_1, Worker.State newValue) {
                if (newValue == Worker.State.SUCCEEDED) {
                    LeafletMapView.access$executeMapSetupScripts(this.this$0, this.$mapConfig);
                }
                if (newValue == Worker.State.SUCCEEDED || newValue == Worker.State.FAILED) {
                    this.$finalMapLoadState.complete(newValue);
                }
            }
            {
                this.this$0 = leafletMapView;
                this.$mapConfig = mapConfig;
                this.$finalMapLoadState = completableFuture;
            }
        });
        this.webEngine.setOnError((EventHandler)displayMap.2.INSTANCE);
        this.webEngine.setOnAlert((EventHandler)displayMap.3.INSTANCE);
        URL uRL = LeafletMapView.class.getResource("/leafletmap/leafletmap.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"LeafletMapView::class.ja\u2026fletmap/leafletmap.html\")");
        URL localFileUrl = uRL;
        this.webEngine.load(localFileUrl.toExternalForm());
        return finalMapLoadState;
    }

    /*
     * WARNING - void declaration
     */
    private final void executeMapSetupScripts(MapConfig mapConfig) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = mapConfig.getLayers();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void layer;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            MapLayer mapLayer = (MapLayer)((Object)item$iv);
            int i = n2;
            boolean bl = false;
            this.execScript("var layer" + (i + 1) + " = " + layer.getJavaScriptCode() + ';');
        }
        Iterable $receiver$iv2 = mapConfig.getLayers();
        Iterable iterable = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void i;
            void layer;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n;
            MapLayer mapLayer = (MapLayer)((Object)item$iv$iv);
            int n4 = n3;
            Collection collection2 = collection;
            boolean bl = false;
            String string = '\'' + layer.getDisplayName() + "': layer" + (int)(i + true);
            collection2.add(string);
        }
        String jsLayers = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        this.execScript("var baseMaps = { " + jsLayers + " };");
        this.execScript(StringsKt.trimMargin$default((String)("\n                |var myMap = L.map('map', {\n                |    center: new L.LatLng(" + mapConfig.getInitialCenter().getLatitude() + ", " + mapConfig.getInitialCenter().getLongitude() + "),\n                |    zoom: 8,\n                |    zoomControl: false,\n                |    layers: [layer1]\n                |});\n                |\n                |var attribution = myMap.attributionControl;\n                |attribution.setPrefix('Leaflet');"), null, (int)1, null));
        if (mapConfig.getLayers().size() > 1) {
            this.execScript(StringsKt.trimMargin$default((String)"\n                    |var overlayMaps = {};\n                    |L.control.layers(baseMaps, overlayMaps).addTo(myMap);", null, (int)1, null));
        }
        if (mapConfig.getScaleControlConfig().getShow()) {
            this.execScript("L.control.scale({position: '" + mapConfig.getScaleControlConfig().getPosition().getPositionName() + "', " + "metric: " + mapConfig.getScaleControlConfig().getMetric() + ", " + "imperial: " + !mapConfig.getScaleControlConfig().getMetric() + "})" + ".addTo(myMap);");
        }
        if (mapConfig.getZoomControlConfig().getShow()) {
            this.execScript("L.control.zoom({position: '" + mapConfig.getZoomControlConfig().getPosition().getPositionName() + "'})" + ".addTo(myMap);");
        }
        Object object = this.webEngine.executeScript("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type netscape.javascript.JSObject");
        }
        JSObject jsObj = (JSObject)object;
        jsObj.setMember("jsBridge", this.jsBridge);
    }

    public final void setView(@NotNull LatLong position, int zoomLevel) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.execScript("myMap.setView([" + position.getLatitude() + ", " + position.getLongitude() + "], " + zoomLevel + ");");
    }

    public final void panTo(@NotNull LatLong position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.execScript("myMap.panTo([" + position.getLatitude() + ", " + position.getLongitude() + "]);");
    }

    public final void setZoom(int zoomLevel) {
        this.execScript("myMap.setZoom([" + zoomLevel + "]);");
    }

    @NotNull
    public final String addMarker(@NotNull Marker marker) {
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        int n = this.varNameSuffix;
        this.varNameSuffix = n + 1;
        String varName = "marker" + n;
        this.markerIds.put(marker, varName);
        this.markerById.put(varName, marker);
        this.execScript("var " + varName + " = L.marker([" + marker.getPosition().getLatitude() + ", " + marker.getPosition().getLongitude() + "], " + "{title: '" + marker + ".title', icon: " + marker.getMarkerIcon().getIconName() + ", zIndexOffset: " + marker + ".zIndexOffset})" + ".addTo(myMap);");
        return varName;
    }

    public final void moveMarker(@NotNull String markerName, @NotNull LatLong position) {
        Intrinsics.checkParameterIsNotNull((Object)markerName, (String)"markerName");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.execScript(markerName + ".setLatLng([" + position.getLatitude() + ", " + position.getLongitude() + "]);");
    }

    public final void removeMarker(@NotNull String markerName) {
        Intrinsics.checkParameterIsNotNull((Object)markerName, (String)"markerName");
        this.execScript("myMap.removeLayer(" + markerName + ");");
        Marker marker = this.markerById.remove(markerName);
        if (marker != null) {
            this.markerIds.remove(marker);
        }
    }

    public final void removeMarker(@NotNull Marker marker) {
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        String markerId = this.markerIds.get(marker);
        if (markerId == null) {
            throw (Throwable)new IllegalStateException("Marker is not present in current map");
        }
        this.removeMarker(markerId);
    }

    @NotNull
    public final String addMarkerClusterGroup(@NotNull MarkerClusterGroup markerClusterGroup) {
        Intrinsics.checkParameterIsNotNull((Object)markerClusterGroup, (String)"markerClusterGroup");
        int n = this.clusterNameSuffix;
        this.clusterNameSuffix = n + 1;
        String varName = "cluster" + n;
        Map<Object, Object> map = this.clusterIds;
        Iterator<Marker> iterator = varName;
        map.put(markerClusterGroup, (String)((Object)iterator));
        map = this.clusterById;
        iterator = markerClusterGroup;
        map.put((MarkerClusterGroup)((Object)varName), (String)((Object)iterator));
        this.execScript("var " + varName + " = L.markerClusterGroup();");
        for (Marker marker : markerClusterGroup.getMarkers()) {
            int n2 = this.clusterMarkerNameSuffix;
            this.clusterMarkerNameSuffix = n2 + 1;
            String clusterMarkerId = "clusterMarker" + n2;
            Map<Object, Object> map2 = this.markerIds;
            Object object = clusterMarkerId;
            map2.put(marker, (String)object);
            map2 = this.markerById;
            object = marker;
            map2.put((Marker)((Object)clusterMarkerId), (String)object);
            this.execScript("var " + clusterMarkerId + " = L.marker([" + marker.getPosition().getLatitude() + ", " + marker.getPosition().getLongitude() + "], " + "{title: '" + marker.getTitle() + "', icon: " + marker.getMarkerIcon().getIconName() + ", zIndexOffset: " + marker.getZIndexOffset() + "}); " + clusterMarkerId + ".on('click',function(){ jsBridge.onMarkerClick('" + clusterMarkerId + "'); });");
            this.execScript(varName + ".addLayer(" + clusterMarkerId + ");");
        }
        this.execScript("myMap.addLayer(" + varName + "); myMap.fitBounds(" + varName + ".getBounds());");
        return varName;
    }

    public final void fitBoundsOfMarkerClusterGroup(@NotNull MarkerClusterGroup markerClusterGroup) {
        Intrinsics.checkParameterIsNotNull((Object)markerClusterGroup, (String)"markerClusterGroup");
        String string = this.clusterIds.get(markerClusterGroup);
        if (string == null) {
            throw (Throwable)new IllegalStateException("Trying to fit to bounds of MarkerClusterGroup which has not been added to this map");
        }
        String varName = string;
        this.execScript("myMap.fitBounds(" + varName + ".getBounds());");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String addTrack(@NotNull List<LatLong> positions) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(positions, (String)"positions");
        int n = this.varNameSuffix;
        this.varNameSuffix = n + 1;
        String varName = "track" + n;
        Iterable iterable = positions;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LatLong latLong = (LatLong)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "    [" + it.getLatitude() + ", " + it.getLongitude() + ']';
            collection.add(string);
        }
        String jsPositions = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", \n", null, null, (int)0, null, null, (int)62, null);
        this.execScript(StringsKt.trimMargin$default((String)("\n            |var latLngs = [\n            |" + jsPositions + "\n            |];\n\n            |var " + varName + " = L.polyline(latLngs, {color: 'red', weight: 2}).addTo(myMap);\n            |myMap.fitBounds(" + varName + ".getBounds());"), null, (int)1, null));
        return varName;
    }

    public final void clearMarkersAndTracks() {
        this.execScript(StringsKt.trimMargin$default((String)"\n            |for (i in myMap._layers) {\n            |   if (myMap._layers[i] instanceof L.Marker || myMap._layers[i] instanceof L.Path) {\n            |       myMap.removeLayer(myMap._layers[i]);\n            |   }\n            |}", null, (int)1, null));
    }

    protected final void execScript(@NotNull String script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (this.DEBUG) {
            System.out.println("Executing " + script);
        }
        this.webEngine.executeScript(script);
    }

    private final void onMarkerClick(String id) {
        block0: {
            EventHandler<Event> eventHandler = this.markerById.get(id);
            if (eventHandler == null || (eventHandler = eventHandler.getOnClickEventHandler()) == null) break block0;
            eventHandler.handle(new Event(JS_CLICK_EVENTTYPE));
        }
    }

    public LeafletMapView() {
        WebEngine webEngine = this.webView.getEngine();
        Intrinsics.checkExpressionValueIsNotNull((Object)webEngine, (String)"webView.engine");
        this.webEngine = webEngine;
        this.varNameSuffix = 1;
        this.clusterNameSuffix = 1;
        this.clusterMarkerNameSuffix = 1;
        this.jsBridge = new JSBridge(this);
        this.markerById = new HashMap();
        this.markerIds = new HashMap();
        this.clusterById = new HashMap();
        this.clusterIds = new HashMap();
        this.getChildren().add((Object)this.webView);
    }

    static {
        Companion = new Companion(null);
        JS_CLICK_EVENTTYPE = new EventType("JSClickEvent");
    }

    public static final /* synthetic */ void access$executeMapSetupScripts(LeafletMapView $this, MapConfig mapConfig) {
        $this.executeMapSetupScripts(mapConfig);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lde/saring/leafletmap/LeafletMapView$JSBridge;", "", "lmv", "Lde/saring/leafletmap/LeafletMapView;", "(Lde/saring/leafletmap/LeafletMapView;)V", "getLmv", "()Lde/saring/leafletmap/LeafletMapView;", "onMarkerClick", "", "id", "", "printMsg", "msg", "leafletmap"})
    public static class JSBridge {
        @NotNull
        private final LeafletMapView lmv;

        public final void printMsg(@NotNull String msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            System.out.println("JS: " + msg);
        }

        public final void onMarkerClick(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.lmv.onMarkerClick(id);
        }

        @NotNull
        public final LeafletMapView getLmv() {
            return this.lmv;
        }

        public JSBridge(@NotNull LeafletMapView lmv) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lmv), (String)"lmv");
            this.lmv = lmv;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/saring/leafletmap/LeafletMapView$Companion;", "", "()V", "JS_CLICK_EVENTTYPE", "Ljavafx/event/EventType;", "Ljavafx/event/Event;", "getJS_CLICK_EVENTTYPE", "()Ljavafx/event/EventType;", "leafletmap"})
    public static final class Companion {
        @NotNull
        public final EventType<Event> getJS_CLICK_EVENTTYPE() {
            return JS_CLICK_EVENTTYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

