/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestAnyServiceGetVersion
extends BaseApiTest<LegacyApiTestConfig> {
    private CommonAMTest commonAMTest;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Calls GetVersion on any available Aggregate manager for the given testbed. This is mainly useful to test connectivity.";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("service_name");
            res.add("service_version");
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }
    };
    private URL preferredUrl = null;
    private ApiInfo.Api preferredApi = null;
    private Map versionRawResult = null;

    @Inject
    public TestAnyServiceGetVersion(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM2CorrectnessXmlRpcResult code == null in " + String.valueOf(res));
        this.assertNotNull(value, "testAM2CorrectnessXmlRpcResult value == null in " + String.valueOf(res));
        this.assertInstanceOf(code, Map.class, "testAM2CorrectnessXmlRpcResult code is not Map in " + String.valueOf(res) + " (it is " + code.getClass().getName() + " with value \"" + code.toString() + "\")");
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM2CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + String.valueOf(res));
        this.assertEquals(genicode.getClass(), Integer.class, "testAM2CorrectnessXmlRpcResult code.geni_code is not int in " + String.valueOf(res));
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + String.valueOf(res));
            this.assertEquals(output.getClass(), String.class, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else if (output == null) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
        } else if (output != null && !(output instanceof String)) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
        }
    }

    @Override
    public void setUp() {
        Map.Entry e;
        String serviceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("service_name");
        String serviceVersion = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("service_version");
        if (serviceName != null) {
            this.note("Will limit to service: " + serviceName);
        }
        if (serviceVersion != null) {
            this.note("Will limit to service version: " + serviceVersion);
        }
        Server server = this.testedAuthority.getServerToConnect();
        HashMap<ApiInfo.Api, URL> urls = new HashMap<ApiInfo.Api, URL>();
        for (Service service : server.getServices()) {
            try {
                urls.put(new ApiInfo.Api(service.getApi(), service.getApiVersion()), new URL(service.getUrl()));
            }
            catch (MalformedURLException e2) {
                this.note("Invalid URL in TestbedInfoSource -> will ignore", e2);
            }
        }
        if (urls.isEmpty()) {
            this.fatalError("No URLs are known for the tested authority " + server.getDefaultComponentManagerUrn());
        } else {
            this.note("The tested authority has " + urls.size() + " registered URLs");
        }
        Iterator it = urls.entrySet().iterator();
        while (it.hasNext()) {
            e = it.next();
            if (serviceName != null && !((ApiInfo.Api)e.getKey()).getName().name().equalsIgnoreCase(serviceName)) {
                it.remove();
                continue;
            }
            if (serviceVersion == null || ((ApiInfo.Api)e.getKey()).getVersion().equalsIgnoreCase(serviceVersion)) continue;
            it.remove();
        }
        if (urls.isEmpty()) {
            this.fatalError("Due to the service_name and/or service_version filter, no URLs are left to test.");
        }
        List<ApiInfo.Api> preferences = Arrays.asList(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 1), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 2), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 1), new ApiInfo.Api(ApiInfo.ApiName.PLANETLAB_SLICE_REGISTRY, 1), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_CH, 1), new ApiInfo.Api(ApiInfo.ApiName.GENI_SCS, 1));
        for (ApiInfo.Api pref : preferences) {
            URL url = (URL)urls.get(pref);
            if (url == null) continue;
            this.preferredUrl = url;
            this.preferredApi = pref;
            break;
        }
        if (this.preferredUrl == null) {
            e = urls.entrySet().iterator().next();
            this.preferredUrl = (URL)e.getValue();
            this.preferredApi = (ApiInfo.Api)e.getKey();
        }
        this.note("Chosen servertype: " + String.valueOf(this.preferredApi));
        this.note("URL: " + String.valueOf(this.preferredUrl));
        this.commonAMTest = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
        this.note("done");
    }

    @ApiTest.Test
    public void testGetVersion() throws JFedException {
        switch (this.preferredApi.getName()) {
            case GENI_AM: {
                this.testAMGetVersion();
                break;
            }
            case GENI_CH: 
            case GENI_CH_MA: 
            case GENI_CH_SA: {
                this.testFedApiGetVersion();
                break;
            }
            case GENI_SCS: {
                this.testScsGetVersion();
                break;
            }
            default: {
                this.fatalError("There is no known \"GetVersion\" test for the server type " + String.valueOf(this.preferredApi));
            }
        }
    }

    public void testScsGetVersion() throws JFedException {
        StitchingComputationService scs = new StitchingComputationService(this.getLogger(), this.getJFedPreferences());
        SfaConnection sfaCon = (SfaConnection)this.getConnectionProvider().getConnectionByAuthority(this.getUser(), this.getTestedAuthority().getServerToConnect(), this.preferredApi);
        StitchingComputationService.SCSReply reply = scs.getVersion(sfaCon);
        Map versionRawResult = reply.getRawResult();
        this.assertNotNull(versionRawResult);
        this.assertEquals(reply.getCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS.getCode(), "GeniResponse code is not SUCCESS (0)");
        Map replyHt = AbstractApi.apiSpecifiesMapStringToObject((Object)versionRawResult);
        Map valueHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("value"));
        Object iface = valueHt.get("interface");
        this.assertEquals(iface, "scs");
        this.note("Test completed successfully.");
    }

    public void testFedApiGetVersion() throws JFedException {
        FederationSliceAuthorityApi2 sa = new FederationSliceAuthorityApi2(this.getLogger(), this.getJFedPreferences());
        SfaConnection sfaCon = (SfaConnection)this.getConnectionProvider().getConnectionByAuthority(this.getUser(), this.getTestedAuthority().getServerToConnect(), this.preferredApi);
        AbstractFederationApi.FederationApiReply reply = sa.getVersion(sfaCon);
        Map versionRawResult = reply.getRawResult();
        this.assertNotNull(versionRawResult);
        this.assertEquals(reply.getCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS.getCode(), "GeniResponse code is not SUCCESS (0)");
        Map replyHt = AbstractApi.apiSpecifiesMapStringToObject((Object)versionRawResult);
        Map valueHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("value"));
        Object version = valueHt.get("VERSION");
        this.assertNotNull(version);
        this.note("Test completed successfully. Version is " + String.valueOf(version));
    }

    public void testAMGetVersion() throws JFedException {
        AutomaticAggregateManagerWrapper amWrapper = this.getAutomaticAggregateManagerWrapperFactory().create(this.logger, this.testedAuthority.getServerToConnect());
        this.versionRawResult = amWrapper.getVersion();
        this.testAM2CorrectnessXmlRpcResult(this.versionRawResult);
        this.assertNotNull(this.versionRawResult);
        Map replyHt = AbstractApi.apiSpecifiesMapStringToObject((Object)this.versionRawResult);
        Map codeHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("code"));
        Integer genicodeHt = AbstractApi.apiSpecifiesInt(codeHt.get("geni_code"));
        this.assertEquals(genicodeHt, GeniAMResponseCode.GENIRESPONSE_SUCCESS.getCode(), "GeniResponse code is not SUCCESS (0)");
        Map valueHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("value"));
        Integer geniapiHt = AbstractApi.apiSpecifiesInt(replyHt.get("geni_api"));
        this.assertNotNull(geniapiHt);
        this.note("Test completed successfully. Version is" + geniapiHt + ".\nAll Done\n");
    }
}

