/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.api.test.AbstractFederationApi1Test;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.NoConfigApiTestMetaData;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestFederationMemberAuthority1
extends AbstractFederationApi1Test {
    private static final ApiTestMetaData metadata = new NoConfigApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Test Uniform Federation API Member Authority";
        }
    };
    private FederationMemberAuthorityApi1 ma;
    private GeniUrn testUserUrn;
    final List<String> memberDefaultFieldNames = new ArrayList<String>();
    List<AbstractFederationApi.GetVersionResult.FieldInfo> memberDefaultFields = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo>();
    final List<String> keyDefaultFieldNames = new ArrayList<String>();
    List<AbstractFederationApi.GetVersionResult.FieldInfo> keyDefaultFields = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo>();
    private boolean hasKeyService = false;
    AnyCredential maTestUserCredential;
    List<AnyCredential> maTestUserCredentialList;
    AnyCredential testUserCredential;
    List<AnyCredential> testUserCredentialList;
    private SSHKeyHelper sshKeyHelper;
    private Map<String, Object> keyCreationDetails;
    private static final String initialKeyDescription = "Randomly generated public key used for automated testing";
    private String keyId;
    private static final String updatedKeyDescription = "Randomly generated public key used for automated testing with updated description";

    @Inject
    public TestFederationMemberAuthority1(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 1));
    }

    @Override
    public void setUp() {
        this.ma = new FederationMemberAuthorityApi1(this.logger, this.getJFedPreferences());
        this.ma.setHandleMalformedReplies(false);
        this.testUserUrn = GeniUrn.parse((String)this.user.getUserUrnString());
        this.assertNotNull(this.testUserUrn, "Error in test user urn: " + this.user.getUserUrnString());
        this.memberDefaultFields = this.ma.getMinimumFields("MEMBER");
        this.keyDefaultFields = this.ma.getMinimumFields("KEY");
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            this.memberDefaultFieldNames.add(fi.getName());
        }
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.keyDefaultFields) {
            this.keyDefaultFieldNames.add(fi.getName());
        }
    }

    @ApiTest.Test(groups={"getversion"})
    public void getVersion() throws JFedException {
        AbstractFederationApi.FederationApiReply reply = this.ma.getVersion(this.getConnection());
        this.checkGetVersion((AbstractFederationApi.FederationApiReply<? extends AbstractFederationApi.GetVersionResult>)reply, (AbstractFederationApi)this.ma, true);
        Map htRes = (Map)reply.getRawValue();
        List services = this.assertMapContainsList(htRes, "SERVICES");
        if (services != null) {
            this.hasKeyService = services.contains("KEY");
        }
    }

    @ApiTest.Test(softDepends={"getVersion"}, groups={"get_redential"})
    public void getTestUserCredential() throws JFedException {
        Object[] rawVal;
        AbstractFederationApi.FederationApiReply reply = this.ma.getCredentials(this.getConnection(), new ArrayList(), this.testUserUrn, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        for (Object credO : rawVal = this.assertInstanceOf(reply.getRawValue(), Object[].class, "The get_credential call should return an array (List) of dictionaries, instead it returned a " + reply.getRawValue().getClass().getName())) {
            this.assertInstanceOf(credO, Map.class, "The get_credential call should return an array containing dictionaries, instead one of the values in the array is a " + credO.getClass().getName());
        }
        List testUserCreds = (List)reply.getValue();
        this.assertNotNull(testUserCreds, "no credential returned");
        this.assertEquals(testUserCreds.size(), rawVal.length, "Error in jFed: raw credential list length (" + testUserCreds.size() + ") differs from converted credential list length (" + rawVal.length + ")");
        this.assertNotEmpty(testUserCreds, "empty list of credentials returned. Expecting a list with credentials, but got  " + (String)(reply.getRawValue() == null ? "null" : (reply.getRawValue() instanceof Object[] ? "a list: " + String.valueOf(reply.getRawValue()) : "something of class:" + reply.getRawValue().getClass().getName())));
        this.maTestUserCredentialList = new ArrayList<AnyCredential>(testUserCreds);
        this.maTestUserCredential = (AnyCredential)testUserCreds.get(0);
    }

    @ApiTest.Test(softDepends={"getTestUserCredential"}, groups={"get_redential"}, description="Get A Credential for the test user. If the MA get_credential call did not work, this will try to fall back to the old PROTOGENI_SA API.")
    public void retrieveCredentialSomehow() throws JFedException {
        if (this.maTestUserCredentialList != null && this.maTestUserCredential != null) {
            this.testUserCredential = this.maTestUserCredential;
            this.testUserCredentialList = this.maTestUserCredentialList;
        } else if (!ApiInfo.hasService((Server)this.user.getUserAuthorityServer(), (ApiInfo.ApiName)ApiInfo.ApiName.PROTOGENI_SA, (int)1)) {
            this.errorFatal("The Uniform Federation API Member Authority get_credential call failed to provide a credential. additionally, the test user authority does not have a PROTOGENI_SA available as fallback. => Cannot retrieve a credential for the test user.");
        } else {
            this.note("The Uniform Federation API Member Authority get_credential call failed to provide a credential: Falling back to the PROTOGENI_SA API to retrieve a credential for the remaining tests.");
            SfaConnection protogeniSaCon = (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.user.getUserAuthorityServer(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
            ProtogeniSliceAuthority protogeniSa = new ProtogeniSliceAuthority(this.logger, this.getJFedPreferences());
            ProtogeniSliceAuthority.SliceAuthorityReply pgSaReply = protogeniSa.getCredential(protogeniSaCon);
            this.assertTrue(pgSaReply.getGeniResponseCode().isSuccess());
            AnyCredential pgCred = (AnyCredential)pgSaReply.getValue();
            this.assertNotNull(pgCred, "no credential returned by protogeni SA");
            this.testUserCredentialList = new ArrayList<AnyCredential>();
            this.testUserCredentialList.add(pgCred);
            this.testUserCredential = pgCred;
        }
    }

    private void checkMemberLookupResult(AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> reply, List<String> expectedFieldNames, List<String> excludedFieldNames) {
        this.setErrorsFatal();
        this.checkCorrectnessXmlRpcResult(reply);
        this.checkLookupCorrectness(reply);
        Map<String, Object> raw = this.assertStringObjectMap(reply.getRawValue());
        AbstractFederationApi.MemberInfoList lookupRes = (AbstractFederationApi.MemberInfoList)reply.getValue();
        if (lookupRes == null) {
            this.warn("lookup result is null. This is either due to receiving an incorrect result (will fail later in this test in that case), or due a a bug in the API client implementation");
        }
        this.errorNonFatalIfNot(raw.size() == 1, "lookup must return one user, but it returned " + raw.size());
        Map<String, Object> rawUser = this.assertStringObjectMap(raw.get(this.testUserUrn.getValue()));
        this.errorNonFatalIfNot(rawUser != null, "lookup must return requested test user (" + this.testUserUrn.getValue() + ") user.");
        String rawUrn = (String)rawUser.get("MEMBER_URN");
        if (rawUrn != null && !Objects.equals(this.testUserUrn.getValue(), rawUrn)) {
            this.errorNonFatal("lookup must return requested test user (" + this.testUserUrn.getValue() + ") user, and it did, however its returned MEMBER_URN entry is not matching: " + rawUrn);
        }
        for (Map.Entry<String, Object> mi : raw.entrySet()) {
            Map<String, Object> memberInfo = this.assertStringObjectMap(mi);
            for (String fieldName : expectedFieldNames) {
                if (memberInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result does not contain field: \"" + fieldName + "\"");
            }
            for (String fieldName : excludedFieldNames) {
                if (!memberInfo.containsKey(fieldName)) continue;
                this.errorNonFatal("returned result contains unexpected field: \"" + fieldName + "\"");
            }
        }
    }

    @ApiTest.Test(softDepends={"retrieveCredentialSomehow"})
    public void lookupPublicMemberInfoNoFilter() throws JFedException {
        this.lookupPublicMemberInfoXFilterHelper(null);
    }

    @ApiTest.Test(softDepends={"retrieveCredentialSomehow"})
    public void lookupPublicMemberInfoEmptyFilter() throws JFedException {
        ArrayList<String> filter = new ArrayList<String>();
        this.note("this test calls a lookup with an EMPTY filter specified. So there is a filter, is just is empty. This test is expecting NO fields to be returned.");
        this.lookupPublicMemberInfoXFilterHelper(filter);
    }

    public void lookupPublicMemberInfoXFilterHelper(List<String> filter) throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("MEMBER_URN", this.testUserUrn.getValue());
        this.note("looking up member by MEMBER_URN: " + this.testUserUrn.getValue() + " with filter: " + String.valueOf(filter));
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupPublicMemberInfo(this.getConnection(), new ArrayList(), match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            if (Objects.equals(fi.getProtect(), AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PUBLIC) && (filter == null || filter.contains(fi.getName()))) {
                expectedFieldNames.add(fi.getName());
                continue;
            }
            excludedFieldNames.add(fi.getName());
        }
        if (filter != null && filter.isEmpty()) {
            this.note("Empty filter provided, so expecting no fields to be returned: excludedFieldNames=" + String.valueOf(excludedFieldNames));
        }
        if (filter == null) {
            this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        }
        this.checkMemberLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList>)reply, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"})
    public void lookupPrivateMemberInfoNoFilter() throws JFedException {
        this.lookupPrivateMemberInfoXFilterHelper(null);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"})
    public void lookupPrivateMemberInfoEmptyFilter() throws JFedException {
        ArrayList<String> filter = new ArrayList<String>();
        this.note("this test calls a lookup with an EMPTY filter specified. So there is a filter, is just is empty. This test is expecting NO fields to be returned.");
        this.lookupPrivateMemberInfoXFilterHelper(filter);
    }

    public void lookupPrivateMemberInfoXFilterHelper(List<String> filter) throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        this.note("looking up member by MEMBER_URN: " + this.testUserUrn.getValue() + " with filter: " + String.valueOf(filter));
        match.put("MEMBER_URN", this.testUserUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupPrivateMemberInfo(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            if (Objects.equals(fi.getProtect(), AbstractFederationApi.GetVersionResult.FieldInfo.Protect.PRIVATE) && (filter == null || filter.contains(fi.getName()))) {
                expectedFieldNames.add(fi.getName());
                continue;
            }
            excludedFieldNames.add(fi.getName());
        }
        if (filter != null && filter.isEmpty()) {
            this.note("Empty filter provided, so expecting no fields to be returned: excludedFieldNames=" + String.valueOf(excludedFieldNames));
        }
        if (filter == null) {
            this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        }
        this.checkMemberLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList>)reply, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"})
    public void lookupIdentifyingMemberInfoNoFilter() throws JFedException {
        List<String> filter = null;
        this.lookupIdentifyingMemberInfoXFilterHelper(filter);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"})
    public void lookupIdentifyingMemberInfoEmptyFilter() throws JFedException {
        ArrayList<String> filter = new ArrayList<String>();
        this.note("this test calls a lookup with an EMPTY filter specified. So there is a filter, is just is empty. This test is expecting NO fields to be returned.");
        this.lookupIdentifyingMemberInfoXFilterHelper(filter);
    }

    public void lookupIdentifyingMemberInfoXFilterHelper(List<String> filter) throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        this.note("looking up member by MEMBER_URN: " + this.testUserUrn.getValue() + " with filter: " + String.valueOf(filter));
        match.put("MEMBER_URN", this.testUserUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupIdentifyingMemberInfo(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            if (Objects.equals(fi.getProtect(), AbstractFederationApi.GetVersionResult.FieldInfo.Protect.IDENTIFYING) && (filter == null || filter.contains(fi.getName()))) {
                expectedFieldNames.add(fi.getName());
                continue;
            }
            excludedFieldNames.add(fi.getName());
        }
        if (filter != null && filter.isEmpty()) {
            this.note("Empty filter provided, so expecting no fields to be returned: excludedFieldNames=" + String.valueOf(excludedFieldNames));
        }
        if (filter == null) {
            this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        }
        this.checkMemberLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList>)reply, expectedFieldNames, excludedFieldNames);
    }

    @ApiTest.Test(softDepends={"lookupPublicMemberInfoEmptyFilter"}, description="")
    public void lookupPublicMemberInfoFiltered() throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("MEMBER_UID");
        this.note("looking up member by MEMBER_URN: " + this.testUserUrn.getValue());
        match.put("MEMBER_URN", this.testUserUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupPublicMemberInfo(this.getConnection(), new ArrayList(), match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            if (filter.contains(fi.getName())) continue;
            excludedFieldNames.add(fi.getName());
        }
        this.note("filter provided, so expecting only these fields to be returned: " + String.valueOf(filter) + " while none of these fields should be returned: " + String.valueOf(excludedFieldNames));
        this.checkMemberLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList>)reply, filter, excludedFieldNames);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"}, softDepends={"lookupIdentifyingMemberInfoEmptyFilter"})
    public void lookupIdentifyingMemberInfoFiltered() throws JFedException {
        HashMap<String, String> match = new HashMap<String, String>();
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("MEMBER_EMAIL");
        filter.add("MEMBER_FIRSTNAME");
        this.note("looking up member by MEMBER_URN: " + this.testUserUrn.getValue());
        match.put("MEMBER_URN", this.testUserUrn.getValue());
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupIdentifyingMemberInfo(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.memberDefaultFields) {
            if (filter.contains(fi.getName())) continue;
            excludedFieldNames.add(fi.getName());
        }
        this.note("filter provided, so expecting only these fields to be returned: " + String.valueOf(filter) + " while none of these fields should be returned: " + String.valueOf(excludedFieldNames));
        this.checkMemberLookupResult((AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList>)reply, filter, excludedFieldNames);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"}, softDepends={"lookupIdentifyingMemberInfoFiltered", "lookupPublicMemberInfoFiltered", "lookupPublicMemberInfoEmptyFilter", "lookupPublicMemberInfoNoFilter", "lookupPrivateMemberInfoEmptyFilter", "lookupPrivateMemberInfoNoFilter", "lookupIdentifyingMemberInfoEmptyFilter", "lookupIdentifyingMemberInfoNoFilter"})
    public void createKey() throws JFedException, NoSuchAlgorithmException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        this.sshKeyHelper = new SSHKeyHelper();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("KEY_MEMBER", this.user.getUserUrnString());
        fields.put("KEY_PUBLIC", this.sshKeyHelper.getSshPublicKeyString());
        fields.put("KEY_DESCRIPTION", initialKeyDescription);
        AbstractFederationApi.FederationApiReply reply = this.ma.createKey(this.getConnection(), this.testUserCredentialList, this.testUserUrn, fields, null);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        Object rawValue = reply.getXmlRpcCallDetailsWithCodeValueError().getResultValueObject();
        this.assertNotNull(rawValue, "The call did not return a value object");
        this.assertInstanceOf(rawValue, Map.class, "The call did not return a dictionary");
        Map rawValueHt = (Map)rawValue;
        for (Object key : rawValueHt.keySet()) {
            this.assertInstanceOf(key, String.class, "One of the dictionary keys in the result value is not a String: class=" + key.getClass().getName() + " value=" + String.valueOf(key));
            Object v = rawValueHt.get(key);
            if (Objects.equals(key, "KEY_ID") && !(v instanceof String)) {
                this.errorNonFatal("The returned KEY_ID should be a String, but it is a " + v.getClass().getName());
            }
            if (Objects.equals(key, "KEY_DESCRIPTION") && !(v instanceof String)) {
                this.errorNonFatal("The returned KEY_DESCRIPTION should be a String, but it is a " + v.getClass().getName());
            }
            if (v instanceof String) continue;
            this.note("One of the dictionary values in the result value is not a String: key=" + String.valueOf(key) + " class=" + v.getClass().getName() + " value=" + String.valueOf(v));
        }
        this.keyCreationDetails = this.assertStringObjectMap(reply.getRawValue());
        this.assertNotNull(this.keyCreationDetails, "The jFed code did not return details about the created key. (reply.getValue() == null). internal jFed error?");
        this.note("key details contains the following fields: " + String.valueOf(this.keyCreationDetails.keySet()));
        this.keyId = this.assertMapContainsNonemptyString(this.keyCreationDetails, "KEY_ID");
    }

    private void checkKeyLookupResult(AbstractFederationApi.FederationApiReply<Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>> reply, List<String> expectedFieldNames, List<String> excludedFieldNames) {
        Map<String, Object> lookupRes = this.assertStringObjectMap(reply.getRawValue());
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertNotNull(lookupRes, "lookup result is null");
        this.assertTrue(lookupRes.size() > 0, "Lookup result is empty for keyId: " + this.keyId);
        this.errorNonFatalIfNot(lookupRes.size() == 1, "lookup must return one member with one key, but it returned " + lookupRes.size() + " members");
        List userKeys = this.assertMapContainsList(lookupRes, this.testUserUrn.getValue());
        this.errorNonFatalIfNot(userKeys.size() == 1, "lookup must return one member with one key, but it returned 1 member with " + userKeys.size() + " keys");
        Map<String, Object> key = this.assertStringObjectMap(userKeys.get(0));
        this.errorNonFatalIfNot(key != null, "lookup must return requested key (" + this.keyId + ") but 1 member with 1 key that was null.");
        String rawId = this.assertMapContainsString(key, "KEY_ID");
        if (rawId != null && !Objects.equals(this.keyId, rawId)) {
            this.errorNonFatal("lookup must return requested key (" + this.keyId + "), and it did, however its returned KEY_ID entry is not matching: " + rawId);
        }
        for (String fieldName : expectedFieldNames) {
            if (key.containsKey(fieldName)) continue;
            this.errorNonFatal("returned result does not contain field: \"" + fieldName + "\"");
        }
        for (String fieldName : excludedFieldNames) {
            if (!key.containsKey(fieldName)) continue;
            this.errorNonFatal("returned result contains unexpected field: \"" + fieldName + "\"");
        }
    }

    @ApiTest.Test(hardDepends={"createKey"})
    public void lookupKeysNoFilter() throws JFedException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        List filter = null;
        match.put("KEY_ID", this.keyId);
        this.note("looking up key by KEY_ID: " + this.keyId);
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupKeys(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.keyDefaultFields) {
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkKeyLookupResult((AbstractFederationApi.FederationApiReply<Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>>)reply, expectedFieldNames, excludedFieldNames);
        String desc = ((AbstractFederationApi.MemberKeyInfo)((List)((Map)reply.getValue()).get(this.testUserUrn)).get(0)).getKeyDescription();
        this.assertNotNull(desc);
        this.assertEquals(desc, initialKeyDescription);
    }

    @ApiTest.Test(hardDepends={"createKey"}, softDepends={"lookupKeysNoFilter"})
    public void updateKey() throws JFedException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("KEY_DESCRIPTION", updatedKeyDescription);
        AbstractFederationApi.FederationApiReply reply = this.ma.updateKey(this.getConnection(), this.testUserCredentialList, this.testUserUrn, this.keyId, fields, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
    }

    @ApiTest.Test(hardDepends={"updateKey"})
    public void lookupKeysNoFilterAfterUpdate() throws JFedException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        List filter = null;
        match.put("KEY_ID", this.keyId);
        this.note("looking up key by KEY_ID: " + this.keyId);
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupKeys(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        ArrayList<String> excludedFieldNames = new ArrayList<String>();
        for (AbstractFederationApi.GetVersionResult.FieldInfo fi : this.keyDefaultFields) {
            expectedFieldNames.add(fi.getName());
        }
        this.note("No filter provided, so expecting all fields to be returned: " + String.valueOf(expectedFieldNames));
        this.checkKeyLookupResult((AbstractFederationApi.FederationApiReply<Map<GeniUrn, List<AbstractFederationApi.MemberKeyInfo>>>)reply, expectedFieldNames, excludedFieldNames);
        String desc = ((AbstractFederationApi.MemberKeyInfo)((List)((Map)reply.getValue()).get(this.testUserUrn)).get(0)).getKeyDescription();
        this.assertNotNull(desc);
        this.assertEquals(desc, updatedKeyDescription);
    }

    @ApiTest.Test(hardDepends={"retrieveCredentialSomehow"}, softDepends={"createKey", "lookupKeysNoFilterAfterUpdate"}, description="Try to delete key. Always called to ensure an attempt to delete is always made.")
    public void deleteKey() throws JFedException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        if (this.keyId == null) {
            this.skip("No key ID to delete known");
        }
        AbstractFederationApi.FederationApiReply reply = this.ma.deleteKey(this.getConnection(), this.testUserCredentialList, this.testUserUrn, this.keyId, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "delete_key unsuccessful");
        this.assertTrue((Boolean)reply.getValue(), "delete_key returned false");
    }

    @ApiTest.Test(hardDepends={"deleteKey"})
    public void lookupKeysNoFilterAfterDelete() throws JFedException {
        if (!this.hasKeyService) {
            this.skip("No KEY service advertised in get_version");
        }
        HashMap<String, String> match = new HashMap<String, String>();
        List filter = null;
        match.put("KEY_ID", this.keyId);
        this.note("looking up key by KEY_ID: " + this.keyId);
        this.note("Expecting no key to be found, since we just deleted the key.");
        AbstractFederationApi.FederationApiReply reply = this.ma.lookupKeys(this.getConnection(), this.testUserCredentialList, match, filter, null);
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The tested call did not return code 0 (success), instead it returned " + String.valueOf(reply.getGeniResponseCode()));
        Map lookupRes = (Map)reply.getValue();
        this.assertNotNull(lookupRes);
        if (lookupRes.size() != 0) {
            List memberKeys = (List)lookupRes.get(this.testUserUrn);
            this.assertTrue(memberKeys.size() == 0, "After delete, a key was still found: " + String.valueOf(memberKeys));
        }
    }
}

