/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.rendersnake.HtmlAttributesFactory;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.internal.CharactersWriteable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTestResult
extends HtmlLogOutput {
    private static final Logger LOG = LoggerFactory.getLogger(ApiTestResult.class);
    @Nullable
    protected final TargetAuthority testedAuthority;
    @Nonnull
    protected final GeniUser user;
    @Nonnull
    private final Class<? extends ApiTest> testClass;
    @Nullable
    private final String testGroup;
    final List<ApiTestMethodResult> resultList = new CopyOnWriteArrayList<ApiTestMethodResult>();
    int returnValue = 0;

    public ApiTestResult(@Nullable TargetAuthority testedAuthority, @Nonnull GeniUser user, @Nonnull Class<? extends ApiTest> testClass, @Nullable String testGroup) {
        super("Test Result");
        this.testedAuthority = testedAuthority;
        this.user = user;
        this.testClass = testClass;
        this.testGroup = testGroup;
    }

    @Nonnull
    public Class<? extends ApiTest> getTestClass() {
        return this.testClass;
    }

    public List<ApiTestMethodResult> getResultList() {
        return Collections.unmodifiableList(this.resultList);
    }

    public Date getStartDate() {
        Date start = null;
        for (ApiTestMethodResult result : this.resultList) {
            Date date = new Date(result.getStartTimeMs());
            if (start != null && !start.after(date)) continue;
            start = date;
        }
        return start;
    }

    public Date getStopDate() {
        Date stop = null;
        for (ApiTestMethodResult result : this.resultList) {
            Date date = new Date(result.getStopTimeMs());
            if (stop != null && !stop.before(date)) continue;
            stop = date;
        }
        return stop;
    }

    public long getDurationMs() {
        Date begin = this.getStartDate();
        Date end = this.getStopDate();
        if (begin == null || end == null) {
            return 0L;
        }
        return end.getTime() - begin.getTime();
    }

    public String getVersionString() {
        StringBuilder version = new StringBuilder();
        try {
            String gitBranch;
            String gitCommit;
            String VERSION_PROPERTIES_FILE = "/version.properties";
            String PROP_VERSION = "version";
            String PROP_GIT_COMMIT = "build.git_commit";
            String PROP_GIT_BRANCH = "build.git_branch";
            String PROP_BUILD_CI = "build.ci_build";
            Properties prop = new Properties();
            prop.load(((Object)((Object)this)).getClass().getResourceAsStream("/version.properties"));
            version.append(prop.getProperty("version", "Unknown"));
            String ciBuildNr = prop.getProperty("build.ci_build");
            if (ciBuildNr != null && !ciBuildNr.isEmpty()) {
                version.append("  - build #").append(ciBuildNr);
            }
            if ((gitCommit = prop.getProperty("build.git_commit")) != null && !gitCommit.isEmpty()) {
                version.append("  - git commit #").append(gitCommit);
            }
            if ((gitBranch = prop.getProperty("build.git_branch")) != null && !gitBranch.isEmpty()) {
                version.append(" on ").append(gitBranch);
            }
            System.out.println("Version: " + version.toString());
        }
        catch (Exception e) {
            version.append(" === EXCEPTION finding version: ").append(e.getMessage()).append("\"");
            LOG.warn("EXCEPTION finding version: \"" + e.getMessage() + "\"", (Throwable)e);
        }
        return version.toString();
    }

    public String getEnvironment() {
        return JFedVersionInfo.getEnvironmentString();
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void toXmlOverview(File file) {
        this.toXmlOverview(file, false);
    }

    public void toXmlOverview(File file, boolean showCredentials) {
        disableRemoveSecurityRisks = showCredentials;
        try {
            XmlTestOverview x = new XmlTestOverview(this.resultList, this.getVersionString(), this.getEnvironment());
            x.testUserUrn = this.user.getUserUrnString();
            String string = x.testUserAuhUrn = this.user.getUserAuthorityServer() == null ? "" : this.user.getUserAuthorityServer().getDefaultComponentManagerUrn();
            assert (this.testedAuthority == null || this.testedAuthority.getServerToConnect() != null);
            x.testedAuthUrn = this.testedAuthority == null ? "none" : this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn();
            x.testedClass = this.testClass.getName();
            x.testedMethods = this.testGroup != null ? "Only group \"" + this.testGroup + "\" + dependencies" : "All";
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{XmlTestOverview.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)x, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Error creating XML", e);
        }
        disableRemoveSecurityRisks = false;
    }

    public void toXmlOverview(Writer writer, boolean showCredentials) {
        disableRemoveSecurityRisks = showCredentials;
        try {
            XmlTestOverview x = new XmlTestOverview(this.resultList, this.getVersionString(), this.getEnvironment());
            x.testUserUrn = this.user.getUserUrnString();
            String string = x.testUserAuhUrn = this.user.getUserAuthorityServer() == null ? "" : this.user.getUserAuthorityServer().getDefaultComponentManagerUrn();
            assert (this.testedAuthority == null || this.testedAuthority.getServerToConnect() != null);
            x.testedAuthUrn = this.testedAuthority == null ? "none" : this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn();
            x.testedClass = this.testClass.getName();
            x.testedMethods = this.testGroup != null ? "Only group \"" + this.testGroup + "\" + dependencies" : "All";
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{XmlTestOverview.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)x, writer);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        disableRemoveSecurityRisks = false;
    }

    public void htmlContent(HtmlCanvas html) throws IOException {
        html.h1().content("Test Settings");
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"test-settings"));
        ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Test User URN", (String)this.user.getUserUrnString());
        ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Test User Authority", (String)(this.user.getUserAuthorityServer() == null ? "unknown" : this.user.getUserAuthorityServer().getDefaultComponentManagerUrn()));
        html.br();
        if (this.testedAuthority != null) {
            ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Tested Aggregate Manager (if applicable)", (String)this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn());
            html.br();
        }
        ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Test Class", (String)this.testClass.getName());
        if (this.testGroup != null) {
            ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-nondata", (String)"Tested Methods", (String)("Only group \"" + this.testGroup + "\" + dependencies"));
        } else {
            ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-nondata", (String)"Tested Methods", (String)"All");
        }
        try {
            ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Test Description", (String)ApiTest.getMetaData(this.testClass).getTestDescription());
        }
        catch (Exception e) {
            LOG.error("Error while retrieving Test Description", (Throwable)e);
            ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Test Description", (String)("Error while retrieving: " + e.getMessage()));
        }
        html.br();
        ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Tester Version", (String)this.getVersionString());
        ApiTestResult.addKeyValue((HtmlCanvas)html, (String)"value-data", (String)"Tester Environment", (String)this.getEnvironment());
        html._div();
        html.h1().content("Overview");
        html.div((CharactersWriteable)HtmlAttributesFactory.class_((String)"times"));
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content("Total duration ");
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content((double)this.getDurationMs() / 1000.0 + "s");
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content(" from ");
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content(String.valueOf(this.getStartDate()));
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"timeheader")).content(" to ");
        html.span((CharactersWriteable)HtmlAttributesFactory.class_((String)"value-nondata")).content(String.valueOf(this.getStopDate()));
        html._div();
        int index = 0;
        for (ApiTestMethodResult res : this.resultList) {
            ApiTestResult.writeOverviewItem((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)res.state, (String)res.methodName);
        }
        index = 0;
        html.h1().content("Details");
        for (ApiTestMethodResult res : this.resultList) {
            ApiTestResult.writeGroupStart((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)res.state, (String)res.methodName, (String)res.description, (long)res.timeMs, (Date)new Date(res.startTimeMs), (Date)new Date(res.stopTimeMs), (Throwable)res.exception, res.apiCallDetails, res.getLogLines(), (HtmlLogOutput.Padding)HtmlLogOutput.Padding.topBottom((int)5), (boolean)false);
            for (ApiTestMethodResult embeddedRes : res.getEmbedded()) {
                ApiTestResult.writeEmbeddedGroup((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)embeddedRes.state, (String)embeddedRes.methodName, (String)embeddedRes.description, (long)embeddedRes.timeMs, (Date)new Date(embeddedRes.startTimeMs), (Date)new Date(embeddedRes.stopTimeMs), (Throwable)embeddedRes.exception, embeddedRes.apiCallDetails, embeddedRes.getLogLines());
            }
            ApiTestResult.writeGroupEnd((HtmlCanvas)html);
        }
    }

    @XmlRootElement(name="method")
    @XmlJavaTypeAdapter(value=JAXBMutableApiTestMethodResultAdaptor.class)
    public static class ApiTestMethodResult {
        @Nonnull
        final String methodName;
        @Nullable
        final String description;
        @Nonnull
        final List<String> hardDependencies;
        @Nonnull
        final List<String> softDependencies;
        @Nonnull
        final List<LogOutput.LogEntry> logLines;
        @Nonnull
        final List<SerializableApiCallDetails> apiCallDetails;
        @Nonnull
        final List<ApiTestMethodResult> embedded;
        @Nullable
        Throwable exception;
        @Nullable
        protected LogOutput.TestResultState state;
        @Nonnull
        protected List<FedmonResultExtra> fedmonResultExtras;
        final long startTimeMs;
        long stopTimeMs;
        long timeMs;

        public ApiTestMethodResult(@Nonnull String methodName, @Nullable String description, @Nonnull List<String> hardDependencies, @Nonnull List<String> softDependencies, @Nonnull List<ApiTestMethodResult> embedded, long startTimeMs) {
            this.methodName = methodName;
            this.description = description;
            this.hardDependencies = Collections.unmodifiableList(new ArrayList<String>(hardDependencies));
            this.softDependencies = Collections.unmodifiableList(new ArrayList<String>(softDependencies));
            this.embedded = new ArrayList<ApiTestMethodResult>(embedded);
            this.logLines = new CopyOnWriteArrayList<LogOutput.LogEntry>();
            this.apiCallDetails = new CopyOnWriteArrayList<SerializableApiCallDetails>();
            this.startTimeMs = startTimeMs;
            this.fedmonResultExtras = new CopyOnWriteArrayList<FedmonResultExtra>();
            this.exception = null;
        }

        public ApiTestMethodResult(@Nonnull String methodName, @Nullable String description, @Nonnull List<String> hardDependencies, @Nonnull List<String> softDependencies, @Nonnull List<ApiTestMethodResult> embedded, @Nonnull List<LogOutput.LogEntry> logLines, @Nonnull List<SerializableApiCallDetails> apiCallDetails, @Nullable Throwable exception, @Nullable LogOutput.TestResultState state, long timeMs, long startTimeMs, long stopTimeMs) {
            this.methodName = methodName;
            this.description = description;
            this.hardDependencies = Collections.unmodifiableList(new ArrayList<String>(hardDependencies));
            this.softDependencies = Collections.unmodifiableList(new ArrayList<String>(softDependencies));
            this.embedded = Collections.unmodifiableList(new ArrayList<ApiTestMethodResult>(embedded));
            this.logLines = new CopyOnWriteArrayList<LogOutput.LogEntry>(logLines);
            this.apiCallDetails = new CopyOnWriteArrayList<SerializableApiCallDetails>(apiCallDetails);
            this.exception = exception;
            this.state = state;
            this.timeMs = timeMs;
            this.startTimeMs = startTimeMs;
            this.stopTimeMs = stopTimeMs;
            this.fedmonResultExtras = new CopyOnWriteArrayList<FedmonResultExtra>();
        }

        public void addLogLine(@Nonnull LogOutput.LogLineType type, @Nullable String text, @Nullable Throwable t, boolean formatAsCode) {
            assert (type != null);
            if (text == null) {
                text = "";
            }
            assert (text != null);
            this.logLines.add(new LogOutput.LogEntry(type, text, t, formatAsCode));
        }

        public void addLogLine(@Nonnull LogOutput.LogLineType type, @Nullable String text, @Nullable Throwable t) {
            assert (type != null);
            if (text == null) {
                text = "";
            }
            assert (text != null);
            this.logLines.add(new LogOutput.LogEntry(type, text, t));
        }

        public void addLogLine(@Nonnull LogOutput.LogLineType type, @Nullable String text, boolean formatAsCode) {
            assert (type != null);
            if (text == null) {
                text = "";
            }
            assert (text != null);
            this.logLines.add(new LogOutput.LogEntry(type, text, formatAsCode));
        }

        public void addLogLine(@Nonnull LogOutput.LogLineType type, @Nullable String text) {
            assert (type != null);
            if (text == null) {
                text = "";
            }
            assert (text != null);
            this.logLines.add(new LogOutput.LogEntry(type, text));
        }

        public void addLogLine(@Nonnull LogOutput.LogEntry logEntry) {
            this.logLines.add(logEntry);
        }

        public void addLogLines(@Nonnull Collection<LogOutput.LogEntry> logEntries) {
            this.logLines.addAll(logEntries);
        }

        @XmlElement(name="state")
        @Nullable
        public LogOutput.TestResultState getState() {
            return this.state;
        }

        @XmlElement(name="methodName")
        @Nonnull
        public String getMethodName() {
            return this.methodName;
        }

        @XmlElement(name="description")
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nonnull
        public List<String> getHardDependencies() {
            return Collections.unmodifiableList(this.hardDependencies);
        }

        @Nonnull
        public List<String> getSoftDependencies() {
            return Collections.unmodifiableList(this.softDependencies);
        }

        @Nonnull
        @XmlElementWrapper(name="embedded")
        @XmlElement(name="result")
        public List<ApiTestMethodResult> getEmbedded() {
            return this.embedded;
        }

        public void addEmbedded(ApiTestMethodResult e) {
            this.embedded.add(e);
        }

        @XmlElementWrapper(name="loglines")
        @XmlElement(name="logline")
        @Nonnull
        public List<LogOutput.LogEntry> getLogLines() {
            return Collections.unmodifiableList(this.logLines);
        }

        @XmlElementWrapper(name="apicalls")
        @XmlElement(name="apicall")
        @Nonnull
        public List<SerializableApiCallDetails> getApiCallDetails() {
            return Collections.unmodifiableList(this.apiCallDetails);
        }

        @Nullable
        public Throwable getException() {
            return this.exception;
        }

        @XmlElement(name="durationInMs")
        public long getTimeMs() {
            return this.timeMs;
        }

        @XmlElement(name="startTimeInMs")
        public long getStartTimeMs() {
            return this.startTimeMs;
        }

        @XmlElement(name="stopTimeInMs")
        public long getStopTimeMs() {
            return this.stopTimeMs;
        }

        public void addExtraResult(FedmonResultExtra extra) {
            this.fedmonResultExtras.add(extra);
        }

        public void addExtraResult(FedmonResultExtraBuilder extra) {
            this.fedmonResultExtras.add(extra.create());
        }

        @Nonnull
        public List<FedmonResultExtra> getFedmonResultExtras() {
            return Collections.unmodifiableList(this.fedmonResultExtras);
        }

        public String toString() {
            return "ApiTestMethodResult{methodName='" + this.methodName + "', description='" + this.description + "', hardDependencies=" + String.valueOf(this.hardDependencies) + ", softDependencies=" + String.valueOf(this.softDependencies) + ", logLines=" + String.valueOf(this.logLines) + ", apiCallDetails=" + String.valueOf(this.apiCallDetails) + ", exception=" + String.valueOf(this.exception) + ", state=" + String.valueOf(this.state) + ", timeMs=" + this.timeMs + ", startTimeMs=" + this.startTimeMs + ", stopTimeMs=" + this.stopTimeMs + "}";
        }

        public static class FedmonResultExtraBuilder {
            private Object value;
            private boolean large = false;
            private String httpMediaType = "text/plain";
            private List<String> nestedKey;

            public FedmonResultExtraBuilder setKey(@Nonnull String key) {
                this.nestedKey = Collections.singletonList(key);
                assert (this.hasValidKey());
                return this;
            }

            public FedmonResultExtraBuilder setKey(String ... keys) {
                this.nestedKey = Arrays.asList(keys);
                assert (this.hasValidKey());
                return this;
            }

            public FedmonResultExtraBuilder setKey(@Nonnull List<String> nestedKey) {
                this.nestedKey = nestedKey;
                assert (this.hasValidKey());
                return this;
            }

            public boolean hasValidKey() {
                if (this.nestedKey == null) {
                    return false;
                }
                if (this.nestedKey.isEmpty()) {
                    return false;
                }
                return this.nestedKey.stream().noneMatch(Objects::isNull);
            }

            public FedmonResultExtraBuilder setValue(@Nonnull Object value) {
                this.value = value;
                return this;
            }

            public FedmonResultExtraBuilder setLarge(boolean large) {
                this.large = large;
                return this;
            }

            public FedmonResultExtraBuilder setHttpMediaType(@Nonnull String httpMediaType) {
                this.httpMediaType = httpMediaType;
                return this;
            }

            public FedmonResultExtraBuilder setHttpMediaTypeToXml() {
                this.httpMediaType = "application/xml";
                return this;
            }

            public FedmonResultExtraBuilder setHttpMediaTypeToText() {
                this.httpMediaType = "text/plain";
                return this;
            }

            public FedmonResultExtraBuilder setHttpMediaTypeToJson() {
                this.httpMediaType = "application/json";
                return this;
            }

            public FedmonResultExtraBuilder setHttpMediaTypeToHtml() {
                this.httpMediaType = "text/html";
                return this;
            }

            public FedmonResultExtra create() {
                if (this.nestedKey == null) {
                    throw new IllegalStateException("Not all required fields have been filled in (key missing)");
                }
                if (this.value == null) {
                    throw new IllegalStateException("Not all required fields have been filled in (value missing)");
                }
                if (this.httpMediaType == null) {
                    throw new IllegalStateException("Not all required fields have been filled in (httpMediaType missing)");
                }
                if (!this.hasValidKey()) {
                    throw new IllegalStateException("Invalid nested key filled in: " + String.valueOf(this.nestedKey));
                }
                return new FedmonResultExtra(this.nestedKey, this.value, this.large, this.httpMediaType);
            }
        }

        public static class FedmonResultExtra {
            @Nonnull
            private final List<String> nestedKey;
            @Nonnull
            private final Object value;
            private final boolean large;
            @Nonnull
            private final String httpMediaType;

            public FedmonResultExtra(@Nonnull String key, @Nonnull Object value, boolean large, @Nonnull String httpMediaType) {
                this.nestedKey = Collections.singletonList(key);
                this.value = value;
                this.large = large;
                this.httpMediaType = httpMediaType;
            }

            public FedmonResultExtra(@Nonnull List<String> nestedKey, @Nonnull Object value, boolean large, @Nonnull String httpMediaType) {
                assert (!nestedKey.isEmpty());
                this.nestedKey = nestedKey;
                this.value = value;
                this.large = large;
                this.httpMediaType = httpMediaType;
            }

            @Nonnull
            public List<String> getNestedKey() {
                return this.nestedKey;
            }

            @Nonnull
            public String getLastNestedKey() {
                assert (!this.nestedKey.isEmpty());
                return this.nestedKey.get(this.nestedKey.size() - 1);
            }

            @Nonnull
            public Object getValue() {
                return this.value;
            }

            @Nonnull
            public String getHttpMediaType() {
                return this.httpMediaType;
            }

            public boolean isLarge() {
                return this.large;
            }
        }
    }

    @XmlRootElement(name="overview")
    private static class XmlTestOverview {
        @XmlElementWrapper(name="methods")
        @XmlElement(name="method")
        private List<ApiTestMethodResult> details;
        @XmlElement(name="version")
        private String version;
        @XmlElement(name="environment")
        private String environment;
        @XmlElement(name="TestUserUrn")
        private String testUserUrn;
        @XmlElement(name="TestUserAuthorityUrn")
        private String testUserAuhUrn;
        @XmlElement(name="TestedAuthorityUrn")
        private String testedAuthUrn;
        @XmlElement(name="TestedClass")
        private String testedClass;
        @XmlElement(name="TestedMethods")
        private String testedMethods;

        public XmlTestOverview() {
        }

        public XmlTestOverview(List<ApiTestMethodResult> resultList, String version, String environment) {
            this.version = version;
            this.environment = environment;
            this.details = new ArrayList<ApiTestMethodResult>(resultList);
        }
    }

    public static class JAXBMutableApiTestMethodResultAdaptor
    extends XmlAdapter<JAXBMutableApiTestMethodResult, ApiTestMethodResult> {
        public ApiTestMethodResult unmarshal(JAXBMutableApiTestMethodResult jaxbMutableApiTestMethodResult) throws Exception {
            ArrayList<ApiTestMethodResult> embedded = new ArrayList<ApiTestMethodResult>();
            if (jaxbMutableApiTestMethodResult.getEmbedded() != null) {
                for (JAXBMutableApiTestMethodResult e : jaxbMutableApiTestMethodResult.getEmbedded()) {
                    ApiTestMethodResult converted = this.unmarshal(e);
                    embedded.add(converted);
                }
            }
            return new ApiTestMethodResult(jaxbMutableApiTestMethodResult.getMethodName(), jaxbMutableApiTestMethodResult.getDescription(), jaxbMutableApiTestMethodResult.getHardDependencies(), jaxbMutableApiTestMethodResult.getSoftDependencies(), embedded, jaxbMutableApiTestMethodResult.getLogLines(), jaxbMutableApiTestMethodResult.getApiCallDetails(), jaxbMutableApiTestMethodResult.getException(), jaxbMutableApiTestMethodResult.getState(), jaxbMutableApiTestMethodResult.getTimeMs(), jaxbMutableApiTestMethodResult.getStartTimeMs(), jaxbMutableApiTestMethodResult.getStopTimeMs());
        }

        public JAXBMutableApiTestMethodResult marshal(ApiTestMethodResult orig) throws Exception {
            ArrayList<JAXBMutableApiTestMethodResult> embedded = new ArrayList<JAXBMutableApiTestMethodResult>();
            for (ApiTestMethodResult e : orig.getEmbedded()) {
                JAXBMutableApiTestMethodResult converted = this.marshal(e);
                embedded.add(converted);
            }
            return new JAXBMutableApiTestMethodResult(orig.getMethodName(), orig.getDescription(), orig.getHardDependencies(), orig.getSoftDependencies(), embedded, orig.getLogLines(), orig.getApiCallDetails(), orig.getException(), orig.getState(), orig.getTimeMs(), orig.getStartTimeMs(), orig.getStopTimeMs());
        }
    }

    public static class JAXBMutableApiTestMethodResult {
        private String methodName;
        private String description;
        private List<String> hardDependencies;
        private List<String> softDependencies;
        private List<JAXBMutableApiTestMethodResult> embedded;
        private List<LogOutput.LogEntry> logLines;
        private List<SerializableApiCallDetails> apiCallDetails;
        private Throwable exception;
        private LogOutput.TestResultState state;
        private long startTimeMs;
        private long stopTimeMs;
        private long timeMs;

        public JAXBMutableApiTestMethodResult() {
        }

        public JAXBMutableApiTestMethodResult(String methodName, String description, List<String> hardDependencies, List<String> softDependencies, List<JAXBMutableApiTestMethodResult> embedded, List<LogOutput.LogEntry> logLines, List<SerializableApiCallDetails> apiCallDetails, Throwable exception, LogOutput.TestResultState state, long timeMs, long startTimeMs, long stopTimeMs) {
            this.methodName = methodName;
            this.description = description;
            this.hardDependencies = hardDependencies;
            this.softDependencies = softDependencies;
            this.embedded = embedded;
            this.logLines = logLines;
            this.apiCallDetails = apiCallDetails;
            this.exception = exception;
            this.state = state;
            this.startTimeMs = startTimeMs;
            this.stopTimeMs = stopTimeMs;
            this.timeMs = timeMs;
        }

        @XmlAttribute
        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @XmlAttribute
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @XmlAttribute
        public List<String> getHardDependencies() {
            return this.hardDependencies;
        }

        public void setHardDependencies(List<String> hardDependencies) {
            this.hardDependencies = hardDependencies;
        }

        @XmlAttribute
        public List<String> getSoftDependencies() {
            return this.softDependencies;
        }

        public List<JAXBMutableApiTestMethodResult> getEmbedded() {
            return this.embedded;
        }

        public void setSoftDependencies(List<String> softDependencies) {
            this.softDependencies = softDependencies;
        }

        @XmlElementWrapper(name="loglines")
        @XmlElement(name="logline")
        public List<LogOutput.LogEntry> getLogLines() {
            return this.logLines;
        }

        public void setLogLines(List<LogOutput.LogEntry> logLines) {
            this.logLines = logLines;
        }

        @XmlElementWrapper(name="apicalls")
        @XmlElement(name="apicall")
        public List<SerializableApiCallDetails> getApiCallDetails() {
            return this.apiCallDetails;
        }

        public void setApiCallDetails(List<SerializableApiCallDetails> apiCallDetails) {
            this.apiCallDetails = apiCallDetails;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        @XmlAttribute
        public LogOutput.TestResultState getState() {
            return this.state;
        }

        public void setState(LogOutput.TestResultState state) {
            this.state = state;
        }

        @XmlAttribute
        public long getStartTimeMs() {
            return this.startTimeMs;
        }

        public void setStartTimeMs(long startTimeMs) {
            this.startTimeMs = startTimeMs;
        }

        @XmlAttribute
        public long getStopTimeMs() {
            return this.stopTimeMs;
        }

        public void setStopTimeMs(long stopTimeMs) {
            this.stopTimeMs = stopTimeMs;
        }

        @XmlAttribute
        public long getTimeMs() {
            return this.timeMs;
        }

        public void setTimeMs(long timeMs) {
            this.timeMs = timeMs;
        }
    }
}

