/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTestRunner.class);
    @Nullable
    private final TargetAuthority testedAuthority;
    @Nonnull
    private final SerializableApiCallDetailsFactory serializableApiCallDetailsFactory;

    @Inject
    public AutomatedTestRunner(@Nullable TargetAuthority testedAuthority, @Nonnull SerializableApiCallDetailsFactory serializableApiCallDetailsFactory) {
        this.testedAuthority = testedAuthority;
        this.serializableApiCallDetailsFactory = serializableApiCallDetailsFactory;
    }

    private static DepNode findDepNode(String methodName, Collection<DepNode> depNodes) {
        for (DepNode d : depNodes) {
            if (!Objects.equals(d.m.getName(), methodName)) continue;
            return d;
        }
        return null;
    }

    private static DepNodeSortResult sortUsingDependancies(Map<Method, ApiTest.Test> methods, DependancyRetriever dependancyRetriever) {
        ArrayList<DepNode> unlinkedNodes = new ArrayList<DepNode>();
        for (Map.Entry<Method, ApiTest.Test> e : methods.entrySet()) {
            Method m = e.getKey();
            ApiTest.Test a = e.getValue();
            unlinkedNodes.add(new DepNode(m, a));
        }
        return AutomatedTestRunner.sortDepNodesUsingDependancies(unlinkedNodes, dependancyRetriever);
    }

    private static DepNodeSortResult sortUsingDependancies(List<Method> methods, DependancyRetriever dependancyRetriever) {
        ArrayList<DepNode> unlinkedNodes = new ArrayList<DepNode>();
        for (Method m : methods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = m.getDeclaredAnnotations()) {
                if (!(annotation instanceof ApiTest.Test)) continue;
                unlinkedNodes.add(new DepNode(m, (ApiTest.Test)annotation));
            }
        }
        return AutomatedTestRunner.sortDepNodesUsingDependancies(unlinkedNodes, dependancyRetriever);
    }

    private static DepNodeSortResult sortDepNodesUsingDependancies(List<DepNode> unlinkedNodes, DependancyRetriever dependancyRetriever) {
        ArrayList<DepNode> depNodes = new ArrayList<DepNode>(unlinkedNodes);
        for (DepNode d2 : unlinkedNodes) {
            List<DepNode> deps = dependancyRetriever.getDependancies(d2, depNodes);
            for (DepNode depNode : deps) {
                depNode.dependers.add(d2);
                d2.dependsOn.add(depNode);
            }
        }
        DepNodeSortResult res = new DepNodeSortResult();
        int prevSize = depNodes.size() + 1;
        while (depNodes.size() > 0 && depNodes.size() != prevSize) {
            prevSize = depNodes.size();
            List toRemove = depNodes.stream().filter(d -> d.dependsOn.isEmpty()).collect(Collectors.toList());
            ArrayList<Method> depMethList = new ArrayList<Method>();
            for (DepNode d3 : toRemove) {
                for (DepNode depender : d3.dependers) {
                    depender.dependsOn.remove(d3);
                }
                depMethList.add(d3.m);
            }
            res.methods.add(depMethList);
            depNodes.removeAll(toRemove);
        }
        if (depNodes.size() > 0) {
            res.hasCycle = true;
            ArrayList<Method> leftoverList = new ArrayList<Method>();
            for (DepNode depNode : depNodes) {
                for (DepNode depender : depNode.dependers) {
                    depender.dependsOn.remove(depNode);
                }
                leftoverList.add(depNode.m);
            }
            res.methods.add(leftoverList);
        } else {
            res.hasCycle = false;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<Method, ApiTest.Test> filterUsingGroup(Map<Method, ApiTest.Test> methods, DependancyRetriever dependancyRetriever, String group) {
        void var5_9;
        ArrayList<DepNode> unlinkedNodes = new ArrayList<DepNode>();
        for (Map.Entry<Method, ApiTest.Test> entry : methods.entrySet()) {
            Method m = entry.getKey();
            ApiTest.Test a = entry.getValue();
            unlinkedNodes.add(new DepNode(m, a));
        }
        ArrayList<DepNode> allDepNodes = new ArrayList<DepNode>(unlinkedNodes);
        for (DepNode d2 : unlinkedNodes) {
            List<DepNode> deps = dependancyRetriever.getDependancies(d2, allDepNodes);
            for (DepNode other : deps) {
                other.dependers.add(d2);
                d2.dependsOn.add(other);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (group != null) {
            List toAdd = allDepNodes.stream().filter(d -> d.groups.contains(group)).collect(Collectors.toList());
            arrayList.addAll(toAdd);
            if (toAdd.isEmpty()) {
                throw new RuntimeException("Error: group \"" + group + "\" not found. No tests to run.");
            }
            while (!toAdd.isEmpty()) {
                ArrayList adding = new ArrayList(toAdd);
                toAdd.clear();
                for (DepNode d3 : adding) {
                    for (DepNode dd : d3.dependsOn) {
                        if (arrayList.contains(dd) || toAdd.contains(dd)) continue;
                        arrayList.add(dd);
                        toAdd.add(dd);
                    }
                }
            }
        } else {
            ArrayList<DepNode> arrayList2 = allDepNodes;
        }
        HashMap<Method, ApiTest.Test> res = new HashMap<Method, ApiTest.Test>();
        for (DepNode depNode : var5_9) {
            res.put(depNode.m, depNode.a);
        }
        return res;
    }

    public ApiTestResult runTest(@Nonnull ApiTest test, @Nullable String group, @Nullable TestListener listener, boolean fake) {
        ApiTestResult result = new ApiTestResult(this.testedAuthority, test.getUser(), test.getClass(), group);
        return this.runTest(test, group, listener, fake, result);
    }

    public ApiTestResult runTest(@Nonnull ApiTest test, @Nullable String group, @Nullable TestListener listener, boolean fake, @Nonnull ApiTestResult result) {
        int retValue;
        Map<Method, ApiTest.Test> testMethods = new HashMap<Method, ApiTest.Test>();
        List<Method> methods = Arrays.asList(test.getClass().getMethods());
        for (Method m : methods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = m.getDeclaredAnnotations()) {
                if (!(annotation instanceof ApiTest.Test)) continue;
                testMethods.put(m, (ApiTest.Test)annotation);
            }
        }
        List<String> allMethodNames = methods.stream().map(Method::getName).collect(Collectors.toList());
        DependancyRetriever bothDependancyRetriever = new DependancyRetriever(){
            List<String> allowedMissingMethodnames;

            public DependancyRetriever init(List<String> allowedMissingMethodnames) {
                this.allowedMissingMethodnames = allowedMissingMethodnames;
                return this;
            }

            @Override
            public List<DepNode> getDependancies(DepNode node, List<DepNode> allDepNodes) {
                DepNode other;
                String[] hardDeps = node.a.hardDepends();
                String[] softDeps = node.a.softDepends();
                ArrayList<DepNode> res = new ArrayList<DepNode>();
                for (String hardDep : hardDeps) {
                    other = AutomatedTestRunner.findDepNode(hardDep, allDepNodes);
                    if (other == null && !this.allowedMissingMethodnames.contains(hardDep)) {
                        throw new RuntimeException("Test Method \"" + node.m.getName() + "\" hard depends on unknown method \"" + hardDep + "\"");
                    }
                    if (other == null) continue;
                    res.add(other);
                }
                for (String softDep : softDeps) {
                    other = AutomatedTestRunner.findDepNode(softDep, allDepNodes);
                    if (other == null && !this.allowedMissingMethodnames.contains(softDep)) {
                        throw new RuntimeException("Test Method \"" + node.m.getName() + "\" soft depends on unknown method \"" + softDep + "\"");
                    }
                    if (other == null) continue;
                    res.add(other);
                }
                return res;
            }
        }.init(allMethodNames);
        DependancyRetriever hardDependancyRetriever = new DependancyRetriever(){
            List<String> allowedMissingMethodnames;

            public DependancyRetriever init(List<String> allowedMissingMethodnames) {
                this.allowedMissingMethodnames = allowedMissingMethodnames;
                return this;
            }

            @Override
            public List<DepNode> getDependancies(DepNode node, List<DepNode> allDepNodes) {
                String[] hardDeps = node.a.hardDepends();
                ArrayList<DepNode> res = new ArrayList<DepNode>();
                for (String hardDep : hardDeps) {
                    DepNode other = AutomatedTestRunner.findDepNode(hardDep, allDepNodes);
                    if (other == null && !this.allowedMissingMethodnames.contains(hardDep)) {
                        throw new RuntimeException("Test Method \"" + node.m.getName() + "\" depends on unknown method \"" + hardDep + "\"");
                    }
                    if (other == null) continue;
                    res.add(other);
                }
                return res;
            }
        }.init(allMethodNames);
        DependancyRetriever allowingSoftDependancyRetriever = (node, allDepNodes) -> {
            String[] softDeps = node.a.softDepends();
            ArrayList<DepNode> res = new ArrayList<DepNode>();
            for (String softDep : softDeps) {
                DepNode other = AutomatedTestRunner.findDepNode(softDep, allDepNodes);
                if (other == null) continue;
                res.add(other);
            }
            return res;
        };
        if (group != null) {
            testMethods = AutomatedTestRunner.filterUsingGroup(testMethods, hardDependancyRetriever, group);
        }
        DepNodeSortResult hardSortRes = AutomatedTestRunner.sortUsingDependancies(testMethods, bothDependancyRetriever);
        if (hardSortRes.hasCycle) {
            List<Method> cycleMethods = hardSortRes.methods.get(hardSortRes.methods.size() - 1);
            Object cycleMethodsString = "";
            for (Method m : cycleMethods) {
                if (!((String)cycleMethodsString).isEmpty()) {
                    cycleMethodsString = (String)cycleMethodsString + "\n";
                }
                cycleMethodsString = (String)cycleMethodsString + " - " + m.getName();
            }
            throw new RuntimeException("There are cycles in the dependency graph! Methods in cycle:\n" + (String)cycleMethodsString);
        }
        ArrayList sortedTestMethods = new ArrayList();
        for (List list : hardSortRes.methods) {
            sortedTestMethods.addAll(list);
        }
        ApiTestResult.ApiTestMethodResult setupRes = new ApiTestResult.ApiTestMethodResult("setUp", "Test Class setup", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), System.currentTimeMillis());
        ResultListener resultListener = sresult -> setupRes.apiCallDetails.add(this.serializableApiCallDetailsFactory.createFromApiCallDetails(sresult));
        test.getLogger().addResultListener(resultListener);
        try {
            if (listener != null) {
                listener.onStart(setupRes.getMethodName(), 0, sortedTestMethods.size());
            }
        }
        catch (AssertionError t) {
            LOG.error("AssertionError in RunTests.runTest listener.onStart: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)((Object)t));
        }
        catch (Exception t) {
            LOG.error("Exception in RunTests.runTest listener.onStart: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)t);
        }
        setupRes.stopTimeMs = 0L;
        test.setCurrentTestResult(setupRes);
        try {
            setupRes.state = LogOutput.TestResultState.SUCCESS;
            if (!fake) {
                test.setUp();
            } else {
                test.note("\"fake\" set, setup not really called");
            }
            setupRes.stopTimeMs = System.currentTimeMillis();
        }
        catch (AssertionError ex) {
            setupRes.stopTimeMs = System.currentTimeMillis();
            setupRes.exception = ex;
            setupRes.addLogLine(LogOutput.LogLineType.EXCEPTION, "Caught AssertionError while executing tst class setup: " + ((Throwable)((Object)ex)).getMessage());
            setupRes.state = LogOutput.TestResultState.FAILED;
        }
        catch (Exception ex) {
            setupRes.stopTimeMs = System.currentTimeMillis();
            setupRes.exception = ex;
            setupRes.addLogLine(LogOutput.LogLineType.EXCEPTION, "Caught exception while executing tst class setup: " + ex.getMessage());
            setupRes.state = LogOutput.TestResultState.FAILED;
        }
        setupRes.timeMs = setupRes.stopTimeMs - setupRes.startTimeMs;
        test.getLogger().removeResultListener(resultListener);
        result.resultList.add(setupRes);
        try {
            if (listener != null) {
                listener.onResult(setupRes, 0, sortedTestMethods.size());
            }
        }
        catch (AssertionError t) {
            LOG.error("AssertionError in RunTests.runTest listener.onResult: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)((Object)t));
        }
        catch (Exception t) {
            LOG.error("Exception in RunTests.runTest listener.onResult: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)t);
        }
        if (!Objects.equals(setupRes.getState(), LogOutput.TestResultState.SUCCESS)) {
            result.returnValue = 2;
            if (listener != null) {
                listener.onAllTestDone(result, sortedTestMethods.size());
            }
            return result;
        }
        boolean allSuccessful = true;
        boolean allMaxWarn = true;
        ArrayList<String> failList = new ArrayList<String>();
        int testNr = 1;
        for (Method m : sortedTestMethods) {
            ApiTestResult.ApiTestMethodResult res;
            ApiTest.Test a = testMethods.get(m);
            ApiTestResult.ApiTestMethodResult skipRes = new ApiTestResult.ApiTestMethodResult(m.getName(), a.description(), Arrays.asList(a.softDepends()), Arrays.asList(a.hardDepends()), Collections.emptyList(), System.currentTimeMillis());
            boolean skip = false;
            for (String hardDep : a.hardDepends()) {
                if (!failList.contains(hardDep)) continue;
                skipRes.addLogLine(LogOutput.LogLineType.NOTE, "Test method skipped because hard dependency has failed: " + hardDep);
                skip = true;
            }
            if (!Objects.equals(a.dataProvider(), "")) {
                LOG.error("TODO: implement dataProvider support or rework tests and remove it");
                skipRes.addLogLine(LogOutput.LogLineType.NOTE, "Test method skipped because it uses dataProvider which is currently not supported. (needs to be implemented)");
                skip = true;
            }
            try {
                if (listener != null) {
                    listener.onStart(m.getName(), testNr, sortedTestMethods.size());
                }
            }
            catch (AssertionError t) {
                LOG.error("AssertionError in RunTests.runTest listener.onStart: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)((Object)t));
            }
            catch (Exception t) {
                LOG.error("Exception in RunTests.runTest listener.onStart: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)t);
            }
            if (!skip) {
                test.setErrorsFatal();
                res = new ApiTestResult.ApiTestMethodResult(m.getName(), a.description(), Arrays.asList(a.softDepends()), Arrays.asList(a.hardDepends()), Collections.emptyList(), System.currentTimeMillis());
                result.resultList.add(res);
                AutomatedTestRunner.runSingleTest(res, test, m, a, fake, this.serializableApiCallDetailsFactory);
                if (res.state == null) {
                    res.addLogLine(LogOutput.LogLineType.ERROR, "BUG: No result detected for method: falling back to FAILED");
                    res.state = LogOutput.TestResultState.FAILED;
                }
            } else {
                skipRes.stopTimeMs = System.currentTimeMillis();
                skipRes.timeMs = 0L;
                skipRes.exception = null;
                skipRes.state = LogOutput.TestResultState.SKIPPED;
                res = skipRes;
                result.resultList.add(res);
            }
            boolean skipHardDeps = false;
            if (res.state != null) {
                switch (res.state) {
                    case FAILED: {
                        allSuccessful = false;
                        allMaxWarn = false;
                        skipHardDeps = true;
                        break;
                    }
                    case SKIPPED: {
                        allSuccessful = false;
                        allMaxWarn = false;
                        skipHardDeps = true;
                        break;
                    }
                    case WARN: {
                        allSuccessful = false;
                        break;
                    }
                }
            }
            if (skipHardDeps) {
                failList.add(m.getName());
            }
            try {
                if (listener != null) {
                    listener.onResult(res, testNr, sortedTestMethods.size());
                }
            }
            catch (AssertionError t) {
                LOG.error("AssertionError in RunTests.runTest listener.onResult: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)((Object)t));
            }
            catch (Exception t) {
                LOG.error("Exception in RunTests.runTest listener.onResult: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)t);
            }
            ++testNr;
        }
        int n = retValue = allMaxWarn ? 1 : 2;
        if (allSuccessful) {
            retValue = 0;
        }
        result.returnValue = retValue;
        try {
            if (listener != null) {
                listener.onAllTestDone(result, sortedTestMethods.size());
            }
        }
        catch (AssertionError t) {
            LOG.error("AssertionError in RunTests.runTest listener.onAllTestDone: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)((Object)t));
        }
        catch (Exception t) {
            LOG.error("Exception in RunTests.runTest listener.onAllTestDone: will be ignored as it won't affect the tests, but it is likely a bug.", (Throwable)t);
        }
        return result;
    }

    private static void runSingleTest(ApiTestResult.ApiTestMethodResult res, ApiTest test, Method method, ApiTest.Test annotation, boolean fake, SerializableApiCallDetailsFactory serializableApiCallDetailsFactory) {
        ResultListener resultListener = result -> res.apiCallDetails.add(serializableApiCallDetailsFactory.createFromApiCallDetails(result));
        test.getLogger().addResultListener(resultListener);
        res.stopTimeMs = 0L;
        test.setCurrentTestResult(res);
        test.setErrorsFatal();
        try {
            try {
                res.state = LogOutput.TestResultState.SUCCESS;
                if (!fake) {
                    Object[] args = new Object[]{};
                    method.invoke((Object)test, args);
                } else {
                    test.note("\"fake\" set: method not really called");
                }
            }
            catch (IllegalAccessException e1) {
                LOG.error("RunTest bug: IllegalAccessException in runSingleTest", (Throwable)e1);
                e1.printStackTrace();
                res.exception = e1;
            }
            catch (InvocationTargetException e1) {
                if (e1.getCause() != null) {
                    if (e1.getCause() instanceof Exception) {
                        throw (Exception)e1.getCause();
                    }
                    if (e1.getCause() instanceof Error) {
                        throw (Error)e1.getCause();
                    }
                    LOG.error("Throwable is neither Exception or Error?!?", e1.getCause());
                    throw e1;
                }
                LOG.error("RunTest bug: InvocationTargetException in runSingleTest", (Throwable)e1);
                e1.printStackTrace();
                res.exception = e1;
                throw e1;
            }
        }
        catch (SkipTestException ex) {
            res.exception = ex;
            res.state = LogOutput.TestResultState.SKIPPED;
            if (Objects.equals(ex.getMessage(), "")) {
                res.addLogLine(LogOutput.LogLineType.NOTE, "Test method requested test to be skipped");
            } else {
                res.addLogLine(LogOutput.LogLineType.NOTE, "Test method requested test to be skipped, reason: " + ex.getMessage());
            }
        }
        catch (AssertionError ex) {
            res.exception = ex;
            res.addLogLine(LogOutput.LogLineType.FATAL_ERROR, ((Throwable)((Object)ex)).getMessage() == null ? "" : ((Throwable)((Object)ex)).getMessage());
            res.state = LogOutput.TestResultState.FAILED;
        }
        catch (JFedException ex) {
            res.exception = ex;
            res.addLogLine(LogOutput.LogLineType.EXCEPTION, "Caught exception while executing test: " + ex.getMessage());
            res.state = LogOutput.TestResultState.FAILED;
            if (ex.getXmlRpcResult() != null) {
                XMLRPCCallDetails xmlRes = ex.getXmlRpcResult();
                res.apiCallDetails.add(serializableApiCallDetailsFactory.createFromApiCallDetails(new ApiCallDetails(null, null, null, null, null, xmlRes.getConnectionConfig(), xmlRes.getServerUrl(), null, null, null, null, null, xmlRes.getRequestHttpRequestLine(), xmlRes.getRequestHttpHeaders(), xmlRes.getRequestHttpContent(), xmlRes.getResultHttpStatusLine(), xmlRes.getResultHttpHeaders(), xmlRes.getResultHttpContent(), xmlRes.getRequest(), xmlRes.getResultValueObject(), null, xmlRes.getStartTime(), xmlRes.getStopTime(), xmlRes.getException())));
            }
        }
        catch (Exception ex) {
            res.exception = ex;
            res.addLogLine(LogOutput.LogLineType.EXCEPTION, "Caught exception while executing test: " + ex.getMessage());
            res.state = LogOutput.TestResultState.FAILED;
        }
        catch (ThreadDeath err) {
            res.state = LogOutput.TestResultState.FAILED;
            res.exception = err;
            res.addLogLine(LogOutput.LogLineType.EXCEPTION, "Test was forcfully stopped: " + err.getMessage());
            throw err;
        }
        catch (Error err) {
            res.state = LogOutput.TestResultState.FAILED;
            res.exception = err;
            res.addLogLine(LogOutput.LogLineType.EXCEPTION, "Fatal error occured during test: " + err.getMessage());
            throw err;
        }
        finally {
            res.stopTimeMs = System.currentTimeMillis();
            res.timeMs = res.stopTimeMs - res.startTimeMs;
            test.setErrorsFatal();
            test.getLogger().removeResultListener(resultListener);
        }
    }

    private static class DepNode {
        public List<DepNode> dependsOn = new ArrayList<DepNode>();
        public List<DepNode> dependers = new ArrayList<DepNode>();
        public List<String> groups;
        public Method m;
        public ApiTest.Test a;
        public String mName;

        public DepNode(Method m, ApiTest.Test a) {
            this.m = m;
            this.a = a;
            this.mName = m.getName();
            this.groups = new ArrayList<String>();
            Collections.addAll(this.groups, a.groups());
        }
    }

    private static interface DependancyRetriever {
        public List<DepNode> getDependancies(DepNode var1, List<DepNode> var2);
    }

    private static class DepNodeSortResult {
        List<List<Method>> methods = new ArrayList<List<Method>>();
        boolean hasCycle = false;

        private DepNodeSortResult() {
        }
    }

    public static interface TestListener {
        public void onStart(String var1, int var2, int var3);

        public void onResult(ApiTestResult.ApiTestMethodResult var1, int var2, int var3);

        public void onAllTestDone(ApiTestResult var1, int var2);
    }

    static class SkipTestException
    extends RuntimeException {
        SkipTestException(String reason) {
            super(reason);
        }

        SkipTestException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

