/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.base;

import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LegacyApiTestConfigEditor
implements ApiTestConfigEditor<LegacyApiTestConfig> {
    @Nonnull
    private final LegacyApiTestMetaData legacyApiTestMetaData;
    @Nonnull
    private Properties res = new Properties();

    public LegacyApiTestConfigEditor(@Nonnull LegacyApiTestMetaData legacyApiTestMetaData) {
        this.legacyApiTestMetaData = legacyApiTestMetaData;
    }

    @Override
    @Nonnull
    public List<ApiTestConfigEditor.ApiTestConfigParameter> getParameters() {
        ArrayList<ApiTestConfigEditor.ApiTestConfigParameter> res = new ArrayList<ApiTestConfigEditor.ApiTestConfigParameter>();
        for (String reqKey : this.legacyApiTestMetaData.getReqConfKeys()) {
            res.add(new ApiTestConfigEditor.ApiTestConfigParameter(Collections.singletonList(reqKey), "no description", String.class, null, false, null));
        }
        for (String reqKey : this.legacyApiTestMetaData.getOptConfKeys()) {
            res.add(new ApiTestConfigEditor.ApiTestConfigParameter(Collections.singletonList(reqKey), "no description", String.class, null, true, null));
        }
        return res;
    }

    @Override
    public void setParameter(@Nonnull ApiTestConfigEditor.ApiTestConfigParameter parameter, @Nullable Object value) {
        if (value == null) {
            this.res.remove(parameter.getLastName());
        } else {
            this.res.setProperty(parameter.getLastName(), String.valueOf(value));
        }
    }

    @Override
    @Nullable
    public Object getParameter(@Nonnull ApiTestConfigEditor.ApiTestConfigParameter parameter) {
        return this.res.getProperty(parameter.getLastName());
    }

    @Override
    public void setConfig(@Nonnull LegacyApiTestConfig apiTestConfig) {
        this.res = apiTestConfig.getProperties();
    }

    @Override
    @Nonnull
    public LegacyApiTestConfig build() {
        return new LegacyApiTestConfig(this.res, this.legacyApiTestMetaData);
    }
}

