/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTestExternalExecutableLocationsImpl
implements AutomatedTestExternalExecutableLocations {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTestExternalExecutableLocationsImpl.class);
    @Nonnull
    private final Map<String, File> exeMapping = new HashMap<String, File>();
    @Nullable
    private final PropConfig config;

    public AutomatedTestExternalExecutableLocationsImpl(@Nullable PropConfig config) {
        this.config = config;
    }

    @Inject
    public AutomatedTestExternalExecutableLocationsImpl() {
        this.config = null;
    }

    @Override
    @Nonnull
    public File getExe(@Nonnull String exeName) {
        if (!this.exeMapping.containsKey(exeName)) {
            throw new IllegalStateException("bug: requireExe(\"" + exeName + "\") should have been called earlier");
        }
        return this.exeMapping.get(exeName);
    }

    @Override
    public void requireExe(@Nonnull String exeName) throws AutomatedTestExternalExecutableLocations.ExecutableNotFoundException {
        File exeLoc = AutomatedTestExternalExecutableLocationsImpl.findExecutableLocation(exeName, this.config);
        this.exeMapping.put(exeName, exeLoc);
    }

    @Nonnull
    private static File findExecutableLocation(@Nonnull String command, @Nullable PropConfig config) throws AutomatedTestExternalExecutableLocations.ExecutableNotFoundException {
        String key = command.toLowerCase().replaceAll("[^a-zA-Z0-9]*", "");
        String exe = config == null ? null : config.getProperty(key + "Exe");
        String res = exe != null ? exe : null;
        if (res == null) {
            res = AutomatedTestExternalExecutableLocationsImpl.getWhichOutput(command);
        }
        if (res == null) {
            throw new AutomatedTestExternalExecutableLocations.ExecutableNotFoundException("Executable for \"" + command + "\" was not found.");
        }
        File resFile = new File(res);
        if (!resFile.exists()) {
            throw new AutomatedTestExternalExecutableLocations.ExecutableNotFoundException("Executable for \"" + command + "\" at \"" + res + "\" was not found.");
        }
        return resFile;
    }

    @Nullable
    private static String getWhichOutput(@Nonnull String command) {
        try {
            String line;
            Process cmdProc = Runtime.getRuntime().exec("which " + command);
            Object out = "";
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
            while ((line = stdoutReader.readLine()) != null) {
                out = (String)out + line;
            }
            stdoutReader.close();
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(cmdProc.getErrorStream()));
            while ((line = stderrReader.readLine()) != null) {
                out = (String)out + line;
            }
            stderrReader.close();
            try {
                cmdProc.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException in getWhichOutput", (Throwable)e);
            }
            int retValue = cmdProc.exitValue();
            if (retValue != 0) {
                return null;
            }
            return out;
        }
        catch (Exception e) {
            LOG.error("Failure during \"which " + command + "\". Will assume command is not found.", (Throwable)e);
            return null;
        }
    }

    public static interface PropConfig {
        @Nullable
        public String getProperty(@Nonnull String var1);
    }
}

