/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLoginTestStepConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLoginTestStepConfig.class);
    @Nonnull
    private final SSHKeySource sshKeySource;
    @Nullable
    private final PublicKey publicKey;
    @Nullable
    private final PrivateKey privateKey;
    private boolean useExternalSsh;
    @Nonnull
    private Proxy proxyConfig;
    private long nodeLoginDeadlineMs;
    @Nullable
    private String preferredUser = null;
    @Nullable
    private Integer nodeLoginForceIpVersion = null;

    public NodeLoginTestStepConfig(@Nonnull SSHKeySource sshKeySource, @Nullable PublicKey publicKey, @Nullable PrivateKey privateKey, boolean useExternalSsh, @Nonnull Proxy proxyConfig, long nodeLoginDeadlineMs, @Nullable String preferredUser, @Nullable Integer nodeLoginForceIpVersion) {
        this.sshKeySource = sshKeySource;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.useExternalSsh = useExternalSsh;
        this.proxyConfig = proxyConfig;
        this.nodeLoginDeadlineMs = nodeLoginDeadlineMs;
        this.preferredUser = preferredUser;
        this.nodeLoginForceIpVersion = nodeLoginForceIpVersion;
    }

    public NodeLoginTestStepConfig(@Nonnull String publicKeyPemContent, @Nonnull String privateKeyPemContent, @Nullable String privateKeyPemPass, boolean useExternalSsh, @Nonnull Proxy proxyConfig, long nodeLoginDeadlineMs, @Nullable String preferredUser, @Nullable Integer nodeLoginForceIpVersion) {
        this.sshKeySource = SSHKeySource.PROVIDED;
        this.useExternalSsh = useExternalSsh;
        this.proxyConfig = proxyConfig;
        this.nodeLoginDeadlineMs = nodeLoginDeadlineMs;
        this.preferredUser = preferredUser;
        this.nodeLoginForceIpVersion = nodeLoginForceIpVersion;
        try {
            boolean isCertificate = KeyUtil.hasX509Certificate((String)publicKeyPemContent);
            boolean isOpenSsl = KeyUtil.isOpenSshFormatRsaPublicKey((String)publicKeyPemContent);
            if (!isCertificate && !isOpenSsl) {
                throw new RuntimeException("Problem determining public key format: neither opensSH format pubkey, or X509 certificate found in PEM.");
            }
            PublicKey publicKey = null;
            if (isOpenSsl) {
                publicKey = KeyUtil.openSshAuthorizedKeysFormatRsaPublicKey((String)publicKeyPemContent);
            }
            if (isCertificate) {
                X509Certificate cert = KeyUtil.pemToX509Certificate((String)publicKeyPemContent);
                if (cert == null) {
                    throw new RuntimeException("Problem while reading public key from certificate.");
                }
                publicKey = cert.getPublicKey();
            }
            assert (publicKey != null);
            this.publicKey = publicKey;
            this.privateKey = KeyUtil.pemToRsaPrivateKey((String)privateKeyPemContent, (char[])(privateKeyPemPass == null ? null : privateKeyPemPass.toCharArray()));
            if (this.publicKey == null) {
                throw new RuntimeException("Public key not found in PEM");
            }
            if (this.privateKey == null) {
                throw new RuntimeException("Private key not found in PEM");
            }
        }
        catch (Exception e) {
            LOG.error("Exception while reading key: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Exception while reading key: " + e.getMessage(), e);
        }
    }

    @Nonnull
    public SSHKeySource getSshKeySource() {
        return this.sshKeySource;
    }

    @Nullable
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isUseExternalSsh() {
        return this.useExternalSsh;
    }

    @Nonnull
    public Proxy getProxyConfig() {
        return this.proxyConfig;
    }

    public long getNodeLoginDeadlineMs() {
        return this.nodeLoginDeadlineMs;
    }

    @Nullable
    public String getPreferredUser() {
        return this.preferredUser;
    }

    @Nullable
    public Integer getNodeLoginForceIpVersion() {
        return this.nodeLoginForceIpVersion;
    }

    @Nonnull
    public static NodeLoginTestStepConfig generateFromLegacyConfig(@Nonnull ApiTest test, @Nonnull LegacyApiTestConfig config, @Nonnull GeniUserProvider geniUserProvider) {
        Proxy proxyConfig;
        String mode;
        Boolean useExternalSsh;
        Integer nodeLoginForceIpVersion;
        String nodeLoginDeadlineMsString = config.getProperty("nodelogin_deadline_ms");
        long nodeLoginDeadlineMs = nodeLoginDeadlineMsString != null ? Long.parseLong(nodeLoginDeadlineMsString.trim()) : 1200000L;
        String nodeloginPreferredUser = config.getProperty("nodelogin_preferred_user");
        String nodeloginForceIpVersionString = config.getProperty("nodelogin_force_ip_version");
        if (nodeloginForceIpVersionString != null) {
            try {
                nodeLoginForceIpVersion = Integer.parseInt(nodeloginForceIpVersionString);
            }
            catch (NumberFormatException e) {
                test.warn("nodelogin_force_ip_version property is set to invalid value: \"" + nodeloginForceIpVersionString + "\". Supported: 4 or 6");
                nodeLoginForceIpVersion = null;
            }
        } else {
            nodeLoginForceIpVersion = null;
        }
        if ((useExternalSsh = TextUtil.objectToBoolean((Object)config.getProperty("nodelogin_use_external_ssh"))) == null) {
            useExternalSsh = false;
        }
        if (config.get("sshProxyHostName") != null) {
            throw new IllegalStateException("old sshProxyHostName option is no longer not supported");
        }
        if (config.get("loginSshProxyMode") != null) {
            mode = config.getProperty("loginSshProxyMode");
            if (!(Objects.equals(mode, "manual") || Objects.equals(mode, "user") || Objects.equals(mode, "off"))) {
                throw new IllegalStateException("loginSshProxyMode=\"" + mode + "\" not supported");
            }
        } else {
            mode = null;
        }
        if (Objects.equals(mode, "manual")) {
            String sshProxyHostName = (String)config.get("loginSshProxyHostName");
            int sshProxyHostPort = Integer.parseInt(String.valueOf(config.get("loginSshProxyHostPort")));
            String sshProxyHostKey = (String)config.get("loginSshProxyHostKey");
            String username = (String)config.get("loginSshProxyUsername");
            Proxy.ProxyKeySource keySource = null;
            String sshProxyKeySource = (String)config.get("loginSshProxyKeySource");
            Object sshKeyInfo = null;
            if (sshProxyKeySource != null && sshProxyKeySource.equalsIgnoreCase("user")) {
                test.note("Using user private key as proxy private key.");
                keySource = Proxy.ProxyKeySource.USER;
            }
            if (sshProxyKeySource != null && sshProxyKeySource.equalsIgnoreCase("node")) {
                test.note("Using node private key as proxy private key.");
                keySource = Proxy.ProxyKeySource.NODE;
            }
            if (keySource == null) {
                throw new IllegalStateException("loginSshProxyKeySource=\"" + sshProxyKeySource + "\" not supported");
            }
            proxyConfig = new Proxy(Proxy.ProxyMode.MANUAL, sshProxyHostName, sshProxyHostKey, sshProxyHostPort, username, keySource);
        } else {
            proxyConfig = Objects.equals(mode, "user") ? new Proxy(Proxy.ProxyMode.USER_AUTHORITY, null, null, null, null, null) : new Proxy(Proxy.ProxyMode.OFF, null, null, null, null, null);
        }
        String fixedSshPublicKeyFile = config.getProperty("fixed_ssh_public_key_file");
        String fixedSshPrivateKeyFile = config.getProperty("fixed_ssh_private_key_file");
        String fixedSshPrivateKeyPassword = config.getProperty("fixed_ssh_private_key_password");
        if (fixedSshPublicKeyFile == null != (fixedSshPrivateKeyFile == null)) {
            throw new IllegalStateException("fixed_ssh_public_key_file and fixed_ssh_private_key_file should either both be null, or neither should be null");
        }
        if (fixedSshPublicKeyFile != null) {
            String fixedSshPrivateKeyFileContent;
            String fixedSshPublicKeyFileContent;
            try {
                fixedSshPublicKeyFileContent = IOUtils.fileToString((String)fixedSshPublicKeyFile);
                fixedSshPrivateKeyFileContent = IOUtils.fileToString((String)fixedSshPrivateKeyFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read one of the SSH key files for the node login test setup", e);
            }
            return new NodeLoginTestStepConfig(fixedSshPublicKeyFileContent, fixedSshPrivateKeyFileContent, fixedSshPrivateKeyPassword, (boolean)useExternalSsh, proxyConfig, nodeLoginDeadlineMs, nodeloginPreferredUser, nodeLoginForceIpVersion);
        }
        return new NodeLoginTestStepConfig(SSHKeySource.RANDOM, null, null, (boolean)useExternalSsh, proxyConfig, nodeLoginDeadlineMs, nodeloginPreferredUser, nodeLoginForceIpVersion);
    }

    public static enum SSHKeySource {
        PROVIDED,
        RANDOM;

    }
}

