/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui;

import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.ProbeController;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class CommandParameterModel<T> {
    protected final Class parameterClass;
    protected final ApiMethodParameter annotation;
    protected final ProbeController.MethodInfo methodInfo;
    private final boolean required;
    private final BooleanProperty included = new SimpleBooleanProperty(true);
    private final StringProperty parameterName = new SimpleStringProperty();
    private final ObjectProperty<T> value = new SimpleObjectProperty(null);

    public CommandParameterModel(String parameterName, Class<T> parameterClass, ApiMethodParameter annotation, ProbeController.MethodInfo methodInfo) {
        assert (parameterName != null);
        assert (parameterClass != null);
        assert (annotation != null);
        assert (methodInfo != null);
        this.parameterName.set((Object)parameterName);
        this.parameterClass = parameterClass;
        this.annotation = annotation;
        this.methodInfo = methodInfo;
        this.required = annotation.required();
        if (annotation.guiDefault() != null) {
            if (Objects.equals(parameterClass, String.class)) {
                this.value.set((Object)annotation.guiDefault());
            }
            if (Objects.equals(parameterClass, Integer.class)) {
                this.value.set((Object)Integer.parseInt(annotation.guiDefault()));
            }
            if (Objects.equals(parameterClass, Double.class)) {
                this.value.set((Object)new Double(Double.parseDouble(annotation.guiDefault())));
            }
            if (Objects.equals(parameterClass, Long.class)) {
                this.value.set((Object)new Long(Long.parseLong(annotation.guiDefault())));
            }
        }
        if (!this.required) {
            this.included.set(annotation.guiDefaultOptional());
        }
    }

    public BooleanProperty includedProperty() {
        return this.included;
    }

    public StringProperty nameProperty() {
        return this.parameterName;
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public String getParameterName() {
        return (String)this.parameterName.get();
    }

    public Class getParameterClass() {
        return this.parameterClass;
    }

    public ApiMethodParameter getAnnotation() {
        return this.annotation;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ProbeController.MethodInfo getMethodInfo() {
        return this.methodInfo;
    }
}

