/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui;

import be.iminds.ilabt.jfed.base_gui.BaseGuiModule;
import be.iminds.ilabt.jfed.base_gui.UncaughtGuiExceptionLogger;
import be.iminds.ilabt.jfed.base_gui.util.GuiceContext;
import be.iminds.ilabt.jfed.highlevel.HighLevelModule;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule;
import be.iminds.ilabt.jfed.highlevel.UserLoginModelModule;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.SshAgentHelper;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.ProbeFactory;
import be.iminds.ilabt.jfed.ui.javafx.userlogin.AdvancedUserLoginDialog;
import be.iminds.ilabt.jfed.ui.javafx.util.ExtraInfoCallBackGUIs;
import com.google.inject.AbstractModule;
import java.security.Security;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedProbeStandalone
extends Application
implements GeniUserProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JFedProbeStandalone.class);
    public static boolean debugEnabled = false;
    private final GuiceContext context = new GuiceContext((Object)this, () -> {
        ArrayList<1> modules = new ArrayList<1>();
        modules.add(new AbstractModule(){

            protected void configure() {
                this.bind(GeniUserProvider.class).toInstance((Object)JFedProbeStandalone.this);
            }
        });
        modules.add(new HighLevelModule());
        modules.add(new SfaOnlyExperimentModule());
        modules.add(new LowLevelModule());
        modules.add(new UserLoginModelModule(false));
        modules.add(new BaseGuiModule());
        return modules;
    });
    @Inject
    private Provider<AdvancedUserLoginDialog> advancedUserLoginDialogProvider;
    @Inject
    private ProbeFactory probeFactory;
    @Inject
    private TaskThread tt;
    private GeniUser loggedInGeniUser;

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("debug") && !arg.equalsIgnoreCase("--debug") && !arg.equalsIgnoreCase("-debug")) continue;
            debugEnabled = true;
        }
        JFedProbeStandalone.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)UncaughtGuiExceptionLogger.getInstance((Stage)stage));
        this.context.init();
        ExtraInfoCallBackGUIs.prepareExtraInfoCallback((Window)stage);
        stage.setOnCloseRequest(event -> this.exit());
        this.loggedInGeniUser = ((AdvancedUserLoginDialog)this.advancedUserLoginDialogProvider.get()).showUserLogin((Window)stage);
        this.probeFactory.showProbe(stage);
    }

    public void exit() {
        LOG.info("Close was requested. Trying to terminate");
        this.tt.requestStop();
        try {
            SshAgentHelper.stopSshAgent();
        }
        catch (SshAgentHelper.SshAgentHelperException e) {
            LOG.error("Failed to stop SSH agent. Will ignore this and continue jFed shutdown.", (Throwable)e);
        }
        Platform.exit();
        System.exit(0);
    }

    @Override
    @Nonnull
    public GeniUser getLoggedInGeniUser() {
        return this.loggedInGeniUser;
    }

    @Override
    public boolean isUserLoggedIn() {
        return this.loggedInGeniUser != null;
    }

    static {
        System.setProperty("java.awt.headless", "false");
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL");
    }
}

