/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnumArgumentChooser<E extends Enum>
extends CommandArgumentChooser<E>
implements Initializable {
    @FXML
    private ComboBox<String> valueField;
    @Nonnull
    private final Class<E> enumClass;
    @Nonnull
    private final ObservableList<String> items;
    @Nonnull
    private final ObjectProperty<E> enumProperty = new SimpleObjectProperty();
    public final StringConverter<E> conv = new StringConverter<E>(){

        public String toString(E o) {
            return ((Enum)o).name();
        }

        public E fromString(String s) {
            for (Enum cur : (Enum[])EnumArgumentChooser.this.enumClass.getEnumConstants()) {
                if (!cur.name().equals(s)) continue;
                return cur;
            }
            return null;
        }
    };

    public EnumArgumentChooser(@Nonnull Class<E> enumClass, @Nullable E defaultValue) {
        this.enumClass = enumClass;
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("EnumArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            List itemStrings = Arrays.asList((Enum[])enumClass.getEnumConstants()).stream().map(Enum::name).collect(Collectors.toList());
            this.items = FXCollections.observableList(itemStrings);
            this.valueField.setItems(this.items);
            if (defaultValue != null) {
                this.valueField.getSelectionModel().select((Object)((Enum)defaultValue).name());
                this.enumProperty.setValue(defaultValue);
            } else {
                this.valueField.getSelectionModel().clearSelection();
                this.enumProperty.setValue(null);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.valueField.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue observableValue, String oldValue, String newValue) {
                if (newValue != null) {
                    Enum eVal = (Enum)EnumArgumentChooser.this.conv.fromString(newValue);
                    assert (eVal != null);
                    EnumArgumentChooser.this.enumProperty.setValue((Object)eVal);
                } else {
                    EnumArgumentChooser.this.enumProperty.setValue(null);
                }
            }
        });
        this.value = this.enumProperty;
    }

    public void setValue(E v) {
        if (v == null) {
            this.valueField.getSelectionModel().clearSelection();
            this.enumProperty.setValue(null);
        } else {
            this.valueField.getSelectionModel().select((Object)((Enum)v).name());
            this.enumProperty.setValue(v);
        }
    }

    public void setStringValue(String newValue) {
        if (newValue == null) {
            this.valueField.getSelectionModel().clearSelection();
            this.enumProperty.setValue(null);
        } else {
            Enum eVal = (Enum)this.conv.fromString(newValue);
            this.valueField.getSelectionModel().select((Object)newValue);
            this.enumProperty.setValue((Object)eVal);
        }
    }
}

