/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapArgumentChooser
extends CommandArgumentChooser<Map>
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(MapArgumentChooser.class);
    @FXML
    private TextArea textField;
    @FXML
    private Label errorLabel;
    @FXML
    private Button loadFromFileButton;
    private final ObjectProperty<Map> valueProperty = new SimpleObjectProperty();

    public MapArgumentChooser(Map defaultValue, boolean showLoadFromFileButton) {
        this(defaultValue == null ? null : JSonHelper.jsonObjectToString((Object)defaultValue), showLoadFromFileButton);
    }

    public MapArgumentChooser(String defaultValue, boolean showLoadFromFileButton) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MapArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            if (defaultValue != null && !defaultValue.trim().isEmpty()) {
                this.textField.setText(defaultValue);
            } else {
                this.textField.setText("{  \n  \n}");
            }
            this.loadFromFileButton.setVisible(showLoadFromFileButton);
            this.textField.textProperty().addListener((observable, oldValue, newValue) -> this.update((String)newValue));
            this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> this.update(this.textField.getText()));
            this.errorLabel.managedProperty().bind((ObservableValue)this.errorLabel.visibleProperty());
            this.errorLabel.setVisible(false);
            this.errorLabel.setText("ERROR: not a valid JSON struct");
            this.errorLabel.setStyle("-fx-text-fill: red;");
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void update(String stringValue) {
        Object newO;
        try {
            newO = JSonHelper.jsonStringToXmlRpcLikeObject((String)stringValue);
        }
        catch (Exception e) {
            newO = null;
        }
        if (newO == null || !(newO instanceof Map)) {
            this.textField.setStyle("-fx-text-fill: red;");
            this.errorLabel.setVisible(true);
            this.valueProperty.setValue(null);
        } else {
            Map newHt = (Map)newO;
            this.textField.setStyle("-fx-text-fill: black;");
            this.errorLabel.setVisible(false);
            this.valueProperty.setValue((Object)newHt);
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.value = this.valueProperty;
        this.update(this.textField.getText());
    }

    public void loadFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load JSON from file");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JSON Files", new String[]{"*.json"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file = fileChooser.showOpenDialog(this.textField.getScene().getWindow());
        if (file != null) {
            try {
                String content = IOUtils.fileToString((File)file);
                Platform.runLater(() -> this.textField.setText(content));
            }
            catch (IOException e) {
                LOG.error("Failed to open file: " + file.getPath(), (Throwable)e);
            }
        }
    }
}

