/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class MapStringToObjectArgumentChooser
extends CommandArgumentChooser<Map<String, Object>> {
    private static final String validationErrorCssClass = "validation_error";
    private final ChangeListener<Object> changeListener = (observableValue, s, s1) -> this.updateMap();
    @FXML
    protected TableView<MyEntry> table;
    final ObservableList<MyEntry> argument = FXCollections.observableArrayList();
    private final ObjectProperty<Map<String, Object>> valueProperty = new SimpleObjectProperty();

    public MapStringToObjectArgumentChooser(Map<String, Object> defaultArguments) {
        this(defaultArguments, "Key", "Value");
    }

    public MapStringToObjectArgumentChooser(Map<String, Object> defaultArguments, String keyColHeader, String valueColHeader) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MapStringToObjectArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.table != null);
            if (defaultArguments != null) {
                for (Map.Entry<String, Object> e : defaultArguments.entrySet()) {
                    this.argument.add((Object)new MyEntry(e.getKey(), e.getValue()));
                }
            }
            this.table.setItems(this.argument);
            this.table.setEditable(true);
            TableColumn keyCol = new TableColumn(keyColHeader);
            keyCol.setMinWidth(100.0);
            keyCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).key);
            keyCol.setCellFactory(p -> new StringEditingCell());
            TableColumn valueCol = new TableColumn(valueColHeader);
            valueCol.setMinWidth(200.0);
            valueCol.setCellValueFactory(myEntryStringCellDataFeatures -> ((MyEntry)myEntryStringCellDataFeatures.getValue()).value);
            valueCol.setCellFactory(p -> new ObjectEditingCell());
            this.table.getColumns().add((Object)keyCol);
            this.table.getColumns().add((Object)valueCol);
            this.argument.addListener(change -> {
                while (change.next()) {
                    for (MyEntry r : change.getRemoved()) {
                        r.removeListeners();
                    }
                    for (MyEntry a : change.getAddedSubList()) {
                        a.addListeners();
                    }
                }
                this.updateMap();
            });
            this.updateMap();
            for (MyEntry e : this.argument) {
                e.addListeners();
            }
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void updateMap() {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (MyEntry e : this.argument) {
            newMap.put((String)e.key.get(), e.value.get());
        }
        this.valueProperty.set(newMap);
    }

    public void add() {
        this.argument.add((Object)new MyEntry("key", "value"));
    }

    public void remove() {
        MyEntry r = (MyEntry)this.table.getSelectionModel().getSelectedItem();
        if (r != null) {
            this.argument.remove((Object)r);
        }
    }

    class MyEntry {
        public final StringProperty key = new SimpleStringProperty();
        public final ObjectProperty value = new SimpleObjectProperty();

        public MyEntry(String key, Object value) {
            this.key.set((Object)key);
            this.value.set(value);
        }

        public void addListeners() {
            this.key.addListener(MapStringToObjectArgumentChooser.this.changeListener);
            this.value.addListener(MapStringToObjectArgumentChooser.this.changeListener);
        }

        public void removeListeners() {
            this.key.removeListener(MapStringToObjectArgumentChooser.this.changeListener);
            this.value.removeListener(MapStringToObjectArgumentChooser.this.changeListener);
        }
    }

    private static class ObjectEditingCell
    extends TableCell<MyEntry, Object> {
        private ComboBox<ObjectType> typeComboBox;
        private TextField textField;
        private HBox hbox;
        private final ObservableList<ObjectType> allObjectTypes = FXCollections.observableArrayList((Object[])ObjectType.values());

        public ObjectEditingCell() {
            this.setEditable(false);
            this.createHBox();
            this.setGraphic(null);
            this.setText(null);
        }

        public void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                if (this.textField != null && item != null) {
                    this.textField.getStyleClass().removeAll((Object[])new String[]{MapStringToObjectArgumentChooser.validationErrorCssClass});
                    this.textField.setText(this.getString());
                    this.typeComboBox.getSelectionModel().select((Object)this.getType());
                }
                this.setText(null);
                this.setGraphic((Node)this.hbox);
            }
        }

        private Object calcValue() {
            return this.calcValue((ObjectType)((Object)this.typeComboBox.getValue()), this.textField.getText());
        }

        private Object calcValue(ObjectType selectedObjectType, String curString) {
            switch (selectedObjectType.ordinal()) {
                case 0: {
                    return curString;
                }
                case 1: {
                    try {
                        return Integer.parseInt(curString);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                case 3: {
                    return TextUtil.stringToBoolean((String)curString);
                }
                case 2: {
                    try {
                        return Double.parseDouble(curString);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
            throw new RuntimeException("Unsupported Object type: " + String.valueOf((Object)selectedObjectType));
        }

        private void confirmEditItem() {
            ObservableValue ov = this.getTableColumn().getCellObservableValue(this.getIndex());
            SimpleObjectProperty op = (SimpleObjectProperty)ov;
            Object item = this.calcValue();
            this.textField.getStyleClass().removeAll((Object[])new String[]{MapStringToObjectArgumentChooser.validationErrorCssClass});
            if (item == null) {
                this.textField.getStyleClass().add((Object)MapStringToObjectArgumentChooser.validationErrorCssClass);
            } else {
                op.setValue(item);
            }
        }

        private void createHBox() {
            if (this.textField == null) {
                this.typeComboBox = new ComboBox();
                this.hbox = new HBox();
                this.textField = new TextField(this.getString());
                this.textField.focusedProperty().addListener((arg0, oldIsFocused, newIsFocused) -> {
                    if (!newIsFocused.booleanValue()) {
                        this.confirmEditItem();
                    }
                });
                this.textField.setOnAction(actionEvent -> this.confirmEditItem());
                this.typeComboBox.setItems(this.allObjectTypes);
                this.typeComboBox.getSelectionModel().select((Object)this.getType());
                this.typeComboBox.getSelectionModel().selectedItemProperty().addListener((arg0, oldItem, newItem) -> this.confirmEditItem());
                this.hbox.getChildren().addAll((Object[])new Node[]{this.typeComboBox, this.textField});
                this.hbox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : this.getItem().toString();
        }

        private ObjectType getType() {
            Object item = this.getItem();
            if (item == null) {
                return ObjectType.STRING;
            }
            if (item instanceof String) {
                return ObjectType.STRING;
            }
            if (item instanceof Integer) {
                return ObjectType.INTEGER;
            }
            if (item instanceof Double) {
                return ObjectType.DOUBLE;
            }
            if (item instanceof Boolean) {
                return ObjectType.BOOLEAN;
            }
            throw new RuntimeException("Unsupported Object type: " + item.getClass().getName());
        }

        private static enum ObjectType {
            STRING,
            INTEGER,
            DOUBLE,
            BOOLEAN;

        }
    }

    static class StringEditingCell
    extends TableCell<MyEntry, String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                Platform.runLater(() -> {
                    this.textField.requestFocus();
                    this.textField.selectAll();
                    this.textField.end();
                    Platform.runLater(() -> {
                        this.textField.requestFocus();
                        this.textField.end();
                    });
                });
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            if (this.textField == null) {
                this.textField = new TextField(this.getString());
                this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
                    if (!arg2.booleanValue()) {
                        this.commitEdit(this.textField.getText());
                    }
                });
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

