/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLineStringArgumentChooser
extends CommandArgumentChooser<String>
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLineStringArgumentChooser.class);
    @FXML
    private TextArea valueField;
    @FXML
    private Button loadFromFileButton;

    public MultiLineStringArgumentChooser(String defaultValue, boolean showLoadFromFileButton) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MultiLineStringArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            if (defaultValue != null) {
                this.valueField.setText(defaultValue);
            }
            this.loadFromFileButton.setVisible(showLoadFromFileButton);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.value = this.valueField.textProperty();
    }

    public void loadFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file = fileChooser.showOpenDialog(this.valueField.getScene().getWindow());
        if (file != null) {
            try {
                String content = IOUtils.fileToString((File)file);
                Platform.runLater(() -> this.valueField.setText(content));
            }
            catch (IOException e) {
                LOG.error("Failed to open file: " + file.getPath(), (Throwable)e);
            }
        }
    }

    public void setValue(String v) {
        this.valueField.textProperty().set((Object)v);
    }
}

