/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.util.StringConverter;

public class MultiStringArgumentProvidedOptionsChooser
extends CommandArgumentChooser<List<String>> {
    @FXML
    protected ListView<SelectableImmutableString> valueField;
    @FXML
    protected TextField addTextField;
    protected final ObservableList<SelectableImmutableString> selectableOptions = FXCollections.observableArrayList();
    private final ObservableList<SelectableImmutableString> selectedOptionsList = FXCollections.observableArrayList();
    private final ObjectProperty<List<String>> valueProperty = new SimpleObjectProperty();

    public MultiStringArgumentProvidedOptionsChooser(List<String> options) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MultiStringArgumentProvidedOptionsChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.valueField != null);
            this.valueField.setCellFactory(list -> {
                CheckBoxListCell cb = new CheckBoxListCell();
                cb.setConverter((StringConverter)new StringConverter<SelectableImmutableString>(){

                    public String toString(SelectableImmutableString selectableImmutableString) {
                        return selectableImmutableString.getText();
                    }

                    public SelectableImmutableString fromString(String s) {
                        throw new RuntimeException("This direction doesn't work and is not needed");
                    }
                });
                cb.setSelectedStateCallback(SelectableImmutableString::selectedProperty);
                return cb;
            });
            this.setAllOptions(options);
            this.valueField.setItems(this.selectableOptions);
            if (!this.valueField.getItems().isEmpty()) {
                this.valueField.getSelectionModel().selectLast();
            }
            this.selectedOptionsList.addListener(change -> this.valueProperty.set(new ArrayList<String>(this.getSelectedStrings())));
            this.valueProperty.set(new ArrayList<String>(this.getSelectedStrings()));
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private List<String> getSelectedStrings() {
        ArrayList<String> selectedItemsStr = new ArrayList<String>();
        for (SelectableImmutableString sms : this.selectedOptionsList) {
            selectedItemsStr.add(sms.getText());
        }
        return selectedItemsStr;
    }

    protected void setAllOptions(List<String> options) {
        this.selectableOptions.clear();
        this.selectedOptionsList.clear();
        for (String option : options) {
            SelectableImmutableString selMutStr = new SelectableImmutableString(option, false);
            this.selectableOptions.add((Object)selMutStr);
        }
        this.selectedOptionsList.clear();
    }

    public void add() {
        SelectableImmutableString toAdd = new SelectableImmutableString(this.addTextField.getText(), true);
        this.selectableOptions.add((Object)toAdd);
    }

    private class SelectableImmutableString {
        private final BooleanProperty selected;
        private final String text;

        private SelectableImmutableString(String text, boolean selected) {
            this.text = text;
            this.selected = new SimpleBooleanProperty(selected);
            this.selected.addListener((observableValue, oldValue, newValue) -> {
                if (MultiStringArgumentProvidedOptionsChooser.this.selectedOptionsList != null) {
                    if (!newValue.booleanValue()) {
                        MultiStringArgumentProvidedOptionsChooser.this.selectedOptionsList.removeAll((Object[])new SelectableImmutableString[]{this});
                    } else {
                        assert (!MultiStringArgumentProvidedOptionsChooser.this.selectedOptionsList.contains((Object)this));
                        MultiStringArgumentProvidedOptionsChooser.this.selectedOptionsList.add((Object)this);
                    }
                }
            });
            if (selected) {
                MultiStringArgumentProvidedOptionsChooser.this.selectedOptionsList.add((Object)this);
            }
        }

        public boolean getSelected() {
            return this.selected.get();
        }

        public BooleanProperty selectedProperty() {
            return this.selected;
        }

        public String getText() {
            return this.text;
        }
    }
}

