/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;

public class MultiUrnArgumentProvidedOptionsChooser
extends CommandArgumentChooser<List<GeniUrn>> {
    @FXML
    private ListView<String> valueField;
    @FXML
    private TextField addTextField;
    final ObservableList<String> options = FXCollections.observableArrayList();
    private final ObjectProperty<List<GeniUrn>> valueProperty = new SimpleObjectProperty();

    public MultiUrnArgumentProvidedOptionsChooser(ObservableList<String> options) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("MultiStringArgumentProvidedOptionsChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.valueField != null);
            this.options.addAll(options);
            this.valueField.setItems(this.options);
            this.valueField.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            if (!this.valueField.getItems().isEmpty()) {
                this.valueField.getSelectionModel().selectLast();
            }
            this.valueField.getSelectionModel().getSelectedItems().addListener(change -> this.setValue());
            this.setValue();
            this.value = this.valueProperty;
            assert (this.value != null);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void setValue() {
        ObservableList selectedItems = this.valueField.getSelectionModel().getSelectedItems();
        ArrayList<GeniUrn> urns = new ArrayList<GeniUrn>();
        for (String urnString : selectedItems) {
            GeniUrn u = GeniUrn.parse((String)urnString);
            if (u != null) {
                urns.add(u);
                continue;
            }
            System.err.println("Invalid urn will be ignored: " + String.valueOf(u));
        }
        this.valueProperty.set(urns);
    }

    public void add() {
        String toAdd = this.addTextField.getText();
        this.options.add((Object)toAdd);
    }
}

