/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments;

import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.probe_gui.command_arguments.CommandArgumentChooser;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSpecListArgumentChooser
extends CommandArgumentChooser<List<UserSpec>> {
    private static final Logger LOG = LoggerFactory.getLogger(UserSpecListArgumentChooser.class);
    private static final boolean startWithLoggedInUserAdded = true;
    private static final boolean startWithFirstUserSelected = false;
    private static final boolean saveClearsSelection = false;
    private static final boolean removeSelectsNext = true;
    private static final boolean showSaveOnlyIfDirty = true;
    private static final boolean addSelectsNew = false;
    private static final boolean autoSave = false;
    final ObservableList<UserSpec> userSpecs = FXCollections.observableArrayList();
    @FXML
    private ListView<UserSpec> userSpecListView;
    @FXML
    private TextField userUrnTextField;
    @FXML
    private TextArea sshTextField;
    @FXML
    private Label userUrnLabel;
    @FXML
    private Label sshLabel;
    @FXML
    private Button saveButton;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    private final ObjectProperty<List<UserSpec>> valueProperty = new SimpleObjectProperty();
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;

    public UserSpecListArgumentChooser(GeniUserProvider geniUserProvider, SfaModel sfaModel) {
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        if (this.geniUserProvider.isUserLoggedIn()) {
            String userUrn = this.geniUserProvider.getLoggedInGeniUser().getUserUrnString();
            assert (userUrn != null);
            ArrayList<String> userKeys = this.sfaModel.getUserKeys();
            if (userKeys == null) {
                userKeys = new ArrayList<String>();
            }
            this.userSpecs.add((Object)new MyUserSpec(userUrn, userKeys));
        }
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("UserSpecListArgumentChooser.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            assert (this.userSpecListView != null);
            this.userSpecListView.setItems(this.userSpecs);
            this.userSpecListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            if (!this.userSpecListView.getItems().isEmpty()) {
                this.userSpecListView.getSelectionModel().selectLast();
            }
            ObservableList selectedItems = this.userSpecListView.getSelectionModel().getSelectedItems();
            selectedItems.addListener(change -> this.valueProperty.set(new ArrayList(selectedItems)));
            this.valueProperty.set(new ArrayList(selectedItems));
            this.value = this.valueProperty;
            assert (this.value != null);
            ChangeListener setEditItemChangeListener = (observableValue, oldUserSpec, newUserSpec) -> {
                if (newUserSpec != null) {
                    if (this.saveButton != null) {
                        this.saveButton.setVisible(true);
                    }
                    this.removeButton.setVisible(true);
                    this.userUrnTextField.setVisible(true);
                    this.sshTextField.setVisible(true);
                    this.userUrnLabel.setVisible(true);
                    this.sshLabel.setVisible(true);
                    this.userUrnTextField.setText(newUserSpec.getUrn());
                    if (newUserSpec.getSshKey().isEmpty()) {
                        this.sshTextField.setText("");
                    } else {
                        Object keys = "";
                        for (String key : newUserSpec.getSshKey()) {
                            keys = (String)keys + key + "\n";
                        }
                        this.sshTextField.setText((String)keys);
                    }
                } else {
                    if (this.saveButton != null) {
                        this.saveButton.setVisible(false);
                    }
                    this.removeButton.setVisible(false);
                    this.userUrnTextField.setVisible(false);
                    this.sshTextField.setVisible(false);
                    this.userUrnLabel.setVisible(false);
                    this.sshLabel.setVisible(false);
                }
            };
            this.removeButton.setVisible(false);
            if (this.saveButton != null) {
                this.saveButton.setVisible(false);
            }
            this.userSpecListView.getSelectionModel().selectedItemProperty().addListener(setEditItemChangeListener);
            if (!this.userSpecs.isEmpty()) {
                this.userSpecListView.getSelectionModel().clearSelection();
                setEditItemChangeListener.changed(null, null, null);
            } else {
                setEditItemChangeListener.changed(null, null, null);
            }
            this.userUrnTextField.focusedProperty().addListener((observableValue, wasFocused, isfocused) -> {});
            this.sshTextField.focusedProperty().addListener((observableValue, wasFocused, isfocused) -> {});
            ChangeListener dirtyListener = (observableValue, oldText, newText) -> {
                if (this.userUrnTextField.disableProperty().get()) {
                    return;
                }
                UserSpec selectedUserSpec = this.selectedUserSpec();
                if (selectedUserSpec == null) {
                    LOG.warn("strange situation: no userspec selected, yet userUrnTextField enabled and edited!");
                    this.saveButton.setVisible(true);
                    return;
                }
                MyUserSpec currentEditUserSpec = this.currentEditUserSpec();
                this.saveButton.setVisible(!Objects.equals(currentEditUserSpec, selectedUserSpec));
            };
            this.userUrnTextField.textProperty().addListener(dirtyListener);
            this.sshTextField.textProperty().addListener(dirtyListener);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean isUrnInList(String userUrn) {
        for (UserSpec userSpec : this.userSpecs) {
            if (!Objects.equals(userSpec.getUrn(), userUrn)) continue;
            return true;
        }
        return false;
    }

    public UserSpec selectedUserSpec() {
        return (UserSpec)this.userSpecListView.getSelectionModel().getSelectedItem();
    }

    public void remove() {
        UserSpec userSpec = this.selectedUserSpec();
        if (userSpec == null) {
            return;
        }
        int oldPos = this.userSpecListView.getSelectionModel().getSelectedIndex();
        this.userSpecs.remove((Object)userSpec);
        if (this.userSpecs.size() > 0) {
            if (oldPos >= this.userSpecs.size()) {
                oldPos = this.userSpecs.size() - 1;
            }
            if (oldPos < 0) {
                oldPos = 0;
            }
            this.userSpecListView.getSelectionModel().select(oldPos);
        } else {
            this.userSpecListView.getSelectionModel().clearSelection();
        }
    }

    public void add() {
        MyUserSpec newUserSpec = null;
        if (this.geniUserProvider.isUserLoggedIn()) {
            String userUrn = this.geniUserProvider.getLoggedInGeniUser().getUserUrnString();
            assert (userUrn != null);
            ArrayList<String> userKeys = this.sfaModel.getUserKeys();
            if (userKeys == null) {
                userKeys = new ArrayList<String>();
            }
            if (!this.isUrnInList(userUrn)) {
                newUserSpec = new MyUserSpec(userUrn, userKeys);
            }
        }
        if (newUserSpec == null) {
            String authPart = this.geniUserProvider.isUserLoggedIn() ? this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getUrnTld() : "authority";
            int usernameCount = 1;
            String userUrn = GeniUrn.createGeniUrnFromEncodedParts((String)authPart, (String)"user", (String)("user" + usernameCount)).toString();
            while (this.isUrnInList(userUrn)) {
                userUrn = GeniUrn.createGeniUrnFromEncodedParts((String)authPart, (String)"user", (String)("user" + ++usernameCount)).toString();
            }
            ArrayList<String> userKeys = new ArrayList<String>();
            newUserSpec = new MyUserSpec(userUrn, userKeys);
        }
        this.userSpecs.add(newUserSpec);
    }

    public void save() {
        UserSpec oldUserSpec = this.selectedUserSpec();
        if (oldUserSpec == null) {
            return;
        }
        int oldPos = this.userSpecListView.getSelectionModel().getSelectedIndex();
        this.save(oldUserSpec, oldPos);
        this.userSpecListView.getSelectionModel().clearSelection();
        this.userSpecListView.getSelectionModel().select(oldPos);
        this.saveButton.setVisible(false);
    }

    public void save(UserSpec oldUserSpec, int oldPos) {
        MyUserSpec newUserSpec = this.currentEditUserSpec();
        this.userSpecs.set(oldPos, (Object)newUserSpec);
    }

    public MyUserSpec currentEditUserSpec() {
        String[] keys;
        String userUrn = this.userUrnTextField.getText();
        ArrayList<String> userKeys = new ArrayList<String>();
        String keysText = this.sshTextField.getText();
        for (String key : keys = keysText.split("\n")) {
            if (key.trim().isEmpty()) continue;
            userKeys.add(key);
        }
        return new MyUserSpec(userUrn, userKeys);
    }

    private class MyUserSpec
    extends UserSpec {
        public MyUserSpec(String urn, Collection<String> sshKey) {
            super(urn, sshKey);
        }

        public MyUserSpec(String urn) {
            super(urn);
        }

        @Override
        public String toString() {
            String usernameString = this.urn;
            GeniUrn geniUrn = GeniUrn.parse((String)this.urn);
            if (geniUrn != null) {
                usernameString = geniUrn.getEncodedResourceName();
            }
            if (!this.sshKey.isEmpty()) {
                if (this.sshKey.size() == 1) {
                    return usernameString + " with 1 key";
                }
                return usernameString + " with " + this.sshKey.size() + " keys";
            }
            return usernameString;
        }
    }
}

